/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.platform.ppu.NesPpu;
import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import com.lambelly.lambnes.test.utils.TestUtils;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class PPUVramAddressRegisterTest {
    @Autowired
    private TestUtils testUtils;
    @Autowired
    private NesCpu cpu;
    @Autowired
    private NesCpuMemory cpuMemory;
    @Autowired
    private NesPpu ppu;
    @Autowired
    private NesPpuMemory ppuMemory;
    private Logger logger = Logger.getLogger(PPUVramAddressRegisterTest.class);

    @Before
    public void setUp() throws Exception {
        this.getTestUtils().createTestPlatform();
    }

    @Test
    public void write() throws IOException {
        this.getCpuMemory().setMemoryFromHexAddress(8198, 63);
        this.getPpu().cycle(1);
        this.getCpuMemory().setMemoryFromHexAddress(8198, 0);
        this.getPpu().cycle(2);
        this.getCpu().setY(32);
        this.getPpu().cycle(3);
        this.getCpu().setX(32);
        this.getPpu().cycle(4);
        this.getCpuMemory().setMemoryFromHexAddress(8199, 47);
        this.getPpu().cycle(5);
        this.getCpuMemory().setMemoryFromHexAddress(8199, 63);
        this.getPpu().cycle(6);
        this.getPpu().cycle(7);
        Assert.assertEquals((long)47L, (long)this.getPpuMemory().getMemoryFromHexAddress(16128));
        Assert.assertEquals((long)63L, (long)this.getPpuMemory().getMemoryFromHexAddress(16129));
    }

    public TestUtils getTestUtils() {
        return this.testUtils;
    }

    public void setTestUtils(TestUtils testUtils) {
        this.testUtils = testUtils;
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public NesPpu getPpu() {
        return this.ppu;
    }

    public void setPpu(NesPpu ppu) {
        this.ppu = ppu;
    }

    public NesPpuMemory getPpuMemory() {
        return this.ppuMemory;
    }

    public void setPpuMemory(NesPpuMemory ppuMemory) {
        this.ppuMemory = ppuMemory;
    }
}

