/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.test;

import com.lambelly.lambnes.cartridge.Ines;
import com.lambelly.lambnes.gui.PatternTableVisualization;
import com.lambelly.lambnes.platform.Platform;
import com.lambelly.lambnes.platform.ppu.BackgroundTile;
import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import com.lambelly.lambnes.platform.ppu.PaletteColor;
import com.lambelly.lambnes.test.TestScreen;
import com.lambelly.lambnes.util.ArrayUtils;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:beans.xml"})
public class TileTestImageViewer
extends JFrame
implements ActionListener,
KeyListener,
Runnable {
    private BufferedImage image = null;
    private Logger logger = Logger.getLogger(TileTestImageViewer.class);
    @Autowired
    private Platform platform;
    @Autowired
    private Ines cartridge;
    @Autowired
    private NesPpuMemory ppuMemory;
    public static final String SCREEN_TITLE = "LambNes";

    public TileTestImageViewer(int tileNumber) throws Exception {
        this.getPpuMemory().establishMirroring();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"pattern tiles head:");
        }
        ArrayUtils.head(this.getCartridge().getPatternTiles(), 16);
        this.getPpuMemory().setPatternTiles(this.getCartridge().getPatternTiles());
        this.getPpuMemory().setImagePalette(new PaletteColor[]{new PaletteColor(0, 13), new PaletteColor(0, 7), new PaletteColor(0, 23), new PaletteColor(0, 39), new PaletteColor(0, 13), new PaletteColor(0, 22), new PaletteColor(0, 38), new PaletteColor(0, 55), new PaletteColor(0, 13), new PaletteColor(0, 18), new PaletteColor(0, 60), new PaletteColor(0, 48), new PaletteColor(0, 13), new PaletteColor(0, 6), new PaletteColor(0, 39), new PaletteColor(0, 56)});
        BackgroundTile bg = new BackgroundTile(tileNumber, 0);
        this.setImage(bg.getBufferedImage());
    }

    @Override
    public void run() {
        this.setTitle(SCREEN_TITLE);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TileTestImageViewer.this.logger.isDebugEnabled()) {
                    TileTestImageViewer.this.logger.debug((Object)"window closed.");
                }
                TileTestImageViewer.this.setVisible(false);
                TileTestImageViewer.this.dispose();
            }
        });
        Container content = this.getContentPane();
        content.add(new TestScreen(this.getImage()));
        content.add(new PatternTableVisualization("test", 1));
        this.pack();
        this.setVisible(true);
        while (this.isVisible()) {
            content.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public Ines getCartridge() {
        return this.cartridge;
    }

    public void setCartridge(Ines cartridge) {
        this.cartridge = cartridge;
    }

    public NesPpuMemory getPpuMemory() {
        return this.ppuMemory;
    }

    public void setPpuMemory(NesPpuMemory ppuMemory) {
        this.ppuMemory = ppuMemory;
    }
}

