/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.json.JSONArray;
import org.json.JSONTokener;

public class JSONObject {
    private HashMap myHashMap;
    public static final Object NULL = new Null();

    public JSONObject() {
        this.myHashMap = new HashMap();
    }

    public JSONObject(JSONTokener jSONTokener) throws ParseException {
        this();
        if (jSONTokener.next() == '%') {
            jSONTokener.unescape();
        }
        jSONTokener.back();
        if (jSONTokener.nextClean() != '{') {
            throw jSONTokener.syntaxError("A JSONObject must begin with '{'");
        }
        block8: while (true) {
            char c = jSONTokener.nextClean();
            switch (c) {
                case '\u0000': {
                    throw jSONTokener.syntaxError("A JSONObject must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            jSONTokener.back();
            String string = jSONTokener.nextValue().toString();
            if (jSONTokener.nextClean() != ':') {
                throw jSONTokener.syntaxError("Expected a ':' after a key");
            }
            this.myHashMap.put(string, jSONTokener.nextValue());
            switch (jSONTokener.nextClean()) {
                case ',': {
                    if (jSONTokener.nextClean() == '}') {
                        return;
                    }
                    jSONTokener.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw jSONTokener.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(String string) throws ParseException {
        this(new JSONTokener(string));
    }

    public JSONObject(Map map) {
        this.myHashMap = new HashMap(map);
    }

    public JSONObject accumulate(String string, Object object) throws NullPointerException {
        Object object2 = this.opt(string);
        if (object2 == null) {
            this.put(string, object);
        } else if (object2 instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object2;
            jSONArray.put(object);
        } else {
            JSONArray jSONArray = new JSONArray();
            jSONArray.put(object2);
            jSONArray.put(object);
            this.put(string, jSONArray);
        }
        return this;
    }

    public Object get(String string) throws NoSuchElementException {
        Object object = this.opt(string);
        if (object == null) {
            throw new NoSuchElementException("JSONObject[" + JSONObject.quote(string) + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(String string) throws ClassCastException, NoSuchElementException {
        Object object = this.get(string);
        if (object == Boolean.FALSE || object.equals("false")) {
            return false;
        }
        if (object == Boolean.TRUE || object.equals("true")) {
            return true;
        }
        throw new ClassCastException("JSONObject[" + JSONObject.quote(string) + "] is not a Boolean.");
    }

    public double getDouble(String string) throws NoSuchElementException, NumberFormatException {
        Object object = this.get(string);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        throw new NumberFormatException("JSONObject[" + JSONObject.quote(string) + "] is not a number.");
    }

    HashMap getHashMap() {
        return this.myHashMap;
    }

    public int getInt(String string) throws NoSuchElementException, NumberFormatException {
        Object object = this.get(string);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return (int)this.getDouble(string);
    }

    public JSONArray getJSONArray(String string) throws NoSuchElementException {
        Object object = this.get(string);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new NoSuchElementException("JSONObject[" + JSONObject.quote(string) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String string) throws NoSuchElementException {
        Object object = this.get(string);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new NoSuchElementException("JSONObject[" + JSONObject.quote(string) + "] is not a JSONObject.");
    }

    public String getString(String string) throws NoSuchElementException {
        return this.get(string).toString();
    }

    public boolean has(String string) {
        return this.myHashMap.containsKey(string);
    }

    public boolean isNull(String string) {
        return NULL.equals(this.opt(string));
    }

    public Iterator keys() {
        return this.myHashMap.keySet().iterator();
    }

    public int length() {
        return this.myHashMap.size();
    }

    public JSONArray names() {
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = this.keys();
        while (iterator.hasNext()) {
            jSONArray.put(iterator.next());
        }
        if (jSONArray.length() == 0) {
            return null;
        }
        return jSONArray;
    }

    public static String numberToString(Number number) throws ArithmeticException {
        if (number instanceof Float && (((Float)number).isInfinite() || ((Float)number).isNaN()) || number instanceof Double && (((Double)number).isInfinite() || ((Double)number).isNaN())) {
            throw new ArithmeticException("JSON can only serialize finite numbers.");
        }
        String string = number.toString().toLowerCase();
        if (string.indexOf(101) < 0 && string.indexOf(46) > 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object opt(String string) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("Null key");
        }
        return this.myHashMap.get(string);
    }

    public boolean optBoolean(String string) {
        return this.optBoolean(string, false);
    }

    public boolean optBoolean(String string, boolean bl) {
        Object object = this.opt(string);
        if (object != null) {
            if (object == Boolean.FALSE || object.equals("false")) {
                return false;
            }
            if (object == Boolean.TRUE || object.equals("true")) {
                return true;
            }
        }
        return bl;
    }

    public double optDouble(String string) {
        return this.optDouble(string, Double.NaN);
    }

    public double optDouble(String string, double d) {
        Object object = this.opt(string);
        if (object != null) {
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            try {
                return Double.parseDouble((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    public int optInt(String string) {
        return this.optInt(string, 0);
    }

    public int optInt(String string, int n) {
        Object object = this.opt(string);
        if (object != null) {
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            try {
                return Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public JSONArray optJSONArray(String string) {
        Object object = this.opt(string);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        return null;
    }

    public JSONObject optJSONObject(String string) {
        Object object = this.opt(string);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        return null;
    }

    public String optString(String string) {
        return this.optString(string, "");
    }

    public String optString(String string, String string2) {
        Object object = this.opt(string);
        if (object != null) {
            return object.toString();
        }
        return string2;
    }

    public JSONObject put(String string, boolean bl) {
        this.put(string, new Boolean(bl));
        return this;
    }

    public JSONObject put(String string, double d) {
        this.put(string, new Double(d));
        return this;
    }

    public JSONObject put(String string, int n) {
        this.put(string, new Integer(n));
        return this;
    }

    public JSONObject put(String string, Object object) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("Null key.");
        }
        if (object != null) {
            this.myHashMap.put(string, object);
        } else {
            this.remove(string);
        }
        return this;
    }

    public JSONObject putOpt(String string, Object object) throws NullPointerException {
        if (object != null) {
            this.put(string, object);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 4);
        stringBuffer.append('\"');
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block8;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String string2 = "000" + Integer.toHexString(c);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4));
                        continue block8;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public Object remove(String string) {
        return this.myHashMap.remove(string);
    }

    public JSONArray toJSONArray(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        JSONArray jSONArray2 = new JSONArray();
        for (int i = 0; i < jSONArray.length(); ++i) {
            jSONArray2.put(this.opt(jSONArray.getString(i)));
        }
        return jSONArray2;
    }

    public String toString() {
        Iterator iterator = this.keys();
        Object object = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        while (iterator.hasNext()) {
            String string;
            if (object != null) {
                stringBuffer.append(',');
            }
            if ((object = (Object)this.myHashMap.get(string = iterator.next().toString())) == null) continue;
            stringBuffer.append(JSONObject.quote(string));
            stringBuffer.append(':');
            if (object instanceof String) {
                stringBuffer.append(JSONObject.quote((String)object));
                continue;
            }
            if (object instanceof Number) {
                stringBuffer.append(JSONObject.numberToString((Number)object));
                continue;
            }
            stringBuffer.append(object.toString());
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public String toString(int n) {
        return this.toString(n, 0);
    }

    String toString(int n, int n2) {
        Iterator iterator = this.keys();
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        n2 += n;
        for (int i = 0; i < n2; ++i) {
            string = string + ' ';
        }
        stringBuffer.append("{\n");
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            Object v = this.myHashMap.get(string2);
            if (v == null) continue;
            if (stringBuffer.length() > 2) {
                stringBuffer.append(",\n");
            }
            stringBuffer.append(string);
            stringBuffer.append(JSONObject.quote(string2));
            stringBuffer.append(": ");
            if (v instanceof String) {
                stringBuffer.append(JSONObject.quote((String)v));
                continue;
            }
            if (v instanceof Number) {
                stringBuffer.append(JSONObject.numberToString((Number)v));
                continue;
            }
            if (v instanceof JSONObject) {
                stringBuffer.append(((JSONObject)v).toString(n, n2));
                continue;
            }
            if (v instanceof JSONArray) {
                stringBuffer.append(((JSONArray)v).toString(n, n2));
                continue;
            }
            stringBuffer.append(v.toString());
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

