/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.text.ParseException;
import java.util.HashMap;
import org.json.JSONTokener;
import org.json.XML;

public class XMLTokener
extends JSONTokener {
    private static final HashMap entity = new HashMap(8);

    public XMLTokener(String string) {
        super(string);
    }

    public Object nextContent() throws ParseException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        if (c == '\u0000') {
            return null;
        }
        if (c == '<') {
            return XML.LT;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if (c == '<' || c == '\u0000') {
                this.back();
                return stringBuffer.toString().trim();
            }
            if (c == '&') {
                stringBuffer.append(this.nextEntity(c));
            } else {
                stringBuffer.append(c);
            }
            c = this.next();
        }
    }

    public Object nextEntity(char c) throws ParseException {
        char c2;
        StringBuffer stringBuffer = new StringBuffer();
        while (Character.isLetter(c2 = this.next())) {
            stringBuffer.append(Character.toLowerCase(c2));
        }
        if (c2 != ';') {
            throw this.syntaxError("Missing ';' in XML entity: &" + stringBuffer);
        }
        String string = stringBuffer.toString();
        Object v = entity.get(string);
        if (v != null) {
            return v;
        }
        return c + string + ";";
    }

    public Object nextMeta() throws ParseException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw this.syntaxError("Misshaped meta tag.");
            }
            case '<': {
                return XML.LT;
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char c2 = c;
                do {
                    if ((c = this.next()) != '\u0000') continue;
                    throw this.syntaxError("Unterminated string.");
                } while (c != c2);
                return Boolean.TRUE;
            }
        }
        while (!Character.isWhitespace(c = this.next())) {
            switch (c) {
                case '\u0000': 
                case '!': 
                case '\"': 
                case '\'': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '?': {
                    this.back();
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.TRUE;
    }

    public Object nextToken() throws ParseException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw this.syntaxError("Misshaped element.");
            }
            case '<': {
                throw this.syntaxError("Misplaced '<'.");
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char c2 = c;
                StringBuffer stringBuffer = new StringBuffer();
                while (true) {
                    if ((c = this.next()) == '\u0000') {
                        throw this.syntaxError("Unterminated string.");
                    }
                    if (c == c2) {
                        return stringBuffer.toString();
                    }
                    if (c == '&') {
                        stringBuffer.append(this.nextEntity(c));
                        continue;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            stringBuffer.append(c);
            c = this.next();
            if (Character.isWhitespace(c)) {
                return stringBuffer.toString();
            }
            switch (c) {
                case '\u0000': 
                case '!': 
                case '/': 
                case '=': 
                case '>': 
                case '?': {
                    this.back();
                    return stringBuffer.toString();
                }
                case '\"': 
                case '\'': 
                case '<': {
                    throw this.syntaxError("Bad character in a name.");
                }
            }
        }
    }

    static {
        entity.put("amp", XML.AMP);
        entity.put("apos", XML.APOS);
        entity.put("gt", XML.GT);
        entity.put("lt", XML.LT);
        entity.put("quot", XML.QUOT);
    }
}

