/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ButtonsPanel
extends JPanel {
    private static final Color OFF_COLOUR = Color.LIGHT_GRAY;
    private static final Color ON_COLOUR = Color.YELLOW;
    private JTextField[] buttonTFs;

    public ButtonsPanel() {
        this.setBackground(Color.white);
        this.buttonTFs = new JTextField[12];
        for (int i = 0; i < 12; ++i) {
            this.buttonTFs[i] = new JTextField("" + (i + 1), 2);
            this.buttonTFs[i].setEditable(false);
            this.buttonTFs[i].setBackground(OFF_COLOUR);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.makeRow(0, 6);
        this.makeRow(6, 12);
    }

    private void makeRow(int start, int end) {
        JPanel rowPanel = new JPanel();
        rowPanel.setLayout(new BoxLayout(rowPanel, 0));
        for (int i = start; i < end; ++i) {
            JPanel p = new JPanel();
            p.setBackground(Color.white);
            p.add(this.buttonTFs[i]);
            rowPanel.add(p);
        }
        this.add(rowPanel);
    }

    public void setButtons(boolean[] bVals) {
        if (bVals.length != 12) {
            System.out.println("Wring number of button values");
        } else {
            for (int i = 0; i < 12; ++i) {
                Color c = bVals[i] ? ON_COLOUR : OFF_COLOUR;
                this.buttonTFs[i].setBackground(c);
            }
            this.repaint();
        }
    }
}

