/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device.sound;

import JCPC.core.device.sound.SoundUtil;
import JCPC.core.device.sound.SunAudio;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class JavaSound
extends SunAudio {
    public static int SAMPLE_RATE = 22050;
    public static int[] rates = new int[]{6000, 8000, 11025, 22050, 32000, 44100};
    public static boolean muted = false;
    protected static AudioFormat STEREO_FORMAT;
    protected SourceDataLine line;
    protected byte[] data;
    protected int offset = 0;
    protected int channels;
    protected long startCount;

    public JavaSound(int samples, boolean stereo) {
        super(samples, stereo);
        System.out.println("Samples:" + samples);
    }

    @Override
    public int getSampleRate() {
        return SAMPLE_RATE;
    }

    @Override
    protected void init() {
        this.format = 2;
        this.channels = 2;
        this.data = new byte[this.samples * this.channels];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = -128;
        }
        boolean match = false;
        int i = rates.length - 1;
        boolean a = false;
        boolean b = true;
        while (!match) {
            try {
                SAMPLE_RATE = rates[i--];
                AudioFormat audioformat = STEREO_FORMAT = new AudioFormat(SAMPLE_RATE, 8, 2, a, b);
                this.line = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, audioformat, SAMPLE_RATE * this.channels));
                this.line.open();
                match = true;
            }
            catch (Exception e) {
                if (i >= 0) continue;
                if (!a) {
                    a = true;
                } else if (!b) {
                    b = true;
                } else {
                    System.err.println("Critical Error!!!\r\nUnable to define sound!");
                    break;
                }
                i = rates.length - 1;
            }
        }
        System.out.println("Samplerate is: " + SAMPLE_RATE + " - A is: " + a + " - B is: " + b);
    }

    @Override
    public void resync() {
        int len;
        this.line.flush();
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = -128;
        }
        this.startCount = this.line.getLongFramePosition();
        for (int sample = SAMPLE_RATE / 10 * this.channels; sample > 0; sample -= len) {
            len = Math.min(this.data.length, sample);
            this.line.write(this.data, 0, len);
        }
        System.out.println("resync: start=" + this.startCount);
    }

    @Override
    public long getCount() {
        return this.line.getLongFramePosition() - this.startCount - 100L;
    }

    @Override
    public long getDeviation() {
        return SAMPLE_RATE / 10;
    }

    @Override
    public void play() {
        this.resync();
        this.line.start();
    }

    @Override
    public void stop() {
        this.line.stop();
    }

    @Override
    public void dispose() {
        this.line.close();
    }

    @Override
    public void writeStereo(int a, int b) {
        a ^= 0x80;
        b ^= 0x80;
        switch (this.format) {
            case 0: {
                this.data[this.offset] = SoundUtil.ulawToUPCM8((byte)a);
                this.data[this.offset + 1] = SoundUtil.ulawToUPCM8((byte)b);
                break;
            }
            case 2: {
                this.data[this.offset] = (byte)a;
                this.data[this.offset + 1] = (byte)b;
            }
        }
        if (muted) {
            this.data[this.offset] = 0;
            this.data[this.offset + 1] = 0;
        }
        if ((this.offset += 2) == this.data.length) {
            this.line.write(this.data, 0, this.data.length);
            this.offset = 0;
        }
        ++this.updates;
    }
}

