/*
 * Decompiled with CFR 0.152.
 */
package JCPC.system.cpc;

import JCPC.core.Util;
import JCPC.system.cpc.CPC;
import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Poker
extends JFrame {
    CPC cpc;
    StringBuilder addressBuilder;
    int[] addresses = new int[65536];
    int[] values = new int[65536];
    String old2;
    String old1;
    private JTextField address;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JList<String> jList1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JTextField jTextField2;
    public JButton poke;
    public JComboBox preset;
    private JTextField value;

    public Poker(CPC cpc) {
        this.cpc = cpc;
        this.initComponents();
    }

    public int getAddress() {
        try {
            String b = this.address.getText();
            while (b.startsWith("0")) {
                b = b.substring(1);
            }
            if (b.length() < 1) {
                b = "0";
            }
            return Util.hexValue(b);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    protected void scan() {
        try {
            int val = Integer.parseInt(this.value.getText());
            int off = 0;
            this.addressBuilder = new StringBuilder();
            for (int i = 0; i < 65536; ++i) {
                if (val == this.cpc.PEEK(i) && this.addresses[off] != -2) {
                    this.addressBuilder.append(Util.hex((short)i)).append(" - ").append(val).append("\n");
                    this.values[off] = val;
                    this.addresses[off++] = i;
                    continue;
                }
                this.values[off] = -1;
                this.addresses[off++] = -2;
            }
            final String[] list = this.addressBuilder.toString().split("\n");
            this.jList1.setModel((ListModel<String>)new AbstractListModel<String>(){

                @Override
                public int getSize() {
                    return list.length;
                }

                @Override
                public String getElementAt(int i) {
                    return list[i];
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void reset() {
        for (int i = 0; i < 65536; ++i) {
            this.addresses[i] = -1;
            this.values[i] = -1;
        }
    }

    public int getValue() {
        try {
            String b = this.jTextField2.getText();
            while (b.startsWith("0")) {
                b = b.substring(1);
            }
            if (b.length() < 1) {
                b = "0";
            }
            return Util.hexValue(b);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.preset = new JComboBox();
        this.jPanel4 = new JPanel();
        this.poke = new JButton();
        this.jPanel5 = new JPanel();
        this.jLabel1 = new JLabel();
        this.address = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jPanel6 = new JPanel();
        this.jLabel3 = new JLabel();
        this.value = new JTextField();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton2 = new JButton();
        this.setTitle("POKE");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Cartridge Pokes"));
        this.preset.setModel(new DefaultComboBoxModel<String>(new String[]{"Preset:", "Prehistorik 2", "Burnin Rubber", "Fire & Forget II", "Robocop II", "The Enforcer", "Wild Streets", "Copter 271"}));
        this.preset.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Poker.this.presetItemStateChanged(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.preset, -2, -1, -2).addGap(16, 16, 16)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.preset, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setLayout(new BorderLayout());
        this.poke.setText("POKE");
        this.poke.setFocusable(false);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Memory Pokes"));
        this.jLabel1.setText("Address:  &");
        this.address.setColumns(3);
        this.address.setHorizontalAlignment(4);
        this.address.setText("0000");
        this.address.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Poker.this.addressKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                Poker.this.addressKeyTyped(evt);
            }
        });
        this.jLabel2.setText("Value:  &");
        this.jTextField2.setColumns(2);
        this.jTextField2.setHorizontalAlignment(4);
        this.jTextField2.setText("00");
        this.jTextField2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Poker.this.jTextField2KeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                Poker.this.jTextField2KeyTyped(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.address, -2, -1, -2)).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.address, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField2, -2, -1, -2)).addGap(0, 39, Short.MAX_VALUE)));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder("Quick Finder"));
        this.jLabel3.setText("Value:");
        this.value.setColumns(2);
        this.value.setHorizontalAlignment(4);
        this.value.setText("0");
        this.value.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Poker.this.valueKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                Poker.this.valueKeyTyped(evt);
            }
        });
        this.jButton1.setText("Scan");
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Poker.this.jButton1ActionPerformed(evt);
            }
        });
        this.jList1.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"0:0"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jButton2.setText("Reset");
        this.jButton2.setFocusable(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Poker.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.value, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.value, -2, -1, -2).addComponent(this.jButton1).addComponent(this.jButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 106, -2).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.poke).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jPanel4, -2, 140, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.poke).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void addressKeyReleased(KeyEvent evt) {
        String a = this.address.getText();
        while (a.length() > 4) {
            a = a.substring(1);
        }
        try {
            String b = a;
            while (b.startsWith("0")) {
                b = b.substring(1);
            }
            if (b.length() < 1) {
                b = "0";
            }
            int n = Util.hexValue(b);
        }
        catch (Exception e) {
            a = this.old1;
            try {
                String b = a;
                while (b.startsWith("0")) {
                    b = b.substring(1);
                }
                if (b.length() < 1) {
                    b = "0";
                }
                int n = Util.hexValue(b);
            }
            catch (Exception r) {
                a = "0000";
            }
        }
        this.address.setText(a);
    }

    private void jTextField2KeyReleased(KeyEvent evt) {
        String a = this.jTextField2.getText();
        while (a.length() > 2) {
            a = a.substring(1);
        }
        try {
            String b = a;
            while (b.startsWith("0")) {
                b = b.substring(1);
            }
            if (b.length() < 1) {
                b = "0";
            }
            int n = Util.hexValue(b);
        }
        catch (Exception e) {
            a = this.old2;
            try {
                String b = a;
                while (b.startsWith("0")) {
                    b = b.substring(1);
                }
                if (b.length() < 1) {
                    b = "0";
                }
                int n = Util.hexValue(b);
            }
            catch (Exception r) {
                a = "0000";
            }
        }
        this.jTextField2.setText(a);
    }

    private void addressKeyTyped(KeyEvent evt) {
        this.old1 = this.address.getText();
    }

    private void jTextField2KeyTyped(KeyEvent evt) {
        this.old2 = this.jTextField2.getText();
    }

    private void presetItemStateChanged(ItemEvent evt) {
        this.address.setEnabled(this.preset.getSelectedIndex() == 0);
        this.jTextField2.setEnabled(this.preset.getSelectedIndex() == 0);
    }

    private void valueKeyReleased(KeyEvent evt) {
    }

    private void valueKeyTyped(KeyEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.scan();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.reset();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Poker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Poker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Poker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Poker.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Poker(null).setVisible(true);
            }
        });
    }
}

