/*
 * Decompiled with CFR 0.152.
 */
package JCPC.ui;

import JCPC.core.Util;
import JCPC.core.device.Computer;
import JCPC.core.device.memory.Memory;
import JCPC.ui.Counter;
import JCPC.ui.TimerListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class EMemory
extends JComponent
implements TimerListener {
    protected static final int INVALID = 0;
    protected static final int HEX1 = 1;
    protected static final int HEX2 = 2;
    protected static final int TEXT = 3;
    protected Memory mem;
    protected Color selBackground = new Color(0, 0, 127);
    protected Color selForeground = Color.white;
    protected boolean textMode = false;
    protected boolean right = false;
    protected int selAnchor;
    protected int selStart;
    protected int selEnd;
    protected int selected;
    protected int addressDigits;
    protected int cw;
    protected int ch;
    protected int left;
    protected Counter counter;
    protected boolean cursor;

    public EMemory() {
        this.enableEvents(52L);
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.setFont(new Font("Courier", 0, 12));
        this.setAutoscrolls(true);
        this.setFocusable(true);
    }

    public void setMemory(Memory value) {
        this.mem = value;
        this.addressDigits = Math.max(4, Integer.toHexString(this.mem.getAddressSize() - 1).length());
    }

    public void setComputer(Computer value) {
        this.setMemory(value == null ? null : value.getMemory());
    }

    @Override
    protected void paintComponent(Graphics g) {
        byte[] buff = new byte[16];
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.mem != null) {
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            g.setColor(this.getForeground());
            int a = fm.getAscent();
            this.ch = fm.getHeight();
            Rectangle rect = g.getClipBounds();
            Insets insets = this.getInsets();
            int row = (rect.y - insets.top) / this.ch;
            int address = row * 16;
            for (int y = insets.top + row * this.ch; y < rect.y + rect.height; y += fm.getHeight()) {
                String line;
                if (this.addressDigits > 4) {
                    line = Util.hex(address);
                    if (this.addressDigits < 8) {
                        line = line.substring(8 - this.addressDigits);
                    }
                } else {
                    line = Util.hex((short)address);
                }
                line = line + ": ";
                int w = fm.stringWidth(line);
                this.cw = w / line.length();
                this.left = w += insets.left;
                g.setColor(this.getForeground());
                int ya = y + a;
                g.drawString(line, insets.left, ya);
                for (int i = 0; i < 16; ++i) {
                    buff[i] = (byte)this.mem.readByte(address + i, null);
                }
                line = Util.dumpBytes(buff, 0, 16, false, true, false);
                int start = 0;
                if (this.selStart < address + 16 && this.selEnd >= address) {
                    if (this.right) {
                        int index = (this.selected - address) * 3 + 1;
                        line = line.substring(0, index - 1) + line.charAt(index) + ' ' + line.substring(index + 1);
                    } else {
                        int end;
                        if (this.textMode) {
                            int textStart = line.length() - 16;
                            start = Math.max(textStart, textStart + this.selStart - address);
                            g.drawString(line.substring(0, start), w, ya);
                            w += fm.stringWidth(line.substring(0, start));
                            end = Math.min(line.length(), textStart + this.selEnd - address + 1);
                        } else {
                            start = Math.max(0, (this.selStart - address) * 3);
                            if (start > 0) {
                                g.drawString(line.substring(0, start), w, ya);
                                w += fm.stringWidth(line.substring(0, start));
                            }
                            end = Math.min(47, (this.selEnd - address + 1) * 3 - 1);
                        }
                        int ww = fm.stringWidth(line.substring(start, end));
                        g.setColor(this.selBackground);
                        g.fillRect(w, y, ww, this.ch);
                        g.setColor(this.selForeground);
                        g.drawString(line.substring(start, end), w, ya);
                        w += ww;
                        start = end;
                        g.setColor(this.getForeground());
                    }
                }
                if (start != line.length()) {
                    g.drawString(line.substring(start), w, ya);
                }
                if ((address += 16) >= this.mem.getAddressSize()) break;
            }
            if (this.cursor) {
                Rectangle cursor = this.getRect(this.selected);
                if (this.right) {
                    cursor.x += this.cw;
                }
                g.setXORMode(Color.white);
                g.fillRect(cursor.x, cursor.y, 2, cursor.height);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return new Dimension(fm.charWidth('0') * (66 + this.addressDigits), fm.getHeight() * (this.mem == null ? 4096 : this.mem.getAddressSize() >> 4));
    }

    protected Point getCharacterCell(MouseEvent e) {
        Insets insets = this.getInsets();
        return new Point(e.getX() < this.left ? -1 : (e.getX() - this.left) / this.cw, (e.getY() - insets.top) / this.ch);
    }

    protected Rectangle getRect(int addr) {
        int y = (addr >> 4) * this.ch + this.getInsets().top;
        int x = addr & 0xF;
        x = this.textMode ? this.left + (x + 48) * this.cw : this.left + x * this.cw * 3;
        return new Rectangle(x, y, this.textMode ? this.cw : this.cw * 2, this.ch);
    }

    protected int getClickSection(Point ch) {
        int result = 0;
        if (ch.x >= 48) {
            ch.x -= 48;
            result = 3;
        } else if (ch.x >= 0) {
            switch (ch.x % 3) {
                case 0: {
                    result = 1;
                    break;
                }
                case 1: {
                    result = 2;
                }
            }
            ch.x /= 3;
        }
        ch.x = Math.max(0, Math.min(ch.x, 15));
        return result;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0 && e.getID() == 501) {
            this.requestFocus();
            Point p = this.getCharacterCell(e);
            int section = this.getClickSection(p);
            this.setTextMode(section == 3);
            this.setSelection((p.y << 4) + p.x, false);
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0 && e.getID() == 506) {
            Point p = this.getCharacterCell(e);
            int section = this.getClickSection(p);
            if (this.textMode && section != 3) {
                p.x = 0;
            } else if (!this.textMode && section == 3) {
                p.x = 15;
            }
            int addr = (p.y << 4) + p.x;
            this.setSelection(addr, true);
        }
        super.processMouseMotionEvent(e);
    }

    public void setTextMode(boolean value) {
        if (this.textMode != value) {
            this.textMode = value;
            this.right = false;
            this.repaint();
        }
    }

    public int getPageSize() {
        return Math.max(1, this.getSize().height / this.ch);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            boolean shift = (e.getModifiers() & 1) != 0;
            switch (e.getKeyCode()) {
                case 36: {
                    this.setSelection(0, shift);
                    break;
                }
                case 35: {
                    this.setSelection(this.mem.getAddressSize() - 1, shift);
                    break;
                }
                case 37: {
                    this.setSelection(this.selected - 1, shift);
                    break;
                }
                case 39: {
                    this.setSelection(this.selected + 1, shift);
                    break;
                }
                case 38: {
                    if (this.selected <= 15) break;
                    this.setSelection(this.selected - 16, shift);
                    break;
                }
                case 40: {
                    if (this.selected >= this.mem.getAddressSize() - 16) break;
                    this.setSelection(this.selected + 16, shift);
                    break;
                }
                case 34: {
                    this.setSelection(this.selected + this.getPageSize(), shift);
                    break;
                }
                case 33: {
                    this.setSelection(this.selected - this.getPageSize(), shift);
                    break;
                }
                case 9: {
                    if ((e.getModifiers() & 2) == 0) break;
                    this.setTextMode(!this.textMode);
                }
            }
        } else if (e.getID() == 400) {
            char ch = e.getKeyChar();
            this.repaint(this.getRect(this.selected));
            if (this.textMode) {
                if (ch < ' ' || ch < '\u007f') {
                    // empty if block
                }
                this.mem.writeByte(this.selected, ch);
                --this.selStart;
                this.setAddress(Math.min(this.mem.getAddressSize() - 1, this.selected + 1));
            } else {
                int hex = "0123456789ABCDEFabcdef".indexOf(ch);
                if (hex != -1) {
                    if (hex > 15) {
                        hex -= 6;
                    }
                    if (this.right = !this.right) {
                        this.mem.writeByte(this.selected, hex);
                    } else {
                        this.mem.writeByte(this.selected, this.mem.readByte(this.selected) << 4 | hex);
                        --this.selStart;
                        this.setAddress(Math.min(this.mem.getAddressSize() - 1, this.selected + 1));
                    }
                }
            }
            this.repaint(this.getRect(this.selected));
        }
        this.cursor = this.counter != null;
        super.processKeyEvent(e);
    }

    protected void setSelection(int addr) {
        this.setSelection(addr, true);
    }

    protected void setSelection(int addr, boolean range) {
        int start;
        int end;
        this.selected = addr = Math.max(0, Math.min(this.mem.getAddressSize() - 1, addr));
        if (!range) {
            end = this.selAnchor = addr;
            start = this.selAnchor;
        } else if (addr < this.selAnchor) {
            start = addr;
            end = this.selAnchor;
        } else {
            end = addr;
            start = this.selAnchor;
        }
        if (this.right || start != this.selStart || end != this.selEnd) {
            this.right = false;
            this.selStart = start;
            this.selEnd = end;
            this.scrollRectToVisible(this.getRect(addr));
            this.repaint();
        }
    }

    public void setAddress(int addr) {
        this.setSelection(addr, false);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            if (this.counter == null) {
                this.counter = new Counter(this, 500L, null);
            }
            this.cursor = true;
        } else if (e.getID() == 1005 && this.counter != null) {
            if (this.right) {
                this.right = false;
                this.repaint(this.getRect(this.selected));
            }
            this.counter.stop();
            this.counter = null;
            this.timerTick(null);
        }
        super.processFocusEvent(e);
    }

    @Override
    public void timerTick(Counter counter) {
        this.cursor = !this.cursor && counter != null;
        this.repaint(this.getRect(this.selected));
    }
}

