/*
 * Decompiled with CFR 0.152.
 */
package JCPC.util.diss;

import JCPC.core.Util;
import JCPC.core.device.memory.Memory;
import JCPC.util.diss.Disassembler;

public class Diss6502
extends Disassembler {
    protected static final String[] cc00 = new String[]{"???", "BIT ", "JMP ", "JMP (", "STY ", "LDY ", "CPY ", "CPX "};
    protected static final String[] cc01 = new String[]{"ORA ", "AND ", "EOR ", "ADC ", "STA ", "LDA ", "CMP ", "SBC "};
    protected static final String[] cc10 = new String[]{"ASL ", "ROL ", "LSR ", "ROR ", "STX ", "LDX ", "DEC ", "INC "};
    protected static final String[] cc00b2 = new String[]{"PHP", "PLP", "PHA", "PLA", "DEY", "TAY", "INY", "INX"};
    protected static final String[] cc00b6 = new String[]{"CLC", "SEC", "CLI", "SEI", "TYA", "CLV", "CLD", "SED"};
    protected static final String[] cc10b2 = new String[]{"TXA", "TAX", "DEX", "NOP"};
    protected static final String[] branch = new String[]{"BPL ", "BMI ", "BVC ", "BVS ", "BCC ", "BCS ", "BNE ", "BEQ "};

    @Override
    public String disassemble(Memory memory, int[] address) {
        int opcode = memory.readByte(this.nextAddress(address), this.config);
        int aaa = opcode >> 5 & 7;
        int bbb = opcode >> 2 & 7;
        String result = "???";
        if ((opcode & 2) == 0) {
            if ((opcode & 1) == 0) {
                if (bbb == 2) {
                    result = cc00b2[aaa];
                } else if (bbb == 4) {
                    result = branch[aaa] + "&" + Util.hex((short)(address[0] + (byte)memory.readByte(this.nextAddress(address), this.config) + 1));
                } else if (bbb == 6) {
                    result = cc00b6[aaa];
                } else {
                    block0 : switch (bbb) {
                        case 0: {
                            switch (aaa) {
                                case 0: {
                                    result = "BRK";
                                    break block0;
                                }
                                case 1: {
                                    result = "JSR " + this.nn(memory, address);
                                    break block0;
                                }
                                case 2: {
                                    result = "RTI";
                                    break block0;
                                }
                                case 3: {
                                    result = "RTS";
                                    break block0;
                                }
                                case 4: {
                                    result = "???";
                                    break block0;
                                }
                            }
                            result = cc00[aaa] + "#" + this.n(memory, address);
                            break;
                        }
                        case 1: {
                            result = aaa == 1 || aaa > 3 ? cc00[aaa] + this.n(memory, address) : "???";
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            result = aaa == 0 ? "???" : cc00[aaa] + this.nn(memory, address) + (aaa == 3 ? ")" : "");
                            break;
                        }
                        case 5: {
                            result = aaa == 4 || aaa == 5 ? cc00[aaa] + this.n(memory, address) + ",X" : "???";
                            break;
                        }
                        case 7: {
                            result = aaa == 5 ? cc00[aaa] + this.nn(memory, address) + ",X" : "???";
                        }
                    }
                }
            } else {
                switch (bbb) {
                    case 0: {
                        result = cc01[aaa] + "(" + this.n(memory, address) + ",X)";
                        break;
                    }
                    case 1: {
                        result = cc01[aaa] + this.n(memory, address);
                        break;
                    }
                    case 2: {
                        result = aaa == 4 ? "???" : cc01[aaa] + "#" + this.n(memory, address);
                        break;
                    }
                    case 3: {
                        result = cc01[aaa] + this.nn(memory, address);
                        break;
                    }
                    case 4: {
                        result = cc01[aaa] + "(" + this.n(memory, address) + "),Y";
                        break;
                    }
                    case 5: {
                        result = cc01[aaa] + this.n(memory, address) + ",X";
                        break;
                    }
                    case 6: {
                        result = cc01[aaa] + this.nn(memory, address) + ",Y";
                        break;
                    }
                    case 7: {
                        result = cc01[aaa] + this.nn(memory, address) + ",X";
                    }
                }
            }
        } else if ((opcode & 1) == 0) {
            switch (bbb) {
                case 0: {
                    result = aaa == 5 ? cc10[aaa] + "#" + this.n(memory, address) : "???";
                    break;
                }
                case 1: {
                    result = cc10[aaa] + this.n(memory, address);
                    break;
                }
                case 2: {
                    result = aaa > 3 ? cc10b2[aaa - 4] : cc10[aaa].substring(0, 3);
                    break;
                }
                case 3: {
                    result = cc10[aaa] + this.nn(memory, address);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    result = cc10[aaa] + this.n(memory, address) + (aaa == 4 || aaa == 5 ? ",Y" : ",X");
                    break;
                }
                case 6: {
                    result = aaa == 4 ? "TXS" : (aaa == 5 ? "TSX" : "???");
                    break;
                }
                case 7: {
                    result = aaa == 4 ? "???" : cc10[aaa] + this.nn(memory, address) + (aaa == 5 ? ",Y" : ",X");
                }
            }
        }
        return result;
    }

    protected String n(Memory memory, int[] address) {
        return "&" + Util.hex((byte)memory.readByte(this.nextAddress(address), this.config));
    }

    protected String nn(Memory memory, int[] address) {
        int lsb = memory.readByte(this.nextAddress(address), this.config);
        return "&" + Util.hex((short)(lsb + (memory.readByte(this.nextAddress(address), this.config) << 8)));
    }
}

