/*
 * Decompiled with CFR 0.152.
 */
package classes;

import CPCFileSystem.CPCFileSystem;
import classes.CPCSCRHandler;
import classes.Settings;
import classes.TileGrabber;
import classes.UniPixelViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.SoftBevelBorder;
import jemu.core.Util;
import jemu.ui.Desktop;

public class MapGen
extends JFrame {
    boolean blockDraw = false;
    int blockDelay;
    ActionListener update = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MapGen.this.view.hasFocus() && MapGen.this.isGenerated) {
                if (MapGen.this.blockDraw) {
                    return;
                }
                if (MapGen.this.blockMove) {
                    ++MapGen.this.blockDelay;
                    if (MapGen.this.blockDelay > 5) {
                        MapGen.this.blockDelay = 0;
                        MapGen.this.blockMove = false;
                    }
                    return;
                }
                MapGen.this.drawMap(MapGen.this.zoomFactor);
            }
        }
    };
    boolean blockMove = false;
    ActionListener updateMouse = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MapGen.this.view.hasFocus() && MapGen.this.isGenerated) {
                if (MapGen.this.blockDraw) {
                    return;
                }
                if (!MapGen.this.autoScroll.isSelected()) {
                    return;
                }
                int k = -(MapGen.this.jScrollPane1.getVerticalScrollBar().getValue() - MapGen.this.lastY * MapGen.this.zoomFactor);
                if (k < 80 || k > MapGen.this.jScrollPane1.getHeight() - 80) {
                    MapGen.this.blockMove = true;
                    if (k < 80) {
                        MapGen.this.jScrollPane1.getVerticalScrollBar().setValue(MapGen.this.jScrollPane1.getVerticalScrollBar().getValue() - (MapGen.this.tileHeight + 1) * MapGen.this.zoomFactor);
                    } else {
                        MapGen.this.jScrollPane1.getVerticalScrollBar().setValue(MapGen.this.jScrollPane1.getVerticalScrollBar().getValue() + (MapGen.this.tileHeight + 1) * MapGen.this.zoomFactor);
                    }
                }
                if ((k = -(MapGen.this.jScrollPane1.getHorizontalScrollBar().getValue() - MapGen.this.lastX * MapGen.this.zoomFactor)) < 80 || k > MapGen.this.jScrollPane1.getWidth() - 80) {
                    if (k < 80) {
                        MapGen.this.blockMove = true;
                        MapGen.this.jScrollPane1.getHorizontalScrollBar().setValue(MapGen.this.jScrollPane1.getHorizontalScrollBar().getValue() - (MapGen.this.tileWidth + 1) * MapGen.this.zoomFactor);
                    } else {
                        MapGen.this.jScrollPane1.getHorizontalScrollBar().setValue(MapGen.this.jScrollPane1.getHorizontalScrollBar().getValue() + (MapGen.this.tileWidth + 1) * MapGen.this.zoomFactor);
                    }
                }
            }
        }
    };
    Timer fireUpdate = new Timer(50, this.update);
    Timer fireUpdateMouse = new Timer(15, this.updateMouse);
    public BufferedImage[] tiles;
    protected BufferedImage mapImage;
    protected BufferedImage Overlay;
    private boolean isGenerated = false;
    int[][] matrix;
    int tileWidth;
    int tileHeight;
    int mapWidth;
    int mapHeight;
    public BufferedImage image;
    UniPixelViewer viewer;
    int zoomFactor = 1;
    TileGrabber grabber;
    int lastXD = 0;
    int lastYD = 0;
    Color transparent = new Color(255, 255, 255, 96);
    BufferedImage spriteImage;
    public boolean removeDuplicate = false;
    BufferedImage tileView;
    FileDialog exportdialog;
    FileDialog importdialog;
    protected byte[] rawdata;
    int lastX;
    int lastY;
    int bitMapWidth;
    BufferedImage error;
    int matrixWidth;
    BufferedImage blank;
    boolean useBlank = false;
    Desktop desktop;
    boolean isKeyStroke = false;
    private JCheckBox autoScroll;
    private JButton exp;
    private JButton gen;
    private JButton imp;
    private JButton impraw;
    private JCheckBox is16bit;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton5;
    private JButton jButton6;
    private JComboBox<String> jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField mapXSize;
    private JTextField mapYSize;
    private JTextField rawOff;
    private JLabel tileIcon;
    private JComboBox<String> tileSelect;
    private JTextField tileXSize;
    private JTextField tileYSize;
    private JLabel tileview;
    private JLabel view;

    public void setStyle() {
        if (this.grabber != null) {
            SwingUtilities.updateComponentTreeUI(this.grabber);
            this.grabber.pack();
        }
    }

    public void setTileSize() {
        this.tileWidth = this.grabber.getSprWidth();
        this.tileHeight = this.grabber.getSprHeight();
        this.tileXSize.setText("" + this.tileWidth);
        this.tileYSize.setText("" + this.tileHeight);
    }

    protected void drawMap(int z) {
        if (!this.isGenerated) {
            return;
        }
        if (this.Overlay == null) {
            this.generateMap();
        }
        BufferedImage zoom = new BufferedImage(this.Overlay.getWidth() * z, this.Overlay.getHeight() * z, 2);
        Graphics g = zoom.getGraphics();
        g.drawImage(this.Overlay, 0, 0, zoom.getWidth(), zoom.getHeight(), null);
        g.setColor(new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0)));
        int x = this.lastXD / (this.tileWidth + 1) * (this.tileWidth + 1) * this.zoomFactor;
        int y = this.lastYD / (this.tileHeight + 1) * (this.tileHeight + 1) * this.zoomFactor;
        int w = (this.tileWidth + 1) * this.zoomFactor;
        int h = (this.tileHeight + 1) * this.zoomFactor;
        if (!this.autoScroll.isSelected() && this.isKeyStroke) {
            int k = -(this.jScrollPane1.getVerticalScrollBar().getValue() - this.lastY * this.zoomFactor);
            if (k < 80 || k > this.jScrollPane1.getHeight() - 80) {
                this.blockMove = true;
                if (k < 80) {
                    this.jScrollPane1.getVerticalScrollBar().setValue(this.jScrollPane1.getVerticalScrollBar().getValue() - (this.tileHeight + 1) * this.zoomFactor);
                } else {
                    this.jScrollPane1.getVerticalScrollBar().setValue(this.jScrollPane1.getVerticalScrollBar().getValue() + (this.tileHeight + 1) * this.zoomFactor);
                }
            }
            if ((k = -(this.jScrollPane1.getHorizontalScrollBar().getValue() - this.lastX * this.zoomFactor)) < 80 || k > this.jScrollPane1.getWidth() - 80) {
                if (k < 80) {
                    this.blockMove = true;
                    this.jScrollPane1.getHorizontalScrollBar().setValue(this.jScrollPane1.getHorizontalScrollBar().getValue() - (this.tileWidth + 1) * this.zoomFactor);
                } else {
                    this.jScrollPane1.getHorizontalScrollBar().setValue(this.jScrollPane1.getHorizontalScrollBar().getValue() + (this.tileWidth + 1) * this.zoomFactor);
                }
            }
            this.isKeyStroke = false;
        }
        g.drawRect(x, y, w, h);
        this.view.setIcon(new ImageIcon(zoom));
        this.view.setPreferredSize(new Dimension(zoom.getWidth(), zoom.getHeight()));
    }

    public void draw() {
        if (this.image == null) {
            return;
        }
        this.spriteImage = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 1);
        int nr = this.grabber.getNumber();
        int posX = this.grabber.getPosX();
        int posY = this.grabber.getPosY();
        int width = this.grabber.getSprWidth();
        int height = this.grabber.getSprHeight();
        Graphics2D g = this.spriteImage.createGraphics();
        g.drawImage((Image)this.image, 0, 0, null);
        int firstPosX = posX;
        int k = 0;
        for (int i = 0; i < nr; ++i) {
            g.setColor(this.transparent);
            g.fillRect(posX, posY, width, height);
            g.setColor(Color.red);
            g.drawRect(posX, posY, width, height);
            int split = this.grabber.getSplit();
            if ((split <= 0 || split != ++k) && (posX += width + this.grabber.getGapX()) + width + this.grabber.getGapX() <= this.image.getWidth() + this.grabber.getGapX()) continue;
            posX = this.grabber.getBeginZero() ? 0 : firstPosX;
            posY += height + this.grabber.getGapY();
            k = 0;
        }
        BufferedImage zoom = new BufferedImage(this.spriteImage.getWidth() * this.zoomFactor, this.spriteImage.getHeight() * this.zoomFactor, 1);
        zoom.getGraphics().drawImage(this.spriteImage, 0, 0, zoom.getWidth(), zoom.getHeight(), null);
        this.view.setIcon(new ImageIcon(zoom));
        this.view.setPreferredSize(new Dimension(zoom.getWidth(), zoom.getHeight()));
    }

    public void doTiles() {
        int i;
        if (this.image == null) {
            return;
        }
        int nr = this.grabber.getNumber();
        BufferedImage trimBuffer = new BufferedImage(384, 272, 1);
        int x = this.grabber.getPosX();
        int y = this.grabber.getPosY();
        int w = this.grabber.getSprWidth();
        int h = this.grabber.getSprHeight();
        this.initTiles(nr, w, h);
        BufferedImage shape = new BufferedImage(w, h, 1);
        Graphics g = shape.getGraphics();
        Graphics v = trimBuffer.getGraphics();
        System.out.println("Grabbing " + nr + " sprites");
        boolean[] add = new boolean[this.tiles.length];
        for (i = 0; i < add.length; ++i) {
            add[i] = true;
        }
        for (i = 0; i < nr; ++i) {
            g.drawImage(this.image, -x, -y, null);
            this.feedTile(shape, i);
            if ((x += w + this.grabber.getGapX()) + w + this.grabber.getGapX() > this.image.getWidth() + this.grabber.getGapX()) {
                x = this.grabber.getBeginZero() ? 0 : this.grabber.getPosX();
                y = y + h + this.grabber.getGapY();
            }
            if (i <= 0 || !this.removeDuplicate) continue;
            for (int k = 0; k < i; ++k) {
                if (!this.compareImage(shape, this.tiles[k])) continue;
                add[i] = false;
            }
        }
        if (this.removeDuplicate) {
            String[] model;
            int i2;
            int off = 0;
            for (int i3 = 0; i3 < add.length; ++i3) {
                if (!add[i3]) continue;
                ++off;
            }
            System.out.println(off + " used tiles");
            BufferedImage[] newTiles = new BufferedImage[off];
            off = 0;
            for (i2 = 0; i2 < this.tiles.length; ++i2) {
                if (!add[i2]) continue;
                newTiles[off] = new BufferedImage(this.tiles[i2].getWidth(), this.tiles[i2].getHeight(), 1);
                newTiles[off++].getGraphics().drawImage(this.tiles[i2], 0, 0, null);
            }
            this.tiles = new BufferedImage[newTiles.length];
            for (i2 = 0; i2 < this.tiles.length; ++i2) {
                this.tiles[i2] = new BufferedImage(w, h, 1);
                this.feedTile(newTiles[i2], i2);
            }
            if (this.useBlank) {
                model = new String[this.tiles.length + 1];
                model[0] = "<blank>";
                for (int i4 = 0; i4 < model.length - 1; ++i4) {
                    model[i4 + 1] = "Tile " + (i4 + 1);
                }
            } else {
                model = new String[this.tiles.length];
                for (int i5 = 0; i5 < model.length; ++i5) {
                    model[i5] = "Tile " + (i5 + 1);
                }
            }
            this.tileSelect.setModel(new DefaultComboBoxModel<String>(model));
        }
        this.drawTileWindow();
        this.gen.setEnabled(true);
        this.imp.setEnabled(true);
        this.exp.setEnabled(true);
    }

    public boolean compareImage(BufferedImage biA, BufferedImage biB) {
        DataBuffer dbB;
        int sizeB;
        DataBuffer dbA = biA.getData().getDataBuffer();
        int sizeA = dbA.getSize();
        if (sizeA == (sizeB = (dbB = biB.getData().getDataBuffer()).getSize())) {
            for (int i = 0; i < sizeA; ++i) {
                if (dbA.getElem(i) == dbB.getElem(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void openGrabber() {
        if (this.desktop == null) {
            PointerInfo a = MouseInfo.getPointerInfo();
            Point b = a.getLocation();
            int x = (int)b.getX();
            int y = (int)b.getY();
            this.grabber.setLocation(x - 60, y - 256);
            this.grabber.setVisible(true);
        } else {
            this.desktop.openMapGrabber(this.grabber);
        }
    }

    public MapGen(UniPixelViewer viewer, Desktop desktop) {
        this.desktop = desktop;
        this.initComponents();
        this.autoScroll.setSelected(Settings.getBoolean("Autoscroll", true));
        this.tileview.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MapGen.this.viewKeyPressed(evt);
            }
        });
        this.fireUpdate.start();
        this.fireUpdateMouse.start();
        this.grabber = new TileGrabber(this);
        this.viewer = viewer;
    }

    protected void exportMap() {
        if (!this.isGenerated) {
            return;
        }
        if (this.exportdialog == null) {
            this.exportdialog = new FileDialog((Frame)this, "Export map", 1);
        }
        this.exportdialog.setFile("*.csv");
        this.exportdialog.setVisible(true);
        String path = this.exportdialog.getDirectory();
        String file = this.exportdialog.getFile();
        if (file != null && path != null) {
            try {
                if (!file.toLowerCase().endsWith(".csv")) {
                    file = file + ".csv";
                }
                String filename = path + file;
                File a = new File(filename);
                filename = filename.replace(".csv", "-map.png");
                File b = new File(filename);
                filename = filename.replace("-map.png", "-map.asm");
                File c = new File(filename);
                filename = filename.replace("-map.asm", "-map.bin");
                File d = new File(filename);
                StringBuilder map = new StringBuilder();
                for (int y = 0; y < this.mapHeight; ++y) {
                    for (int x = 0; x < this.mapWidth; ++x) {
                        String ch = Util.hex((byte)this.matrix[x][y]);
                        map.append(x == 0 ? "DB " : "").append("#").append(ch).append(x < this.mapWidth - 1 ? "," : "");
                    }
                    map.append("\r\n");
                }
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(c));
                bos.write(map.toString().getBytes("UTF-8"));
                bos.close();
                map = new StringBuilder();
                byte[] mapdata = new byte[this.mapHeight * this.mapWidth];
                int off = 0;
                for (int y = 0; y < this.mapHeight; ++y) {
                    for (int x = 0; x < this.mapWidth; ++x) {
                        map.append(this.matrix[x][y] + (x < this.mapWidth - 1 ? "," : ""));
                        mapdata[off++] = (byte)this.matrix[x][y];
                    }
                    map.append("\r\n");
                }
                bos = new BufferedOutputStream(new FileOutputStream(a));
                bos.write(map.toString().getBytes("UTF-8"));
                bos.close();
                BufferedImage theMap = new BufferedImage(this.mapWidth * this.tileWidth * this.zoomFactor, this.mapHeight * this.tileHeight * this.zoomFactor, 1);
                Graphics g = theMap.getGraphics();
                for (int x = 0; x < this.mapWidth; ++x) {
                    for (int y = 0; y < this.mapHeight; ++y) {
                        g.drawImage(this.tiles[this.matrix[x][y]], x * this.tileWidth * this.zoomFactor, y * this.tileHeight * this.zoomFactor, this.tileWidth * this.zoomFactor, this.tileHeight * this.zoomFactor, null);
                    }
                }
                ImageIO.write((RenderedImage)theMap, "PNG", b);
                mapdata = new CPCFileSystem().makeHeader(2, 0, mapdata.length, 0, "MAPDATA", mapdata);
                bos = new BufferedOutputStream(new FileOutputStream(d));
                bos.write(mapdata);
                bos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void importRaw() {
        if (this.importdialog == null) {
            this.importdialog = new FileDialog((Frame)this, "Import map", 0);
        }
        this.importdialog.setFile("*.*");
        this.importdialog.setVisible(true);
        String path = this.importdialog.getDirectory();
        String file = this.importdialog.getFile();
        if (file != null && path != null) {
            try {
                String filename = path + file;
                File a = new File(filename);
                if (!a.exists()) {
                    return;
                }
                byte[] data = new byte[(int)a.length()];
                try (BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));){
                    bin.read(data);
                }
                if (CPCSCRHandler.CheckAMSDOS(data)) {
                    data = CPCSCRHandler.getCPCFile(data);
                }
                this.rawdata = new byte[data.length];
                System.arraycopy(data, 0, this.rawdata, 0, data.length);
                this.generateMap();
                int off = 0;
                block13: for (int y = 0; y < this.mapHeight; ++y) {
                    for (int x = 0; x < this.mapWidth; ++x) {
                        try {
                            int h;
                            this.matrix[x][y] = h = data[off++] & 0xFF;
                            continue;
                        }
                        catch (Exception e) {
                            continue block13;
                        }
                    }
                }
                this.drawMatrix();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void scanRawData(int off) {
        block2: for (int y = 0; y < this.mapHeight; ++y) {
            for (int x = 0; x < this.mapWidth; ++x) {
                try {
                    int h;
                    if (this.is16bit.isSelected()) {
                        h = UniPixelViewer.getWord(this.rawdata, off);
                        off += 2;
                    } else {
                        h = this.rawdata[off++] & 0xFF;
                    }
                    this.matrix[x][y] = h;
                    continue;
                }
                catch (Exception e) {
                    continue block2;
                }
            }
        }
        this.drawMatrix();
    }

    protected void importMap() {
        if (this.importdialog == null) {
            this.importdialog = new FileDialog((Frame)this, "Import map", 0);
        }
        this.importdialog.setFile("*.csv");
        this.importdialog.setVisible(true);
        String path = this.importdialog.getDirectory();
        String file = this.importdialog.getFile();
        if (file != null && path != null) {
            try {
                String filename = path + file;
                File a = new File(filename);
                if (!a.exists()) {
                    return;
                }
                byte[] data = new byte[(int)a.length()];
                BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
                bin.read(data);
                bin.close();
                StringBuilder map = new StringBuilder();
                for (int i = 0; i < data.length; ++i) {
                    map.append((char)(data[i] & 0xFF));
                }
                String mapdata = map.toString();
                boolean isHex = false;
                if (mapdata.contains("#") || mapdata.contains("&") || mapdata.contains("0x")) {
                    isHex = true;
                }
                mapdata = mapdata.replace("DB ", "");
                mapdata = mapdata.replace("#", "");
                String[] d = mapdata.split("\r\n");
                this.mapYSize.setText(d.length + "");
                String[] w = d[0].split(",");
                this.mapXSize.setText(w.length + "");
                int off = 0;
                this.generateMap();
                for (int y = 0; y < this.mapHeight; ++y) {
                    String[] g = d[off + y].split(",");
                    for (int x = 0; x < this.mapWidth; ++x) {
                        int h;
                        this.matrix[x][y] = h = isHex ? Util.hexValue(g[x]) : Integer.parseInt(g[x]);
                    }
                }
                this.drawMatrix();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void drawMatrix() {
        if (this.matrix == null) {
            return;
        }
        this.blank = new BufferedImage(this.tileWidth, this.tileHeight, 1);
        Graphics g = this.blank.getGraphics();
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, this.tileWidth, this.tileHeight);
        this.error = new BufferedImage(this.tileWidth, this.tileHeight, 1);
        g = this.error.getGraphics();
        g.setColor(Color.MAGENTA);
        g.fillRect(0, 0, this.tileWidth, this.tileHeight);
        g.setColor(Color.BLACK);
        g.drawLine(0, 0, this.tileWidth, this.tileHeight);
        g.drawLine(this.tileWidth, 0, 0, this.tileHeight);
        Graphics d = this.mapImage.getGraphics();
        for (int y = 0; y < this.mapHeight; ++y) {
            for (int x = 0; x < this.mapWidth; ++x) {
                int i = this.matrix[x][y];
                try {
                    if (this.useBlank) {
                        if (i == 0) {
                            d.drawImage(this.blank, x * (this.tileWidth + 1) + 1, y * (this.tileHeight + 1) + 1, null);
                            continue;
                        }
                        if (this.tiles == null || this.tiles[i] == null) {
                            g.setColor(Color.black);
                            g.drawString(i - 1 + "", 4, 20);
                            d.drawImage(this.blank, x * (this.tileWidth + 1) + 1, y * (this.tileHeight + 1) + 1, null);
                            g.setColor(Color.lightGray);
                            g.fillRect(0, 0, this.tileWidth, this.tileHeight);
                            continue;
                        }
                        d.drawImage(this.tiles[i - 1], x * (this.tileWidth + 1) + 1, y * (this.tileHeight + 1) + 1, null);
                        continue;
                    }
                    d.drawImage(this.tiles[i], x * (this.tileWidth + 1) + 1, y * (this.tileHeight + 1) + 1, null);
                    continue;
                }
                catch (Exception ex) {
                    d.drawImage(this.error, x * (this.tileWidth + 1) + 1, y * (this.tileHeight + 1) + 1, null);
                }
            }
        }
        g = this.Overlay.getGraphics();
        g.drawImage(this.mapImage, 0, 0, null);
        int w = this.mapImage.getWidth();
        int h = this.mapImage.getHeight();
        g.setColor(Color.white);
        for (int x = 0; x < w; x += this.tileWidth + 1) {
            g.drawLine(x, 0, x, h);
        }
        for (int y = 0; y < h; y += this.tileHeight + 1) {
            g.drawLine(0, y, w, y);
        }
        this.drawMap(this.zoomFactor);
    }

    public void initTiles(int nr, int w, int h) {
        int i;
        String[] model;
        this.tiles = new BufferedImage[nr];
        this.tileWidth = w;
        this.tileHeight = h;
        if (this.useBlank) {
            model = new String[this.tiles.length + 1];
            model[0] = "<blank>";
            for (i = 0; i < model.length - 1; ++i) {
                model[i + 1] = "Tile " + (i + 1);
            }
        } else {
            model = new String[this.tiles.length];
            for (i = 0; i < model.length; ++i) {
                model[i] = "Tile " + (i + 1);
            }
        }
        this.tileSelect.setModel(new DefaultComboBoxModel<String>(model));
        for (i = 0; i < nr; ++i) {
            this.tiles[i] = new BufferedImage(w, h, 1);
        }
    }

    public void previewTile(int x, int y) {
        if (this.tiles == null) {
            return;
        }
        BufferedImage bum = new BufferedImage(128, 128, 1);
        Graphics g = bum.getGraphics();
        Graphics2D l2 = (Graphics2D)g;
        l2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        this.tileIcon.setIcon(new ImageIcon(bum));
        int index = (x /= this.tileWidth + 1) + (y /= this.tileHeight + 1) * this.bitMapWidth;
        if (index >= this.tiles.length) {
            return;
        }
        if (this.useBlank) {
            if (index == 0) {
                g.drawImage(this.blank, 0, 0, 128, 128, null);
            } else {
                g.drawImage(this.tiles[index - 1], 0, 0, 128, 128, null);
            }
        } else {
            g.drawImage(this.tiles[index], 0, 0, 128, 128, null);
        }
        this.tileIcon.setIcon(new ImageIcon(bum));
    }

    public void getTile(int x, int y) {
        int posX = (x /= this.tileWidth + 1) * (this.tileWidth + 1);
        int posY = (y /= this.tileHeight + 1) * (this.tileHeight + 1);
        int index = x + y * this.bitMapWidth;
        if (index > this.tiles.length) {
            return;
        }
        this.tileSelect.setSelectedIndex(index);
        Graphics g = this.tileView.getGraphics();
        g.setColor(Color.white);
        x = 0;
        y = 0;
        for (int i = 0; i < this.tiles.length + (this.useBlank ? 1 : 0); ++i) {
            g.setColor(Color.white);
            g.drawRect(x, y, this.tileWidth + 1, this.tileHeight + 1);
            if (this.useBlank) {
                g.drawImage(i == 0 ? this.blank : this.tiles[i - 1], x + 1, y + 1, null);
            } else {
                g.drawImage(this.tiles[i], x + 1, y + 1, null);
            }
            x = x + this.tileWidth + 1;
            if (x + this.tileWidth + 1 < 200) continue;
            y = y + this.tileHeight + 1;
            x = 0;
        }
        g.setColor(Color.blue);
        g.drawRect(posX, posY, this.tileWidth + 1, this.tileHeight + 1);
        g.setColor(new Color(255, 255, 255, 120));
        g.fillRect(posX + 1, posY + 1, this.tileWidth, this.tileHeight);
        this.tileview.setIcon(new ImageIcon(this.tileView));
    }

    public void drawTile() {
        int i;
        int x = 0;
        int y = 0;
        Graphics g = this.tileView.getGraphics();
        g.setColor(Color.white);
        for (i = 0; i < this.tiles.length + (this.useBlank ? 1 : 0); ++i) {
            g.setColor(Color.white);
            g.drawRect(x, y, this.tileWidth + 1, this.tileHeight + 1);
            if (this.useBlank) {
                g.drawImage(i == 0 ? this.blank : this.tiles[i - 1], x + 1, y + 1, null);
            } else {
                g.drawImage(this.tiles[i], x + 1, y + 1, null);
            }
            x = x + this.tileWidth + 1;
            if (x + this.tileWidth + 1 < 200) continue;
            y = y + this.tileHeight + 1;
            x = 0;
        }
        i = this.tileSelect.getSelectedIndex();
        int posX = i % this.matrixWidth;
        int posY = i / this.matrixWidth;
        g.setColor(Color.blue);
        g.drawRect(posX *= this.tileWidth + 1, posY *= this.tileWidth + 1, this.tileWidth + 1, this.tileHeight + 1);
        g.setColor(new Color(255, 255, 255, 120));
        g.fillRect(posX + 1, posY + 1, this.tileWidth, this.tileHeight);
        this.tileview.setIcon(new ImageIcon(this.tileView));
        this.drawTile(this.lastX, this.lastY, false);
    }

    public void drawTileWindow() {
        int i;
        this.blank = new BufferedImage(this.tileWidth, this.tileHeight, 1);
        Graphics g = this.blank.getGraphics();
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, this.tileWidth, this.tileHeight);
        this.error = new BufferedImage(this.tileWidth, this.tileHeight, 1);
        g = this.error.getGraphics();
        g.setColor(Color.MAGENTA);
        g.fillRect(0, 0, this.tileWidth, this.tileHeight);
        g.setColor(Color.BLACK);
        g.drawLine(0, 0, this.tileWidth, this.tileHeight);
        g.drawLine(this.tileWidth, 0, 0, this.tileHeight);
        int x = 0;
        int y = 0;
        this.bitMapWidth = 0;
        for (i = 0; i < this.tiles.length + (this.useBlank ? 1 : 0); ++i) {
            if ((x = x + this.tileWidth + 1) + this.tileWidth + 1 <= 201) continue;
            if (y == 0) {
                this.matrixWidth = i + 1;
            }
            if (this.bitMapWidth == 0) {
                this.bitMapWidth = i + 1;
            }
            y = y + this.tileHeight + 1;
            x = 0;
        }
        this.tileView = new BufferedImage(200, y + this.tileHeight + 1, 1);
        g = this.tileView.getGraphics();
        x = 0;
        y = 0;
        for (i = 0; i < this.tiles.length + (this.useBlank ? 1 : 0); ++i) {
            g.setColor(Color.white);
            g.drawRect(x, y, this.tileWidth + 1, this.tileHeight + 1);
            if (this.useBlank) {
                g.drawImage(i == 0 ? this.blank : this.tiles[i - 1], x + 1, y + 1, null);
            } else {
                g.drawImage(this.tiles[i], x + 1, y + 1, null);
            }
            x = x + this.tileWidth + 1;
            if (x + this.tileWidth + 1 < 200) continue;
            y = y + this.tileHeight + 1;
            x = 0;
        }
        this.tileview.setIcon(new ImageIcon(this.tileView));
        this.view.requestFocus();
    }

    public void feedTile(BufferedImage in, int index) {
        Graphics2D g = this.tiles[index].createGraphics();
        g.drawImage((Image)in, 0, 0, null);
    }

    protected void paintTile(int index) {
        if (this.tiles == null) {
            return;
        }
        BufferedImage bum = new BufferedImage(128, 128, 1);
        Graphics g = bum.getGraphics();
        Graphics2D l2 = (Graphics2D)g;
        l2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (this.useBlank) {
            if (index == 0) {
                g.drawImage(this.blank, 0, 0, 128, 128, null);
            } else {
                g.drawImage(this.tiles[index - 1], 0, 0, 128, 128, null);
            }
        } else {
            g.drawImage(this.tiles[index], 0, 0, 128, 128, null);
        }
        this.tileIcon.setIcon(new ImageIcon(bum));
    }

    protected void generateMap() {
        int sw = Integer.parseInt(this.tileXSize.getText()) + 1;
        int sh = Integer.parseInt(this.tileYSize.getText()) + 1;
        this.tileWidth = sw - 1;
        this.tileHeight = sh - 1;
        int w = Integer.parseInt(this.mapXSize.getText());
        int h = Integer.parseInt(this.mapYSize.getText());
        this.mapWidth = w;
        this.mapHeight = h;
        this.matrix = new int[w][h];
        this.mapImage = new BufferedImage(w * sw, h * sh, 1);
        this.Overlay = new BufferedImage(w * sw, h * sh, 2);
        w = this.mapImage.getWidth();
        h = this.mapImage.getHeight();
        Graphics g = this.mapImage.getGraphics();
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, w, h);
        g = this.Overlay.getGraphics();
        g.drawImage(this.mapImage, 0, 0, null);
        g.setColor(Color.white);
        for (int x = 0; x < w; x += sw) {
            g.drawLine(x, 0, x, h);
        }
        System.out.println("We draw y lines with width of " + w);
        for (int y = 0; y < h; y += sh) {
            g.drawLine(0, y, w, y);
        }
        this.view.setPreferredSize(new Dimension(w, h));
        this.drawMap(this.zoomFactor);
        this.tileSelect.setEnabled(true);
        this.blank = new BufferedImage(this.tileWidth, this.tileHeight, 1);
        g = this.blank.getGraphics();
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, this.tileWidth, this.tileHeight);
        this.error = new BufferedImage(this.tileWidth, this.tileHeight, 1);
        g = this.error.getGraphics();
        g.setColor(Color.MAGENTA);
        g.fillRect(0, 0, this.tileWidth, this.tileHeight);
        g.setColor(Color.BLACK);
        g.drawLine(0, 0, this.tileWidth, this.tileHeight);
        g.drawLine(this.tileWidth, 0, 0, this.tileHeight);
        this.isGenerated = true;
    }

    protected void Fill(boolean skip) {
        if (!this.isGenerated) {
            return;
        }
        Graphics g = this.mapImage.getGraphics();
        int t = this.tileSelect.getSelectedIndex();
        for (int y = 0; y < this.mapImage.getHeight(); y += this.tileHeight + 1) {
            for (int x = 0; x < this.mapImage.getWidth(); x += this.tileWidth + 1) {
                boolean draw;
                int xx = x / (this.tileWidth + 1);
                int yy = y / (this.tileHeight + 1);
                boolean bl = draw = !skip;
                if (this.matrix[xx][yy] == 0 && skip) {
                    draw = true;
                }
                if (!draw) continue;
                if (this.useBlank) {
                    if (t == 0) {
                        g.drawImage(this.blank, x + 1, y + 1, null);
                    } else {
                        g.drawImage(this.tiles[t - 1], x + 1, y + 1, null);
                    }
                } else {
                    g.drawImage(this.tiles[t], x + 1, y + 1, null);
                }
                this.matrix[x / (this.tileWidth + 1)][y / (this.tileWidth + 1)] = t;
            }
        }
        this.drawTile(-100, -100, true);
    }

    protected void drawTile(int x, int y, boolean draw) {
        Graphics g;
        if (!this.isGenerated) {
            return;
        }
        if (this.desktop == null ? this.grabber.isVisible() : this.desktop.mapGenFrame.isVisible()) {
            return;
        }
        this.lastX = x;
        this.lastY = y;
        this.lastXD = x;
        this.lastYD = y;
        int mx = x /= this.tileWidth + 1;
        x *= this.tileWidth + 1;
        int my = y /= this.tileHeight + 1;
        if (mx >= 0 && my >= 0 && mx < this.mapWidth && my < this.mapHeight) {
            this.setTitle("UniPixelViewer - Map Builder - " + mx + "," + my + " [" + this.matrix[mx][my] + "]");
        }
        y *= this.tileHeight + 1;
        int t = this.tileSelect.getSelectedIndex();
        if (draw) {
            if (mx >= 0 && my >= 0 && mx < this.mapWidth && my < this.mapHeight) {
                this.matrix[mx][my] = t;
            }
            g = this.mapImage.getGraphics();
            try {
                if (this.useBlank) {
                    if (t == 0) {
                        g.drawImage(this.blank, x + 1, y + 1, null);
                    } else {
                        g.drawImage(this.tiles[t - 1], x + 1, y + 1, null);
                    }
                } else {
                    g.drawImage(this.tiles[t], x + 1, y + 1, null);
                }
            }
            catch (Exception ex) {
                g.drawImage(this.error, x + 1, y + 1, null);
            }
        }
        g = this.Overlay.getGraphics();
        g.drawImage(this.mapImage, 0, 0, null);
        if (this.useBlank) {
            if (t == 0) {
                g.drawImage(this.blank, x + 1, y + 1, null);
            } else {
                g.drawImage(this.tiles[t - 1], x + 1, y + 1, null);
            }
        } else if (this.tiles != null) {
            g.drawImage(this.tiles[t], x + 1, y + 1, null);
        } else {
            g.drawImage(this.blank, x + 1, y + 1, null);
        }
        int w = this.mapImage.getWidth();
        int h = this.mapImage.getHeight();
        g.setColor(Color.white);
        for (x = 0; x < w; x += this.tileWidth + 1) {
            g.drawLine(x, 0, x, h);
        }
        for (y = 0; y < h; y += this.tileHeight + 1) {
            g.drawLine(0, y, w, y);
        }
        this.drawMap(this.zoomFactor);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.mapXSize = new JTextField();
        this.jLabel3 = new JLabel();
        this.mapYSize = new JTextField();
        this.jLabel2 = new JLabel();
        this.tileXSize = new JTextField();
        this.jLabel4 = new JLabel();
        this.tileYSize = new JTextField();
        this.gen = new JButton();
        this.tileIcon = new JLabel();
        this.tileSelect = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jButton5 = new JButton();
        this.jButton2 = new JButton();
        this.jComboBox1 = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jButton6 = new JButton();
        this.imp = new JButton();
        this.exp = new JButton();
        this.autoScroll = new JCheckBox();
        this.impraw = new JButton();
        this.jButton1 = new JButton();
        this.rawOff = new JTextField();
        this.jButton3 = new JButton();
        this.is16bit = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tileview = new JLabel();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.view = new JLabel();
        this.setTitle("UniPixelViewer - Map Builder");
        this.setMaximumSize(new Dimension(10204, 5909));
        this.setMinimumSize(new Dimension(1024, 500));
        this.setPreferredSize(new Dimension(1024, 599));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setFocusable(false);
        this.jPanel1.setMaximumSize(new Dimension(156, 57557));
        this.jPanel1.setMinimumSize(new Dimension(156, 7));
        this.jLabel1.setText("Map size:");
        this.mapXSize.setColumns(3);
        this.mapXSize.setText("10");
        this.jLabel3.setText("x");
        this.mapYSize.setColumns(3);
        this.mapYSize.setText("10");
        this.jLabel2.setText("Tiles size:");
        this.tileXSize.setColumns(3);
        this.tileXSize.setText("32");
        this.jLabel4.setText("x");
        this.tileYSize.setColumns(3);
        this.tileYSize.setText("32");
        this.gen.setText("Generate Map");
        this.gen.setEnabled(false);
        this.gen.setFocusable(false);
        this.gen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapGen.this.genActionPerformed(evt);
            }
        });
        this.tileIcon.setBackground(new Color(0, 0, 0));
        this.tileIcon.setHorizontalAlignment(0);
        this.tileIcon.setBorder(BorderFactory.createEtchedBorder());
        this.tileIcon.setMaximumSize(new Dimension(132, 132));
        this.tileIcon.setMinimumSize(new Dimension(132, 132));
        this.tileIcon.setOpaque(true);
        this.tileIcon.setPreferredSize(new Dimension(132, 132));
        this.tileSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5"}));
        this.tileSelect.setEnabled(false);
        this.tileSelect.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MapGen.this.tileSelectItemStateChanged(evt);
            }
        });
        this.jLabel5.setText("Select tile:");
        this.jButton5.setText("Fill zero");
        this.jButton5.setFocusable(false);
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapGen.this.jButton5ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Fill");
        this.jButton2.setFocusable(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapGen.this.jButton2ActionPerformed(evt);
            }
        });
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"1x", "2x", "3x", "4x"}));
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MapGen.this.jComboBox1ItemStateChanged(evt);
            }
        });
        this.jLabel6.setText("Zoom:");
        this.jButton6.setText("Tile Grabber");
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapGen.this.jButton6ActionPerformed(evt);
            }
        });
        this.imp.setText("Import map");
        this.imp.setEnabled(false);
        this.imp.setFocusable(false);
        this.imp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapGen.this.impActionPerformed(evt);
            }
        });
        this.exp.setText("Export map");
        this.exp.setEnabled(false);
        this.exp.setFocusable(false);
        this.exp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapGen.this.expActionPerformed(evt);
            }
        });
        this.autoScroll.setText("Autoscroll");
        this.autoScroll.setFocusable(false);
        this.autoScroll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapGen.this.autoScrollActionPerformed(evt);
            }
        });
        this.impraw.setText("Import RAW binary");
        this.impraw.setFocusable(false);
        this.impraw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapGen.this.imprawActionPerformed(evt);
            }
        });
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/classes/arrow-left-5.png")));
        this.jButton1.setBorder(new SoftBevelBorder(0));
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapGen.this.jButton1ActionPerformed(evt);
            }
        });
        this.rawOff.setColumns(4);
        this.rawOff.setHorizontalAlignment(4);
        this.rawOff.setText("0");
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/classes/arrow-right-5.png")));
        this.jButton3.setBorder(new SoftBevelBorder(0));
        this.jButton3.setFocusable(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapGen.this.jButton3ActionPerformed(evt);
            }
        });
        this.is16bit.setText("16Bit");
        this.is16bit.setFocusable(false);
        this.is16bit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapGen.this.is16bitActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton6, -1, -1, Short.MAX_VALUE).addComponent(this.gen, -1, -1, Short.MAX_VALUE).addComponent(this.tileIcon, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tileSelect, 0, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE)).addComponent(this.exp, -1, -1, Short.MAX_VALUE).addComponent(this.imp, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.is16bit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rawOff, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3)).addComponent(this.impraw, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoScroll).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 54, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.tileXSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tileYSize, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.mapXSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mapYSize, -2, -1, -2))))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.mapXSize, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.mapYSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.tileXSize, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.tileYSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tileIcon, -2, 132, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.tileSelect, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.autoScroll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 90, Short.MAX_VALUE).addComponent(this.imp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.impraw).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.rawOff, -2, -1, -2).addComponent(this.jButton3).addComponent(this.is16bit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exp).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setMaximumSize(new Dimension(226, 342144));
        this.jPanel2.setMinimumSize(new Dimension(226, 4));
        this.jPanel2.setPreferredSize(new Dimension(226, 104));
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPane2.setMaximumSize(new Dimension(200, 3231131));
        this.jScrollPane2.setPreferredSize(new Dimension(200, 100));
        this.tileview.setVerticalAlignment(1);
        this.tileview.setFocusable(false);
        this.tileview.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                MapGen.this.tileviewMouseMoved(evt);
            }
        });
        this.tileview.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                MapGen.this.tileviewMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                MapGen.this.tileviewMouseReleased(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.tileview);
        this.jPanel2.add((Component)this.jScrollPane2, "Center");
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setMinimumSize(new Dimension(22, 27));
        this.jPanel3.setLayout(new BorderLayout());
        this.jScrollPane1.setMaximumSize(new Dimension(26600, Short.MAX_VALUE));
        this.jScrollPane1.setMinimumSize(new Dimension(90, 23));
        this.view.setVerticalAlignment(1);
        this.view.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MapGen.this.viewMouseDragged(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                MapGen.this.viewMouseMoved(evt);
            }
        });
        this.view.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MapGen.this.viewFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MapGen.this.viewFocusLost(evt);
            }
        });
        this.view.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MapGen.this.viewMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                MapGen.this.viewMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MapGen.this.viewMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                MapGen.this.viewMouseReleased(evt);
            }
        });
        this.view.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MapGen.this.viewKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.view);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, 671, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void genActionPerformed(ActionEvent evt) {
        this.generateMap();
    }

    private void tileSelectItemStateChanged(ItemEvent evt) {
        this.paintTile(this.tileSelect.getSelectedIndex());
    }

    private void viewMouseMoved(MouseEvent evt) {
        this.drawTile(evt.getX() / this.zoomFactor, evt.getY() / this.zoomFactor, false);
        this.view.requestFocus();
        this.blockMove = true;
    }

    private void viewMouseClicked(MouseEvent evt) {
        this.drawTile(evt.getX() / this.zoomFactor, evt.getY() / this.zoomFactor, true);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.Fill(false);
    }

    private void expActionPerformed(ActionEvent evt) {
        this.exportMap();
    }

    private void impActionPerformed(ActionEvent evt) {
        this.importMap();
    }

    private void tileviewMouseReleased(MouseEvent evt) {
        this.getTile(evt.getX(), evt.getY());
    }

    private void viewMouseDragged(MouseEvent evt) {
        this.blockDraw = true;
        this.drawTile(evt.getX(), evt.getY(), true);
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.Fill(true);
    }

    private void jComboBox1ItemStateChanged(ItemEvent evt) {
        this.zoomFactor = this.jComboBox1.getSelectedIndex() + 1;
        if (this.grabber.isVisible()) {
            this.draw();
        } else {
            this.drawMap(this.zoomFactor);
        }
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.openGrabber();
    }

    private void tileviewMouseMoved(MouseEvent evt) {
        this.previewTile(evt.getX(), evt.getY());
    }

    private void tileviewMouseExited(MouseEvent evt) {
        this.paintTile(this.tileSelect.getSelectedIndex());
    }

    private void viewMouseReleased(MouseEvent evt) {
        this.blockDraw = false;
        this.view.requestFocus();
    }

    private void viewKeyPressed(KeyEvent evt) {
        int t;
        if (evt.getKeyCode() == 32) {
            this.drawTile(this.lastXD, this.lastYD, true);
            evt.consume();
        }
        if (evt.getKeyCode() == 37) {
            if (this.lastXD > 0) {
                this.lastXD -= this.tileWidth + 1;
            }
            this.lastX = this.lastXD;
            this.lastY = this.lastYD;
            this.blockMove = true;
            this.isKeyStroke = true;
            evt.consume();
        }
        if (evt.getKeyCode() == 39) {
            if (this.lastXD + (this.tileWidth + 1) < this.mapWidth * (this.tileWidth + 1)) {
                this.lastXD += this.tileWidth + 1;
            }
            this.lastX = this.lastXD;
            this.lastY = this.lastYD;
            this.blockMove = true;
            this.isKeyStroke = true;
            evt.consume();
        }
        if (evt.getKeyCode() == 38) {
            if (this.lastYD > 0) {
                this.lastYD -= this.tileHeight + 1;
            }
            this.lastX = this.lastXD;
            this.lastY = this.lastYD;
            this.blockMove = true;
            this.isKeyStroke = true;
            evt.consume();
        }
        if (evt.getKeyCode() == 40) {
            if (this.lastYD + (this.tileHeight + 1) < this.mapHeight * (this.tileHeight + 1)) {
                this.lastYD += this.tileHeight + 1;
            }
            this.lastX = this.lastXD;
            this.lastY = this.lastYD;
            this.blockMove = true;
            this.isKeyStroke = true;
            evt.consume();
        }
        if (evt.getKeyCode() == 521 || evt.getKeyCode() == 68) {
            t = this.tileSelect.getSelectedIndex();
            if (t < this.tileSelect.getItemCount() - 1) {
                ++t;
            }
            this.tileSelect.setSelectedIndex(t);
        }
        if (evt.getKeyCode() == 34 || evt.getKeyCode() == 83) {
            t = this.tileSelect.getSelectedIndex();
            if (t + this.matrixWidth < this.tileSelect.getItemCount() - 1) {
                t += this.matrixWidth;
            }
            this.tileSelect.setSelectedIndex(t);
        }
        if (evt.getKeyCode() == 33 || evt.getKeyCode() == 87) {
            t = this.tileSelect.getSelectedIndex();
            if (t > this.matrixWidth) {
                t -= this.matrixWidth;
            }
            this.tileSelect.setSelectedIndex(t);
        }
        if (evt.getKeyCode() == 45 || evt.getKeyCode() == 65) {
            t = this.tileSelect.getSelectedIndex();
            if (t > 0) {
                --t;
            }
            this.tileSelect.setSelectedIndex(t);
        }
        this.drawTile();
    }

    private void viewFocusLost(FocusEvent evt) {
    }

    private void viewFocusGained(FocusEvent evt) {
    }

    private void viewMouseExited(MouseEvent evt) {
    }

    private void viewMouseEntered(MouseEvent evt) {
    }

    private void autoScrollActionPerformed(ActionEvent evt) {
        Settings.setBoolean("Autoscroll", this.autoScroll.isSelected());
    }

    private void imprawActionPerformed(ActionEvent evt) {
        this.importRaw();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            int off = Integer.parseInt(this.rawOff.getText());
            if (off > 0) {
                this.rawOff.setText(--off + "");
                this.scanRawData(off);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        try {
            int off = Integer.parseInt(this.rawOff.getText());
            if (off < this.rawdata.length - this.mapWidth * this.mapHeight) {
                this.rawOff.setText(++off + "");
                this.scanRawData(off);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void is16bitActionPerformed(ActionEvent evt) {
        int off = Integer.parseInt(this.rawOff.getText());
        this.scanRawData(off);
    }

    public static void main(String[] args) {
        try {
            try {
                UIManager.setLookAndFeel("com.pagosoft.plaf.PgsLookAndFeel");
            }
            catch (Exception exception) {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if ("Nimbus".equals(info.getName())) {
                        UIManager.setLookAndFeel(info.getClassName());
                    }
                    if (!"Windows".equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                }
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(UniPixelViewer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(UniPixelViewer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(UniPixelViewer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(UniPixelViewer.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapGen frame = new MapGen(null, null);
                frame.setVisible(true);
                frame.setDefaultCloseOperation(3);
            }
        });
    }
}

