/*
 * Decompiled with CFR 0.152.
 */
package classes.prohibition;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Properties;

public class HighscoreSettings {
    private static File file = new File(System.getProperty("user.home"), "/.prohibition/prohibition.ini");
    private static final HighscoreSettings instance = new HighscoreSettings();
    private final Properties props = new Properties();
    public static final String SCORES = "score_";
    public static final String NAMES = "name_";

    private HighscoreSettings() {
        if (file.exists()) {
            try {
                if (System.getSecurityManager() != null) {
                    System.getSecurityManager().checkRead(file.getAbsolutePath());
                }
                this.props.load(new FileInputStream(file));
                System.out.println("loaded " + (this.props.size() >> 1) + " highscore entries");
            }
            catch (Throwable t) {
                System.out.println("can't load user settings (" + t.getMessage() + ")");
            }
        }
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = HighscoreSettings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    public static int getInt(String key, int defaultValue) {
        String value = HighscoreSettings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static void setBoolean(String key, boolean value) {
        HighscoreSettings.instance.props.setProperty(key, value ? "true" : "false");
        HighscoreSettings.save();
    }

    public static String get(String key, String defaultValue) {
        String value = HighscoreSettings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void set(String key, String value) {
        if (value.equals(HighscoreSettings.get(key, null))) {
            return;
        }
        HighscoreSettings.instance.props.setProperty(key, value);
        HighscoreSettings.save();
    }

    private static void save() {
        try {
            File f = new File(System.getProperty("user.home"), ".prohibition");
            f.mkdir();
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkWrite(file.getAbsolutePath());
            }
            FileOutputStream fos = new FileOutputStream(file);
            HighscoreSettings.instance.props.store(fos, "[Settings]");
            StringBuilder contents = new StringBuilder();
            BufferedReader reader = null;
            FileReader fre = new FileReader(file);
            reader = new BufferedReader(fre);
            String text = null;
            while ((text = reader.readLine()) != null) {
                contents.append(text).append(System.getProperty("line.separator"));
            }
            reader.close();
            fre.close();
            String result = contents.toString();
            Object[] res = result.split("\n");
            Arrays.sort(res);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            for (int i = 0; i < res.length; ++i) {
                bos.write(((String)res[i] + '\n').getBytes("UTF-8"));
            }
            bos.close();
        }
        catch (Throwable t) {
            System.out.println("can't save user settings (" + t.getMessage() + ")");
        }
    }
}

