/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.c64utils;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class AutoStore {
    public static final int CMP_EQUAL = 1;
    public static final int CMP_NOT_EQUAL = 2;
    public static final int CMP_GREATER = 3;
    public static final int CMP_LESS = 4;
    public static final int R_ADDRESS = 0;
    public static final int R_CMP = 1;
    public static final int R_VAL = 2;
    private ArrayList store = new ArrayList();
    private ArrayList rules = new ArrayList();
    private String prefixUrl = "";

    public AutoStore(String prefixUrl) {
        this.prefixUrl = prefixUrl;
    }

    public String checkRules(int[] memory) {
        int n = this.rules.size();
        for (int i = 0; i < n; ++i) {
            int[] rule = (int[])this.rules.get(i);
            int cval = memory[rule[0]];
            if (this.matches(cval, rule[1], rule[2])) continue;
            return null;
        }
        return this.saveState(memory);
    }

    private String saveState(int[] memory) {
        String urls = this.prefixUrl;
        int n = this.store.size();
        for (int i = 0; i < n; i += 2) {
            String name = (String)this.store.get(i);
            int[] arr = (int[])this.store.get(i + 1);
            if (i > 0) {
                urls = urls + "&";
            }
            urls = urls + name + "=" + this.toHex(memory, arr[0], arr[1]);
        }
        System.out.println("URL: " + urls);
        try {
            int c;
            URL url = this.getClass().getResource(urls);
            URLConnection urlc = url.openConnection();
            HttpURLConnection httpConnection = (HttpURLConnection)urlc;
            InputStream is = httpConnection.getInputStream();
            System.out.println("Read back:");
            while ((c = is.read()) != -1) {
                System.out.print((char)c);
            }
            System.out.println("----------------");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String toHex(int[] memory, int address, int len) {
        String s = "";
        int n = len;
        for (int i = 0; i < n; ++i) {
            if (memory[i + address] < 16) {
                s = s + "0";
            }
            s = s + Integer.toString(memory[i + address], 16);
        }
        return s;
    }

    private boolean matches(int v1, int cmp, int v2) {
        switch (cmp) {
            case 1: {
                return v1 == v2;
            }
            case 2: {
                return v1 != v2;
            }
            case 4: {
                return v1 < v2;
            }
            case 3: {
                return v1 > v2;
            }
        }
        return false;
    }

    public void addRule(int address, int type, int value) {
        this.rules.add(new int[]{address, type, value});
    }

    public void addRule(String rule) {
        int adr = 0;
        int val = 0;
        String inx = "0123456789abcdef";
        rule = rule.trim().toLowerCase();
        int n = 4;
        for (int i = 0; i < n; ++i) {
            adr <<= 4;
            int ix = inx.indexOf(rule.charAt(i));
            if (ix == -1) {
                throw new IllegalArgumentException("Illegal syntax");
            }
            adr += ix;
        }
        int realType = "#=!><".indexOf(rule.charAt(4));
        int n2 = 7;
        for (int i = 5; i < n2; ++i) {
            val <<= 4;
            int ix = inx.indexOf(rule.charAt(i));
            if (ix == -1) {
                throw new IllegalArgumentException("Illegal syntax");
            }
            val += ix;
        }
        System.out.println(rule + " => " + adr + " " + realType + " " + val);
        this.addRule(adr, realType, val);
    }

    public void addStore(int address, int len, String name) {
        this.store.add(name);
        this.store.add(new int[]{address, len});
    }
}

