/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.c64utils;

import com.dreamfabric.c64utils.IPPacket;

public class TCPPacket
extends IPPacket {
    public TCPPacket() {
    }

    public TCPPacket(IPPacket packet) {
        this.data = packet.data;
        this.header = packet.header;
    }

    public int getSourcePort() {
        return this.getData16(0);
    }

    public int getDestinationPort() {
        return this.getData16(2);
    }

    public long getSequenceNumber() {
        return this.getData32(4);
    }

    public long getAckNumber() {
        return this.getData32(8);
    }

    public int getTCPHeaderLengthBytes() {
        return 4 * (this.getData8(12) >> 4 & 0xF);
    }

    @Override
    public int getFlags() {
        return this.getData8(13);
    }

    public int getWindow() {
        return this.getData16(14);
    }

    @Override
    public int getChecksum() {
        return this.getData16(16);
    }

    public int getUrgentPointer() {
        return this.getData16(18);
    }
}

