/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.AudioDriver;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

public class AudioDriverSE
extends AudioDriver {
    private SourceDataLine dataLine;
    private FloatControl volume;
    private int vol = 0;
    private boolean soundOn = true;
    private boolean fullSpeed = false;

    @Override
    public int available() {
        return this.dataLine.available();
    }

    @Override
    public int getMasterVolume() {
        return this.vol;
    }

    @Override
    public long getMicros() {
        return this.dataLine.getMicrosecondPosition();
    }

    @Override
    public boolean hasSound() {
        return this.dataLine != null;
    }

    @Override
    public void init(int sampleRate, int bufferSize) {
        AudioFormat af = new AudioFormat(sampleRate, 16, 1, true, false);
        DataLine.Info dli = new DataLine.Info(SourceDataLine.class, af, bufferSize);
        try {
            this.dataLine = (SourceDataLine)AudioSystem.getLine(dli);
            if (this.dataLine == null) {
                System.out.println("DataLine: not existing...");
            } else {
                System.out.println("DataLine allocated: " + this.dataLine);
                this.dataLine.open(this.dataLine.getFormat(), bufferSize);
                this.volume = (FloatControl)this.dataLine.getControl(FloatControl.Type.MASTER_GAIN);
                this.setMasterVolume(100);
                this.dataLine.start();
            }
        }
        catch (Exception e) {
            System.out.println("Problem while getting data line ");
            e.printStackTrace();
            this.dataLine = null;
        }
    }

    @Override
    public void setMasterVolume(int v) {
        if (this.volume != null) {
            this.volume.setValue(-10.0f + 0.1f * (float)v);
        }
        this.vol = v;
    }

    @Override
    public void shutdown() {
        this.dataLine.close();
    }

    @Override
    public void write(byte[] buffer) {
        int bsize = buffer.length;
        if (!this.fullSpeed) {
            while (this.dataLine.available() < bsize) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
        } else if (this.dataLine.available() < bsize) {
            return;
        }
        if (!this.soundOn) {
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = 0;
            }
        }
        this.dataLine.write(buffer, 0, bsize);
    }

    @Override
    public void setSoundOn(boolean on) {
        this.soundOn = on;
    }

    @Override
    public void setFullSpeed(boolean full) {
        this.fullSpeed = full;
    }

    @Override
    public boolean fullSpeed() {
        return this.fullSpeed;
    }
}

