/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.C1541Emu;
import com.dreamfabric.jac64.C64Reader;
import com.dreamfabric.jac64.C64Screen;
import com.dreamfabric.jac64.DiskListener;
import com.dreamfabric.jac64.ExtChip;

public class C1541Chips
extends ExtChip
implements DiskListener {
    public static final int GCR_SECTOR_SIZE = 354;
    public static final boolean DEBUG = false;
    public static final boolean DEBUG_IRQ = false;
    public static final boolean DEBUG_WRITE = false;
    public static final boolean DEBUG_GCR = false;
    public static final boolean DEBUG_IEC = false;
    public static final Object LED_MOTOR = new Object();
    public static final Object HEAD_MOVED = new Object();
    public static final Object SECTOR_UPDATE = new Object();
    public static final int[] GCR = new int[]{10, 11, 18, 19, 14, 15, 22, 23, 9, 25, 26, 27, 13, 29, 30, 21};
    public static final int[] GCR_REV = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 8, 0, 1, 255, 12, 4, 5, 255, 255, 2, 3, 255, 15, 6, 7, 255, 9, 10, 11, 255, 13, 14, 255};
    private C1541Emu cpu;
    private int diskID1 = 0;
    private int diskID2 = 0;
    private int track = 1;
    private int hTrack = 2;
    private int sector = 0;
    private int sectorPos = 0;
    private int currentTrackSize = 21;
    private int[] gcrSector = new int[354];
    private int[] gcrWriteSector = new int[354];
    private int[][][] gcrCacheSector = new int[40][21][];
    private int via1PB;
    private int via1PA;
    private int via1CB;
    private int via1CA;
    private int via1T1Ctr;
    private int via1T1Latch;
    private int via1T2Ctr;
    private int via1T2Latch;
    private int via1SerialRegister;
    private int via1AuxControl;
    private int via1PerControl;
    private int via1IFlag;
    private int via1IEnable;
    private int via2PB;
    private int via2PA;
    private int via2CB;
    private int via2CA;
    private int via2T1Ctr;
    private int via2T1Latch;
    private int via2T2Ctr;
    private int via2T2Latch;
    private int via2SerialRegister;
    private int via2AuxControl;
    int via2PerControl;
    private int via2IFlag;
    private int via2IEnable;
    private boolean diskChanged = true;
    private boolean writeProtected = true;
    public boolean ledOn;
    public boolean motorOn;
    public int currentTrack;
    public int currentSector;
    public int headOutBeyond = 0;
    private int bytesWritten = 0;
    private int currentByte = 0;
    private C64Reader reader;
    boolean byteReadyOverflow = false;
    boolean diskModeWrite = false;
    C64Screen cia2;
    int iecLines;
    long nextAutoforward;
    long lastCycles = 0L;
    long nextCheck = 0L;
    boolean lastSync = false;

    public C1541Chips(C1541Emu emu) {
        this.cpu = emu;
        this.init(this.cpu);
    }

    public void initIEC2(C64Screen s) {
        this.cia2 = s;
    }

    public void setReader(C64Reader reader) {
        this.log("Setting reader...");
        this.reader = reader;
        reader.setDiskListener(this);
    }

    @Override
    public final int performRead(int address, long cycles) {
        switch (address) {
            case 6144: {
                return (this.via1PB & 0x1A | (this.iecLines & this.cia2.iecLines) >> 7 & 1 | (this.iecLines & this.cia2.iecLines) >> 4 & 4 | this.cia2.iecLines << 3 & 0x80) ^ 0x85;
            }
            case 6145: 
            case 6159: {
                this.via1IFlag &= 0xFFFFFFFD;
                this.checkInterrupt(1, "read from pa");
                return 255;
            }
            case 6146: {
                return this.via1CB;
            }
            case 6147: {
                return this.via1CA;
            }
            case 6148: {
                this.via1IFlag &= 0xBF;
                this.checkInterrupt(1, "read T1 low");
                return this.via1T1Ctr & 0xFF;
            }
            case 6149: {
                return this.via1T1Ctr >> 8;
            }
            case 6150: {
                return this.via1T1Latch & 0xFF;
            }
            case 6151: {
                return this.via1T1Latch >> 8;
            }
            case 6152: {
                this.via1IFlag &= 0xDF;
                this.checkInterrupt(1, "read T2 low");
                return this.via1T2Ctr & 0xFF;
            }
            case 6153: {
                return this.via1T2Ctr >> 8;
            }
            case 6154: {
                return this.via1SerialRegister;
            }
            case 6155: {
                return this.via1AuxControl;
            }
            case 6156: {
                return this.via1PerControl;
            }
            case 6157: {
                return this.via1IFlag;
            }
            case 6158: {
                return this.via1IEnable;
            }
            case 7168: {
                return this.via2PB & 0x6F | this.sync() | this.writeProtect();
            }
            case 7169: 
            case 7183: {
                return this.readByte();
            }
            case 7170: {
                return this.via2CB;
            }
            case 7171: {
                return this.via2CA;
            }
            case 7172: {
                this.via2IFlag &= 0xBF;
                this.checkInterrupt(1, "read T1 low");
                return this.via2T1Ctr & 0xFF;
            }
            case 7173: {
                return this.via2T1Ctr >> 8;
            }
            case 7174: {
                return this.via2T1Latch & 0xFF;
            }
            case 7175: {
                return this.via2T1Latch >> 8;
            }
            case 7176: {
                this.via2IFlag &= 0xDF;
                this.checkInterrupt(2, "read T2 low");
                return this.via2T2Ctr & 0xFF;
            }
            case 7177: {
                return this.via2T2Ctr >> 8;
            }
            case 7178: {
                return this.via2SerialRegister;
            }
            case 7179: {
                return this.via2AuxControl;
            }
            case 7180: {
                return this.via2PerControl;
            }
            case 7181: {
                return this.via2IFlag;
            }
            case 7182: {
                return this.via2IEnable;
            }
        }
        return 0;
    }

    @Override
    public final void performWrite(int address, int data, long cycles) {
        switch (address) {
            case 6144: {
                this.via1PB = data;
                this.updateIECLines();
                break;
            }
            case 6145: {
                this.via1IFlag &= 0xFFFFFFFD;
                this.checkInterrupt(1, "wrote pa");
                this.via1PA = data;
                break;
            }
            case 6146: {
                this.via1CB = data;
                this.updateIECLines();
                break;
            }
            case 6147: {
                this.via1CA = data;
                break;
            }
            case 6148: {
                this.via1T1Latch = this.via1T1Latch & 0xFF00 | data;
                break;
            }
            case 6149: {
                this.via1T1Latch = this.via1T1Latch & 0xFF | data << 8;
                this.via1IFlag &= 0xBF;
                this.via1T1Ctr = this.via1T1Latch;
                this.checkInterrupt(1, "write T1 high");
                break;
            }
            case 6150: {
                this.via1T1Latch = this.via1T1Latch & 0xFF00 | data;
                break;
            }
            case 6151: {
                this.via1T1Latch = this.via1T1Latch & 0xFF | data << 8;
                break;
            }
            case 6152: {
                this.via1T2Latch = this.via1T2Latch & 0xFF00 | data;
                break;
            }
            case 6153: {
                this.via1T2Latch = this.via1T2Latch & 0xFF | data << 8;
                this.via1IFlag &= 0xDF;
                this.via1T2Ctr = this.via1T1Latch;
                this.checkInterrupt(1, "write T2 high");
                break;
            }
            case 6154: {
                this.via1SerialRegister = data;
                break;
            }
            case 6155: {
                this.via1AuxControl = data;
                break;
            }
            case 6156: {
                this.via1PerControl = data;
                break;
            }
            case 6157: {
                this.via1IFlag &= ~data;
                this.checkInterrupt(1, "write IFlag");
                break;
            }
            case 6158: {
                this.via1IEnable = (data & 0x80) == 128 ? (this.via1IEnable |= data & 0x7F) : (this.via1IEnable &= ~data);
                this.checkInterrupt(1, "write IE");
                break;
            }
            case 7168: {
                boolean lastLed = this.ledOn;
                boolean lastMotor = this.motorOn;
                this.ledOn = (data & 8) != 0;
                this.motorOn = (data & 4) != 0;
                if (lastLed != this.ledOn | lastMotor != this.motorOn) {
                    this.update(this, LED_MOTOR);
                }
                if (((this.via2PB ^ data) & 3) != 0) {
                    if ((this.via2PB & 3) == (data + 1 & 3)) {
                        this.headOut();
                    } else if ((this.via2PB & 3) == (data - 1 & 3)) {
                        this.headIn();
                    }
                }
                this.via2PB = data;
                break;
            }
            case 7169: {
                this.via2PA = data;
                this.writeByte(data);
                break;
            }
            case 7170: {
                this.via2CB = data;
                break;
            }
            case 7171: {
                this.via2CA = data;
                break;
            }
            case 7172: {
                this.via2T1Latch = this.via2T1Latch & 0xFF00 | data;
                break;
            }
            case 7173: {
                this.via2T1Latch = this.via2T1Latch & 0xFF | data << 8;
                this.via2IFlag &= 0xBF;
                this.via2T1Ctr = this.via2T1Latch;
                this.checkInterrupt(2, "write T1 high: " + data + " latch: " + this.via2T1Latch);
                break;
            }
            case 7174: {
                this.via2T1Latch = this.via2T1Latch & 0xFF00 | data;
                break;
            }
            case 7175: {
                this.via2T1Latch = this.via2T1Latch & 0xFF | data << 8;
                break;
            }
            case 7176: {
                this.via2T2Latch = this.via2T2Latch & 0xFF00 | data;
                break;
            }
            case 7177: {
                this.via2T2Latch = this.via2T2Latch & 0xFF | data << 8;
                this.via2IFlag &= 0xDF;
                this.via2T2Ctr = this.via2T2Latch;
                this.checkInterrupt(2, "write T2 high");
                break;
            }
            case 7178: {
                this.via2SerialRegister = data;
                break;
            }
            case 7179: {
                this.via2AuxControl = data;
                break;
            }
            case 7180: {
                this.byteReadyOverflow = (data & 2) == 2;
                this.diskModeWrite = (data & 0x20) != 32;
                this.via2PerControl = data;
                if (this.diskModeWrite) break;
                this.currentByte = -1;
                break;
            }
            case 7181: {
                this.via2IFlag &= ~data;
                this.checkInterrupt(2, "write IFlag");
                break;
            }
            case 7182: {
                this.via2IEnable = (data & 0x80) == 128 ? (this.via2IEnable |= data & 0x7F) : (this.via2IEnable &= ~data);
                this.checkInterrupt(2, "write IE");
            }
        }
    }

    private void writeByte(int data) {
        this.currentByte = data;
        this.log("CPU Writes byte: " + Integer.toString(data, 16) + " at " + Integer.toString(this.cpu.pc, 16));
    }

    private void finishWrite() {
        if (this.bytesWritten > 0) {
            this.convertGCRSector();
        }
        this.bytesWritten = 0;
    }

    private void checkInterrupt(int via, String reason) {
        if (via == 1) {
            if ((this.via1IFlag & this.via1IEnable) == 0) {
                this.via1IFlag &= 0x7F;
                this.clearIRQ(1);
            } else {
                this.via1IFlag |= 0x80;
                this.setIRQ(1);
            }
        } else if ((this.via2IFlag & this.via2IEnable) == 0) {
            this.via2IFlag &= 0x7F;
            this.clearIRQ(2);
        } else {
            this.via2IFlag |= 0x80;
            this.setIRQ(2);
        }
    }

    public void updateIECLines() {
        int data = ~this.via1PB & this.via1CB;
        this.iecLines = data << 6 & (~data ^ this.cia2.iecLines) << 3 & 0x80 | data << 3 & 0x40;
    }

    void autoForward(long cycles) {
        if (this.motorOn) {
            if (this.nextAutoforward < cycles) {
                if (this.nextAutoforward == 0L) {
                    this.nextAutoforward = cycles + 32L;
                } else {
                    this.nextAutoforward += 30L;
                    this.forward();
                }
            }
        } else {
            this.nextAutoforward = cycles + 10000L;
        }
    }

    @Override
    public final void clock(long cycles) {
        if (this.nextCheck > cycles) {
            return;
        }
        this.autoForward(cycles);
        int delta = (int)(cycles - this.lastCycles);
        this.lastCycles = cycles;
        this.nextCheck = cycles + 13L;
        this.via1T1Ctr -= delta;
        if (this.via1T1Ctr <= 0) {
            this.via1T1Ctr = (this.via1AuxControl & 0x40) == 64 ? (this.via1T1Ctr += this.via1T1Latch) : (this.via1T1Ctr &= 0xFFFF);
            this.via1IFlag |= 0x40;
            this.checkInterrupt(1, "clock wrap, T1");
        }
        if ((this.via1AuxControl & 0x20) == 0) {
            this.via1T2Ctr -= delta;
            if (this.via1T2Ctr <= 0) {
                this.via1IFlag |= 0x20;
                this.via1T2Ctr &= 0xFFFF;
                this.checkInterrupt(1, "clock wrap, T2");
            }
        }
        this.via2T1Ctr -= delta;
        if (this.via2T1Ctr <= 0) {
            this.via2T1Ctr = (this.via2AuxControl & 0x40) == 64 ? (this.via2T1Ctr += this.via2T1Latch) : (this.via2T1Ctr &= 0xFFFF);
            this.via2IFlag |= 0x40;
            this.checkInterrupt(2, "clock wrap, T1:  latch:" + this.via2T1Latch);
        }
        if ((this.via2AuxControl & 0x20) == 0) {
            this.via2T2Ctr -= delta;
            if (this.via2T2Ctr <= 0) {
                this.via2IFlag |= 0x20;
                this.via2T2Ctr &= 0xFFFF;
                this.checkInterrupt(2, "clock wrap, T2");
            }
        }
    }

    @Override
    public void diskChanged() {
        this.diskChanged = true;
        int n = 40;
        for (int i = 0; i < n; ++i) {
            int m = 21;
            for (int j = 0; j < m; ++j) {
                this.gcrCacheSector[i][j] = null;
            }
        }
        byte[] bam = this.reader.getSector(18, 0);
        this.diskID1 = bam[162] & 0xFF;
        this.diskID2 = bam[163] & 0xFF;
        System.out.println("Disk changed => Disk ID:" + this.diskID1 + "," + this.diskID2);
    }

    @Override
    public void atnChanged(boolean hi) {
        if (hi) {
            this.via1IFlag |= 2;
            this.checkInterrupt(1, "atn went high");
        }
        this.updateIECLines();
    }

    @Override
    public void reset() {
        this.track = 1;
        this.hTrack = 2;
        this.sector = 0;
        this.sectorPos = -1;
        this.diskChanged = false;
        this.writeProtected = false;
        this.currentTrackSize = C64Reader.getSectorCount(this.track);
        this.readGCRSector(this.track, this.sector);
    }

    private int writeProtect() {
        if (this.diskChanged) {
            System.out.println("C1541: //// Disk change detected???!!! ////");
            this.diskChanged = false;
            return this.writeProtected ? 16 : 0;
        }
        return this.writeProtected ? 0 : 16;
    }

    private int sync() {
        if (this.sectorPos == -1) {
            return 128;
        }
        if (this.gcrSector[this.sectorPos] == 255) {
            return 0;
        }
        return 128;
    }

    private int readByte() {
        if (this.sectorPos == -1) {
            return 0;
        }
        int data = this.gcrSector[this.sectorPos];
        return data;
    }

    private void forward() {
        if (this.diskModeWrite && this.via2CA == 255 && this.currentByte != -1 && this.sectorPos >= 0) {
            ++this.bytesWritten;
            this.gcrWriteSector[this.sectorPos] = this.currentByte;
        }
        ++this.sectorPos;
        if (this.sectorPos == 354) {
            this.finishWrite();
            this.sectorPos = -1;
            this.nextAutoforward += 1000L;
            this.sector = (this.sector + 1) % this.currentTrackSize;
            this.readGCRSector(this.track, this.sector);
        }
        this.update(this, SECTOR_UPDATE);
        if (this.diskModeWrite || this.sync() != 0 || !this.lastSync) {
            this.cpu.triggerByteReady();
        }
        this.lastSync = this.sync() == 0;
    }

    private void headOut() {
        if (this.hTrack > 2) {
            --this.hTrack;
        } else {
            ++this.headOutBeyond;
        }
        System.out.println("1541: Move head In to: " + this.hTrack);
        this.updateHTrack();
        this.update(this, HEAD_MOVED);
    }

    private void headIn() {
        if (this.hTrack < 70) {
            ++this.hTrack;
        }
        System.out.println("1541: Move head Out to: " + this.hTrack);
        this.updateHTrack();
        this.update(this, HEAD_MOVED);
    }

    private void updateHTrack() {
        if (this.track != this.hTrack >> 1) {
            this.nextAutoforward = this.cpu.cycles + 100000L;
            this.finishWrite();
            this.track = this.hTrack >> 1;
            this.sector = 0;
            this.sectorPos = -1;
            this.currentTrackSize = C64Reader.getSectorCount(this.track);
            System.out.println("1541: New Track " + this.track + " reading: " + this.track + ", " + this.sector + " s/t: " + this.currentTrackSize);
            this.readGCRSector(this.track, this.sector);
        }
    }

    private static long getGCR(int b) {
        return GCR[b >> 4] << 5 | GCR[b & 0xF];
    }

    private static char i2c(int i) {
        if (i < 32) {
            return '.';
        }
        return (char)i;
    }

    public static int makeGCR(int[] gcrBuf, int pos, int b1, int b2, int b3, int b4) {
        int cSum = b1 ^ b2 ^ b3 ^ b4;
        long gcr = C1541Chips.getGCR(b1) << 30 | C1541Chips.getGCR(b2) << 20 | C1541Chips.getGCR(b3) << 10 | C1541Chips.getGCR(b4);
        long bits = 32L;
        int n = 5;
        for (int i = 0; i < n; ++i) {
            gcrBuf[pos++] = (int)(gcr >> (int)bits & 0xFFL);
            bits -= 8L;
        }
        return cSum;
    }

    private void readGCRSector(int track, int sector) {
        int i;
        this.currentTrack = track;
        this.currentSector = sector;
        if (this.gcrCacheSector[track][sector] != null) {
            this.gcrSector = this.gcrCacheSector[track][sector];
            this.gcrWriteSector = this.gcrSector;
            return;
        }
        byte[] sectorBuf = this.reader.getSector(track, sector);
        int pos = 0;
        int cSum = 0;
        this.gcrSector = new int[354];
        this.gcrSector[pos++] = 255;
        C1541Chips.makeGCR(this.gcrSector, pos, 8, sector ^ track ^ this.diskID1 ^ this.diskID2, sector, track);
        C1541Chips.makeGCR(this.gcrSector, pos += 5, this.diskID2, this.diskID1, 15, 15);
        pos += 5;
        for (i = 0; i < 9; ++i) {
            this.gcrSector[pos++] = 85;
        }
        this.gcrSector[pos++] = 255;
        cSum = 7;
        cSum ^= C1541Chips.makeGCR(this.gcrSector, pos, 7, sectorBuf[0] & 0xFF, sectorBuf[1] & 0xFF, sectorBuf[2] & 0xFF);
        pos += 5;
        int n = 255;
        for (i = 3; i < n; i += 4) {
            cSum ^= C1541Chips.makeGCR(this.gcrSector, pos, sectorBuf[i] & 0xFF, sectorBuf[i + 1] & 0xFF, sectorBuf[i + 2] & 0xFF, sectorBuf[i + 3] & 0xFF);
            pos += 5;
        }
        C1541Chips.makeGCR(this.gcrSector, pos, sectorBuf[255] & 0xFF, (cSum ^= sectorBuf[255] & 0xFF) & 0xFF, 0, 0);
        pos += 5;
        n = 8;
        for (i = 0; i < n; ++i) {
            this.gcrSector[pos++] = 85;
        }
        this.gcrWriteSector = this.gcrSector;
        this.gcrCacheSector[track][sector] = this.gcrSector;
    }

    private void convertGCRSector() {
        int i;
        int[] buffer = new int[266];
        int pos = 0;
        int start = 0;
        int n = 30;
        for (i = 5; i < n; ++i) {
            if (this.gcrSector[i] != 255) continue;
            start = i + 1;
        }
        n = 325;
        for (i = 0; i < n; i += 5) {
            this.convertFromGCR(buffer, pos, i + start);
            pos += 4;
        }
        System.out.println("Converted " + pos + " bytes");
        byte[] newSector = new byte[256];
        int n2 = 255;
        for (int i2 = 0; i2 < n2; ++i2) {
            newSector[i2] = (byte)(buffer[i2 + 1] & 0xFF);
        }
        this.reader.setSector(this.track, this.sector, newSector);
    }

    private void convertFromGCR(int[] buff, int pos, int posW) {
        long data = C1541Chips.convertFromGCR(this.gcrWriteSector[posW], this.gcrWriteSector[posW + 1], this.gcrWriteSector[posW + 2], this.gcrWriteSector[posW + 3], this.gcrWriteSector[posW + 4]);
        System.out.println("Converting (" + posW + "): " + Long.toString(data, 16));
        buff[pos++] = (int)(data >> 24) & 0xFF;
        buff[pos++] = (int)(data >> 16) & 0xFF;
        buff[pos++] = (int)(data >> 8) & 0xFF;
        buff[pos++] = (int)data & 0xFF;
        int n = 4;
        for (int i = 0; i < n; ++i) {
            int c = buff[pos - 4 + i];
            System.out.println("Converted: " + c + " => " + (char)c);
        }
    }

    public static long convertFromGCR(long b1, long b2, long b3, long b4, long b5) {
        long data = (b1 << 32) + (b2 << 24) + (b3 << 16) + (b4 << 8) + b5;
        System.out.println("Converting from: " + Long.toString(data, 16));
        long d1 = GCR_REV[(int)(data >> 35) & 0x1F] << 4 | GCR_REV[(int)(data >> 30) & 0x1F];
        long d2 = GCR_REV[(int)(data >> 25) & 0x1F] << 4 | GCR_REV[(int)(data >> 20) & 0x1F];
        long d3 = GCR_REV[(int)(data >> 15) & 0x1F] << 4 | GCR_REV[(int)(data >> 10) & 0x1F];
        long d4 = GCR_REV[(int)(data >> 5) & 0x1F] << 4 | GCR_REV[(int)data & 0x1F];
        return (d1 << 24) + (d2 << 16) + (d3 << 8) + d4;
    }

    public static void main(String[] args) {
        int i;
        String text = args[0];
        int[] gcrEncoded = new int[text.length() * 2];
        int gcrPos = 0;
        int gcrVal = 0;
        int gcrBits = 0;
        int n = text.length();
        for (i = 0; i < n; ++i) {
            int c = text.charAt(i) & 0xFF;
            gcrVal |= (GCR[c >> 4] << 5 | GCR[c & 0xF]) << gcrBits;
            gcrBits += 10;
            while (gcrBits >= 8) {
                gcrEncoded[gcrPos++] = gcrVal & 0xFF;
                gcrBits -= 8;
                gcrVal >>= 8;
            }
        }
        System.out.println("GCR Data:");
        n = gcrPos;
        for (i = 0; i < n; ++i) {
            if (i % 16 == 0) {
                System.out.println("");
            }
            System.out.print(Integer.toHexString(gcrEncoded[i]) + " ");
        }
        gcrVal = 0;
        gcrBits = 0;
        System.out.println("Decoded: ");
        n = gcrPos;
        for (i = 0; i < n; ++i) {
            gcrVal |= gcrEncoded[i] << gcrBits;
            if ((gcrBits += 8) < 10) continue;
            int val = gcrVal & 0x3FF;
            int bval = GCR_REV[val >> 5] << 4 | GCR_REV[val & 0x1F];
            gcrVal >>= 10;
            gcrBits -= 10;
            System.out.print((char)bval);
        }
        System.out.println("");
    }

    @Override
    public void stop() {
    }

    public void log(String text) {
        System.out.println("C1541: " + text);
    }
}

