/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.C1541Chips;
import com.dreamfabric.jac64.C64Reader;
import com.dreamfabric.jac64.IMonitor;
import com.dreamfabric.jac64.MOS6510Core;
import com.dreamfabric.jac64.PatchListener;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class C1541Emu
extends MOS6510Core {
    public static final boolean DEBUG = false;
    public static final boolean IODEBUG = false;
    public static final int C1541ROM = 49152;
    public static final int RESET_VECTOR = 65532;
    public C1541Chips chips;
    boolean byteReady = false;

    public C1541Emu(IMonitor m, String cb) {
        super(m, cb);
        this.memory = new int[65536];
        this.chips = new C1541Chips(this);
        this.init(this.chips);
        this.loadDebug("c1541dbg.txt");
        this.debug = false;
    }

    @Override
    public String getName() {
        return "C1541 CPU";
    }

    public void setReader(C64Reader reader) {
        this.chips.setReader(reader);
    }

    @Override
    protected final int fetchByte(int adr) {
        ++this.cycles;
        if (adr < 2048 || adr >= 49152) {
            return this.memory[adr];
        }
        int c = adr & 0xFF00;
        if (c == 6144 || c == 7168) {
            int data = this.chips.performRead(adr, this.cycles);
            return data;
        }
        return 0;
    }

    @Override
    protected final void writeByte(int adr, int data) {
        int c;
        ++this.cycles;
        if (adr < 2048) {
            this.memory[adr] = data;
        }
        if ((c = adr & 0xFF00) == 6144 || c == 7168) {
            this.chips.performWrite(adr, data, this.cycles);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.pc = this.memory[65532] | this.memory[65533] << 8;
        System.out.println("C1541: Reset to " + Integer.toHexString(this.pc));
    }

    void triggerByteReady() {
        this.byteReady = true;
    }

    public void tick(long c64Cycles) {
        while (this.cycles < c64Cycles) {
            if (this.byteReady && this.chips.byteReadyOverflow) {
                this.overflow = true;
                this.byteReady = false;
            }
            this.emulateOp();
            if (this.chips.nextCheck >= this.cycles) continue;
            this.chips.clock(this.cycles);
        }
    }

    @Override
    public void patchROM(PatchListener list) {
    }

    public void loadDebug(String resource) {
        try {
            URL url = this.getClass().getResource(resource);
            this.monitor.info("Loading debug from URL: " + url);
            if (url == null) {
                url = new URL(this.codebase + resource);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split("\t");
                int adr = -1;
                try {
                    adr = Integer.parseInt(parts[0].trim(), 16);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (adr == -1) continue;
                this.setDebug(adr, parts[1].trim());
            }
        }
        catch (Exception e) {
            System.out.println("Failed to load debug text: " + resource);
        }
    }

    protected void readROM(String resource, int startMem, int len) {
        try {
            URL url = this.getClass().getResource(resource);
            this.monitor.info("URL: " + url);
            this.monitor.info("Read ROM " + resource);
            if (url == null) {
                url = new URL(this.codebase + resource);
            }
            this.loadROM(new DataInputStream(url.openConnection().getInputStream()), startMem, len);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void installROMS() {
        this.readROM("/roms/c1541.rom", 49152, 16384);
    }
}

