/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.TimeEvent;

public class EventQueue {
    private TimeEvent first;
    public long nextTime;

    public void addEvent(TimeEvent event, long time) {
        event.time = time;
        this.addEvent(event);
    }

    public void addEvent(TimeEvent event) {
        if (event.scheduled) {
            this.removeEvent(event);
        }
        if (this.first == null) {
            this.first = event;
        } else {
            TimeEvent pos = this.first;
            TimeEvent lastPos = this.first;
            while (pos != null && pos.time < event.time) {
                lastPos = pos;
                pos = pos.nextEvent;
            }
            if (pos == this.first) {
                event.nextEvent = pos;
                this.first = event;
            } else {
                event.nextEvent = pos;
                lastPos.nextEvent = event;
            }
        }
        this.nextTime = this.first != null ? this.first.time : 0L;
        event.scheduled = true;
    }

    public boolean removeEvent(TimeEvent event) {
        TimeEvent pos = this.first;
        TimeEvent lastPos = this.first;
        while (pos != null && pos != event) {
            lastPos = pos;
            pos = pos.nextEvent;
        }
        if (pos == null) {
            return false;
        }
        if (pos == this.first) {
            this.first = pos.nextEvent;
        } else {
            lastPos.nextEvent = pos.nextEvent;
        }
        pos.nextEvent = null;
        this.nextTime = this.first != null ? this.first.time : 0L;
        event.scheduled = false;
        return true;
    }

    public TimeEvent popFirst() {
        TimeEvent tmp = this.first;
        if (tmp != null) {
            this.first = tmp.nextEvent;
            tmp.nextEvent = null;
        }
        this.nextTime = this.first != null ? this.first.time : 0L;
        tmp.scheduled = false;
        return tmp;
    }

    public void print() {
        TimeEvent t = this.first;
        System.out.print("nxt: " + this.nextTime + " [");
        while (t != null) {
            System.out.print(t.getShort());
            t = t.nextEvent;
            if (t == null) continue;
            System.out.print(", ");
        }
        System.out.println("]");
    }

    public void empty() {
        this.first = null;
        this.nextTime = 0L;
    }
}

