/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.MOS6510Core;
import com.dreamfabric.jac64.Observer;
import java.util.Hashtable;

public abstract class ExtChip {
    public static final boolean DEBUG_INTERRUPS = false;
    public static final int VIC_IRQ = 1;
    public static final int CIA_TIMER_IRQ = 2;
    public static final int KEYBOARD_NMI = 1;
    public static final int CIA_TIMER_NMI = 2;
    private static Hashtable<String, InterruptManager> managers = new Hashtable();
    MOS6510Core cpu;
    private Observer observer;
    private InterruptManager im;

    public void init(MOS6510Core cpu) {
        this.cpu = cpu;
        if (managers.get(cpu.getName()) == null) {
            System.out.println("creating new IM...");
            managers.put(cpu.getName(), new InterruptManager(cpu));
        }
        this.im = managers.get(cpu.getName());
    }

    public int getNMIFlags() {
        return this.im.nmiFlags;
    }

    public int getIRQFlags() {
        return this.im.irqFlags;
    }

    public boolean setIRQ(int irq) {
        return this.im.setIRQ(irq);
    }

    public void clearIRQ(int irq) {
        this.im.clearIRQ(irq);
    }

    public boolean setNMI(int nmi) {
        return this.im.setNMI(nmi);
    }

    public void clearNMI(int nmi) {
        this.im.clearNMI(nmi);
    }

    public void resetInterrupts() {
        this.im.reset();
    }

    public abstract void reset();

    public abstract void stop();

    public abstract int performRead(int var1, long var2);

    public abstract void performWrite(int var1, int var2, long var3);

    public abstract void clock(long var1);

    public void setObserver(Observer o) {
        this.observer = o;
    }

    public void update(Object source, Object data) {
        if (this.observer != null) {
            this.observer.update(source, data);
        }
    }

    private static class InterruptManager {
        int nmiFlags;
        int irqFlags;
        int oldIrqFlags;
        int oldNmiFlags;
        MOS6510Core cpu;

        InterruptManager(MOS6510Core cpu) {
            this.cpu = cpu;
        }

        private void reset() {
            this.nmiFlags = 0;
            this.irqFlags = 0;
            this.oldIrqFlags = 0;
            this.oldNmiFlags = 0;
            this.cpu.setIRQLow(false);
            this.cpu.setNMILow(false);
            this.cpu.log("ExtChip: Resetting IRQ flags!");
        }

        public boolean setIRQ(int irq) {
            boolean val = (this.irqFlags & irq) == 0;
            this.irqFlags |= irq;
            if (this.irqFlags != this.oldIrqFlags) {
                this.cpu.setIRQLow(this.irqFlags != 0);
                this.oldIrqFlags = this.irqFlags;
            }
            return val;
        }

        public void clearIRQ(int irq) {
            this.irqFlags &= ~irq;
            if (this.irqFlags != this.oldIrqFlags) {
                this.cpu.setIRQLow(this.irqFlags != 0);
                this.oldIrqFlags = this.irqFlags;
            }
        }

        public boolean setNMI(int nmi) {
            boolean val = (this.nmiFlags & nmi) == 0;
            this.nmiFlags |= nmi;
            if (this.nmiFlags != this.oldNmiFlags) {
                this.cpu.setNMILow(this.nmiFlags != 0);
                this.oldNmiFlags = this.nmiFlags;
            }
            return val;
        }

        public void clearNMI(int nmi) {
            this.nmiFlags &= ~nmi;
            if (this.nmiFlags != this.oldNmiFlags) {
                this.cpu.setNMILow(this.nmiFlags != 0);
                this.oldNmiFlags = this.nmiFlags;
            }
        }
    }
}

