/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.Hex;

public class MOS6510Ops {
    public static final int BRK = 0;
    public static final int ORA = 1;
    public static final int TRP = 2;
    public static final int SLO = 3;
    public static final int NOP = 4;
    public static final int ASL = 5;
    public static final int PHP = 6;
    public static final int ANC = 7;
    public static final int BPL = 8;
    public static final int CLC = 9;
    public static final int JSR = 10;
    public static final int AND = 11;
    public static final int RLA = 12;
    public static final int BIT = 13;
    public static final int ROL = 14;
    public static final int PLP = 15;
    public static final int BMI = 16;
    public static final int SEC = 17;
    public static final int RTI = 18;
    public static final int EOR = 19;
    public static final int SRE = 20;
    public static final int LSR = 21;
    public static final int PHA = 22;
    public static final int ASR = 23;
    public static final int JMP = 24;
    public static final int BVC = 25;
    public static final int CLI = 26;
    public static final int RTS = 27;
    public static final int ADC = 28;
    public static final int RRA = 29;
    public static final int ROR = 30;
    public static final int PLA = 31;
    public static final int ARR = 32;
    public static final int BVS = 33;
    public static final int SEI = 34;
    public static final int SAX = 35;
    public static final int STA = 36;
    public static final int STY = 37;
    public static final int STX = 38;
    public static final int DEY = 39;
    public static final int TXA = 40;
    public static final int ANE = 41;
    public static final int BCC = 42;
    public static final int SHA = 43;
    public static final int TYA = 44;
    public static final int TXS = 45;
    public static final int SHS = 46;
    public static final int SHY = 47;
    public static final int SHX = 48;
    public static final int LDY = 49;
    public static final int LDA = 50;
    public static final int LDX = 51;
    public static final int LAX = 52;
    public static final int TAX = 53;
    public static final int LXA = 54;
    public static final int TAY = 55;
    public static final int BCS = 56;
    public static final int CLV = 57;
    public static final int TSX = 58;
    public static final int LAS = 59;
    public static final int CPY = 60;
    public static final int CMP = 61;
    public static final int DCP = 62;
    public static final int DEC = 63;
    public static final int INY = 64;
    public static final int DEX = 65;
    public static final int SBX = 66;
    public static final int BNE = 67;
    public static final int CLD = 68;
    public static final int CPX = 69;
    public static final int SBC = 70;
    public static final int ISB = 71;
    public static final int INC = 72;
    public static final int INX = 73;
    public static final int BEQ = 74;
    public static final int SED = 75;
    public static final int LOAD_FILE = 76;
    public static final int SLEEP = 77;
    public static final int OP_LOAD_FILE = 256;
    public static final int OP_SLEEP = 257;
    public static final int ADDRESSING_MASK = 3840;
    public static final int ADDRESSING_SHIFT = 8;
    public static final int OP_MASK = 255;
    public static final int IMMEDIATE = 256;
    public static final int ZERO = 512;
    public static final int ABSOLUTE = 768;
    public static final int ZERO_X = 1024;
    public static final int ZERO_Y = 1280;
    public static final int ABSOLUTE_X = 1536;
    public static final int ABSOLUTE_Y = 1792;
    public static final int RELATIVE = 2048;
    public static final int INDIRECT_X = 2304;
    public static final int INDIRECT_Y = 2560;
    public static final int ACCUMULATOR = 2816;
    public static final int INDIRECT = 3072;
    public static final int MODE_MASK = 61440;
    public static final int MODE_SHIFT = 12;
    public static final int READ = 4096;
    public static final int WRITE = 8192;
    public static final int RMW = 12288;
    public static final String[] INS_STR = new String[]{"BRK", "ORA", "TRP", "SLO", "NOP", "ASL", "PHP", "ANC", "BPL", "CLC", "JSR", "AND", "RLA", "BIT", "ROL", "PLP", "BMI", "SEC", "RTI", "EOR", "SRE", "LSR", "PHA", "ASR", "JMP", "BVC", "CLI", "RTS", "ADC", "RRA", "ROR", "PLA", "ARR", "BVS", "SEI", "SAX", "STA", "STY", "STX", "DEY", "TXA", "ANE", "BCC", "SHA", "TYA", "TXS", "SHS", "SHY", "SHX", "LDY", "LDA", "LDX", "LAX", "TAX", "LXA", "TAY", "BCS", "CLV", "TSX", "LAS", "CPY", "CMP", "DCP", "DEC", "INY", "DEX", "SBX", "BNE", "CLD", "CPX", "SBC", "ISB", "INC", "INX", "BEQ", "SED", "X-LOAD_FILE", "X-SLEEP"};
    public static final String[] ADR_STR_PRE = new String[]{" ", " #", " Z ", " ", " Z ", " Z ", " ", " ", " ", " (", " (", " ACC", " ("};
    public static final String[] ADR_STR_POST = new String[]{"", "", "", "", ",X", ",Y", ",X", ",Y", "", ",X)", "),Y", "", ")"};
    public static final int[] ADR_LEN = new int[]{1, 2, 2, 3, 2, 2, 3, 3, 2, 2, 2, 1, 3};
    public static final int[] INSTRUCTION_SET = new int[]{0, 1, 2, 3, 4, 1, 5, 3, 6, 1, 5, 7, 4, 1, 5, 3, 8, 1, 2, 3, 4, 1, 5, 3, 9, 1, 4, 3, 4, 1, 5, 3, 10, 11, 2, 12, 13, 11, 14, 12, 15, 11, 14, 7, 13, 11, 14, 12, 16, 11, 2, 12, 4, 11, 14, 12, 17, 11, 4, 12, 4, 11, 14, 12, 18, 19, 2, 20, 4, 19, 21, 20, 22, 19, 21, 23, 24, 19, 21, 20, 25, 19, 2, 20, 4, 19, 21, 20, 26, 19, 4, 20, 4, 19, 21, 20, 27, 28, 2, 29, 4, 28, 30, 29, 31, 28, 30, 32, 24, 28, 30, 29, 33, 28, 2, 29, 4, 28, 30, 29, 34, 28, 4, 29, 4, 28, 30, 29, 4, 36, 4, 35, 37, 36, 38, 35, 39, 4, 40, 41, 37, 36, 38, 35, 42, 36, 2, 43, 37, 36, 38, 35, 44, 36, 45, 46, 47, 36, 48, 43, 49, 50, 51, 52, 49, 50, 51, 52, 55, 50, 53, 54, 49, 50, 51, 52, 56, 50, 2, 52, 49, 50, 51, 52, 57, 50, 58, 59, 49, 50, 51, 52, 60, 61, 4, 62, 60, 61, 63, 62, 64, 61, 65, 66, 60, 61, 63, 62, 67, 61, 2, 62, 4, 61, 63, 62, 68, 61, 4, 62, 4, 61, 63, 62, 69, 70, 4, 71, 69, 70, 72, 71, 73, 70, 4, 70, 69, 70, 72, 71, 74, 70, 2, 71, 4, 70, 72, 71, 75, 70, 4, 71, 4, 70, 72, 71, 76, 77};
    public static final int[] READ_INS = new int[]{50, 51, 49, 19, 11, 1, 28, 70, 61, 69, 60, 13, 52, 59, 4};
    public static final int[] WRITE_INS = new int[]{36, 38, 37, 35, 43, 48, 47, 46};
    public static final int[] RMW_INS = new int[]{5, 21, 14, 30, 72, 63, 3, 20, 12, 29, 71, 62};

    public static void init() {
        int n = INSTRUCTION_SET.length;
        for (int i = 0; i < n; ++i) {
            int mode = i & 0x1F;
            int pos = i >> 5;
            int instruction = INSTRUCTION_SET[i];
            if (i >= 256) continue;
            int n2 = i;
            INSTRUCTION_SET[n2] = INSTRUCTION_SET[n2] | MOS6510Ops.getAdrMode(pos, mode);
            int n3 = i;
            INSTRUCTION_SET[n3] = INSTRUCTION_SET[n3] | MOS6510Ops.getOpMode(instruction);
        }
    }

    public static int lookup(String instr) {
        instr = instr.toUpperCase();
        int n = INS_STR.length;
        for (int i = 0; i < n; ++i) {
            if (!INS_STR[i].equals(instr)) continue;
            return i;
        }
        return -1;
    }

    public static int lookup(int instr, int adrMode) {
        int n = INSTRUCTION_SET.length;
        for (int i = 0; i < n; ++i) {
            int op = INSTRUCTION_SET[i];
            int adr = op & 0xF00;
            if ((op &= 0xFF) != instr || adr != adrMode) continue;
            return i;
        }
        return -1;
    }

    public static String modeString(int mode) {
        switch (mode) {
            case 256: {
                return "immediate";
            }
            case 512: {
                return "zero";
            }
            case 768: {
                return "absolute";
            }
            case 1024: {
                return "zero,x";
            }
            case 1280: {
                return "zero,y";
            }
            case 1536: {
                return "absolute,x";
            }
            case 1792: {
                return "absolute,y";
            }
            case 2048: {
                return "relative";
            }
            case 2304: {
                return "indirect,x";
            }
            case 2560: {
                return "indirect,y";
            }
            case 2816: {
                return "accumulator";
            }
            case 3072: {
                return "indirect";
            }
            case 0: {
                return "implied";
            }
        }
        return "";
    }

    public static String toString(int instr) {
        int op = INSTRUCTION_SET[instr];
        int adr = (op & 0xF00) >> 8;
        return INS_STR[op &= 0xFF] + ADR_STR_PRE[adr] + ADR_STR_POST[adr];
    }

    public static String toString(int instr, boolean rmw) {
        int i = INSTRUCTION_SET[instr];
        int adr = (i & 0xF00) >> 8;
        int op = i & 0xFF;
        if (!rmw) {
            return INS_STR[op] + ADR_STR_PRE[adr] + ADR_STR_POST[adr];
        }
        String s = INS_STR[op] + ADR_STR_PRE[adr] + ADR_STR_POST[adr];
        int mode = i & 0xF000;
        if (mode == 4096) {
            return s + " read";
        }
        if (mode == 8192) {
            return s + " write";
        }
        if (mode == 12288) {
            return s + " rmw";
        }
        return s;
    }

    private static int getAdrMode(int pos, int m) {
        switch (m) {
            case 0: 
            case 2: {
                if (pos > 4) {
                    return 256;
                }
                return 0;
            }
            case 1: 
            case 3: {
                return 2304;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 512;
            }
            case 9: 
            case 11: {
                return 256;
            }
            case 10: {
                if (pos < 4) {
                    return 2816;
                }
                return 0;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                if (m == 12 && pos == 3) {
                    return 3072;
                }
                return 768;
            }
            case 16: {
                return 2048;
            }
            case 17: 
            case 19: {
                return 2560;
            }
            case 20: 
            case 21: {
                return 1024;
            }
            case 22: 
            case 23: {
                if (pos == 4 || pos == 5) {
                    return 1280;
                }
                return 1024;
            }
            case 25: 
            case 27: {
                return 1792;
            }
            case 28: 
            case 29: {
                return 1536;
            }
            case 30: 
            case 31: {
                if (pos == 4 || pos == 5) {
                    return 1792;
                }
                return 1536;
            }
        }
        return 0;
    }

    private static int getOpMode(int i) {
        int j;
        int m = READ_INS.length;
        for (j = 0; j < m; ++j) {
            if (READ_INS[j] != i) continue;
            return 4096;
        }
        m = WRITE_INS.length;
        for (j = 0; j < m; ++j) {
            if (WRITE_INS[j] != i) continue;
            return 8192;
        }
        m = RMW_INS.length;
        for (j = 0; j < m; ++j) {
            if (RMW_INS[j] != i) continue;
            return 12288;
        }
        System.out.println("OP: " + i + " not found...");
        return 0;
    }

    public static void main(String[] args) {
        MOS6510Ops.init();
        int n = 258;
        for (int i = 0; i < n; ++i) {
            System.out.println(Hex.hex2(i) + " => " + MOS6510Ops.toString(i, true) + " IS:" + Hex.hex2(INSTRUCTION_SET[i]));
        }
        int b = MOS6510Ops.lookup(74, 2048);
        System.out.println("BEQ # => " + b);
    }

    static {
        MOS6510Ops.init();
    }
}

