/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.AudioDriver;
import com.dreamfabric.jac64.ExtChip;
import com.dreamfabric.jac64.MOS6510Core;
import com.dreamfabric.jac64.SIDMixer;
import com.dreamfabric.jac64.SIDVoice6581;
import com.dreamfabric.jac64.TimeEvent;

public class SIDChip
extends ExtChip {
    public static final boolean SOUND_AVAIABLE = true;
    public static final int IO_OFFSET = 12288;
    SIDVoice6581[] sid;
    SIDMixer mixer;
    private int sidUpdate = 1000;
    private boolean killEvent = false;
    private TimeEvent sidEvent = new TimeEvent(0L, "JaC SID Chip"){

        @Override
        public void execute(long cycles) {
            SIDChip.this.mixer.updateSound(cycles);
            this.time += (long)SIDChip.this.sidUpdate;
            if (this.time < SIDChip.this.cpu.cycles) {
                this.time = SIDChip.this.cpu.cycles + 10L;
            }
            if (!SIDChip.this.killEvent) {
                SIDChip.this.cpu.scheduler.addEvent(this);
            }
        }
    };

    public SIDChip(MOS6510Core cpu, AudioDriver driver) {
        this.init(cpu);
        try {
            System.out.println("Creating SID configuration");
            this.sid = new SIDVoice6581[3];
            this.sid[0] = new SIDVoice6581(cpu.memory, 66560);
            this.sid[0].init();
            this.sid[1] = new SIDVoice6581(cpu.memory, 66567);
            this.sid[1].init();
            this.sid[2] = new SIDVoice6581(cpu.memory, 66574);
            this.sid[2].init();
            this.sid[0].next = this.sid[2];
            this.sid[1].next = this.sid[0];
            this.sid[2].next = this.sid[1];
            this.mixer = new SIDMixer(this.sid, null, driver);
            driver.setMasterVolume(100);
            this.sidEvent.time = cpu.cycles + 10L;
            cpu.scheduler.addEvent(this.sidEvent);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.sid = null;
        }
    }

    @Override
    public void clock(long cycles) {
    }

    @Override
    public int performRead(int address, long cycles) {
        switch (address - 12288) {
            case 54299: {
                return this.sid[2].lastSample() & 0xFF;
            }
            case 54300: {
                return this.sid[2].adsrVol & 0xFF;
            }
        }
        return 0;
    }

    @Override
    public void performWrite(int address, int data, long cycles) {
        switch (address - 12288) {
            case 54276: {
                this.sid[0].setControl(data, this.cpu.cycles);
                break;
            }
            case 54277: {
                this.sid[0].setAD(data, this.cpu.cycles);
                break;
            }
            case 54278: {
                this.sid[0].setSR(data, this.cpu.cycles);
                break;
            }
            case 54274: 
            case 54275: {
                this.sid[0].updatePulseWidth(cycles);
                break;
            }
            case 54283: {
                this.sid[1].setControl(data, this.cpu.cycles);
                break;
            }
            case 54284: {
                this.sid[1].setAD(data, this.cpu.cycles);
                break;
            }
            case 54285: {
                this.sid[1].setSR(data, this.cpu.cycles);
                break;
            }
            case 54281: 
            case 54282: {
                this.sid[1].updatePulseWidth(cycles);
                break;
            }
            case 54290: {
                this.sid[2].setControl(data, this.cpu.cycles);
                break;
            }
            case 54291: {
                this.sid[2].setAD(data, this.cpu.cycles);
                break;
            }
            case 54292: {
                this.sid[2].setSR(data, this.cpu.cycles);
                break;
            }
            case 54288: 
            case 54289: {
                this.sid[2].updatePulseWidth(cycles);
                break;
            }
            case 54293: {
                this.mixer.setFilterCutoffLO(data & 7);
                break;
            }
            case 54294: {
                this.mixer.setFilterCutoffHI(data);
                break;
            }
            case 54295: {
                this.mixer.setFilterResonance(data >> 4);
                this.mixer.setFilterOn(data & 0xF);
                break;
            }
            case 54296: {
                this.mixer.setVolume(data & 0xF, this.cpu.cycles);
                this.mixer.setFilterCtrl(data);
            }
        }
    }

    @Override
    public void reset() {
        this.mixer.reset();
        this.sidEvent.time = this.cpu.cycles;
    }

    @Override
    public void stop() {
        this.killEvent = true;
    }
}

