/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jsidplay;

import com.dreamfabric.jac64.AudioDriver;
import com.dreamfabric.jac64.AudioDriverSE;
import com.dreamfabric.jac64.SELoader;
import com.dreamfabric.jsidplay.C64TextRenderer;
import com.dreamfabric.jsidplay.JSIDChipemu;
import com.dreamfabric.jsidplay.JSIDListener;
import com.dreamfabric.jsidplay.JSIDPlayer;
import com.dreamfabric.jsidplay.PSIDCanvas;
import com.dreamfabric.jsidplay.SIDCanvas;
import com.dreamfabric.jsidplay.SIDMixerDisplay;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JSIDPlay
extends Applet
implements ActionListener,
JSIDListener {
    public static final boolean DEBUG = false;
    public static final boolean AUTODEBUG = false;
    public static final int PSID = 1;
    public static final int RSID = 2;
    public static final String VERSION = "0.76";
    public static final String JSID = "JSIDPlay 0.76: ";
    public static final String JSID_POST = "                         ";
    public static final int NONE = 0;
    public static final int VIEW_INTERNALS = 1;
    public static final int VIEW_CONTROLS = 2;
    public static final int VIEW_SPECTRUM = 4;
    public static final String DEFAULT_STATUS = "JSIDPlay 0.76:  -= www.jac64.com =-                         ";
    private int repaint;
    private long lastUpdate;
    boolean noapplet = false;
    boolean gui = true;
    private int viewMode = 7;
    String sidName = "sids/City.sid";
    String hvscBase = "";
    FileDialog fileDialog;
    JFrame window;
    JButton nextSong;
    JPanel panel;
    int currentSong = 0;
    int nxtSong;
    int volume = 100;
    C64Scroller statusLabel;
    C64Scroller c64Scroller;
    int effect = 0;
    int scrollSize = 30;
    int fadeTime = -1;
    int fadeVol = 0;
    AudioDriver audioDriver;
    private JSIDPlayer player = new JSIDPlayer(){

        @Override
        public void setSongInfo(String songinfo) {
            System.out.println("Song info:" + songinfo);
            JSIDPlay.this.c64Scroller.setText("                                                song: " + songinfo + "       " + this.songCount + " songs      JSIDPlay " + JSIDPlay.VERSION + " by Joakim Eriksson.......         more info at www.jac64.com                    ");
        }

        @Override
        public void setStatus(String text) {
            if (JSIDPlay.this.statusLabel != null) {
                JSIDPlay.this.statusLabel.setText("JSIDPLAY: " + text + JSIDPlay.JSID_POST);
            } else {
                System.out.println("Status: " + text);
            }
        }
    };
    private boolean enableTimers;
    private SIDCanvas[] sidCanvas = new SIDCanvas[3];
    private PSIDCanvas psidCanvas;
    private SIDMixerDisplay mixerDisplay;
    private JPanel sidPanel;

    @Override
    public String getParameter(String param) {
        if (this.noapplet) {
            return "";
        }
        return super.getParameter(param);
    }

    private URL getResource(String urls) {
        URL url = this.getClass().getResource(urls);
        if (url == null) {
            try {
                url = new URL(this.getCodeBase().toString() + urls);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }

    public void openWindow() {
        if (this.noapplet) {
            this.window = new JFrame();
        }
        if (this.viewMode != 0) {
            this.sidPanel = new JPanel(new GridLayout(0, 1));
            this.sidPanel.setOpaque(false);
        }
        if (this.window != null) {
            this.panel = new JPanel(new GridLayout(0, 4, 0, 0));
            this.window.getContentPane().add((Component)this.panel, "North");
            if (this.sidPanel != null) {
                this.window.getContentPane().add((Component)this.sidPanel, "Center");
            }
        } else {
            this.setLayout(new BorderLayout());
            this.panel = new JPanel(new GridLayout(0, 1, 0, 0));
            this.add((Component)this.panel, "North");
            if (this.sidPanel != null) {
                this.add((Component)this.sidPanel, "Center");
            }
        }
        if ((this.viewMode & 1) != 0 && this.noapplet) {
            this.sidPanel.add(this.c64Scroller);
        }
        if ((this.viewMode & 2) != 0) {
            // empty if block
        }
        if (this.noapplet) {
            JButton butt = new JButton("Load SID");
            butt.addActionListener(this);
            this.panel.add((Component)butt, 0);
            butt = new JButton("Init SID");
            butt.addActionListener(this);
            this.panel.add((Component)butt, 0);
            this.nextSong = new JButton("Next Song");
            this.nextSong.addActionListener(this);
            this.panel.add((Component)this.nextSong, 0);
            butt = new JButton("Reset Player");
            butt.addActionListener(this);
            this.panel.add((Component)butt, 0);
            butt = new JButton("Pause Player");
            butt.addActionListener(this);
            this.panel.add((Component)butt, 0);
            butt = new JButton("Effects on");
            this.effect = 0;
            JButton b2 = new JButton("DEBUG");
            b2.addActionListener(this);
            this.panel.add((Component)b2, 0);
            b2 = new JButton("AUTO DEBUG ON");
            b2.addActionListener(this);
            this.panel.add((Component)b2, 0);
            b2 = new JButton("INFO");
            b2.addActionListener(this);
            this.panel.add((Component)b2, 0);
        } else {
            this.panel.setFont(new Font("Monospaced", 0, 10));
            this.panel.add(this.statusLabel);
            this.statusLabel.setText(DEFAULT_STATUS);
            this.panel.add(this.c64Scroller);
            this.c64Scroller.setText("                                      JSIDPlay 0.76 by Joakim Eriksson, 2004 - 2007                          ");
            if ((this.viewMode & 4) != 0) {
                this.add((Component)this.mixerDisplay, "South");
            }
        }
        if (this.window != null) {
            this.window.setSize(380, 450);
            this.window.show();
        }
        this.screenRefresh();
    }

    public void reset() {
        this.player.reset();
    }

    public void noapplet() {
        this.noapplet = true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JButton b;
        String cmd = ae.getActionCommand();
        if (cmd.startsWith("Load")) {
            if (this.fileDialog == null) {
                this.fileDialog = new FileDialog((Frame)this.window, "Select File to Load");
            }
            this.fileDialog.show();
            String name = this.fileDialog.getDirectory() + this.fileDialog.getFile();
            this.readSIDFromFile(name);
            this.player.playSID();
        } else if (cmd.startsWith("Init")) {
            this.player.initSID();
        } else if (cmd.startsWith("Reset")) {
            System.out.println("Resetting");
            this.player.reset();
        } else if (cmd.startsWith("Pause")) {
            b = (JButton)ae.getSource();
            b.setText("Continue...");
            this.player.sids.setPause(true);
        } else if (cmd.startsWith("Continue")) {
            b = (JButton)ae.getSource();
            b.setText("Pause Player");
            this.player.sids.setPause(false);
        }
        if (cmd.startsWith("Effects")) {
            JButton jButton = (JButton)ae.getSource();
        } else if (cmd.startsWith("DEBUG")) {
            this.player.sids.dumpStatus();
            this.player.imon.setLevel(10);
            this.player.imon.setEnabled(!this.player.imon.isEnabled());
        } else if (cmd.startsWith("AUTO DEBUG")) {
            this.player.setAutoDebug();
        } else if (cmd.startsWith("Next Song")) {
            this.player.nextSong();
        } else if (cmd.startsWith("INFO")) {
            this.player.sids.dumpStatus();
        }
    }

    public void pause() {
        this.player.setPause(true);
        this.player.setStatus("*** Paused ***");
    }

    public void play() {
        this.player.setPause(false);
        if (this.player.songCount() > 0) {
            this.player.setStatus("song: " + (this.player.getSong() + 1) + "/" + this.player.songCount());
        } else {
            this.player.setStatus(DEFAULT_STATUS);
        }
    }

    public void nextSong() {
        this.player.nextSong();
    }

    public void previousSong() {
        this.player.previousSong();
    }

    public void setEffect(int effect) {
        this.player.setEffect(effect);
    }

    public void setVolume(int v) {
        if (v > 100) {
            v = 100;
        }
        if (v < 0) {
            v = 0;
        }
        this.volume = v;
        this.audioDriver.setMasterVolume(this.volume);
        this.player.setStatus("Volume set to: " + v);
    }

    public void incVolume() {
        this.setVolume(this.volume + 10);
    }

    public void decVolume() {
        this.setVolume(this.volume - 10);
    }

    @Override
    public void init() {
        int cval2;
        this.audioDriver = new AudioDriverSE();
        this.audioDriver.init(44000, 22000);
        this.audioDriver.setMasterVolume(100);
        this.player.init(this, new SELoader(), this.audioDriver);
        if (!this.noapplet) {
            try {
                this.viewMode = 0;
                String param = this.getParameter("viewmode");
                if (param != null) {
                    if ("all".equals(param)) {
                        this.viewMode = 3;
                    } else if ("controls".equals(param)) {
                        this.viewMode = 2;
                    } else if ("status".equals(param)) {
                        this.viewMode = 1;
                    } else if ("spectrum".equals(param)) {
                        this.viewMode = 4;
                        this.mixerDisplay = new SIDMixerDisplay();
                    }
                }
            }
            catch (Exception e) {
                this.viewMode = 3;
            }
        }
        String chs = this.getParameter("scroll-size");
        try {
            if (chs != null) {
                this.scrollSize = Integer.parseInt(chs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.statusLabel = new C64Scroller(this.scrollSize);
        this.c64Scroller = new C64Scroller(this.scrollSize);
        String col = this.getParameter("foreground-color");
        if (col != null || col.length() > 1) {
            try {
                cval2 = Integer.parseInt(col, 16);
                this.c64Scroller.text.setColor(1, 0xFF000000 | cval2);
                this.statusLabel.text.setColor(1, 0xFF000000 | cval2);
                if (this.mixerDisplay != null) {
                    this.mixerDisplay.setForeground(new Color(cval2));
                }
                this.panel.setForeground(new Color(cval2));
                this.setForeground(new Color(cval2));
            }
            catch (Exception cval2) {
                // empty catch block
            }
        }
        if ((col = this.getParameter("background-color")) != null || col.length() > 1) {
            try {
                cval2 = Integer.parseInt(col, 16);
                this.c64Scroller.text.setColor(0, 0xFF000000 | cval2);
                this.statusLabel.text.setColor(0, 0xFF000000 | cval2);
                if (this.mixerDisplay != null) {
                    this.mixerDisplay.setBackground(new Color(cval2));
                }
                this.panel.setBackground(new Color(cval2));
                this.setBackground(new Color(cval2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.gui) {
            this.openWindow();
        }
    }

    public void setPlayTime(int seconds) {
        this.fadeTime = seconds;
    }

    @Override
    public void start() {
        this.player.start();
        this.hvscBase = this.getParameter("hvscBase");
        String p = "";
        p = this.getParameter("playsid");
        if (p != null && p != "") {
            final String param = p;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (!((JSIDPlay)JSIDPlay.this).player.sids.isReady()) {
                        JSIDPlay.this.player.setStatus("Warming up " + ((i++ & 1) == 1 ? "_" : " "));
                        try {
                            Thread.currentThread();
                            Thread.sleep(100L);
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                        }
                    }
                    int songNo = -1;
                    try {
                        songNo = Integer.parseInt(JSIDPlay.this.getParameter("playsong"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JSIDPlay.this.playSIDFromURL(param);
                    if (songNo != -1) {
                        JSIDPlay.this.player.playSong(songNo);
                    }
                }
            }).start();
        }
    }

    @Override
    public void stop() {
        this.player.stop();
    }

    public boolean readSIDFromFile(String name) {
        this.player.reset();
        try {
            System.out.println("Loading SID " + name);
            FileInputStream reader = new FileInputStream(name);
            return this.player.readSID(reader);
        }
        catch (Exception e) {
            System.out.println("Error while opening file " + name + "  " + e);
            return false;
        }
    }

    public void playSIDFromURL(String name) {
        this.player.reset();
        this.player.setStatus("Loading song: " + name);
        try {
            URL url = name.startsWith("http") ? new URL(name) : this.getResource(name);
            if (this.player.readSID(url.openConnection().getInputStream())) {
                this.player.playSID();
            }
        }
        catch (IOException ioe) {
            System.out.println("Could not load: ");
            ioe.printStackTrace();
            this.player.setStatus("Could not load SID: " + ioe.getMessage());
        }
    }

    public void playSIDFromHVSC(String name) {
        this.player.reset();
        this.player.setStatus("Loading song: " + name);
        try {
            URL url;
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if (this.player.readSID((url = this.getResource(this.hvscBase + name)).openConnection().getInputStream())) {
                this.player.playSID();
            }
        }
        catch (IOException ioe) {
            System.out.println("Could not load: ");
            ioe.printStackTrace();
            this.player.setStatus("Could not load SID: " + ioe.getMessage());
        }
    }

    @Override
    public void sidUpdate() {
        JSIDChipemu sids = this.player.sids;
    }

    @Override
    public void screenRefresh() {
        long diff = System.currentTimeMillis() - this.lastUpdate;
        if (diff < 10L) {
            return;
        }
        this.lastUpdate = System.currentTimeMillis();
        JSIDChipemu sids = this.player.sids;
        ++this.repaint;
        if ((this.viewMode & 1) != 0 && this.repaint % 4 == 0) {
            this.sidPanel.repaint();
        }
        if (this.mixerDisplay != null && this.repaint % 4 == 0) {
            this.mixerDisplay.repaint();
        }
        if (this.repaint % 50 == 0 && this.player.songCount() > 0) {
            String text = "song " + (this.player.getSong() + 1) + "/" + this.player.songCount() + " ";
            while (text.length() < this.scrollSize - 15) {
                text = text + " ";
            }
            text = text + this.player.getPlayTime();
            this.player.setStatus(text);
        }
        this.c64Scroller.updatePos();
        this.c64Scroller.repaint();
        System.out.println("PlayTime:" + this.player.getPlayTime());
        if (this.fadeTime > 0 && this.player.getPlaySec() > this.fadeTime) {
            this.fadeVol = this.volume;
            this.fadeTime = 0;
        }
        if (this.fadeVol > 0) {
            System.out.println("Time for fade... " + this.fadeVol);
            --this.fadeVol;
            this.player.sids.audioDriver.setMasterVolume(this.fadeVol);
            if (this.fadeVol == 0) {
                this.player.setPause(true);
            }
        }
    }

    public static void main(String[] args) {
        JSIDPlay sp = new JSIDPlay();
        sp.noapplet();
        sp.init();
        sp.start();
    }

    public class C64Scroller
    extends JComponent {
        C64TextRenderer text;
        Image image;
        long lastTime;
        long currentTime;
        int width;
        int pos = 0;
        int speed = 10;
        int size;
        String textStr = "                                              ";

        public C64Scroller(int size) {
            this.size = size;
            this.text = new C64TextRenderer(((JSIDPlay)JSIDPlay.this).player.memory, size * 2, 8);
            this.text.renderText("just a simple test text...");
            this.image = this.text.getImage();
            this.width = size * 8;
            this.speed = 10;
            this.setPreferredSize(new Dimension(size * 8, 8));
            this.updateText();
        }

        public void setText(String text) {
            this.textStr = text.toLowerCase();
            this.pos = 0;
            this.updateText();
            this.repaint();
        }

        private void updateText() {
            String txt = "";
            int n = this.size * 2;
            for (int i = 0; i < n; ++i) {
                txt = txt + this.textStr.charAt((this.pos + i) % this.textStr.length());
            }
            this.text.renderText(txt);
            this.pos += this.size;
        }

        public void updatePos() {
            this.currentTime += (long)this.speed;
        }

        @Override
        public void paint(Graphics g) {
            int delta = (int)(this.currentTime - this.lastTime);
            int w = this.getWidth();
            int xpos = delta * w / 2000;
            if (xpos > w) {
                this.lastTime = this.currentTime;
                xpos -= w;
                this.updateText();
            }
            g.drawImage(this.image, -xpos, 0, w * 2, this.getHeight(), null);
        }
    }
}

