/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jsidplay;

import com.dreamfabric.c64utils.Assembler;
import com.dreamfabric.c64utils.Debugger;
import com.dreamfabric.jac64.AudioDriver;
import com.dreamfabric.jac64.DefaultIMon;
import com.dreamfabric.jac64.IMonitor;
import com.dreamfabric.jac64.Loader;
import com.dreamfabric.jac64.M6510Ops;
import com.dreamfabric.jsidplay.JSCPU;
import com.dreamfabric.jsidplay.JSIDChipemu;
import com.dreamfabric.jsidplay.JSIDListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class JSIDPlayer
implements Runnable,
M6510Ops {
    public static final boolean DEBUG = true;
    public static boolean AUTODEBUG = false;
    public static final int PSID = 1;
    public static final int RSID = 2;
    public static final int V_PAL = 1;
    public static final int V_NTSC = 2;
    public static final int V_BOTH = 3;
    public static final String[] TYPE_NAMES = new String[]{"", "PSID", "RSID"};
    public static final String[] VIDEO_NAMES = new String[]{"", "PAL", "NTSC", "PAL & NTSC"};
    private JSCPU cpu;
    public JSIDChipemu sids;
    public IMonitor imon;
    public Loader loader;
    private int repaint;
    long startTime;
    int[] memory;
    int version;
    int offset;
    int addr;
    int iaddr;
    int paddr;
    int startAddress;
    int startPageAddress;
    int loadEndAddress;
    int songCount;
    int startsong;
    int songadr;
    int type;
    int videoMode = 0;
    long speed;
    boolean autoInstalls = false;
    String sidName = "sids/City.sid";
    String hvscBase = "";
    int currentSong = 0;
    int nxtSong;
    int effect = 0;
    String songName;
    String songAuthor;
    String songCopyright;
    Assembler asm;
    private boolean enableTimers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readSID(InputStream stream) {
        byte[] start = new byte[22];
        this.startPageAddress = 0;
        try {
            DataInputStream reader = new DataInputStream(stream);
            reader.readFully(start);
            String st = new String(start);
            if (st.startsWith("PSID") || st.startsWith("RSID")) {
                this.type = st.startsWith("RSID") ? 2 : 1;
                this.version = (start[4] & 0xFF) * 256 + (start[5] & 0xFF);
                this.offset = (start[6] & 0xFF) * 256 + (start[7] & 0xFF);
                this.addr = (start[8] & 0xFF) * 256 + (start[9] & 0xFF);
                this.iaddr = (start[10] & 0xFF) * 256 + (start[11] & 0xFF);
                this.paddr = (start[12] & 0xFF) * 256 + (start[13] & 0xFF);
                this.songCount = (start[14] & 0xFF) * 256 + (start[15] & 0xFF);
                this.startsong = (start[16] & 0xFF) * 256 + (start[17] & 0xFF) - 1;
                this.speed = ((start[18] & 0xFF) << 24) + ((start[19] & 0xFF) << 16) + ((start[20] & 0xFF) << 8) + (start[21] & 0xFF);
                if (this.startsong < 0) {
                    this.startsong = 0;
                }
                System.out.println("FOUND SID TUNE!");
                System.out.println("Type: " + TYPE_NAMES[this.type]);
                System.out.println("Version: " + this.version);
                System.out.println("LoadAddr: " + this.addr + " (" + Integer.toString(this.addr, 16) + ")");
                System.out.println("InitAddr: " + this.iaddr + " (" + Integer.toString(this.iaddr, 16) + ")");
                System.out.println("PlayAddr: " + this.paddr + " (" + Integer.toString(this.paddr, 16) + ")");
                System.out.println("SongCount: " + this.songCount);
                System.out.println("StartSong: " + this.startsong);
                System.out.println("Speed: " + Long.toString(this.speed, 2));
                this.songName = this.getString(reader);
                this.songAuthor = this.getString(reader);
                this.songCopyright = this.getString(reader);
                System.out.println("--------------------------");
                System.out.println("Name      :" + this.songName);
                System.out.println("Author    :" + this.songAuthor);
                System.out.println("Copyright :" + this.songCopyright);
                if (this.version == 2) {
                    byte[] v2data = new byte[6];
                    reader.readFully(v2data);
                    int flags = (v2data[0] << 8) + v2data[1];
                    System.out.println("Version 2 flags: " + flags);
                    this.videoMode = flags >> 2 & 3;
                    System.out.println("VideoMode: " + VIDEO_NAMES[this.videoMode]);
                    System.out.println("Start Page     : " + (v2data[2] & 0xFF));
                    System.out.println("Page length    : " + (v2data[3] & 0xFF));
                    this.startPageAddress = (v2data[2] & 0xFF) * 256;
                    System.out.println("StartPageAddress: " + this.startPageAddress);
                }
                byte[] adr = new byte[2];
                reader.readFully(adr);
                this.startAddress = (adr[1] & 0xFF) * 256 + (adr[0] & 0xFF);
                System.out.println("Loading SID into: " + this.startAddress + " (" + Integer.toString(this.startAddress, 16) + ")");
                int sadr = this.startAddress;
                try {
                    int byt;
                    while ((byt = reader.read()) != -1) {
                        this.setMemory(sadr++, byt & 0xFF);
                    }
                }
                catch (Exception eof) {
                    System.out.println("Exception " + eof);
                    System.out.println("End of file: " + sadr + " (" + Integer.toString(sadr, 16) + ")");
                }
                finally {
                    this.loadEndAddress = sadr - 1;
                    reader.close();
                }
            }
            System.out.println("End of SID file: " + this.loadEndAddress + " (" + Integer.toString(this.loadEndAddress, 16) + ")");
            this.enableTimers = this.type == 2 || this.speed != 0L;
            this.sids.enableTimers(this.enableTimers);
            this.setSongInfo(this.getSongInfo());
            return true;
        }
        catch (Exception e) {
            System.out.println("Error while reading SID");
            return false;
        }
    }

    private String getString(DataInputStream reader) throws IOException {
        byte[] str = new byte[32];
        reader.readFully(str);
        int n = 32;
        for (int i = 0; i < n; ++i) {
            if (str[i] != 0) continue;
            return new String(str, 0, i);
        }
        return new String(str);
    }

    public void setAutoDebug() {
        AUTODEBUG = true;
    }

    public void playSID() {
        int i = 0;
        this.setStatus("Starting play");
        while (!this.sids.isReady() && i < 50) {
            System.out.println("Waiting for CPU..." + i);
            try {
                ++i;
                Thread.sleep(500L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.sids.isReady()) {
            this.initSID();
            if (AUTODEBUG) {
                System.out.println("AUTODEBUG ON!");
                this.imon.setEnabled(true);
                this.imon.setLevel(10);
            }
            this.setStatus("song " + (this.currentSong + 1) + "/" + this.songCount);
        } else {
            this.setStatus("CPU not ready");
        }
    }

    public int getPlaySec() {
        if (this.startTime == 0L) {
            return 0;
        }
        return (int)((System.currentTimeMillis() - this.startTime) / 1000L);
    }

    public String getPlayTime() {
        int sec = this.getPlaySec();
        if (sec < 10) {
            return "00:0" + sec;
        }
        if (sec < 60) {
            return "00:" + sec;
        }
        if (sec < 600) {
            return "0" + sec / 60 + ":" + sec % 60;
        }
        return "" + sec / 60 + ":" + sec % 60;
    }

    public void playSong(int index) {
        this.startTime = System.currentTimeMillis();
        this.asm.setByteValue("playnum", index);
        this.asm.setByteValue("changeplay", 1);
        this.currentSong = index;
        this.setStatus("song " + (index + 1) + "/" + this.songCount);
    }

    public int songCount() {
        return this.songCount;
    }

    public void nextSong() {
        this.currentSong = (this.currentSong + 1) % this.songCount;
        this.playSong(this.currentSong);
    }

    public void previousSong() {
        this.currentSong = (this.currentSong + this.songCount - 1) % this.songCount;
        this.playSong(this.currentSong);
    }

    public void setEffect(int effect) {
    }

    public void initSID() {
        this.startTime = System.currentTimeMillis();
        if (this.songCount == 0) {
            System.out.println("Error - song count = 0!");
            return;
        }
        this.nxtSong = (this.startsong + 1) % this.songCount;
        this.currentSong = this.startsong;
        int bank = 7;
        int playBank = 7;
        if (this.startAddress < 49152 && this.loadEndAddress > 40960 && this.loadEndAddress < 53248) {
            System.out.println("BANK: BASIC OFF!!!");
            bank = 6;
            playBank = 6;
        } else if (this.startAddress >= 53248 && this.startAddress < 57343 || this.loadEndAddress >= 53248 && this.loadEndAddress < 57343) {
            bank = 0;
            playBank = 0;
        } else if (this.startAddress >= 57344 || this.loadEndAddress >= 57344) {
            System.out.println("BANK: KERNAL OFF!!!");
            bank = 5;
            playBank = 5;
        }
        if (this.paddr < 40960) {
            playBank = 7;
        } else if (this.paddr < 53248) {
            playBank = 6;
        } else if (this.paddr >= 57344) {
            playBank = 5;
        }
        System.out.println("InitBank: " + bank);
        System.out.println("PlayBank: " + playBank);
        this.cpu.freeze();
        if (this.asm == null) {
            this.asm = new Assembler();
            this.asm.setMemory(this.memory);
        }
        int address = 2048;
        if (this.startAddress < 2304 && this.loadEndAddress < 49152) {
            address = 49152;
        }
        if (this.startAddress < 2304 && this.loadEndAddress > 49152 && this.startAddress > 1280) {
            address = 1024;
        }
        if (this.startPageAddress != 0) {
            address = this.startPageAddress;
        }
        this.asm.assemble(this.loader.getResourceString("/sidplay.a65"), address);
        int startAt = this.asm.getLabelAddress("cold");
        this.asm.setByteValue("playnum", this.startsong);
        System.out.println("PlayVec:  " + this.paddr);
        this.asm.setWordValue("playvec", this.paddr);
        this.asm.setWordValue("initvec", this.iaddr);
        this.asm.setByteValue("initiomap", 0x30 | bank);
        if (this.type != 2 && this.paddr != 0) {
            this.asm.setByteValue("playiomap", 0x30 | playBank);
        } else {
            this.asm.setByteValue("playiomap", 0);
        }
        this.asm.setByteValue("speed", (int)(this.speed & 0xFFL));
        if (this.videoMode == 2) {
            this.asm.setByteValue("video", 0);
            this.asm.setByteValue("clock", 0);
            this.sids.setPAL(false);
        } else {
            this.asm.setByteValue("video", 1);
            this.asm.setByteValue("clock", 1);
            this.sids.setPAL(true);
        }
        if (this.type != 2) {
            this.asm.setByteValue("flags", 4);
        }
        this.songadr = this.asm.getLabelAddress("playnum");
        System.out.println("SongAddr: " + this.songadr);
        if (this.paddr == 0) {
            this.asm.setWordValue("irqvec", this.asm.getLabelAddress("irqret"));
        } else {
            this.asm.setWordValue("irqvec", this.asm.getLabelAddress("irqjob"));
        }
        System.out.println("Jumping to: " + Integer.toString(startAt, 16));
        this.cpu.jump(startAt);
        this.cpu.unfreeze();
    }

    public void setPause(boolean pause) {
        if (pause) {
            this.sids.setPause(true);
            this.cpu.freeze();
        } else {
            this.sids.setPause(false);
            this.cpu.unfreeze();
        }
    }

    public boolean reset() {
        this.songName = null;
        this.setPause(false);
        this.setStatus("Resetting...");
        this.cpu.reset();
        int again = 20;
        while (!this.sids.isReady() && again-- > 0) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
                this.setStatus("Waiting for CPU: " + again);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setStatus("-");
        return again > 0;
    }

    public int getSong() {
        return this.currentSong;
    }

    public String getSongInfo() {
        return this.songName + " by " + this.songAuthor + ", " + this.songCopyright;
    }

    private void setMemory(int addr, int data) {
        this.memory[addr] = data;
    }

    public void init(JSIDListener list, Loader loader, AudioDriver driver) {
        try {
            this.imon = new Debugger();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.imon == null) {
            this.imon = new DefaultIMon();
        }
        this.imon.setLevel(2);
        this.cpu = new JSCPU(this.imon, "", loader);
        this.loader = loader;
        this.imon.init(this.cpu);
        this.memory = this.cpu.getMemory();
        this.sids = new JSIDChipemu();
        this.cpu.init(this.sids);
        this.sids.init(this.memory, this.cpu, list, driver);
    }

    public void start() {
        new Thread(this).start();
    }

    @Override
    public void run() {
        this.cpu.start();
    }

    public void stop() {
        this.cpu.stop();
        this.sids.audioDriver.shutdown();
    }

    public String getSongName() {
        return this.songName;
    }

    public String getSongAuthor() {
        return this.songAuthor;
    }

    public String getSongCopyright() {
        return this.songCopyright;
    }

    public abstract void setSongInfo(String var1);

    public abstract void setStatus(String var1);
}

