/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jsidplay;

import com.dreamfabric.jac64.SIDVoice;

public class PSID
extends SIDVoice {
    public static final int UPDATE_CYCLES = 1000;
    public static final int PER_SEC = 1000;
    public static final int IO_OFFSET = 12288;
    public static final boolean DEBUG = false;
    private int[] memory;
    private static final int GENLEN = 44;
    public static final long SAMPLES_PER_CYCLE_1024 = 45L;
    public static final int VOLUME_SIZE = 4096;
    private static final int MICROSEC_PER_GEN = 1000;
    public static final int OFF = 0;
    public static final int SAMPLE = 1;
    public static final int NOISE = 2;
    public static final int NO_SOUND = 0;
    public static final int START = 1;
    public static final int CONTINUE = 2;
    byte[] buffer = new byte[262144];
    int[] quiet = new int[44];
    int sampleStart;
    int sampleEnd;
    int playSamplePos = 0;
    boolean playSample = false;
    int mode = 0;
    int lastMode;
    int pvol = 0;
    long lastGenCycles = 0L;
    int cycleDiff;
    int noiceCount;
    int toneLength;
    int nVol;
    int period;
    int period0;
    int address;
    int endAddress;
    int delay;
    int addBytes;
    boolean highNybbleFirst;
    int repeat;
    int repeatAddress;
    int status = 0;
    int samplePos;
    int smpVol;
    int maxSamplePos;
    int currAddr;
    int lastPlayedSample;
    int nxtChange;
    int noise = 0;
    long noise_reg = 0x7FFFF8L;
    byte[] wbuf;
    int irq = 0;
    int pass = 0;
    boolean debugGen = false;
    private long lastCycles = 0L;
    private int generated = 0;
    private int[] outBuff = new int[44];

    public PSID(int[] mem) {
        this.memory = mem;
        System.out.println("PSID Emulator, GENLEN: 44");
    }

    public void init() {
    }

    public void soundControl(int data, long cycles) {
        switch (data) {
            case 253: {
                this.lastMode = this.mode;
                this.mode = 0;
                break;
            }
            case 252: {
                this.pvol = 1;
            }
            case 254: {
                this.pvol = 2;
            }
            case 255: {
                this.pvol = 3;
                this.mode = 1;
                break;
            }
            default: {
                this.noiceCount = data;
                this.mode = 2;
            }
        }
        this.status = 1;
        if (!this.playSample) {
            this.samplePos = 0;
            this.playSamplePos = 0;
            this.maxSamplePos = 16384;
        } else if (this.maxSamplePos + 16384 < 65535) {
            this.maxSamplePos = this.samplePos + 16384;
        }
        this.genSound(cycles);
    }

    private void genSound(long cycles) {
        if (this.status == 1) {
            this.address = (this.memory[66591] << 8) + this.memory[66590];
            if (this.lastCycles == 0L) {
                this.lastCycles = cycles;
            }
            if (!this.playSample) {
                this.cycleDiff = (int)(cycles - this.lastCycles);
                int sampleStart = (int)((long)this.cycleDiff * 45L) >> 10;
                int n = sampleStart;
                for (int i = 0; i < n; ++i) {
                    this.buffer[i] = 0;
                }
                this.samplePos = sampleStart;
            }
            this.smpVol = 15;
        }
        switch (this.mode) {
            case 2: {
                if (this.status == 1) {
                    this.toneLength = this.memory[66621];
                    this.nVol = this.memory[66622];
                    this.period = this.memory[66623];
                    this.period0 = this.memory[66653];
                    this.smpVol = 15;
                }
                while (this.noiceCount >= 0 && this.samplePos < this.maxSamplePos) {
                    int m = this.toneLength;
                    for (int j = 0; j <= m; ++j) {
                        int data = this.memory[this.address + this.noiceCount];
                        int delay = this.period0 + this.period * data;
                        this.cycleDiff += delay;
                        int nextSamplePos = (int)((long)this.cycleDiff * 45L) >> 10;
                        while (this.samplePos < nextSamplePos) {
                            this.buffer[this.samplePos++] = (byte)(this.smpVol << 3);
                        }
                        this.smpVol = this.smpVol + this.nVol & 0xF;
                    }
                    --this.noiceCount;
                }
                this.sampleEnd = this.samplePos;
                this.playSample = true;
                if (this.noiceCount == -1) {
                    this.status = 0;
                    break;
                }
                this.status = 2;
                break;
            }
            case 1: {
                if (this.status == 1) {
                    this.endAddress = (this.memory[66622] << 8) + this.memory[66621];
                    this.delay = this.memory[66653] + (this.memory[66654] << 8);
                    this.addBytes = this.memory[66655];
                    this.highNybbleFirst = this.memory[66685] == 1;
                    this.repeat = this.memory[66623];
                    this.repeatAddress = this.memory[66686] + (this.memory[66687] << 8);
                    this.currAddr = this.address;
                    this.smpVol = 15;
                }
                while (this.repeat >= 0 && this.samplePos < this.maxSamplePos) {
                    while (this.currAddr < this.endAddress) {
                        int data = this.memory[this.currAddr];
                        this.smpVol = this.highNybbleFirst ? data >> 4 : data & 0xF;
                        int nextSamplePos = (int)((long)this.cycleDiff * 45L) >> 10;
                        int len = this.buffer.length;
                        while (this.samplePos < nextSamplePos && this.samplePos < len) {
                            this.buffer[this.samplePos++] = (byte)(this.smpVol << this.pvol);
                        }
                        this.cycleDiff += this.delay;
                        if (this.addBytes == 0) {
                            this.smpVol = this.highNybbleFirst ? data & 0xF : data >> 4;
                            nextSamplePos = (int)((long)this.cycleDiff * 45L) >> 10;
                            while (this.samplePos < nextSamplePos && this.samplePos < len) {
                                this.buffer[this.samplePos++] = (byte)(this.smpVol << this.pvol);
                            }
                            this.cycleDiff += this.delay;
                        }
                        this.currAddr += this.addBytes + 1;
                    }
                    this.currAddr = this.repeatAddress;
                    if (this.repeat == 255) continue;
                    --this.repeat;
                }
                this.sampleEnd = this.samplePos;
                this.playSample = true;
                this.status = this.repeat == -1 ? 0 : 2;
            }
        }
    }

    public void printStatus() {
        System.out.println("Last played mode: " + this.lastMode);
    }

    @Override
    public int[] generateSound(long cycles) {
        this.lastCycles = cycles;
        if (this.playSample) {
            int len = 0;
            len = this.sampleEnd - this.playSamplePos;
            if (len < 0) {
                System.out.println("#### LEN:" + len);
                this.playSamplePos = 0;
                return this.quiet;
            }
            if (len < 44) {
                int i;
                int n = len;
                for (i = 0; i < n; ++i) {
                    this.outBuff[i] = this.buffer[this.playSamplePos++];
                }
                if (this.status == 2) {
                    if (this.playSamplePos < 20000) {
                        this.maxSamplePos = this.playSamplePos + 16384;
                    } else {
                        this.samplePos = 0;
                        this.maxSamplePos = 16384;
                        this.playSamplePos = 0;
                    }
                    this.genSound(cycles);
                    n = 44;
                    for (i = len; i < n; ++i) {
                        this.outBuff[i] = this.buffer[this.playSamplePos++];
                    }
                } else {
                    n = 44;
                    for (i = len; i < n; ++i) {
                        this.outBuff[i] = 0;
                    }
                }
            } else {
                int n = 44;
                for (int i = 0; i < n; ++i) {
                    this.outBuff[i] = this.buffer[this.playSamplePos++];
                }
            }
            if (this.playSamplePos >= this.sampleEnd && this.status != 2) {
                this.playSample = false;
                this.playSamplePos = 0;
                this.status = 0;
            }
            this.lastPlayedSample = 0;
            return this.outBuff;
        }
        ++this.lastPlayedSample;
        return this.quiet;
    }
}

