/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.loader.InvalidFormatException;
import com.vwp.sound.mod.modplay.loader.ModLoader;
import com.vwp.sound.mod.modplay.loader.ModuleLoader;
import com.vwp.sound.mod.modplay.loader.S3MUnits;
import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.module.Pattern;
import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.module.Track;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoEffect;
import com.vwp.sound.mod.modplay.player.autoeffect.Fadeout;
import com.vwp.sound.mod.util.io.RandomAccess;
import com.vwp.sound.mod.util.io.RandomAccessArray;
import java.io.IOException;

public class S3MLoader
extends ModuleLoader {
    public Module module;
    private boolean first = true;

    public S3MLoader(String name, byte[] data) throws InvalidFormatException, IOException {
        RandomAccessArray raf = new RandomAccessArray(data);
        this.module = this.loadModule(raf);
    }

    public Module getModule() {
        return this.module;
    }

    private Module loadModule(RandomAccess raf) throws InvalidFormatException, IOException {
        String moduleName = this.readModuleName(raf);
        this.verifyID(raf);
        this.verifyFileType(raf);
        raf.skipBytes(2);
        int numOrders = this.readWord(raf);
        int numInstruments = this.readWord(raf);
        int numPatterns = this.readWord(raf);
        int flags = this.readWord(raf);
        boolean bl = (flags & 1) != 0;
        boolean bl2 = (flags & 2) != 0;
        boolean bl3 = (flags & 4) != 0;
        boolean bl4 = (flags & 8) != 0;
        boolean bl5 = (flags & 0x10) != 0;
        boolean bl6 = (flags & 0x20) != 0;
        int trackerVersion = this.readWord(raf) & 0xFFF;
        raf.read();
        raf.skipBytes(1);
        String id = ModLoader.readID(raf);
        raf.read();
        int initialSpeed = raf.read();
        int initialTempo = raf.read();
        int cfr_ignored_0 = raf.read() & 0x7F;
        raf.read();
        boolean bl7 = raf.read() == 252;
        raf.skipBytes(10);
        int[] channelSettings = new int[32];
        int n = 0;
        while (n < 32) {
            channelSettings[n] = raf.read();
            ++n;
        }
        int[] orders = new int[numOrders];
        int n2 = 0;
        while (n2 < numOrders) {
            orders[n2] = raf.read();
            ++n2;
        }
        n2 = 0;
        while (n2 < numOrders) {
            if (orders[n2] > numPatterns) {
                orders[n2] = numPatterns;
            }
            ++n2;
        }
        Instrument[] instruments = new Instrument[numInstruments];
        int n3 = 0;
        while (n3 < numInstruments) {
            instruments[n3] = this.loadInstrument(raf, n3);
            ++n3;
        }
        Pattern[] patterns = new Pattern[numPatterns + 1];
        int n4 = 0;
        while (n4 < numPatterns) {
            patterns[n4] = this.loadPattern(raf);
            ++n4;
        }
        patterns[numPatterns] = new Pattern(this.loadEmptyTracks(32), 64);
        double l = 0.1875;
        double r = 0.75;
        double[] panning = new double[32];
        double[] volume = new double[32];
        int n5 = 0;
        while (n5 < channelSettings.length) {
            int channelSetting = channelSettings[n5];
            if (channelSetting == 255 || channelSetting == 127) {
                panning[n5] = 0.5;
            } else {
                int pan = channelSetting & 0x7F;
                if (pan >= 16) {
                    throw new InvalidFormatException("Adlib channels not supported: " + pan);
                }
                panning[n5] = pan < 8 ? l : r;
            }
            volume[n5] = 1.0;
            ++n5;
        }
        this.module = new Module(moduleName, id, "ScreamTracker " + S3MLoader.parseTrackerVersion(trackerVersion), instruments, patterns, orders, 0, initialTempo, initialSpeed, 1.0, 1, volume, panning);
        return this.module;
    }

    public static String parseTrackerVersion(int version) {
        return String.valueOf(version >> 8 & 0xF) + "." + (version & 0xFF);
    }

    private Track[] loadEmptyTracks(int numtracks) {
        Track[] tracks = new Track[numtracks];
        int n = 0;
        while (n < numtracks) {
            tracks[n] = new Track(64);
            int d = 0;
            while (d < 64) {
                tracks[n].initDivision(d, -1, -2, null, null, null);
                ++d;
            }
            ++n;
        }
        return tracks;
    }

    private Pattern loadPattern(RandomAccess raf) throws IOException {
        int patternOfs = this.readWord(raf);
        long backupOfs = raf.getPosition();
        raf.seek(patternOfs * 16);
        Track[] tracks = this.loadEmptyTracks(32);
        this.readWord(raf);
        int n = 0;
        while (n < 64) {
            int data = -1;
            while ((data = raf.read() & 0xFF) != 0) {
                int trackNum = data & 0x1F;
                int note = -2;
                int instrument = -1;
                int volume = -1;
                int command = -1;
                int arg1 = 0;
                int arg2 = 0;
                boolean keyOff = false;
                if ((data & 0x20) != 0) {
                    note = raf.read() & 0xFF;
                    if (note == 255) {
                        note = -2;
                    } else if (note == 254) {
                        keyOff = true;
                        note = -2;
                    } else {
                        int nt = note & 0xF;
                        int oc = note >>> 4;
                        note = nt + oc * 12;
                    }
                    instrument = (raf.read() & 0xFF) - 1;
                }
                if ((data & 0x40) != 0) {
                    volume = raf.read() & 0xFF;
                }
                if ((data & 0x80) != 0) {
                    command = raf.read() & 0xFF;
                    int args = raf.read() & 0xFF;
                    arg1 = args >>> 4;
                    arg2 = args & 0xF;
                }
                int effNum = 0;
                if (command != -1) {
                    ++effNum;
                }
                if (volume != -1) {
                    ++effNum;
                }
                if (keyOff) {
                    ++effNum;
                }
                int[] eff = new int[effNum];
                int[] a1 = new int[effNum];
                int[] a2 = new int[effNum];
                int effOfs = 0;
                if (volume != -1) {
                    eff[effOfs] = 12;
                    a1[effOfs] = volume >>> 4;
                    a2[effOfs] = volume & 0xF;
                    ++effOfs;
                }
                if (command != -1) {
                    int[] a = this.translateEffect(command, arg1, arg2);
                    eff[effOfs] = a[0];
                    a1[effOfs] = a[1];
                    a2[effOfs] = a[2];
                    ++effOfs;
                }
                if (keyOff) {
                    eff[effOfs] = 50;
                    a1[effOfs] = 0;
                    a2[effOfs] = 0;
                    ++effOfs;
                }
                tracks[trackNum].initDivision(n, instrument, note, eff, a1, a2);
            }
            ++n;
        }
        Pattern pattern = new Pattern(tracks, 64);
        raf.seek(backupOfs);
        return pattern;
    }

    private int[] translateEffect(int effect, int arg1, int arg2) {
        switch (effect) {
            case -1: {
                int[] nArray = new int[3];
                nArray[0] = -1;
                return nArray;
            }
            case 1: {
                return new int[]{15, arg1, arg2};
            }
            case 2: {
                return new int[]{11, arg1, arg2};
            }
            case 3: {
                return new int[]{13, arg1, arg2};
            }
            case 4: {
                if (arg1 != 15 && arg2 != 15) {
                    return new int[]{10, arg1, arg2};
                }
                if (arg1 == 15) {
                    int[] nArray = new int[3];
                    nArray[0] = 27;
                    nArray[2] = arg2;
                    return nArray;
                }
                if (arg2 == 15) {
                    int[] nArray = new int[3];
                    nArray[0] = 26;
                    nArray[2] = arg1;
                    return nArray;
                }
            }
            case 5: {
                if (arg1 < 14) {
                    return new int[]{41, arg1, arg2};
                }
                if (arg1 == 14) {
                    int[] nArray = new int[3];
                    nArray[0] = 45;
                    nArray[2] = arg2;
                    return nArray;
                }
                if (arg1 == 15) {
                    int[] nArray = new int[3];
                    nArray[0] = 56;
                    nArray[2] = arg2;
                    return nArray;
                }
            }
            case 6: {
                if (arg1 < 14) {
                    return new int[]{40, arg1, arg2};
                }
                if (arg1 == 14) {
                    int[] nArray = new int[3];
                    nArray[0] = 44;
                    nArray[2] = arg2;
                    return nArray;
                }
                if (arg1 == 15) {
                    int[] nArray = new int[3];
                    nArray[0] = 55;
                    nArray[2] = arg2;
                    return nArray;
                }
            }
            case 7: {
                return new int[]{42, arg1, arg2};
            }
            case 8: {
                break;
            }
            case 9: {
                return new int[]{60, arg1, arg2};
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 20: {
                return new int[]{15, arg1, arg2};
            }
        }
        int[] nArray = new int[3];
        nArray[0] = -1;
        return nArray;
    }

    private Instrument loadInstrument(RandomAccess raf, int instrumentNum) throws InvalidFormatException, IOException {
        int instrumentOfs = this.readWord(raf);
        long backupOfs = raf.getPosition();
        raf.seek(instrumentOfs * 16);
        int type = raf.read();
        this.readInstrumentFileName(raf);
        raf.skipBytes(1);
        int sampleOffset = this.readWord(raf) * 16;
        int sampleLength = this.readWord(raf);
        raf.skipBytes(2);
        int loopBegin = this.readWord(raf);
        raf.skipBytes(2);
        int loopEnd = this.readWord(raf);
        raf.skipBytes(2);
        int defaultVolume = raf.read();
        raf.read();
        raf.read();
        int flags = raf.read();
        boolean loop = (flags & 1) != 0;
        boolean stereo = (flags & 2) != 0;
        boolean bits16 = (flags & 4) != 0;
        int c2speed = this.readWord(raf);
        raf.skipBytes(2);
        raf.skipBytes(12);
        String instrumentName = this.readInstrumentName(raf);
        ModLoader.readID(raf);
        int[] note2sample = new int[1200];
        Sample sample = null;
        if (type != 0) {
            sample = new Sample("sample-" + instrumentNum, instrumentName, (double)defaultVolume / 64.0, 0.5, sampleLength, loop ? 1 : 0, loopBegin, loopEnd - loopBegin, 0.0, 0.0, new S3MUnits(c2speed, false));
            sample.setData(this.readSampleData(raf, sampleOffset, sampleLength, stereo, bits16, instrumentNum));
        }
        AutoEffect[] autoEff = new AutoEffect[]{new Fadeout(1.0)};
        Instrument instrument = new Instrument(instrumentName, note2sample, new Sample[]{sample}, autoEff, 0.5);
        raf.seek(backupOfs);
        return instrument;
    }

    private short[] readSampleData(RandomAccess raf, int offset, int length, boolean stereo, boolean bits16, int sampleNum) throws InvalidFormatException, IOException {
        long pos = raf.getPosition();
        raf.seek(offset);
        short[] data = null;
        if (!stereo && !bits16) {
            data = new short[length];
            int m = 0;
            while (m < data.length) {
                int d = raf.read() & 0xFF;
                data[m] = (short)((d << 8) - 32768);
                ++m;
            }
        } else if (!stereo && bits16) {
            data = new short[length * 2];
            int m = 0;
            while (m < data.length) {
                data[m] = (short)((raf.read() & 0xFF) + (raf.read() & 0xFF) * 256 - 32768);
                ++m;
            }
        } else {
            throw new InvalidFormatException("Unsupported sample format: " + (stereo ? "stereo" : "mono") + " " + (bits16 ? "16" : "8") + " bit");
        }
        raf.seek(pos);
        return data;
    }

    private String readInstrumentFileName(RandomAccess raf) throws IOException {
        StringBuffer nameSB = new StringBuffer();
        int count = 0;
        while (count++ < 12) {
            nameSB.append((char)raf.read());
        }
        return nameSB.toString();
    }

    private String readInstrumentName(RandomAccess raf) throws IOException {
        long pos = raf.getPosition();
        StringBuffer nameSB = new StringBuffer();
        int count = 0;
        int data = 0;
        while (count++ < 28 && (data = raf.read()) != 0) {
            nameSB.append((char)data);
        }
        raf.seek(pos + 28L);
        return nameSB.toString();
    }

    private String readModuleName(RandomAccess raf) throws IOException {
        StringBuffer nameSB = new StringBuffer();
        int data = -1;
        while (raf.getPosition() < 20L && (data = raf.read()) != 0) {
            nameSB.append((char)data);
        }
        raf.seek(28L);
        return nameSB.toString();
    }

    private void verifyID(RandomAccess raf) throws IOException, InvalidFormatException {
        int id = raf.read();
        if (id != 26) {
            throw new InvalidFormatException("Id = " + id + ", 0x01A expected!");
        }
    }

    private int readWord(RandomAccess raf) throws IOException {
        return raf.read() + 256 * raf.read();
    }

    private void verifyFileType(RandomAccess raf) throws IOException, InvalidFormatException {
        int type = raf.read();
        if (type != 16) {
            throw new InvalidFormatException("Song type = " + type + ", 16 expected");
        }
    }
}

