/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.module;

import com.vwp.sound.mod.util.Util;

public class Track {
    private int[] instruments;
    private int[] notes;
    private int[][] effects;
    private int[][] effectArg1;
    private int[][] effectArg2;
    public static final int NO_INSTRUMENT = -1;

    public Track(int divisions) {
        this.instruments = new int[divisions];
        this.notes = new int[divisions];
        this.effects = new int[divisions][];
        this.effectArg1 = new int[divisions][];
        this.effectArg2 = new int[divisions][];
    }

    public void initDivision(int division, int instrumentNumber, int note, int[] effects, int[] effectArg1, int[] effectArg2) {
        this.instruments[division] = instrumentNumber;
        this.notes[division] = note;
        this.effects[division] = effects;
        this.effectArg1[division] = effectArg1;
        this.effectArg2[division] = effectArg2;
    }

    public int getInstrumentNumber(int div) {
        return this.instruments[div];
    }

    public int getNote(int div) {
        return this.notes[div];
    }

    public int getNumberOfEffects(int div) {
        if (this.effects[div] != null) {
            return this.effects[div].length;
        }
        return 0;
    }

    public int getEffect(int div, int n) {
        return this.effects[div][n];
    }

    public int getEffectArg1(int div, int n) {
        return this.effectArg1[div][n];
    }

    public int getEffectArg2(int div, int n) {
        return this.effectArg2[div][n];
    }

    public String getInfo(int div) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getNoteSymbol(div)) + " ");
        sb.append(String.valueOf(this.getInstrumentSymbol(div)) + " ");
        int n = 0;
        while (n < this.getNumberOfEffects(div)) {
            sb.append(String.valueOf(this.getEffectSymbol(div, n)) + " ");
            ++n;
        }
        n = this.getNumberOfEffects(div);
        while (n < 2) {
            sb.append("--- ");
            ++n;
        }
        return sb.toString();
    }

    private String getNoteSymbol(int div) {
        int note = this.notes[div];
        if (note == -2) {
            return "---";
        }
        int noteNum = note % 12;
        int period = note / 12;
        String code = null;
        switch (noteNum) {
            case 0: {
                code = "C-";
                break;
            }
            case 1: {
                code = "C#";
                break;
            }
            case 2: {
                code = "D-";
                break;
            }
            case 3: {
                code = "D#";
                break;
            }
            case 4: {
                code = "E-";
                break;
            }
            case 5: {
                code = "F-";
                break;
            }
            case 6: {
                code = "F#";
                break;
            }
            case 7: {
                code = "G-";
                break;
            }
            case 8: {
                code = "G#";
                break;
            }
            case 9: {
                code = "A-";
                break;
            }
            case 10: {
                code = "A#";
                break;
            }
            case 11: {
                code = "B-";
                break;
            }
            default: {
                code = "XX";
            }
        }
        code = String.valueOf(code) + period;
        return code;
    }

    private String getInstrumentSymbol(int div) {
        return String.valueOf(Util.nibbleToHex(this.instruments[div] >> 4)) + Util.nibbleToHex(this.instruments[div]);
    }

    private String getEffectSymbol(int div, int n) {
        return String.valueOf(Util.nibbleToHex(this.effects[div][n])) + Util.nibbleToHex(this.effectArg1[div][n]) + Util.nibbleToHex(this.effectArg2[div][n]);
    }
}

