/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.player;

import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.module.Track;
import com.vwp.sound.mod.modplay.player.Mixer;
import com.vwp.sound.mod.modplay.player.PlayerException;
import com.vwp.sound.mod.modplay.player.TrackState;
import com.vwp.sound.mod.modplay.player.effect.GlobalEffects;

public class ModuleState {
    private Module module;
    private Mixer mixer;
    private GlobalEffects effects;
    private TrackState[] trackStates;
    private int bpm;
    private int position;
    private int division;
    private int tick;
    private int positionsInModule;
    private int divisionsInPattern;
    private int ticksInDivision;
    private int patternDelay;

    public ModuleState(Module module, Mixer mixer) {
        this.module = module;
        this.mixer = mixer;
        this.position = 0;
        this.division = 0;
        this.tick = 0;
        this.patternDelay = 0;
        this.effects = new GlobalEffects();
        this.bpm = module.getInitialBpm();
        this.ticksInDivision = module.getInitialSpeed();
        this.divisionsInPattern = module.getPatternAtPos(0).getDivisions();
        this.positionsInModule = module.getNumberOfPositions();
        this.trackStates = new TrackState[module.getPatternAtPos(0).getTrackCount()];
        int n = 0;
        while (n < this.trackStates.length) {
            this.trackStates[n] = new TrackState(this, module, mixer, n);
            ++n;
        }
        Instrument[] instruments = module.getInstruments();
        int n2 = 0;
        while (n2 < instruments.length) {
            if (instruments[n2] != null && instruments[n2].getNumberOfAutoEffects() > 0) {
                int m = 0;
                while (m < instruments[n2].getNumberOfAutoEffects()) {
                    instruments[n2].getAutoEffects()[m].setNumberOfTracks(this.trackStates.length);
                    ++m;
                }
            }
            ++n2;
        }
    }

    public boolean play() throws PlayerException {
        int arg2;
        int arg1;
        int effNum;
        int m;
        Track track;
        int n = 0;
        while (n < this.trackStates.length) {
            track = this.module.getPatternAtPos(this.position).getTrack(n);
            m = 0;
            while (m < track.getNumberOfEffects(this.division)) {
                effNum = track.getEffect(this.division, m);
                arg1 = track.getEffectArg1(this.division, m);
                arg2 = track.getEffectArg2(this.division, m);
                this.effects.preEffect(this, n, this.position, this.division, this.tick, effNum, arg1, arg2);
                ++m;
            }
            ++n;
        }
        n = 0;
        while (n < this.trackStates.length) {
            this.trackStates[n].preEffect(this.position, this.division, this.tick);
            ++n;
        }
        n = 0;
        while (n < this.trackStates.length) {
            this.trackStates[n].loadTick(this.position, this.division, this.tick);
            ++n;
        }
        n = 0;
        while (n < this.trackStates.length) {
            track = this.module.getPatternAtPos(this.position).getTrack(n);
            m = 0;
            while (m < track.getNumberOfEffects(this.division)) {
                effNum = track.getEffect(this.division, m);
                arg1 = track.getEffectArg1(this.division, m);
                arg2 = track.getEffectArg2(this.division, m);
                this.effects.doEffect(this, n, this.position, this.division, this.tick, effNum, arg1, arg2);
                ++m;
            }
            ++n;
        }
        n = 0;
        while (n < this.trackStates.length) {
            this.trackStates[n].doEffects(this.position, this.division, this.tick);
            ++n;
        }
        double time = this.getTickLength(this.ticksInDivision, this.bpm);
        int n2 = 0;
        while (n2 < this.trackStates.length) {
            this.trackStates[n2].setupMixer(this.position, this.division, this.tick, time);
            ++n2;
        }
        this.mixer.play(time);
        n2 = 0;
        while (n2 < this.trackStates.length) {
            this.trackStates[n2].postEffects(this.position, this.division, this.tick);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.trackStates.length) {
            Track track2 = this.module.getPatternAtPos(this.position).getTrack(n2);
            int m2 = 0;
            while (m2 < track2.getNumberOfEffects(this.division)) {
                int effNum2 = track2.getEffect(this.division, m2);
                int arg12 = track2.getEffectArg1(this.division, m2);
                int arg22 = track2.getEffectArg2(this.division, m2);
                this.effects.postEffect(this, n2, this.position, this.division, this.tick, effNum2, arg12, arg22);
                ++m2;
            }
            ++n2;
        }
        if (this.tick == this.ticksInDivision - 1 && this.patternDelay > 0) {
            --this.patternDelay;
            return true;
        }
        return this.nextTick();
    }

    private double getTickLength(int speed, int bpm) {
        double dpm = 24.0 * (double)bpm / (double)speed;
        double dps = dpm / 60.0;
        double tl = 1000.0 / (dps * (double)speed);
        return tl;
    }

    private boolean nextTick() {
        if (++this.tick % this.ticksInDivision == 0) {
            this.tick = 0;
            this.divisionsInPattern = this.module.getPatternAtPos(this.position).getDivisions();
            if (++this.division % this.divisionsInPattern == 0) {
                this.division = 0;
                if (++this.position % this.positionsInModule == 0) {
                    return false;
                }
            }
        }
        return true;
    }

    public Module getModule() {
        return this.module;
    }

    public Mixer getMixer() {
        return this.mixer;
    }

    public int getPosition() {
        return this.position;
    }

    public int getPatternsInModule() {
        return this.positionsInModule;
    }

    public int getDivisionsInPattern() {
        return this.divisionsInPattern;
    }

    public int getTicksInDivision() {
        return this.ticksInDivision;
    }

    public int getTick() {
        return this.tick;
    }

    public int getDivision() {
        return this.division;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setSpeed(int speed) {
        this.ticksInDivision = speed;
    }

    public void setBpm(int bpm) {
        this.bpm = bpm;
    }

    public void jump(int position, int division, int tick) {
        if (position < 0) {
            position = 0;
        }
        if (position >= this.positionsInModule) {
            position = this.positionsInModule - 1;
        }
        this.position = position;
        if (division < 0) {
            division = 0;
        }
        if (division >= this.divisionsInPattern) {
            division = this.divisionsInPattern - 1;
        }
        this.division = division;
        if (tick < 0) {
            tick = 0;
        }
        if (tick >= this.ticksInDivision) {
            tick = this.ticksInDivision - 1;
        }
        this.tick = tick;
    }

    public void setPatternDelay(int delay) {
        this.patternDelay = delay * this.ticksInDivision;
    }
}

