/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.player.autoeffect;

import com.vwp.sound.mod.modplay.player.TrackState;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoEffect;

public class Fadeout
implements AutoEffect {
    private boolean on = true;
    private double fadeout;
    private boolean[] active;
    private int[] count;

    public Fadeout(double fadeout) {
        this.fadeout = fadeout;
    }

    public void setNumberOfTracks(int tracks) {
        this.active = new boolean[tracks];
        this.count = new int[tracks];
    }

    public void doEffect(TrackState state, int track) {
        if (this.on && this.active[track]) {
            double d = 1.0 - (double)this.count[track] * this.fadeout;
            if (d < 0.0) {
                state.setFadeoutVolume(0.0);
            } else {
                state.setFadeoutVolume(d);
            }
            int n = track;
            this.count[n] = this.count[n] + 1;
        } else if (!this.on && this.active[track]) {
            state.setFadeoutVolume(0.0);
        }
    }

    public void keyOff(int track) {
        this.count[track] = 0;
        this.active[track] = true;
    }

    public void newNote(double note, int track) {
        if (note != -2.0) {
            this.active[track] = false;
        }
    }

    public void reset(int track) {
        this.active[track] = false;
        this.count[track] = 0;
    }

    public void activate() {
        this.on = true;
    }

    public void deActivate() {
        this.on = false;
    }
}

