/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.sound.output;

import com.vwp.sound.mod.sound.output.Output;
import com.vwp.sound.mod.sound.output.SoundDataFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WavOutput
implements Output {
    private int[] supportedRates = new int[]{44100};
    private int[] supportedBits = new int[]{16};
    private int[] supportedChannels = new int[]{2};
    public static final String RIFF_MAGIC = "RIFF";
    private int length = 0;
    public static final String WAVE_MAGIC = "WAVE";
    public static final String FORMAT_MAGIC = "fmt ";
    public static final int FORMAT_LENGTH = 16;
    public static final short MORE_MAGIC = 1;
    private short channels = (short)2;
    private int rate = 44100;
    private short bytes_per_sample = (short)4;
    private int bytes_per_sec = this.rate * this.bytes_per_sample;
    private short bits_per_sample = (short)(this.bytes_per_sample / 2 * 8);
    public static final String DATA_MAGIC = "data";
    private int data_length = 0;
    private RandomAccessFile out;
    private String filename;

    public WavOutput(String filename, SoundDataFormat format) throws IOException {
        if (!this.supports(format)) {
            throw new IOException("Format now supported: " + format.toString());
        }
        this.filename = filename;
    }

    public boolean supports(SoundDataFormat format) {
        boolean rateSupported = false;
        int rate = format.getRate();
        int n = 0;
        while (n < this.supportedRates.length) {
            if (this.supportedRates[n] == rate) {
                rateSupported = true;
            }
            ++n;
        }
        boolean bitsSupported = false;
        int bits = format.getBits();
        int n2 = 0;
        while (n2 < this.supportedBits.length) {
            if (this.supportedBits[n2] == bits) {
                bitsSupported = true;
            }
            ++n2;
        }
        boolean channelsSupported = false;
        int channels = format.getChannels();
        int n3 = 0;
        while (n3 < this.supportedChannels.length) {
            if (this.supportedChannels[n3] == channels) {
                channelsSupported = true;
            }
            ++n3;
        }
        return rateSupported && bitsSupported && channelsSupported;
    }

    public boolean isOpen() {
        return this.out != null;
    }

    public boolean open() {
        boolean res = true;
        try {
            this.out = new RandomAccessFile(this.filename, "rw");
            this.out.seek(0L);
            this.out.write(RIFF_MAGIC.getBytes());
            this.writeInt(this.length);
            this.out.write(WAVE_MAGIC.getBytes());
            this.out.write(FORMAT_MAGIC.getBytes());
            this.writeInt(16);
            this.writeShort((short)1);
            this.writeShort(this.channels);
            this.writeInt(this.rate);
            this.writeInt(this.bytes_per_sec);
            this.writeShort(this.bytes_per_sample);
            this.writeShort(this.bits_per_sample);
            this.out.write(DATA_MAGIC.getBytes());
            this.writeInt(this.data_length);
        }
        catch (IOException e) {
            e.printStackTrace();
            res = false;
        }
        return res;
    }

    private void writeInt(int val) throws IOException {
        this.out.write((val & 0xFF) >>> 0);
        this.out.write((val & 0xFF00) >>> 8);
        this.out.write((val & 0xFF0000) >>> 16);
        this.out.write((val & 0xFF000000) >>> 24);
    }

    private void writeShort(short val) throws IOException {
        this.out.write((val & 0xFF) >>> 0);
        this.out.write((val & 0xFF00) >>> 8);
    }

    public boolean close() {
        boolean res = true;
        try {
            this.out.seek(4L);
            int length = 36 + this.data_length;
            this.writeInt(length);
            this.out.seek(40L);
            this.writeInt(this.data_length);
            this.out.setLength(44 + this.data_length);
            this.out.close();
            this.out = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            res = false;
        }
        return res;
    }

    public int write(byte[] data, int ofs, int len) throws IOException {
        this.data_length += len;
        this.out.write(data, ofs, len);
        return data.length;
    }
}

