/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.cpu;

import jemu.core.Util;
import jemu.core.cpu.Processor;
import jemu.core.device.Register;
import jemu.core.device.cpcdos.CPCDos;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;

public class Z80
extends Processor {
    protected final int FCP = 4604752;
    protected int MEMPTR;
    protected static final byte[] Z80_TIME_PRE = new byte[]{4, 10, 7, 6, 4, 4, 7, 4, 4, 11, 7, 6, 4, 4, 7, 4, 8, 10, 7, 6, 4, 4, 7, 4, 12, 11, 7, 6, 4, 4, 7, 4, 7, 10, 16, 6, 4, 4, 7, 4, 7, 11, 16, 6, 4, 4, 7, 4, 7, 10, 13, 6, 11, 11, 10, 4, 7, 11, 13, 6, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 7, 7, 7, 7, 7, 7, 4, 7, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 5, 10, 10, 10, 10, 11, 8, 11, 5, 10, 10, 4, 10, 17, 8, 11, 5, 10, 10, 8, 10, 11, 8, 11, 5, 4, 10, 8, 10, 4, 8, 11, 5, 10, 10, 19, 10, 11, 8, 11, 5, 4, 10, 4, 10, 4, 8, 11, 5, 10, 10, 4, 10, 11, 8, 11, 5, 6, 10, 4, 10, 4, 8, 11};
    public static final byte[] Z80_TIME_PRE_ED = new byte[]{4, 4, 11, 16, 4, 10, 4, 5, 4, 4, 11, 16, 4, 10, 4, 5, 4, 4, 11, 16, 4, 10, 4, 5, 4, 4, 11, 16, 4, 10, 4, 5, 4, 4, 11, 16, 4, 10, 4, 14, 4, 4, 11, 16, 4, 10, 4, 14, 4, 4, 11, 16, 4, 10, 4, 4, 4, 4, 11, 16, 4, 10, 4, 4, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    protected static final int CYCLES_EXTRA_JRCC = 0;
    protected static final int CYCLES_EXTRA_DJNZ = 1;
    protected static final int CYCLES_EXTRA_CALLCC = 2;
    protected static final int CYCLES_EXTRA_RETCC = 3;
    protected static final int CYCLES_EXTRA_LDIR = 4;
    protected static final int CYCLES_EXTRA_CPIR = 5;
    protected static final int CYCLES_EXTRA_INIR = 6;
    protected static final int CYCLES_EXTRA_OTIR = 7;
    protected static final int CYCLES_EXTRA_IDXNORM = 8;
    protected static final int CYCLES_EXTRA_IDXLDIN = 9;
    protected static final int CYCLES_EXTRA_IDXCB = 10;
    protected static final int CYCLES_EXTRA_IM0 = 11;
    protected static final int CYCLES_EXTRA_IM1 = 12;
    protected static final int CYCLES_EXTRA_IM2 = 13;
    protected static final int CYCLES_EXTRA_INTACK = 14;
    protected static final byte[] Z80_TIME_EXTRA = new byte[]{5, 5, 7, 6, 5, 5, 5, 5, 8, 5, 4, 0, 0, 17, 2};
    public static final int B = 0;
    public static final int C = 1;
    public static final int D = 2;
    public static final int E = 3;
    public static final int H = 4;
    public static final int L = 5;
    public static final int F = 6;
    public static final int A = 7;
    public static final int B1 = 8;
    public static final int C1 = 9;
    public static final int D1 = 10;
    public static final int E1 = 11;
    public static final int H1 = 12;
    public static final int L1 = 13;
    public static final int F1 = 14;
    public static final int A1 = 15;
    public static final int BC = 0;
    public static final int DE = 2;
    public static final int HL = 4;
    public static final int AF = 6;
    public static final int FS = 128;
    public static final int FZ = 64;
    public static final int F5 = 32;
    public static final int FH = 16;
    public static final int F3 = 8;
    public static final int FPV = 4;
    public static final int FN = 2;
    public static final int FC = 1;
    protected static final int FLAG_MASK_LDI = 193;
    protected static final int FLAG_MASK_LDD = 233;
    protected static final int FLAG_MASK_LDIR = 233;
    protected static final int FLAG_MASK_LDDR = 193;
    protected static final int FLAG_MASK_CPIR = 250;
    protected static final int FLAG_MASK_CPL = 197;
    protected static final int FLAG_MASK_CCF = 197;
    protected static final int FLAG_MASK_SCF = 197;
    protected static final int FLAG_MASK_ADDHL = 196;
    protected static final int FLAG_MASK_RLCA = 196;
    protected static final int FLAG_MASK_RLD = 1;
    protected static final int FLAG_MASK_BIT = 1;
    protected static final int FLAG_MASK_IN = 1;
    protected static final int FLAG_MASK_INI = 232;
    protected int[] reg = new int[16];
    protected int SP;
    protected int PC;
    protected int IX;
    protected int IY;
    protected int I;
    protected int R;
    protected int R7;
    protected int IM;
    protected boolean IFF1;
    protected boolean IFF2;
    protected boolean noWait = false;
    protected boolean inHalt = false;
    protected boolean interruptExecute = false;
    protected int interruptVector = 255;
    protected byte[] timePre = new byte[256];
    protected byte[] timePost = new byte[256];
    protected byte[] timePreCB = new byte[256];
    protected byte[] timePostCB = new byte[256];
    protected byte[] timePreED = new byte[128];
    protected byte[] timePostED = new byte[128];
    protected byte[] timeExtra = new byte[2];
    protected static int[] PARITY = new int[256];
    CPCDos cpcdos;
    public boolean CPCDOS = false;
    protected boolean checkintafter;
    protected static final int[] CC_MASK;
    protected static final int[] CC_TEST;
    protected static final Register[] REGISTERS;

    public Z80(long cyclesPerSecond) {
        super("Zilog Z80", cyclesPerSecond);
        this.setTimes();
    }

    protected void setTimes() {
        int i;
        byte[] zeros = new byte[256];
        byte[] timesCB = new byte[256];
        for (i = 0; i < 256; ++i) {
            timesCB[i] = (i & 7) != 6 ? 4 : ((i & 0xC0) == 64 ? 8 : 11);
        }
        this.setTimes(Z80_TIME_PRE, zeros, timesCB, zeros, Z80_TIME_PRE_ED, new byte[80], Z80_TIME_EXTRA);
        this.timePost[219] = 3;
        this.timePost[211] = 3;
        for (i = 0; i < 64; i += 8) {
            this.timePostED[64 + i] = 4;
            this.timePostED[65 + i] = 4;
        }
    }

    protected void setTimes(byte[] pre, byte[] post, byte[] preCB, byte[] postCB, byte[] preED, byte[] postED, byte[] extra) {
        int i;
        this.timePre = Z80.checkByteArraySize(pre, 256);
        this.timePost = Z80.checkByteArraySize(post, 256);
        this.timePreCB = Z80.checkByteArraySize(preCB, 256);
        this.timePostCB = Z80.checkByteArraySize(postCB, 256);
        Z80.checkByteArraySize(preED, 80);
        Z80.checkByteArraySize(postED, 80);
        this.timePreED = new byte[256];
        this.timePostED = new byte[256];
        for (i = 0; i < 256; ++i) {
            this.timePreED[i] = this.timePre[0];
            this.timePostED[i] = this.timePost[0];
        }
        System.arraycopy(preED, 0, this.timePreED, 64, 64);
        System.arraycopy(postED, 0, this.timePostED, 64, 64);
        for (i = 0; i < 4; ++i) {
            System.arraycopy(preED, 64 + i * 4, this.timePreED, 160 + i * 8, 4);
            System.arraycopy(postED, 64 + i * 4, this.timePostED, 160 + i * 8, 4);
        }
        this.timeExtra = Z80.checkByteArraySize(extra, 15);
    }

    protected static byte[] checkByteArraySize(byte[] value, int length) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len != length) {
            throw new RuntimeException("Invalid Length for byte array: " + len + ". Should be " + length);
        }
        return value;
    }

    @Override
    public void reset() {
        super.reset();
        this.CPCDOS = Settings.getBoolean("cpc_dos", false);
        if (this.CPCDOS && this.cpcdos == null) {
            this.cpcdos = new CPCDos(this);
        }
        for (int i = 0; i < this.reg.length; ++i) {
            this.reg[i] = 0;
        }
        this.IY = 0;
        this.IX = 0;
        this.PC = 0;
        this.SP = 0;
        this.MEMPTR = 0;
        this.IM = 0;
        this.R7 = 0;
        this.R = 0;
        this.I = 0;
        this.IFF2 = false;
        this.IFF1 = false;
        this.interruptPending = 0;
        this.noWait = false;
        this.inHalt = false;
        this.interruptExecute = false;
    }

    @Override
    public void stepOver() {
        int opcode = this.memory.readByte(this.PC);
        switch (opcode) {
            case 118: {
                this.runTo(this.PC + 1 & 0xFFFF);
                break;
            }
            case 237: {
                this.stepOverED();
                break;
            }
            case 196: 
            case 204: 
            case 205: 
            case 212: 
            case 220: 
            case 228: 
            case 244: 
            case 252: {
                this.runTo(this.PC + 3 & 0xFFFF);
                break;
            }
            default: {
                this.step();
            }
        }
    }

    protected void stepOverED() {
        int opcode = this.memory.readByte(this.PC + 1 & 0xFFFF);
        switch (opcode) {
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 184: 
            case 185: 
            case 186: 
            case 187: {
                this.runTo(this.PC + 2 & 0xFFFF);
                break;
            }
            default: {
                this.step();
            }
        }
    }

    @Override
    public final void step() {
        if (this.interruptExecute) {
            this.doInterrupt();
        } else if (this.inHalt) {
            this.step(0);
        } else {
            this.step(this.fetchOpCode());
        }
    }

    protected final void step(int opcode) {
        this.checkintafter = true;
        this.noWait = false;
        this.executeNormal(opcode);
        this.interruptExecute = this.interruptPending != 0 && this.checkintafter && this.IFF1;
    }

    protected void executeNormal(int opcode) {
        this.cycle(this.timePre[opcode]);
        ++this.R;
        switch (opcode) {
            case 0: {
                this.nop();
                break;
            }
            case 1: 
            case 17: 
            case 33: 
            case 49: {
                this.ldddnn(opcode, this.fetchWord());
                break;
            }
            case 2: {
                this.ldbca();
                break;
            }
            case 3: 
            case 19: 
            case 35: 
            case 51: {
                this.incss(opcode);
                break;
            }
            case 4: 
            case 12: 
            case 20: 
            case 28: 
            case 36: 
            case 44: 
            case 60: {
                this.incr(opcode);
                break;
            }
            case 5: 
            case 13: 
            case 21: 
            case 29: 
            case 37: 
            case 45: 
            case 61: {
                this.decr(opcode);
                break;
            }
            case 6: 
            case 14: 
            case 22: 
            case 30: 
            case 38: 
            case 46: 
            case 62: {
                this.ldrn(opcode, this.fetch());
                break;
            }
            case 7: {
                this.rlca();
                break;
            }
            case 8: {
                this.exafaf1();
                break;
            }
            case 9: 
            case 25: 
            case 41: 
            case 57: {
                this.addhlss(opcode);
                break;
            }
            case 10: {
                this.ldabc();
                break;
            }
            case 11: 
            case 27: 
            case 43: 
            case 59: {
                this.decss(opcode);
                break;
            }
            case 15: {
                this.rrca();
                break;
            }
            case 16: {
                this.djnze((byte)this.fetch());
                break;
            }
            case 18: {
                this.lddea();
                break;
            }
            case 23: {
                this.rla();
                break;
            }
            case 24: {
                this.jre((byte)this.fetch());
                break;
            }
            case 26: {
                this.ldade();
                break;
            }
            case 31: {
                this.rra();
                break;
            }
            case 32: {
                this.jrnze((byte)this.fetch());
                break;
            }
            case 34: {
                this.ldxxhl(this.fetchWord());
                break;
            }
            case 39: {
                this.daa();
                break;
            }
            case 40: {
                this.jrze((byte)this.fetch());
                break;
            }
            case 42: {
                this.ldhlxx(this.fetchWord());
                break;
            }
            case 47: {
                this.cpl();
                break;
            }
            case 48: {
                this.jrnce((byte)this.fetch());
                break;
            }
            case 50: {
                this.ldxxa(this.fetchWord());
                break;
            }
            case 52: {
                this.incchl();
                break;
            }
            case 53: {
                this.decchl();
                break;
            }
            case 54: {
                this.ldhln(this.fetch());
                break;
            }
            case 55: {
                this.scf();
                break;
            }
            case 56: {
                this.jrce((byte)this.fetch());
                break;
            }
            case 58: {
                this.ldaxx(this.fetchWord());
                break;
            }
            case 63: {
                this.ccf();
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 127: {
                this.ldrr(opcode);
                break;
            }
            case 70: 
            case 78: 
            case 86: 
            case 94: 
            case 102: 
            case 110: 
            case 126: {
                this.ldrhl(opcode);
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: {
                this.ldhlr(opcode);
                break;
            }
            case 118: {
                this.halt();
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 135: {
                this.addar(opcode);
                break;
            }
            case 134: {
                this.addahl();
                break;
            }
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: {
                this.adcar(opcode);
                break;
            }
            case 142: {
                this.adcahl();
                break;
            }
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 151: {
                this.subar(opcode);
                break;
            }
            case 150: {
                this.subahl();
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 159: {
                this.sbcar(opcode);
                break;
            }
            case 158: {
                this.sbcahl();
                break;
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 167: {
                this.andar(opcode);
                break;
            }
            case 166: {
                this.andahl();
                break;
            }
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 175: {
                this.xorar(opcode);
                break;
            }
            case 174: {
                this.xorahl();
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 183: {
                this.orar(opcode);
                break;
            }
            case 182: {
                this.orahl();
                break;
            }
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 191: {
                this.cpar(opcode);
                break;
            }
            case 190: {
                this.cpahl();
                break;
            }
            case 192: 
            case 200: 
            case 208: 
            case 216: 
            case 224: 
            case 232: 
            case 240: 
            case 248: {
                this.retcc(opcode);
                break;
            }
            case 193: 
            case 209: 
            case 225: 
            case 241: {
                this.popqq(opcode);
                break;
            }
            case 194: 
            case 202: 
            case 210: 
            case 218: 
            case 226: 
            case 234: 
            case 242: 
            case 250: {
                this.jpccnn(opcode, this.fetchWord());
                break;
            }
            case 195: {
                this.jpnn(this.fetchWord());
                break;
            }
            case 196: 
            case 204: 
            case 212: 
            case 220: 
            case 228: 
            case 236: 
            case 244: 
            case 252: {
                this.callccnn(opcode, this.fetchWord());
                break;
            }
            case 197: 
            case 213: 
            case 229: 
            case 245: {
                this.pushqq(opcode);
                break;
            }
            case 198: {
                this.addan(this.fetch());
                break;
            }
            case 199: 
            case 207: 
            case 215: 
            case 223: 
            case 231: 
            case 239: 
            case 247: 
            case 255: {
                this.rstp(opcode);
                break;
            }
            case 201: {
                this.ret();
                break;
            }
            case 203: {
                this.executeCB(this.fetch(), false);
                break;
            }
            case 205: {
                this.callnn(this.fetchWord());
                break;
            }
            case 206: {
                this.adcan(this.fetch());
                break;
            }
            case 211: {
                this.outna(this.fetch());
                break;
            }
            case 214: {
                this.suban(this.fetch());
                break;
            }
            case 217: {
                this.exx();
                break;
            }
            case 219: {
                this.inan(this.fetch());
                break;
            }
            case 221: {
                this.IX = this.executeDDFD(this.IX, this.fetch());
                break;
            }
            case 222: {
                this.sbcan(this.fetch());
                break;
            }
            case 227: {
                this.exsphl();
                break;
            }
            case 230: {
                this.andan(this.fetch());
                break;
            }
            case 233: {
                this.jphl();
                break;
            }
            case 235: {
                this.exdehl();
                break;
            }
            case 237: {
                this.executeED(this.fetch());
                break;
            }
            case 238: {
                this.xoran(this.fetch());
                break;
            }
            case 243: {
                this.di();
                break;
            }
            case 246: {
                this.oran(this.fetch());
                break;
            }
            case 249: {
                this.ldsphl();
                break;
            }
            case 251: {
                this.ei();
                break;
            }
            case 253: {
                this.IY = this.executeDDFD(this.IY, this.fetch());
                break;
            }
            case 254: {
                this.cpan(this.fetch());
                break;
            }
            default: {
                throw new RuntimeException("Invalid Opcode: " + Util.hex((byte)opcode));
            }
        }
        this.cycle(this.timePost[opcode]);
    }

    protected void executeCB(int opcode, boolean ixiy) {
        this.cycle(this.timePreCB[opcode]);
        ++this.R;
        int result = -1;
        switch (ixiy ? opcode & 0xF8 | 6 : opcode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                this.rlcr(opcode);
                break;
            }
            case 6: {
                result = this.rlchl();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                this.rrcr(opcode);
                break;
            }
            case 14: {
                result = this.rrchl();
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                this.rlr(opcode);
                break;
            }
            case 22: {
                result = this.rlhl();
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                this.rrr(opcode);
                break;
            }
            case 30: {
                result = this.rrhl();
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: {
                this.slar(opcode);
                break;
            }
            case 38: {
                result = this.slahl();
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: {
                this.srar(opcode);
                break;
            }
            case 46: {
                result = this.srahl();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: {
                this.sllr(opcode);
                break;
            }
            case 54: {
                result = this.sllhl();
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: {
                this.srlr(opcode);
                break;
            }
            case 62: {
                result = this.srlhl();
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 127: {
                this.bitbr(opcode);
                break;
            }
            case 70: 
            case 78: 
            case 86: 
            case 94: 
            case 102: 
            case 110: 
            case 118: 
            case 126: {
                this.bitbhl(opcode);
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 191: {
                this.resbr(opcode);
                break;
            }
            case 134: 
            case 142: 
            case 150: 
            case 158: 
            case 166: 
            case 174: 
            case 182: 
            case 190: {
                result = this.resbhl(opcode);
                break;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 255: {
                this.setbr(opcode);
                break;
            }
            case 198: 
            case 206: 
            case 214: 
            case 222: 
            case 230: 
            case 238: 
            case 246: 
            case 254: {
                result = this.setbhl(opcode);
                break;
            }
            default: {
                throw new RuntimeException("Invalid Opcode: CB " + opcode);
            }
        }
        if (ixiy && (opcode & 7) != 6 && (opcode & 0xC0) != 64) {
            int r = opcode & 7;
            this.reg[r] = result;
        }
        this.cycle(this.timePostCB[opcode]);
    }

    protected void executeED(int opcode) {
        this.cycle(this.timePreED[opcode]);
        ++this.R;
        switch (opcode) {
            case 64: 
            case 72: 
            case 80: 
            case 88: 
            case 96: 
            case 104: 
            case 120: {
                this.inrc(opcode);
                break;
            }
            case 65: 
            case 73: 
            case 81: 
            case 89: 
            case 97: 
            case 105: 
            case 121: {
                this.outcr(opcode);
                break;
            }
            case 66: 
            case 82: 
            case 98: 
            case 114: {
                this.sbchlss(opcode);
                break;
            }
            case 67: 
            case 83: 
            case 99: 
            case 115: {
                this.ldxxdd(opcode, this.fetchWord());
                break;
            }
            case 68: 
            case 76: 
            case 84: 
            case 92: 
            case 100: 
            case 108: 
            case 116: 
            case 124: {
                this.neg();
                break;
            }
            case 69: 
            case 85: 
            case 101: 
            case 117: {
                this.retn();
                break;
            }
            case 70: 
            case 78: 
            case 102: 
            case 110: {
                this.imn(0);
                break;
            }
            case 71: {
                this.ldia();
                break;
            }
            case 74: 
            case 90: 
            case 106: 
            case 122: {
                this.adchlss(opcode);
                break;
            }
            case 75: 
            case 91: 
            case 107: 
            case 123: {
                this.ldddxx(opcode, this.fetchWord());
                break;
            }
            case 77: 
            case 93: 
            case 109: 
            case 125: {
                this.reti();
                break;
            }
            case 79: {
                this.ldra();
                break;
            }
            case 86: 
            case 118: {
                this.imn(1);
                break;
            }
            case 87: {
                this.ldai();
                break;
            }
            case 94: 
            case 126: {
                this.imn(2);
                break;
            }
            case 95: {
                this.ldar();
                break;
            }
            case 103: {
                this.rrd();
                break;
            }
            case 111: {
                this.rld();
                break;
            }
            case 112: {
                this.inc();
                break;
            }
            case 113: {
                this.outc0();
                break;
            }
            case 160: {
                this.ldi();
                break;
            }
            case 161: {
                this.cpi();
                break;
            }
            case 162: {
                this.ini();
                break;
            }
            case 163: {
                this.outi();
                break;
            }
            case 168: {
                this.ldd();
                break;
            }
            case 169: {
                this.cpd();
                break;
            }
            case 170: {
                this.ind();
                break;
            }
            case 171: {
                this.outd();
                break;
            }
            case 176: {
                this.ldir();
                break;
            }
            case 177: {
                this.cpir();
                break;
            }
            case 178: {
                this.inir();
                break;
            }
            case 179: {
                this.otir();
                break;
            }
            case 184: {
                this.lddr();
                break;
            }
            case 185: {
                this.cpdr();
                break;
            }
            case 186: {
                this.indr();
                break;
            }
            case 187: {
                this.otdr();
                break;
            }
            case 252: {
                if (CPC.loadtap) {
                    GateArray.cpc.loadblock();
                    break;
                }
                this.nop();
                break;
            }
            case 255: {
                this.executeEDFF();
            }
            default: {
                this.nop();
            }
        }
        this.cycle(this.timePostED[opcode]);
    }

    protected int getEDFFSpecialInstruction() {
        int pos = this.PC;
        int lsb = this.readByte(pos);
        pos = pos + 1 & 0xFFFF;
        lsb |= this.readByte(pos) << 8;
        pos = pos + 1 & 0xFFFF;
        return lsb |= this.readByte(pos) << 16;
    }

    protected void executeEDFF() {
        int command = this.getEDFFSpecialInstruction();
        switch (command) {
            case 4604752: {
                if (this.CPCDOS && this.cpcdos != null) {
                    this.cpcdos.execute();
                    this.PC = this.PC + 3 & 0xFFFF;
                    break;
                }
                this.nop();
                break;
            }
            default: {
                this.nop();
            }
        }
    }

    protected int executeDDFD(int ixiy, int opcode) {
        switch (opcode) {
            case 9: 
            case 25: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 57: 
            case 68: 
            case 69: 
            case 76: 
            case 77: 
            case 84: 
            case 85: 
            case 92: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 111: 
            case 124: 
            case 125: 
            case 132: 
            case 133: 
            case 140: 
            case 141: 
            case 148: 
            case 149: 
            case 156: 
            case 157: 
            case 164: 
            case 165: 
            case 172: 
            case 173: 
            case 180: 
            case 181: 
            case 188: 
            case 189: 
            case 225: 
            case 227: 
            case 229: 
            case 233: 
            case 249: {
                ixiy = this.swapDDFD(ixiy, opcode);
                break;
            }
            case 52: 
            case 53: 
            case 70: 
            case 78: 
            case 86: 
            case 94: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 119: 
            case 126: 
            case 134: 
            case 142: 
            case 150: 
            case 158: 
            case 166: 
            case 174: 
            case 182: 
            case 190: {
                this.indexDDFD(ixiy, opcode, 8);
                break;
            }
            case 54: {
                this.indexDDFD(ixiy, opcode, 9);
                break;
            }
            case 203: {
                this.indexDDFDCB(ixiy, 10);
                break;
            }
            case 102: 
            case 110: {
                this.ldrixiyd(ixiy, opcode);
                break;
            }
            case 116: {
                this.cycle();
            }
            case 117: {
                this.ldixiydr(ixiy, opcode);
                break;
            }
            default: {
                this.executeNormal(opcode);
            }
        }
        return ixiy;
    }

    protected int swapDDFD(int ixiy, int opcode) {
        int hl = this.getqq(4);
        this.setqq(4, ixiy);
        this.executeNormal(opcode);
        ixiy = this.getqq(4);
        this.setqq(4, hl);
        return ixiy;
    }

    protected void indexDDFD(int ixiy, int opcode, int extra) {
        this.cycle(this.timeExtra[extra]);
        int hl = this.getqq(4);
        this.MEMPTR = ixiy + (byte)this.fetch() & 0xFFFF;
        this.setqq(4, this.MEMPTR);
        this.executeNormal(opcode);
        this.setqq(4, hl);
    }

    protected void indexDDFDCB(int ixiy, int extra) {
        this.cycle(this.timeExtra[extra]);
        int hl = this.getqq(4);
        this.MEMPTR = ixiy + (byte)this.fetch() & 0xFFFF;
        this.setqq(4, this.MEMPTR);
        this.executeCB(this.fetchOpCode(), true);
        this.setqq(4, hl);
    }

    protected void ldrixiyd(int ixiy, int opcode) {
        this.cycle(this.timePre[opcode] + this.timeExtra[8]);
        ++this.R;
        int r = (opcode & 0x38) >> 3;
        this.MEMPTR = ixiy + (byte)this.fetch() & 0xFFFF;
        this.reg[r] = this.readByte(this.MEMPTR);
        this.cycle(this.timePost[opcode]);
    }

    protected void ldixiydr(int ixiy, int opcode) {
        this.cycle(this.timePre[opcode] + this.timeExtra[8]);
        ++this.R;
        int r = opcode & 7;
        this.MEMPTR = ixiy + (byte)this.fetch() & 0xFFFF;
        this.writeByte(this.MEMPTR, this.reg[r]);
        this.cycle(this.timePost[opcode]);
    }

    protected void stopHalt() {
        if (this.inHalt) {
            this.inHalt = false;
            this.PC = this.PC + 1 & 0xFFFF;
        }
    }

    public void nmi() {
        this.IFF1 = false;
        this.stopHalt();
        this.cycle(this.timePre[205]);
        this.callnn(102);
        this.cycle(this.timePost[205]);
    }

    protected void doInterrupt() {
        this.interruptExecute = false;
        this.stopHalt();
        if (!this.noWait) {
            this.cycle(this.timeExtra[14]);
        }
        if (this.interruptDevice != null) {
            this.interruptDevice.setInterrupt(1);
        }
        this.interruptNotify();
        this.IFF2 = false;
        this.IFF1 = false;
        switch (this.IM) {
            case 0: {
                this.cycle(this.timeExtra[11]);
                this.step(this.interruptVector);
                break;
            }
            case 1: {
                this.cycle(this.timeExtra[12]);
                this.step(255);
                break;
            }
            case 2: {
                this.cycle(this.timeExtra[13]);
                this.push(this.PC);
                this.MEMPTR = this.PC = this.readWord(this.I << 8 | this.interruptVector);
            }
        }
    }

    protected void interruptNotify() {
    }

    protected int fetchWord() {
        int lsb = this.fetch();
        return lsb | this.fetch() << 8;
    }

    protected int fetch() {
        int result = this.readByte(this.PC);
        this.PC = this.PC + 1 & 0xFFFF;
        return result;
    }

    protected int fetchOpCode() {
        int result = this.readByte(this.PC);
        this.PC = this.PC + 1 & 0xFFFF;
        return result;
    }

    protected void ldrr(int opcode) {
        int r = (opcode & 0x38) >> 3;
        int r1 = opcode & 7;
        this.reg[r] = this.reg[r1];
    }

    protected void ldrn(int opcode, int n) {
        int r = (opcode & 0x38) >> 3;
        this.reg[r] = n;
    }

    protected void ldrhl(int opcode) {
        int r = (opcode & 0x38) >> 3;
        this.reg[r] = this.readByte(this.getqq(4));
    }

    protected void ldhlr(int opcode) {
        int r = opcode & 7;
        this.writeByte(this.getqq(4), this.reg[r]);
    }

    protected void ldhln(int n) {
        this.writeByte(this.getqq(4), n);
    }

    protected void ldabc() {
        int addr = this.getqq(0);
        this.reg[7] = this.readByte(addr);
        this.MEMPTR = addr + 1;
    }

    protected void ldade() {
        int addr = this.getqq(2);
        this.reg[7] = this.readByte(addr);
        this.MEMPTR = addr + 1;
    }

    protected void ldaxx(int xx) {
        this.reg[7] = this.readByte(xx);
        this.MEMPTR = xx + 1;
    }

    protected void ldbca() {
        int addr = this.getqq(0);
        int a = this.reg[7];
        this.writeByte(addr, a);
        this.MEMPTR = addr + 1 & 0xFF | a << 8;
    }

    protected void lddea() {
        int addr = this.getqq(2);
        int a = this.reg[7];
        this.writeByte(addr, a);
        this.MEMPTR = addr + 1 & 0xFF | a << 8;
    }

    protected void ldxxa(int xx) {
        int a = this.reg[7];
        this.writeByte(xx, a);
        this.MEMPTR = xx + 1 & 0xFF | a << 8;
    }

    protected void ldai() {
        this.ldair(this.I);
    }

    protected void ldar() {
        this.ldair(this.R & 0x7F | this.R7);
    }

    protected void ldia() {
        this.I = this.reg[7];
        this.noWait = true;
    }

    protected void ldra() {
        this.R = this.reg[7];
        this.R7 = this.reg[7] & 0x80;
        this.noWait = true;
    }

    protected void ldddnn(int opcode, int nn) {
        int dd = (opcode & 0x30) >> 3;
        this.setdd(dd, nn);
    }

    protected void ldhlxx(int xx) {
        this.setqq(4, this.readWord(xx));
        this.MEMPTR = xx + 1;
    }

    protected void ldddxx(int opcode, int xx) {
        int dd = (opcode & 0x30) >> 3;
        this.setdd(dd, this.readWord(xx));
        this.MEMPTR = xx + 1;
    }

    protected void ldxxhl(int xx) {
        this.writeWord(xx, this.getdd(4));
        this.MEMPTR = xx + 1;
    }

    protected void ldxxdd(int opcode, int xx) {
        int dd = (opcode & 0x30) >> 3;
        this.writeWord(xx, this.getdd(dd));
        this.MEMPTR = xx + 1;
    }

    protected void ldsphl() {
        this.SP = this.getqq(4);
    }

    protected void pushqq(int opcode) {
        int qq = (opcode & 0x30) >> 3;
        this.push(this.getqq(qq));
    }

    protected void popqq(int opcode) {
        int qq = (opcode & 0x30) >> 3;
        this.setqq(qq, this.pop());
    }

    protected void exdehl() {
        int temp = this.reg[2];
        this.reg[2] = this.reg[4];
        this.reg[4] = temp;
        temp = this.reg[3];
        this.reg[3] = this.reg[5];
        this.reg[5] = temp;
    }

    protected void exafaf1() {
        int temp = this.reg[7];
        this.reg[7] = this.reg[15];
        this.reg[15] = temp;
        temp = this.reg[6];
        this.reg[6] = this.reg[14];
        this.reg[14] = temp;
    }

    protected void exx() {
        for (int i = 0; i <= 5; ++i) {
            int temp = this.reg[i];
            this.reg[i] = this.reg[i + 8];
            this.reg[i + 8] = temp;
        }
    }

    protected void exsphl() {
        int data = this.readWord(this.SP);
        this.writeWord(this.SP, this.getqq(4));
        this.MEMPTR = data;
        this.setqq(4, this.MEMPTR);
        this.noWait = true;
    }

    protected void ldi() {
        this.noWait = true;
        int de = this.getqq(2);
        int hl = this.getqq(4);
        int n = this.readByte(hl++);
        this.writeByte(de++, n);
        this.endldi(de, hl, n);
    }

    protected void ldir() {
        this.ldi();
        if ((this.reg[6] & 4) != 0) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.MEMPTR = this.PC + 1;
            this.cycle(this.timeExtra[4]);
        }
        this.noWait = true;
    }

    protected void ldd() {
        this.noWait = true;
        int de = this.getqq(2);
        int hl = this.getqq(4);
        int n = this.readByte(hl--);
        this.writeByte(de--, n);
        this.endldi(de, hl, n);
    }

    protected void lddr() {
        this.ldd();
        if ((this.reg[6] & 4) != 0) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.MEMPTR = this.PC + 1;
            this.cycle(this.timeExtra[4]);
        }
        this.noWait = true;
    }

    protected void cpi() {
        this.cpid(1);
    }

    protected void cpir() {
        this.cpid(1);
        if ((this.reg[6] & 0x44) == 4) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.MEMPTR = this.PC + 1;
            this.cycle(this.timeExtra[5]);
            this.noWait = true;
        }
    }

    protected void cpd() {
        this.cpid(-1);
    }

    protected void cpdr() {
        this.cpid(-1);
        if ((this.reg[6] & 0x44) == 4) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.MEMPTR = this.PC + 1;
            this.cycle(this.timeExtra[5]);
            this.noWait = true;
        }
    }

    protected void addar(int opcode) {
        int r = opcode & 7;
        this.addan(this.reg[r], 0);
    }

    protected void addan(int n) {
        this.addan(n, 0);
    }

    protected void addahl() {
        this.addan(this.readByte(this.getqq(4)), 0);
    }

    protected void adcar(int opcode) {
        int r = opcode & 7;
        this.addan(this.reg[r], this.reg[6] & 1);
    }

    protected void adcan(int n) {
        this.addan(n, this.reg[6] & 1);
    }

    protected void adcahl() {
        this.addan(this.readByte(this.getqq(4)), this.reg[6] & 1);
    }

    protected void subar(int opcode) {
        int r = opcode & 7;
        this.suba(this.reg[r], 0);
    }

    protected void suban(int n) {
        this.suba(n, 0);
    }

    protected void subahl() {
        this.suba(this.readByte(this.getqq(4)), 0);
    }

    protected void sbcar(int opcode) {
        int r = opcode & 7;
        this.suba(this.reg[r], this.reg[6] & 1);
    }

    protected void sbcan(int n) {
        this.suba(n, this.reg[6] & 1);
    }

    protected void sbcahl() {
        this.suba(this.readByte(this.getqq(4)), this.reg[6] & 1);
    }

    protected void andar(int opcode) {
        int r = opcode & 7;
        this.andan(this.reg[r]);
    }

    protected void andan(int n) {
        int a = this.reg[7] = this.reg[7] & n;
        int f = a & 0xA8 | 0x10 | PARITY[a];
        this.reg[6] = a == 0 ? f | 0x40 : f;
    }

    protected void andahl() {
        this.andan(this.readByte(this.getqq(4)));
    }

    protected void orar(int opcode) {
        int r = opcode & 7;
        this.oran(this.reg[r]);
    }

    protected void oran(int n) {
        int a = this.reg[7] = this.reg[7] | n;
        int f = a & 0xA8 | PARITY[a];
        this.reg[6] = a == 0 ? f | 0x40 : f;
    }

    protected void orahl() {
        this.oran(this.readByte(this.getqq(4)));
    }

    protected void xorar(int opcode) {
        int r = opcode & 7;
        this.xoran(this.reg[r]);
    }

    protected void xoran(int n) {
        int a = this.reg[7] = this.reg[7] ^ n;
        int f = a & 0xA8 | PARITY[a];
        this.reg[6] = a == 0 ? f | 0x40 : f;
    }

    protected void xorahl() {
        this.xoran(this.readByte(this.getqq(4)));
    }

    protected void cpar(int opcode) {
        int r = opcode & 7;
        this.cpan(this.reg[r]);
    }

    protected void cpan(int n) {
        int a = this.reg[7];
        int result = a - n;
        int f = result & 0x80 | 2 | n & 0x28;
        if (result < 0) {
            f |= 1;
        }
        if (((a ^ n) & 0x80) != 0 && (((result &= 0xFF) ^ a) & 0x80) != 0) {
            f |= 4;
        }
        if ((a & 0xF) - (n & 0xF) < 0) {
            f |= 0x10;
        }
        this.reg[6] = result == 0 ? f | 0x40 : f;
    }

    protected void cpin(int n) {
        int a = this.reg[7];
        int result = a - n;
        int f = result & 0x80 | 2;
        if (result < 0) {
            f |= 1;
        }
        if (((a ^ n) & 0x80) != 0 && (((result &= 0xFF) ^ a) & 0x80) != 0) {
            f |= 4;
        }
        if ((a & 0xF) - (n & 0xF) < 0) {
            f |= 0x10;
        }
        this.reg[6] = result == 0 ? f | 0x40 : f;
        this.reg[6] = this.reg[6] | ((result -= this.reg[6] >> 4 & 1) & 2) << 4;
        this.reg[6] = this.reg[6] | result & 8;
    }

    protected void cpahl() {
        this.cpan(this.readByte(this.getqq(4)));
    }

    protected void incr(int opcode) {
        int r = (opcode & 0x38) >> 3;
        this.reg[r] = this.incn(this.reg[r]);
    }

    protected void incchl() {
        int hl = this.getqq(4);
        this.writeByte(hl, this.incn(this.readByte(hl)));
    }

    protected void decr(int opcode) {
        int r = (opcode & 0x38) >> 3;
        this.reg[r] = this.decn(this.reg[r]);
    }

    protected void decchl() {
        int hl = this.getqq(4);
        this.writeByte(hl, this.decn(this.readByte(hl)));
    }

    protected void daa() {
        int add;
        int a = this.reg[7];
        int f = this.reg[6];
        int lsn = a & 0xF;
        int n = add = lsn > 9 || (f & 0x10) != 0 ? 6 : 0;
        if ((f & 1) != 0 || a > 153) {
            f |= 1;
            add |= 0x60;
        }
        if ((f & 2) != 0) {
            this.suba(add, 0);
        } else {
            this.addan(add, 0);
        }
        this.reg[6] = this.reg[6] & 0xFFFFFFFA | f & 1 | PARITY[this.reg[7]];
    }

    protected void cpl() {
        int a = this.reg[7] = ~this.reg[7] & 0xFF;
        this.reg[6] = this.reg[6] & 0xC5 | a & 0x28 | 0x10 | 2;
    }

    protected void neg() {
        int a = this.reg[7];
        this.reg[7] = 0;
        this.suba(a, 0);
    }

    protected void ccf() {
        int f = this.reg[6];
        this.reg[6] = f & 0xC5 ^ 1 | this.reg[7] & 0x28 | ((f & 1) == 0 ? 0 : 16);
    }

    protected void scf() {
        this.reg[6] = this.reg[6] & 0xC5 | this.reg[7] & 0x28 | 1;
    }

    protected void nop() {
    }

    public void haltstop() {
        this.inHalt = true;
    }

    protected void halt() {
        this.inHalt = true;
        this.PC = this.PC - 1 & 0xFFFF;
    }

    public void di() {
        this.IFF2 = false;
        this.IFF1 = false;
    }

    public void ei() {
        this.checkintafter = false;
        this.IFF2 = true;
        this.IFF1 = true;
    }

    protected void imn(int n) {
        this.IM = n;
    }

    protected void addhlss(int opcode) {
        int ss = (opcode & 0x30) >> 3;
        int hl = this.getqq(4);
        this.MEMPTR = hl + 1;
        int n = this.getdd(ss);
        int result = hl + n;
        int f = this.reg[6] & 0xC4 | result >> 8 & 0x28;
        if ((result & 0x10000) != 0) {
            f |= 1;
        }
        if ((hl & 0xFFF) + (n & 0xFFF) > 4095) {
            f |= 0x10;
        }
        this.setqq(4, result);
        this.reg[6] = f;
    }

    protected void adchlss(int opcode) {
        int ss = (opcode & 0x30) >> 3;
        int hl = this.getqq(4);
        this.MEMPTR = hl + 1;
        int n = this.getdd(ss);
        int c = this.reg[6] & 1;
        int result = hl + n + c;
        int f = result >> 8 & 0xA8;
        if ((result & 0x10000) != 0) {
            f |= 1;
        }
        if ((hl & 0xFFF) + (n & 0xFFF) + c > 4095) {
            f |= 0x10;
        }
        if (((hl ^ n) & 0x8000) == 0 && ((result ^ hl) & 0x8000) != 0) {
            f |= 4;
        }
        this.setqq(4, result &= 0xFFFF);
        this.reg[6] = result == 0 ? f | 0x40 : f;
    }

    protected void sbchlss(int opcode) {
        int ss = (opcode & 0x30) >> 3;
        int hl = this.getqq(4);
        this.MEMPTR = hl + 1;
        int n = this.getdd(ss);
        int c = this.reg[6] & 1;
        int result = hl - n - c;
        int f = result >> 8 & 0xA8 | 2;
        if (result < 0) {
            f |= 1;
        }
        if ((hl & 0xFFF) - (n & 0xFFF) - c < 0) {
            f |= 0x10;
        }
        if (((hl ^ n) & 0x8000) != 0 && ((result ^ hl) & 0x8000) != 0) {
            f |= 4;
        }
        this.setqq(4, result &= 0xFFFF);
        this.reg[6] = result == 0 ? f | 0x40 : f;
    }

    protected void incss(int opcode) {
        int ss = (opcode & 0x30) >> 3;
        this.setdd(ss, this.getdd(ss) + 1 & 0xFFFF);
    }

    protected void decss(int opcode) {
        int ss = (opcode & 0x30) >> 3;
        this.setdd(ss, this.getdd(ss) - 1 & 0xFFFF);
    }

    protected void rlca() {
        int a = this.reg[7];
        int c = (a & 0x80) == 0 ? 0 : 1;
        this.reg[7] = a = (a << 1 | c) & 0xFF;
        this.reg[6] = this.reg[6] & 0xC4 | a & 0x28 | c;
    }

    protected void rla() {
        int a = this.reg[7];
        int f = this.reg[6];
        a = a << 1 | f & 1;
        f = f & 0xC4 | a & 0x28;
        this.reg[7] = a & 0xFF;
        this.reg[6] = (a & 0x100) != 0 ? f | 1 : f;
    }

    protected void rrca() {
        int a = this.reg[7];
        int c = a & 1;
        this.reg[7] = a = (a >> 1 | c << 7) & 0xFF;
        this.reg[6] = this.reg[6] & 0xC4 | a & 0x28 | c;
    }

    protected void rra() {
        int a = this.reg[7];
        int f = this.reg[6];
        int c = a & 1;
        this.reg[7] = a = ((f & 1) == 0 ? a >> 1 : a >> 1 | 0x80) & 0xFF;
        this.reg[6] = this.reg[6] & 0xC4 | a & 0x28 | c;
    }

    protected void rlcr(int opcode) {
        int r = opcode & 7;
        this.reg[r] = this.rlcn(this.reg[r]);
    }

    protected int rlchl() {
        int hl = this.getqq(4);
        return this.writeByte(hl, this.rlcn(this.readByte(hl)));
    }

    protected void rlr(int opcode) {
        int r = opcode & 7;
        this.reg[r] = this.rln(this.reg[r]);
    }

    protected int rlhl() {
        int hl = this.getqq(4);
        return this.writeByte(hl, this.rln(this.readByte(hl)));
    }

    protected void rrcr(int opcode) {
        int r = opcode & 7;
        this.reg[r] = this.rrcn(this.reg[r]);
    }

    protected int rrchl() {
        int hl = this.getqq(4);
        return this.writeByte(hl, this.rrcn(this.readByte(hl)));
    }

    protected void rrr(int opcode) {
        int r = opcode & 7;
        this.reg[r] = this.rrn(this.reg[r]);
    }

    protected int rrhl() {
        int hl = this.getqq(4);
        return this.writeByte(hl, this.rrn(this.readByte(hl)));
    }

    protected void slar(int opcode) {
        int r = opcode & 7;
        this.reg[r] = this.slan(this.reg[r]);
    }

    protected int slahl() {
        int hl = this.getqq(4);
        return this.writeByte(hl, this.slan(this.readByte(hl)));
    }

    protected void sllr(int opcode) {
        int r = opcode & 7;
        this.reg[r] = this.slln(this.reg[r]);
    }

    protected int sllhl() {
        int hl = this.getqq(4);
        return this.writeByte(hl, this.slln(this.readByte(hl)));
    }

    protected void srar(int opcode) {
        int r = opcode & 7;
        this.reg[r] = this.sran(this.reg[r]);
    }

    protected int srahl() {
        int hl = this.getqq(4);
        return this.writeByte(hl, this.sran(this.readByte(hl)));
    }

    protected void srlr(int opcode) {
        int r = opcode & 7;
        this.reg[r] = this.srln(this.reg[r]);
    }

    protected int srlhl() {
        int hl = this.getqq(4);
        return this.writeByte(hl, this.srln(this.readByte(hl)));
    }

    protected void rld() {
        int a = this.reg[7];
        int hl = this.getqq(4);
        this.MEMPTR = hl + 1;
        int b = this.readByte(hl);
        this.writeByte(hl, (b << 4 | a & 0xF) & 0xFF);
        this.reg[7] = a = a & 0xF0 | b >> 4 & 0xF;
        int f = this.reg[6] & 1 | a & 0xA8 | PARITY[a];
        this.reg[6] = a == 0 ? f | 0x40 : f;
    }

    protected void rrd() {
        int a = this.reg[7];
        int hl = this.getqq(4);
        this.MEMPTR = hl + 1;
        int b = this.readByte(hl);
        this.writeByte(hl, a << 4 & 0xF0 | b >> 4 & 0xF);
        this.reg[7] = a = a & 0xF0 | b & 0xF;
        int f = this.reg[6] & 1 | a & 0xA8 | PARITY[a];
        this.reg[6] = a == 0 ? f | 0x40 : f;
    }

    protected void bitbr(int opcode) {
        int r = opcode & 7;
        this.bitbn(this.reg[r], opcode);
    }

    protected void bitbhl(int opcode) {
        int hl = this.getqq(4);
        int b = (opcode & 0x38) >> 3;
        int n = this.readByte(hl) & 1 << b;
        int f = this.reg[6] & 1 | n & 0x80 | this.MEMPTR >> 8 & 0x28 | 0x10;
        this.reg[6] = n == 0 ? f | 0x44 : f;
    }

    protected void setbr(int opcode) {
        int r = opcode & 7;
        this.reg[r] = this.setbn(this.reg[r], opcode);
    }

    protected int setbhl(int opcode) {
        int hl = this.getqq(4);
        return this.writeByte(hl, this.setbn(this.readByte(hl), opcode));
    }

    protected void resbr(int opcode) {
        int r = opcode & 7;
        this.reg[r] = this.resbn(this.reg[r], opcode);
    }

    protected int resbhl(int opcode) {
        int hl = this.getqq(4);
        return this.writeByte(hl, this.resbn(this.readByte(hl), opcode));
    }

    protected void jpnn(int nn) {
        this.MEMPTR = this.PC = nn;
    }

    protected void jpccnn(int opcode, int nn) {
        int cc = (opcode & 0x38) >> 3;
        if ((this.reg[6] & CC_MASK[cc]) == CC_TEST[cc]) {
            this.MEMPTR = this.PC = nn;
        }
    }

    protected void jre(byte e) {
        this.MEMPTR = this.PC = this.PC + e & 0xFFFF;
    }

    protected void jrce(byte e) {
        if ((this.reg[6] & 1) != 0) {
            this.MEMPTR = this.PC = this.PC + e & 0xFFFF;
            this.cycle(this.timeExtra[0]);
        }
    }

    protected void jrnce(byte e) {
        if ((this.reg[6] & 1) == 0) {
            this.MEMPTR = this.PC = this.PC + e & 0xFFFF;
            this.cycle(this.timeExtra[0]);
        }
    }

    protected void jrze(byte e) {
        if ((this.reg[6] & 0x40) != 0) {
            this.MEMPTR = this.PC = this.PC + e & 0xFFFF;
            this.cycle(this.timeExtra[0]);
        }
    }

    protected void jrnze(byte e) {
        if ((this.reg[6] & 0x40) == 0) {
            this.MEMPTR = this.PC = this.PC + e & 0xFFFF;
            this.cycle(this.timeExtra[0]);
        }
    }

    protected void jphl() {
        this.PC = this.getqq(4);
    }

    protected void djnze(byte e) {
        this.reg[0] = this.reg[0] - 1 & 0xFF;
        int b = this.reg[0];
        if (b != 0) {
            this.MEMPTR = this.PC = this.PC + e & 0xFFFF;
            this.cycle(this.timeExtra[1]);
        }
    }

    protected void callnn(int nn) {
        this.push(this.PC);
        this.MEMPTR = this.PC = nn;
    }

    protected void callccnn(int opcode, int nn) {
        int cc = (opcode & 0x38) >> 3;
        if ((this.reg[6] & CC_MASK[cc]) == CC_TEST[cc]) {
            this.push(this.PC);
            this.PC = nn;
            this.cycle(this.timeExtra[2]);
        }
        this.MEMPTR = nn;
    }

    public void ret() {
        this.MEMPTR = this.PC = this.pop();
    }

    protected void retcc(int opcode) {
        int cc = (opcode & 0x38) >> 3;
        if ((this.reg[6] & CC_MASK[cc]) == CC_TEST[cc]) {
            this.MEMPTR = this.PC = this.pop();
            this.cycle(this.timeExtra[3]);
        }
    }

    protected void reti() {
        this.MEMPTR = this.PC = this.pop();
        this.IFF1 = this.IFF2;
    }

    protected void retn() {
        this.MEMPTR = this.PC = this.pop();
        this.IFF1 = this.IFF2;
    }

    protected void rstp(int opcode) {
        this.push(this.PC);
        this.MEMPTR = this.PC = opcode & 0x38;
    }

    protected void inan(int n) {
        int addr = this.reg[7] << 8 | n;
        this.reg[7] = this.in(addr);
        this.MEMPTR = addr + 1;
    }

    protected void inrc(int opcode) {
        int r = (opcode & 0x38) >> 3;
        int bc = this.getqq(0);
        int result = this.reg[r] = this.in(bc);
        int f = this.reg[6] & 1 | result & 0xA8 | PARITY[result];
        this.reg[6] = result == 0 ? f | 0x40 : f;
        this.MEMPTR = bc + 1;
    }

    protected void inc() {
        int bc = this.getqq(0);
        int result = this.in(bc);
        int f = this.reg[6] & 1 | result & 0xA8 | PARITY[result];
        this.reg[6] = result == 0 ? f | 0x40 : f;
        this.MEMPTR = bc + 1;
    }

    protected void ini() {
        this.inid(1);
    }

    protected void inir() {
        this.inid(1);
        if ((this.reg[6] & 0x40) == 0) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.cycle(this.timeExtra[6]);
        }
    }

    protected void ind() {
        this.inid(-1);
    }

    protected void indr() {
        this.inid(-1);
        if ((this.reg[6] & 0x40) == 0) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.cycle(this.timeExtra[6]);
        }
    }

    protected void outna(int n) {
        int a = this.reg[7];
        int a8 = a << 8;
        int addr = a8 | n;
        this.out(addr, a);
        this.MEMPTR = n + 1 & 0xFF | a8;
    }

    protected void outcr(int opcode) {
        int r = (opcode & 0x38) >> 3;
        int bc = this.getqq(0);
        this.out(bc, this.reg[r]);
        this.MEMPTR = bc + 1;
    }

    protected void outc0() {
        int bc = this.getqq(0);
        this.out(bc, 0);
        this.MEMPTR = bc + 1;
    }

    protected void outi() {
        this.outid(1);
    }

    protected void otir() {
        this.outid(1);
        if ((this.reg[6] & 0x40) == 0) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.cycle(this.timeExtra[7]);
        }
    }

    protected void outd() {
        this.outid(-1);
    }

    protected void otdr() {
        this.outid(-1);
        if ((this.reg[6] & 0x40) == 0) {
            this.PC = this.PC - 2 & 0xFFFF;
            this.cycle(this.timeExtra[7]);
        }
    }

    protected void endldi(int de, int hl, int n) {
        this.setqq(2, de & 0xFFFF);
        this.setqq(4, hl & 0xFFFF);
        int bc = this.getqq(0) - 1 & 0xFFFF;
        this.setqq(0, bc);
        int f = this.reg[6] & 0xC1 | (n += this.reg[7]) << 4 & 0x20 | n & 8;
        this.reg[6] = bc != 0 ? f | 4 : f;
    }

    protected void bitbn(int n, int opcode) {
        int b = (opcode & 0x38) >> 3;
        int f = this.reg[6] & 1 | n & 0x28 | 0x10;
        this.reg[6] = (n >> b & 1) != 0 ? (b == 7 ? f | 0x80 : f) : f | 0x44;
    }

    protected void cpid(int add) {
        int hl = this.getqq(4);
        int a = this.reg[7];
        int n = this.readByte(hl);
        int result = a - n & 0xFF;
        int f = this.reg[6] & 1 | result & 0x80 | 2;
        if (result == 0) {
            f |= 0x40;
        }
        if ((a & 0xF) - (n & 0xF) < 0) {
            f |= 0x10;
            --result;
        }
        hl = hl + add & 0xFFFF;
        this.setqq(4, hl);
        int bc = this.getqq(0) - 1 & 0xFFFF;
        this.setqq(0, bc);
        this.reg[6] = (bc != 0 ? f | 4 : f) | result << 4 & 0x20 | result & 8;
        this.MEMPTR += add;
    }

    protected void ldair(int a) {
        this.reg[7] = a;
        int f = a & 0xA8 | this.reg[6] & 1;
        if (this.IFF2) {
            f |= 4;
        }
        this.reg[6] = a == 0 ? f | 0x40 : f;
        this.noWait = true;
    }

    protected void addan(int n, int c) {
        int a = this.reg[7];
        int result = a + n + c;
        int f = result & 0xA8;
        if ((result & 0x100) != 0) {
            f |= 1;
        }
        this.reg[7] = result &= 0xFF;
        if (((a ^ n) & 0x80) == 0 && ((result ^ a) & 0x80) != 0) {
            f |= 4;
        }
        if ((a & 0xF) + (n & 0xF) + c > 15) {
            f |= 0x10;
        }
        this.reg[6] = result == 0 ? f | 0x40 : f;
    }

    protected void suba(int n, int c) {
        int a = this.reg[7];
        int result = a - n - c;
        int f = result & 0xA8 | 2;
        if (result < 0) {
            f |= 1;
        }
        this.reg[7] = result &= 0xFF;
        if (((a ^ n) & 0x80) != 0 && ((result ^ a) & 0x80) != 0) {
            f |= 4;
        }
        if ((a & 0xF) - (n & 0xF) - c < 0) {
            f |= 0x10;
        }
        this.reg[6] = result == 0 ? f | 0x40 : f;
    }

    protected int incn(int n) {
        n = n + 1 & 0xFF;
        int f = n & 0xA8 | this.reg[6] & 1;
        if ((n & 0xF) == 0) {
            f |= 0x10;
        }
        if (n == 128) {
            f |= 4;
        } else if (n == 0) {
            f |= 0x40;
        }
        this.reg[6] = f;
        return n;
    }

    protected int decn(int n) {
        n = n - 1 & 0xFF;
        int f = n & 0xA8 | this.reg[6] & 1 | 2;
        if ((n & 0xF) == 15) {
            f |= 0x10;
        }
        if (n == 127) {
            f |= 4;
        } else if (n == 0) {
            f |= 0x40;
        }
        this.reg[6] = f;
        return n;
    }

    protected int rlcn(int n) {
        int c = (n & 0x80) == 0 ? 0 : 1;
        n = (n << 1 | c) & 0xFF;
        int f = n & 0xA8 | c | PARITY[n];
        this.reg[6] = n == 0 ? f | 0x40 : f;
        return n;
    }

    protected int rln(int n) {
        int f = this.reg[6];
        n = n << 1 | f & 1;
        f = n & 0xA8;
        if ((n & 0x100) != 0) {
            f |= 1;
        }
        this.reg[6] = ((n &= 0xFF) == 0 ? f | 0x40 : f) | PARITY[n];
        return n;
    }

    protected int rrcn(int n) {
        int c = n & 1;
        n = (n >> 1 | c << 7) & 0xFF;
        int f = n & 0xA8 | c | PARITY[n];
        this.reg[6] = n == 0 ? f | 0x40 : f;
        return n;
    }

    protected int rrn(int n) {
        int f = this.reg[6];
        int c = n & 1;
        n = ((f & 1) == 0 ? n >> 1 : n >> 1 | 0x80) & 0xFF;
        f = n & 0xA8 | c | PARITY[n];
        this.reg[6] = n == 0 ? f | 0x40 : f;
        return n;
    }

    protected int slan(int n) {
        int f = (n <<= 1) & 0xA8;
        if ((n & 0x100) != 0) {
            f |= 1;
        }
        this.reg[6] = ((n &= 0xFF) == 0 ? f | 0x40 : f) | PARITY[n];
        return n;
    }

    protected int slln(int n) {
        n = n << 1 | 1;
        int f = n & 0xA8;
        if ((n & 0x100) != 0) {
            f |= 1;
        }
        this.reg[6] = ((n &= 0xFF) == 0 ? f | 0x40 : f) | PARITY[n];
        return n;
    }

    protected int sran(int n) {
        int c = n & 1;
        n = n >> 1 | n & 0x80;
        int f = n & 0xA8 | c | PARITY[n];
        this.reg[6] = n == 0 ? f | 0x40 : f;
        return n;
    }

    protected int srln(int n) {
        int c = n & 1;
        int f = (n >>= 1) & 0xA8 | c | PARITY[n];
        this.reg[6] = n == 0 ? f | 0x40 : f;
        return n;
    }

    protected int setbn(int n, int opcode) {
        int b = (opcode & 0x38) >> 3;
        return n | 1 << b;
    }

    protected int resbn(int n, int opcode) {
        int b = (opcode & 0x38) >> 3;
        return n & ~(1 << b);
    }

    protected void inid(int add) {
        int hl = this.getqq(4);
        int b = this.reg[0];
        int c = this.reg[1];
        int bc = b << 8 | c;
        int result = this.in(bc);
        this.writeByte(hl, result);
        this.setqq(4, hl + add & 0xFFFF);
        c = ((c + add & 0xFF) + result & 0x100) != 0 ? 17 : 0;
        this.reg[0] = b = this.decn(b);
        this.reg[6] = this.reg[6] & 0xE8 | c | PARITY[result] | (result & 0x80) >> 6;
        this.MEMPTR = bc + add;
    }

    protected void outid(int add) {
        int hl = this.getqq(4);
        int b = this.reg[0] = this.decn(this.reg[0]);
        int addr = b << 8 | this.reg[1];
        this.out(addr, this.readByte(hl));
        this.setqq(4, hl + add & 0xFFFF);
        this.MEMPTR = addr + add;
    }

    protected int getqq(int index) {
        return index == 6 ? this.reg[index] | this.reg[index + 1] << 8 : this.reg[index + 1] | this.reg[index] << 8;
    }

    protected void setqq(int index, int value) {
        if (index == 6) {
            this.reg[index] = value & 0xFF;
            this.reg[index + 1] = value >> 8 & 0xFF;
        } else {
            this.reg[index + 1] = value & 0xFF;
            this.reg[index] = value >> 8 & 0xFF;
        }
    }

    protected int getdd(int index) {
        return index == 6 ? this.SP : this.reg[index + 1] | this.reg[index] << 8;
    }

    protected void setdd(int index, int value) {
        if (index == 6) {
            this.SP = value & 0xFFFF;
        } else {
            this.reg[index + 1] = value & 0xFF;
            this.reg[index] = value >> 8 & 0xFF;
        }
    }

    protected int pop() {
        int result = this.readWord(this.SP);
        this.SP = this.SP + 2 & 0xFFFF;
        return result;
    }

    public void push(int data) {
        this.SP = this.SP - 2 & 0xFFFF;
        this.writeWord(this.SP, data);
    }

    @Override
    public Register[] getRegisters() {
        return REGISTERS;
    }

    @Override
    public int getRegisterValue(int index) {
        int result;
        switch (index) {
            case 0: {
                result = this.reg[6];
                break;
            }
            case 1: {
                result = this.getqq(6);
                break;
            }
            case 2: {
                result = this.reg[14] | this.reg[15] << 8;
                break;
            }
            case 3: {
                result = this.getqq(4);
                break;
            }
            case 4: {
                result = this.getqq(12);
                break;
            }
            case 5: {
                result = this.getqq(2);
                break;
            }
            case 6: {
                result = this.getqq(10);
                break;
            }
            case 7: {
                result = this.getqq(0);
                break;
            }
            case 8: {
                result = this.getqq(8);
                break;
            }
            case 9: {
                result = this.IX;
                break;
            }
            case 10: {
                result = this.SP;
                break;
            }
            case 11: {
                result = this.IY;
                break;
            }
            case 12: {
                result = this.I;
                break;
            }
            case 13: {
                result = this.PC;
                break;
            }
            case 14: {
                result = this.R & 0x7F | this.R7;
                break;
            }
            case 15: {
                result = this.MEMPTR;
                break;
            }
            case 16: {
                result = this.IM;
                break;
            }
            case 17: {
                result = this.IFF1 ? 1 : 0;
                break;
            }
            case 18: {
                result = this.IFF2 ? 1 : 0;
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }

    @Override
    public int getProgramCounter() {
        return this.PC;
    }

    @Override
    public int getStackPointer() {
        return this.SP;
    }

    public void setAF(int value) {
        this.setqq(6, value);
    }

    public void setB(int value) {
        this.setqq(0, value);
    }

    public void setBC(int value) {
        this.setqq(0, value);
    }

    public void setDE(int value) {
        this.setqq(2, value);
    }

    public void setHL(int value) {
        this.setqq(4, value);
    }

    public void setR(int value) {
        this.R = value & 0xFF;
        this.R7 = value & 0x80;
    }

    public void setI(int value) {
        this.I = value & 0xFF;
    }

    public void setIFF1(boolean value) {
        this.IFF1 = value;
    }

    public void setIFF2(boolean value) {
        this.IFF2 = value;
    }

    public int getIFF1() {
        if (this.IFF1) {
            return 1;
        }
        return 0;
    }

    public int getIFF2() {
        if (this.IFF2) {
            return 1;
        }
        return 0;
    }

    public void setIX(int value) {
        this.IX = value & 0xFFFF;
    }

    public void setIY(int value) {
        this.IY = value & 0xFFFF;
    }

    public void setSP(int value) {
        this.SP = value & 0xFFFF;
    }

    public void setPC(int value) {
        this.PC = value & 0xFFFF;
    }

    public int getMEMPTR() {
        return this.MEMPTR & 0xFFFF;
    }

    public void setIM(int value) {
        this.IM = value & 0xFF;
    }

    public int getIM() {
        return this.IM;
    }

    public void setF(int value) {
        this.setqq(6, value);
    }

    public void incHL() {
        this.setqq(4, this.getHL() + 1);
    }

    public void setAF1(int value) {
        this.reg[14] = value & 0xFF;
        this.reg[15] = value >> 8 & 0xFF;
    }

    public void setBC1(int value) {
        this.setqq(8, value);
    }

    public void setDE1(int value) {
        this.setqq(10, value);
    }

    public void setHL1(int value) {
        this.setqq(12, value);
    }

    public boolean isInHalt() {
        return this.inHalt;
    }

    public int getF() {
        return 6;
    }

    public int getA() {
        return 7;
    }

    public void setA(int value) {
        this.reg[7] = value;
    }

    public int getC() {
        return 1;
    }

    public int getB() {
        return 0;
    }

    public int getE() {
        return 3;
    }

    public int getD() {
        return 2;
    }

    public int getL() {
        return 5;
    }

    public int getH() {
        return 4;
    }

    public int getR() {
        return this.R & 0x7F | this.R7;
    }

    public int getI() {
        return this.I;
    }

    public int getPC() {
        return this.PC;
    }

    public int getAF() {
        return this.getqq(6);
    }

    public int getBC() {
        return this.getqq(0);
    }

    public int getDE() {
        return this.getqq(2);
    }

    public int getHL() {
        return this.getqq(4);
    }

    public int getIX() {
        return this.IX;
    }

    public int getIY() {
        return this.IY;
    }

    public int getSP() {
        return this.SP;
    }

    public int getAF1() {
        return this.reg[14] | this.reg[15] << 8;
    }

    public int getBC1() {
        return this.getqq(8);
    }

    public int getDE1() {
        return this.getqq(10);
    }

    public int getHL1() {
        return this.getqq(12);
    }

    @Override
    public String getState() {
        String result = "AF :" + Util.hex((short)this.getqq(6)) + " HL :" + Util.hex((short)this.getqq(4)) + " DE :" + Util.hex((short)this.getqq(2)) + " BC :" + Util.hex((short)this.getqq(0)) + " IX :" + Util.hex((short)this.IX) + " IY :" + Util.hex((short)this.IY) + "\nAF':" + Util.hex((byte)this.reg[15]) + Util.hex((byte)this.reg[14]) + " HL':" + Util.hex((short)this.getqq(12)) + " DE':" + Util.hex((short)this.getqq(10)) + " BC':" + Util.hex((short)this.getqq(8)) + " Cycles: " + Util.hex((int)this.cycles);
        return result;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int p;
            int n = p = (i & 1) == 0 ? 4 : 0;
            if ((i & 2) != 0) {
                p ^= 4;
            }
            if ((i & 4) != 0) {
                p ^= 4;
            }
            if ((i & 8) != 0) {
                p ^= 4;
            }
            if ((i & 0x10) != 0) {
                p ^= 4;
            }
            if ((i & 0x20) != 0) {
                p ^= 4;
            }
            if ((i & 0x40) != 0) {
                p ^= 4;
            }
            if ((i & 0x80) != 0) {
                p ^= 4;
            }
            Z80.PARITY[i] = p;
        }
        CC_MASK = new int[]{64, 64, 1, 1, 4, 4, 128, 128};
        CC_TEST = new int[]{0, 64, 0, 1, 0, 4, 0, 128};
        REGISTERS = new Register[]{new Register("Flags", 8, "SZ-H-VNC"), new Register("AF", 16), new Register("AF'", 16, 1), new Register("HL", 16), new Register("HL'", 16, 1), new Register("DE", 16), new Register("DE'", 16, 1), new Register("BC", 16), new Register("BC'", 16, 1), new Register("IX", 16), new Register("SP", 16, 1), new Register("IY", 16), new Register("I", 8, 1), new Register("PC", 16), new Register("R", 8, 1), new Register("MEMPTR", 16), new Register("IM", 8, 1), new Register("IFF1", 8), new Register("IFF2", 8, 1)};
    }
}

