/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device;

import java.applet.Applet;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Vector;
import java.util.jar.JarInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import jemu.core.Util;
import jemu.core.cpu.Processor;
import jemu.core.device.ComputerDescriptor;
import jemu.core.device.ComputerTimer;
import jemu.core.device.Device;
import jemu.core.device.FileDescriptor;
import jemu.core.device.floppy.Drive;
import jemu.core.device.memory.Memory;
import jemu.system.cpc.GateArray;
import jemu.ui.Display;
import jemu.ui.ScreenCapture;
import jemu.util.diss.Disassembler;

public abstract class Computer
extends Device
implements Runnable {
    protected boolean webstart = false;
    protected final String server = "http://yourdomain.com/";
    public byte[][] disks;
    public String[] disknames;
    protected int index = 0;
    public static final ComputerDescriptor[] COMPUTERS = new ComputerDescriptor[]{new ComputerDescriptor("CPC464T", "Amstrad/Schneider CPC 464", "jemu.system.cpc.CPC"), new ComputerDescriptor("CPC464", "Amstrad/Schneider CPC 464", "jemu.system.cpc.CPC"), new ComputerDescriptor("CPC664", "Amstrad/Schneider CPC 664", "jemu.system.cpc.CPC"), new ComputerDescriptor("CPC6128", "Amstrad/Schneider CPC 6128", "jemu.system.cpc.CPC"), new ComputerDescriptor("CPC464PARA", "Amstrad CPC 464 / ParaDos", "jemu.system.cpc.CPC"), new ComputerDescriptor("PARADOS", "Amstrad CPC 6128 / ParaDos", "jemu.system.cpc.CPC"), new ComputerDescriptor("ROMPACK", "CPC 6128 / ParaDos / RomPack", "jemu.system.cpc.CPC"), new ComputerDescriptor("ROMSYM", "CPC 6128 / SymbOS / RomPack", "jemu.system.cpc.CPC"), new ComputerDescriptor("ST128", "Amstrad CPC 6128 / ST 128", "jemu.system.cpc.CPC"), new ComputerDescriptor("ART", "Amstrad CPC 6128 / OCP Art Studio", "jemu.system.cpc.CPC"), new ComputerDescriptor("CPC6128fr", "CPC 6128 - French ROMs", "jemu.system.cpc.CPC"), new ComputerDescriptor("CPC6128es", "CPC 6128 - Spanish ROMs", "jemu.system.cpc.CPC"), new ComputerDescriptor("SYMBOS", "Symbiosis SymbOS", "jemu.system.cpc.CPC"), new ComputerDescriptor("FUTUREOS", "CPC 6128 / Future-OS", "jemu.system.cpc.CPC"), new ComputerDescriptor("KCCOMPACT", "KC compact", "jemu.system.cpc.CPC"), new ComputerDescriptor("COMCPC", "Surprise CPC", "jemu.system.cpc.CPC"), new ComputerDescriptor("CUSTOM", "CUSTOM", "jemu.system.cpc.CPC"), new ComputerDescriptor("PLUS", "PLUS", "jemu.system.cpc.CPC")};
    public int zipcount = 0;
    public static final String DEFAULT_COMPUTER = "CPC6128";
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_SNAPSHOT = 1;
    public static final int TYPE_DISC_IMAGE = 2;
    public static final int TYPE_TAPE_IMAGE = 3;
    public static final int STOP = 0;
    public static final int STEP = 1;
    public static final int STEP_OVER = 2;
    public static final int RUN = 3;
    public static final int MAX_FRAME_SKIP = 20;
    public static final int MAX_FILE_SIZE = 0x3200000;
    public static int FILE_SIZE = 0;
    protected Applet applet;
    protected Thread thread = new Thread(this);
    protected boolean stopped = false;
    protected int action = 0;
    protected boolean running = false;
    protected boolean waiting = false;
    protected long startTime;
    protected long startCycles;
    protected String romPath;
    protected String filePath;
    protected Vector files = null;
    protected Display display;
    protected int frameSkip = 0;
    protected int runTo = -1;
    protected int mode = 0;
    protected long maxResync = 200L;
    protected int currentDrive = 0;
    protected Vector devices = new Vector();
    protected Vector listeners = new Vector(1);
    protected static byte[] SKIP_BUFFER = new byte[1024];
    public int maystop = 0;

    public static Computer createComputer(Applet applet, String name) throws Exception {
        for (int index = 0; index < COMPUTERS.length; ++index) {
            if (!Computer.COMPUTERS[index].key.equalsIgnoreCase(name)) continue;
            Class cl = Util.findClass(null, Computer.COMPUTERS[index].className);
            Constructor con = cl.getConstructor(Applet.class, String.class);
            return (Computer)con.newInstance(applet, name);
        }
        throw new Exception("Computer " + name + " not found");
    }

    public Computer(Applet applet, String name) {
        super("Computer: " + name);
        this.applet = applet;
        this.name = name;
        this.thread.start();
    }

    public void repaintDisplay() {
        this.display.update(this.display.getGraphics());
    }

    protected void setBasePath(String path) {
        String jpath = "";
        try {
            jpath = this.getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String d = System.getProperty("file.separator");
        this.romPath = jpath + "system" + d + path + d + "rom" + d;
        this.filePath = jpath + "system" + d + path + d + "file" + d;
    }

    public String getPath() throws Exception {
        String p = System.getProperty("user.dir") + System.getProperty("file.separator");
        System.out.println("Path is:*" + p + "*");
        return p;
    }

    public void initialise() {
        this.reset();
    }

    public Device addDevice(Device device) {
        return this.addDevice(device, null);
    }

    public Device addDevice(Device device, String name) {
        if (name != null) {
            device.setName(name);
        }
        this.devices.addElement(device);
        return device;
    }

    public Vector getDevices() {
        return this.devices;
    }

    public final InputStream openFile(String name) {
        try {
            InflaterInputStream str;
            InputStream result = this.getStream(name);
            FILE_SIZE = result.available();
            if (name.toLowerCase().endsWith(".zip") || name.toLowerCase().endsWith(".dskz") || name.toLowerCase().endsWith(".cdtz") || name.toLowerCase().endsWith(".snaz")) {
                String foundEntry;
                this.index = 0;
                boolean err = false;
                FILE_SIZE = this.getZipSize(name);
                ZipInputStream str2 = new ZipInputStream(result);
                int total = 1;
                Thread.yield();
                while (!err) {
                    try {
                        String unused = str2.getNextEntry().getName();
                        ++total;
                    }
                    catch (Exception e) {
                        // empty catch block
                        break;
                    }
                }
                System.out.println("ZIP-Objects found: " + total);
                this.disks = new byte[total][];
                this.disknames = new String[total];
                str2.close();
                result = this.getStream(name);
                str2 = new ZipInputStream(result);
                while (!err) {
                    try {
                        String sname;
                        foundEntry = str2.getNextEntry().getName();
                        System.out.println(" entry found:" + foundEntry);
                        if (!foundEntry.toLowerCase().endsWith("rom") && !foundEntry.toLowerCase().endsWith("dsk") && !foundEntry.toLowerCase().endsWith("cdt") && !foundEntry.toLowerCase().endsWith("cdt") && !foundEntry.toLowerCase().endsWith("sna") && !foundEntry.toLowerCase().endsWith("tzx") && !foundEntry.toLowerCase().endsWith("csw") && !foundEntry.toLowerCase().endsWith("wav")) continue;
                        this.disks[this.index] = this.getEntry(str2);
                        this.disknames[this.index] = sname = foundEntry;
                        ++this.index;
                        if (this.index <= total) continue;
                        break;
                    }
                    catch (Exception ef) {
                        // empty catch block
                        break;
                    }
                }
                str2.close();
                err = false;
                result = this.getStream(name);
                str2 = new ZipInputStream(result);
                while (!err) {
                    try {
                        foundEntry = str2.getNextEntry().getName();
                        if (!foundEntry.toLowerCase().endsWith("rom") && !foundEntry.toLowerCase().endsWith("dsk") && !foundEntry.toLowerCase().endsWith("cdt") && !foundEntry.toLowerCase().endsWith("cdt") && !foundEntry.toLowerCase().endsWith("sna") && !foundEntry.toLowerCase().endsWith("tzx") && !foundEntry.toLowerCase().endsWith("csw") && !foundEntry.toLowerCase().endsWith("wav")) continue;
                        result = str2;
                        break;
                    }
                    catch (Exception r) {
                        // empty catch block
                        break;
                    }
                }
                if (this.getIndex() < 2) {
                    return result;
                }
                return null;
            }
            if (name.toLowerCase().endsWith(".jar")) {
                FILE_SIZE = this.getJarSize(name);
                str = new JarInputStream(result);
                str.getNextEntry();
                result = str;
            }
            if (name.toLowerCase().endsWith(".anz")) {
                FILE_SIZE = this.getZipSize(name);
                System.out.println("Opening compressed CPC movie file...");
                str = new ZipInputStream(result);
                ((ZipInputStream)str).getNextEntry();
                result = str;
            }
            if (name.toLowerCase().endsWith(".snz") || name.toLowerCase().endsWith(".taz") || name.toLowerCase().endsWith(".dsz") || name.toLowerCase().endsWith(".szk")) {
                System.out.println("Opening GZip compressed file...");
                FILE_SIZE = this.getGZipSize(name);
                str = new GZIPInputStream(result);
                result = str;
            }
            return result;
        }
        catch (Exception e) {
            System.out.println("*FATAL ERROR* File not found:" + name);
            return null;
        }
    }

    protected InputStream getStream(String name) throws Exception {
        InputStream result;
        if (this.webstart) {
            try {
                result = new FileInputStream(name);
            }
            catch (Exception e) {
                result = new URL("http://yourdomain.com/" + name).openStream();
            }
        } else {
            try {
                result = new URL(this.applet.getCodeBase(), name).openStream();
            }
            catch (Exception e) {
                result = new FileInputStream(name);
            }
        }
        return result;
    }

    public byte[] getEntry(InputStream input) {
        try {
            return this.getEntry(input, FILE_SIZE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected byte[] getEntry(InputStream input, int size) {
        byte[] buffer = new byte[size];
        int offs = 0;
        try {
            int read;
            while (input.available() > 0 && (read = input.read(buffer, offs, size)) != -1) {
                offs += read;
                size -= read;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (offs < buffer.length) {
            byte[] result = new byte[offs];
            System.arraycopy(buffer, 0, result, 0, offs);
            buffer = result;
            result = null;
        }
        System.gc();
        return buffer;
    }

    protected int readStream(InputStream stream, byte[] buffer, int offs, int size) throws Exception {
        return this.readStream(stream, buffer, offs, size, true);
    }

    protected int getZipSize(String name) {
        int zipsize = 0;
        try {
            InputStream in = this.getStream(name);
            ZipInputStream in2 = new ZipInputStream(in);
            while (in2.available() == 1) {
                zipsize = (int)((long)zipsize + (in2.getNextEntry().getSize() + 1L));
            }
            in2.close();
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("ZIPsize = " + zipsize);
        return zipsize;
    }

    protected int getJarSize(String name) {
        int zipsize = 0;
        try {
            InputStream in = this.getStream(name);
            JarInputStream in2 = new JarInputStream(in);
            while (in2.available() == 1) {
                zipsize = (int)((long)zipsize + in2.getNextEntry().getSize());
            }
            in2.close();
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("ZIPsize = " + zipsize);
        return zipsize;
    }

    protected int getGZipSize(String name) {
        int gzipsize = 0x3200000;
        return gzipsize;
    }

    protected int readStream(InputStream stream, byte[] buffer, int offs, int size, boolean error) throws Exception {
        while (size > 0) {
            int read = stream.read(buffer, offs, size);
            if (read == -1) {
                if (!error) break;
                throw new Exception("Unexpected end of stream");
            }
            offs += read;
            size -= read;
        }
        System.gc();
        return offs;
    }

    protected void skipStream(InputStream stream, int size) throws Exception {
        while (size > 0) {
            int bytes = size > 1024 ? 1024 : size;
            stream.read(SKIP_BUFFER, 0, bytes);
            size -= bytes;
        }
    }

    public byte[] getFile(String name) {
        return this.getFile(name, true);
    }

    public byte[] getRomFile(String name) {
        byte[] data = this.getFile(name, true);
        try {
            if (Computer.CheckAMSDOS(data)) {
                byte[] newdata = new byte[data.length - 128];
                System.arraycopy(data, 128, newdata, 0, newdata.length);
                data = newdata;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static int ChecksumAMSDOS(byte[] pHeader) {
        int Checksum = 0;
        for (int i = 0; i < 67; ++i) {
            int CheckSumByte = pHeader[i] & 0xFF;
            Checksum += CheckSumByte;
        }
        return Checksum;
    }

    public static boolean CheckAMSDOS(byte[] pHeader) {
        int CalculatedChecksum;
        try {
            CalculatedChecksum = Computer.ChecksumAMSDOS(pHeader);
        }
        catch (Exception e) {
            return false;
        }
        int ChecksumFromHeader = pHeader[67] & 0xFF | (pHeader[68] & 0xFF) << 8;
        return ChecksumFromHeader == CalculatedChecksum && ChecksumFromHeader != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getFile(String name, boolean crop) {
        int offs;
        byte[] buffer;
        block9: {
            buffer = null;
            offs = 0;
            int size = 0;
            try (InputStream stream = null;){
                int read;
                stream = this.openFile(name);
                buffer = new byte[size];
                if (stream == null) break block9;
                for (size = FILE_SIZE; size > 0; size -= read) {
                    read = stream.read(buffer, offs, size);
                    if (read == -1) {
                        break;
                    }
                    offs += read;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (crop && offs < buffer.length) {
            byte[] result = new byte[offs];
            System.arraycopy(buffer, 0, result, 0, offs);
            buffer = result;
            result = null;
        }
        System.gc();
        return buffer;
    }

    public void setDisplay(Display value) {
        this.display = value;
        this.displaySet();
    }

    public Display getDisplay() {
        return this.display;
    }

    protected void displaySet() {
    }

    public Disassembler getDisassembler() {
        return null;
    }

    public abstract Processor getProcessor();

    public abstract void formatDisk(int var1);

    public abstract Memory getMemory();

    public abstract void DSK2MFM();

    public abstract void refreshRoms(String var1);

    public void processKeyEvent(KeyEvent e) {
        if (this.mode == 3) {
            if (e.getID() == 401) {
                this.keyPressed(e);
            } else if (e.getID() == 402) {
                this.keyReleased(e);
            }
        }
    }

    public abstract void SNP_Save();

    public abstract void SNP_Stop();

    public abstract void recordKeys();

    public abstract void playKeys();

    public abstract void stopKeys();

    public abstract void loadEntry(int var1, int var2);

    public abstract void pressPlay();

    public abstract void pressRec();

    public abstract void restoreState();

    public abstract void storeState();

    public abstract void pressRew();

    public abstract void pressFwd();

    public abstract void pressStop();

    public abstract void pressPause();

    public abstract void mouseRight(boolean var1);

    public abstract void mouseLeft(boolean var1);

    public abstract void mouseDown(boolean var1);

    public abstract void mouseUp(boolean var1);

    public abstract String getCounter();

    public abstract void setInfo(String var1, boolean var2);

    public abstract void keyPressed(KeyEvent var1);

    public abstract void keyReleased(KeyEvent var1);

    public abstract void keyPressed(int var1);

    public abstract void keyReleased(int var1);

    public abstract void AtKey();

    public abstract void bootCPM();

    public abstract void typeCat();

    public abstract void typeRun();

    public abstract void bootDisk();

    public abstract void bootDiskb();

    public abstract void AutoType();

    public abstract void MouseFire1();

    public abstract void MouseFire2();

    public abstract void MouseReleaseFire1();

    public abstract void runDeathSword();

    public abstract void lightgunShot();

    public abstract void lightShot(int var1, int var2);

    public abstract void lightgunRelease();

    public abstract void MouseReleaseFire2();

    public abstract void tape_WAV_save();

    public abstract void CDT2WAV();

    public abstract void tapeEject();

    public abstract int getPPI_A();

    public abstract int getPPI_B();

    public abstract int getPPI_C();

    public abstract int getPPI_Control();

    public abstract byte[] getDSKImage(int var1);

    public abstract void SNA_Save(int var1);

    public abstract byte[] getDSKImage(int var1, int var2);

    public void loadFile(int type, String name) throws Exception {
    }

    public abstract Dimension getDisplaySize(boolean var1);

    public abstract void reSync();

    public void setLarge(boolean value) {
    }

    public Dimension getDisplayScale(boolean large) {
        return large ? Display.SCALE_2 : Display.SCALE_1;
    }

    public void start() {
        GateArray.cpc.isStarted = true;
        this.setAction(3, true);
    }

    public void stop() {
        GateArray.cpc.isStarted = false;
        this.setAction(0, true);
    }

    public void goOn() {
        GateArray.cpc.isStarted = true;
        this.setAction(3, false);
    }

    public void Hold() {
        GateArray.cpc.isStarted = false;
        this.setAction(0, false);
    }

    public void step() {
        GateArray.cpc.isStarted = false;
        this.setAction(1, true);
    }

    public void stepOver() {
        GateArray.cpc.isStarted = false;
        this.setAction(2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAction(int value, boolean info) {
        try {
            if (this.running && value != 3) {
                this.action = 0;
                if (info) {
                    System.out.println(this + " Stopping " + this.getProcessor());
                }
                this.getProcessor().stop();
                this.display.setPainted(true);
                this.maystop = 0;
                while (this.running) {
                    try {
                        if (info) {
                            System.out.println("stopping...");
                        }
                        if (this.maystop++ > 3) break;
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            Thread thread = this.thread;
            synchronized (thread) {
                this.action = value;
                this.thread.notify();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        this.stopped = true;
        this.stop();
        try {
            if (this.thread != Thread.currentThread()) {
                this.thread.join();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.thread = null;
        this.display = null;
        this.applet = null;
    }

    protected void emulate(int mode) {
        switch (mode) {
            case 1: {
                this.getProcessor().step();
                break;
            }
            case 2: {
                this.getProcessor().stepOver();
                break;
            }
            case 3: {
                if (this.runTo == -1) {
                    this.getProcessor().run();
                    break;
                }
                this.getProcessor().runTo(this.runTo);
            }
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.removeElement(listener);
    }

    protected void fireActionEvent() {
        ActionEvent e = new ActionEvent(this, 0, null);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ActionListener)this.listeners.elementAt(i)).actionPerformed(e);
        }
    }

    public String getROMPath() {
        return this.romPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRom(String name, int size) {
        byte[] buffer = new byte[size];
        int offs = 0;
        try (InputStream stream = null;){
            InputStream is;
            stream = is = this.getClass().getResourceAsStream(name);
            while (size > 0) {
                int read = stream.read(buffer, offs, size);
                if (read == -1) {
                    break;
                }
                offs += read;
                size -= read;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRom(String name) {
        byte[] buffer = null;
        int offs = 0;
        try (InputStream stream = null;){
            int read;
            int size;
            InputStream is;
            stream = is = this.getClass().getResourceAsStream(name);
            buffer = new byte[size];
            for (size = is.available(); size > 0; size -= read) {
                read = stream.read(buffer, offs, size);
                if (read == -1) {
                    break;
                }
                offs += read;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer;
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void reset() {
    }

    public void eject() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopped) {
            try {
                Thread thread;
                if (this.action == 0) {
                    thread = this.thread;
                    synchronized (thread) {
                        this.thread.wait();
                    }
                }
                if (this.action == 0) continue;
                try {
                    this.running = true;
                    thread = this.thread;
                    synchronized (thread) {
                        this.mode = this.action;
                        this.action = 0;
                    }
                    this.startCycles = this.getProcessor().getCycles();
                    this.startTime = System.currentTimeMillis();
                    this.emulate(this.mode);
                }
                finally {
                    this.running = false;
                    this.fireActionEvent();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFiles() {
        if (this.files == null) {
            this.files = new Vector();
            BufferedReader reader = null;
            try {
                String line;
                reader = new LineNumberReader(new InputStreamReader(this.openFile(this.filePath + "Files.txt")));
                while ((line = ((LineNumberReader)reader).readLine()) != null) {
                    int iDesc = line.indexOf(61);
                    if (iDesc == -1) continue;
                    String desc = line.substring(0, iDesc).trim();
                    int iName = line.indexOf(44, iDesc + 1);
                    if (iName == -1) {
                        iName = line.length();
                    }
                    String names = line.substring(iDesc + 1, iName).trim();
                    String instructions = iName < line.length() ? line.substring(iName + 1).trim().replace('|', '\n') : "";
                    this.files.addElement(new FileDescriptor(desc, names, instructions));
                }
            }
            catch (Exception e) {
                System.out.println("Cannot get file list for " + this);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.files;
    }

    public String getFileInfo(String fileName) {
        String result = null;
        this.getFiles();
        for (int i = 0; i < this.files.size(); ++i) {
            FileDescriptor file = (FileDescriptor)this.files.elementAt(i);
            if (!file.filename.equalsIgnoreCase(fileName)) continue;
            result = file.instructions;
            break;
        }
        return result;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void syncProcessor() {
        this.syncProcessor(null, ((this.getProcessor().getCycles() - this.startCycles) * 2000L / this.getProcessor().getCyclesPerSecond() + 1L) / 2L, 200L);
    }

    protected void syncProcessor(ComputerTimer timer) {
        this.syncProcessor(timer, timer.getUpdates(), timer.getDeviation());
    }

    protected void syncProcessor(ComputerTimer timer, long count, long deviation) {
        block14: {
            long time;
            this.startTime += count;
            this.startCycles = this.getProcessor().getCycles();
            long l = time = timer != null ? timer.getCount() : System.currentTimeMillis();
            if (time < this.startTime - deviation) {
                this.setFrameSkip(0);
                this.startTime = time;
            } else if (time > this.startTime) {
                if (this.frameSkip == 20) {
                    this.setFrameSkip(0);
                    if (timer != null) {
                        timer.resync();
                    }
                    this.startTime = timer != null ? timer.getCount() : System.currentTimeMillis();
                } else {
                    try {
                        if (!(Display.record || ScreenCapture.record || ScreenCapture.frameskip.isSelected())) {
                            this.setFrameSkip(this.frameSkip + 1);
                            break block14;
                        }
                        this.setFrameSkip(0);
                    }
                    catch (Exception noCap) {
                        this.setFrameSkip(this.frameSkip + 1);
                    }
                }
            } else {
                try {
                    this.setFrameSkip(0);
                    long start = System.currentTimeMillis();
                    while ((time = timer != null ? timer.getCount() : System.currentTimeMillis()) < this.startTime) {
                        if (timer != null && System.currentTimeMillis() - start > this.maxResync) {
                            timer.resync();
                            this.startTime = timer.getCount();
                            break;
                        }
                        Thread.sleep(1L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
    }

    public void setMaxResync(long value) {
        this.maxResync = value;
    }

    public void setFrameSkip(int value) {
        this.frameSkip = value;
    }

    public void displayLostFocus() {
    }

    public void updateDisplay(boolean wait) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setRunToAddress(int value) {
        this.runTo = value;
    }

    public void clearRunToAddress() {
        this.runTo = -1;
    }

    public int getMode() {
        return this.mode;
    }

    public Drive[] getFloppyDrives() {
        return null;
    }

    public int getCurrentDrive() {
        return this.currentDrive;
    }

    public void setCurrentDrive(int drive) {
        this.currentDrive = drive;
    }

    public int getIndex() {
        return this.index;
    }
}

