/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.filesystem;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jemu.core.device.filesystem.DskFile;
import jemu.core.device.filesystem.DskMaster;
import jemu.core.device.filesystem.DskSector;
import jemu.core.device.filesystem.DskSectorCatalog;
import jemu.core.device.filesystem.DskSectorCatalogs;
import jemu.core.device.filesystem.DskTrack;
import jemu.core.device.filesystem.DskType;
import jemu.core.device.filesystem.NewFreeCatResult;

public class DskManager {
    protected byte[] CPM22SYS = null;
    private static DskManager instance = null;
    DskFile dskFile;

    public static DskManager getInstance() {
        if (instance == null) {
            instance = new DskManager();
        }
        return instance;
    }

    public int getSectorSize() {
        DskSector sector = new DskSector(this.dskFile.master);
        return sector.getSectorSize();
    }

    private void initCPM() {
        this.CPM22SYS = this.getData("CPM22.SYS", 9216);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getData(String name, int size) {
        byte[] buffer = new byte[size];
        int offs = 0;
        try (InputStream stream = null;){
            InputStream is;
            stream = is = this.getClass().getResourceAsStream(name);
            while (size > 0) {
                int read = stream.read(buffer, offs, size);
                if (read == -1) {
                    break;
                }
                offs += read;
                size -= read;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer;
    }

    public DskFile newDsk(File currentDir, String dskName, DskType type) throws IOException {
        int[] sectorId_PARADOS80 = new int[]{145, 150, 146, 151, 147, 152, 148, 153, 149, 154};
        int[] sectorId_PARADOS41 = new int[]{129, 134, 130, 135, 131, 136, 132, 137, 133, 138};
        int[] sectorId_PARADOS40D = new int[]{161, 166, 162, 167, 163, 168, 164, 169, 165, 170};
        int[] sectorId_SS40 = new int[]{193, 198, 194, 199, 195, 200, 196, 201, 197};
        int[] sectorId_DOSD2 = new int[]{33, 38, 34, 39, 35, 40, 36, 41, 37};
        int[] sectorId_DOSD10 = new int[]{17, 22, 18, 23, 19, 24, 20, 25, 21, 26};
        int[] sectorId_DOSD20 = new int[]{49, 54, 50, 55, 51, 56, 52, 57, 53, 58};
        int[] sectorId_DOSD40 = new int[]{81, 86, 82, 87, 83, 88, 84, 89, 85, 90};
        int[] sectorId_SDOS = new int[]{113, 118, 114, 119, 115, 120, 116, 121, 117, 122};
        int[] sectorId_VORTEX = new int[]{1, 6, 2, 7, 3, 8, 4, 9, 5};
        int[] sectorId_SYSTEM = new int[]{65, 70, 66, 71, 67, 72, 68, 73, 69};
        int[] sectorId = null;
        this.dskFile = new DskFile(currentDir, dskName);
        ByteArrayInputStream baisCPM22SYS = null;
        if (null != type) {
            switch (type) {
                case PARADOS80: {
                    sectorId = sectorId_PARADOS80;
                    this.dskFile.nbTracks = 80;
                    this.dskFile.sizeOfTrack = 21;
                    break;
                }
                case PARADOS41: {
                    sectorId = sectorId_PARADOS41;
                    this.dskFile.nbTracks = 41;
                    this.dskFile.sizeOfTrack = 21;
                    break;
                }
                case PARADOS40D: {
                    sectorId = sectorId_PARADOS40D;
                    this.dskFile.nbSides = 2;
                    this.dskFile.sizeOfTrack = 21;
                    break;
                }
                case DOSD10: {
                    sectorId = sectorId_DOSD10;
                    this.dskFile.nbSides = 2;
                    this.dskFile.nbTracks = 80;
                    this.dskFile.sizeOfTrack = 21;
                    break;
                }
                case DOSD20: {
                    sectorId = sectorId_DOSD20;
                    this.dskFile.nbSides = 2;
                    this.dskFile.nbTracks = 80;
                    this.dskFile.sizeOfTrack = 21;
                    break;
                }
                case DOSD40: {
                    sectorId = sectorId_DOSD40;
                    this.dskFile.nbSides = 2;
                    this.dskFile.sizeOfTrack = 21;
                    break;
                }
                case SDOS: {
                    sectorId = sectorId_SDOS;
                    this.dskFile.nbTracks = 80;
                    this.dskFile.sizeOfTrack = 21;
                    break;
                }
                case DOSD2: {
                    sectorId = sectorId_DOSD2;
                    this.dskFile.nbSides = 2;
                    this.dskFile.nbTracks = 80;
                    break;
                }
                case VORTEX: {
                    sectorId = sectorId_VORTEX;
                    this.initCPM();
                    baisCPM22SYS = new ByteArrayInputStream(this.CPM22SYS);
                    this.dskFile.nbSides = 2;
                    this.dskFile.nbTracks = 80;
                    break;
                }
                case SS40: {
                    sectorId = sectorId_SS40;
                    break;
                }
                case SYSTEM: {
                    sectorId = sectorId_SYSTEM;
                    this.initCPM();
                    baisCPM22SYS = new ByteArrayInputStream(this.CPM22SYS);
                    break;
                }
            }
        }
        this.dskFile.master = new DskMaster();
        this.dskFile.master.type = type;
        FileOutputStream fos = new FileOutputStream(this.dskFile.file);
        this.dskFile.scan(fos);
        this.dskFile.master.allCatsId.clear();
        this.dskFile.master.allCatsSector.clear();
        this.dskFile.master.allSectors.clear();
        for (int i = 0; i < this.dskFile.nbTracks; ++i) {
            for (int s = 0; s < this.dskFile.nbSides; ++s) {
                int j;
                DskTrack dskTrack = new DskTrack(this.dskFile.master);
                if (type == DskType.DOSD2 || type == DskType.SYSTEM || type == DskType.VORTEX) {
                    dskTrack.gap = 82;
                } else if (type == DskType.PARADOS80 || type == DskType.PARADOS41 || type == DskType.PARADOS40D || type == DskType.DOSD10 || type == DskType.DOSD20 || type == DskType.DOSD40 || type == DskType.SDOS) {
                    dskTrack.gap = 16;
                    dskTrack.nbSectors = 10;
                }
                dskTrack.noTrack = i;
                dskTrack.side = s;
                this.dskFile.tracks.add(dskTrack);
                dskTrack.scan(fos);
                for (j = 0; j < dskTrack.nbSectors; ++j) {
                    DskSector sector = new DskSector(this.dskFile.master);
                    sector.trackC = i;
                    sector.sideH = s;
                    sector.sectorIdR = sectorId[j];
                    sector.scan(fos);
                    if (this.dskFile.master.catalogToCreate(sector.trackC, sector.sideH, sector.sectorIdR)) {
                        sector = new DskSectorCatalogs(sector);
                    }
                    dskTrack.sectors.add(sector);
                    this.dskFile.master.allSectors.add(sector);
                }
                for (j = 0; j < 232 - dskTrack.nbSectors * 8; ++j) {
                    fos.write(0);
                }
                for (j = 0; j < dskTrack.nbSectors; ++j) {
                    dskTrack.sectors.get((int)j).data = new byte[this.dskFile.master.sectorSizes[dskTrack.sectorSize]];
                    for (int k = 0; k < this.dskFile.master.sectorSizes[dskTrack.sectorSize]; ++k) {
                        dskTrack.sectors.get((int)j).data[k] = i < 2 && s == 0 && this.dskFile.master.type == DskType.SYSTEM ? (byte)baisCPM22SYS.read() : (i < 1 && this.dskFile.master.type == DskType.VORTEX ? (byte)baisCPM22SYS.read() : Integer.valueOf(dskTrack.fillerByte).byteValue());
                    }
                    dskTrack.sectors.get(j).scanData(fos);
                }
            }
        }
        if (baisCPM22SYS != null) {
            baisCPM22SYS.close();
        }
        fos.close();
        for (DskSectorCatalogs catalog : this.dskFile.master.buildCatalogs(this.dskFile.tracks)) {
            catalog.scanCatalogFromData();
        }
        return this.dskFile;
    }

    public DskFile loadDsk(File currentDir, String dskName) throws IOException {
        DskFile dskFile = new DskFile(currentDir, dskName);
        try {
            FileInputStream fis = new FileInputStream(dskFile.file);
            dskFile.scan(fis);
            dskFile.master.allCatsId.clear();
            dskFile.master.allCatsSector.clear();
            dskFile.master.allSectors.clear();
            for (int i = 0; i < dskFile.nbTracks; ++i) {
                for (int s = 0; s < dskFile.nbSides; ++s) {
                    DskTrack dskTrack = new DskTrack(dskFile.master);
                    dskFile.tracks.add(dskTrack);
                    dskTrack.scan(fis);
                    for (int j = 0; j < dskTrack.nbSectors; ++j) {
                        DskSector sector = new DskSector(dskFile.master);
                        sector.scan(fis);
                        if (i == 0 && s == 0 && j == 0) {
                            if ((sector.sectorIdR & 0xF0) == 144) {
                                dskFile.master.type = DskType.PARADOS80;
                            } else if ((sector.sectorIdR & 0xF0) == 128) {
                                dskFile.master.type = DskType.PARADOS41;
                            } else if ((sector.sectorIdR & 0xF0) == 160) {
                                dskFile.master.type = DskType.PARADOS40D;
                            } else if ((sector.sectorIdR & 0xF0) == 192 && dskFile.nbSides == 1) {
                                dskFile.master.type = DskType.SS40;
                            } else if ((sector.sectorIdR & 0xF0) == 32) {
                                dskFile.master.type = DskType.DOSD2;
                            } else if ((sector.sectorIdR & 0xF0) == 16) {
                                dskFile.master.type = DskType.DOSD10;
                            } else if ((sector.sectorIdR & 0xF0) == 48) {
                                dskFile.master.type = DskType.DOSD20;
                            } else if ((sector.sectorIdR & 0xF0) == 80) {
                                dskFile.master.type = DskType.DOSD40;
                            } else if ((sector.sectorIdR & 0xF0) == 112) {
                                dskFile.master.type = DskType.SDOS;
                            } else if ((sector.sectorIdR & 0xF0) == 0 && dskTrack.nbSectors == 9) {
                                dskFile.master.type = DskType.VORTEX;
                            } else if ((sector.sectorIdR & 0xF0) == 64 && dskFile.nbSides == 1) {
                                dskFile.master.type = DskType.SYSTEM;
                            }
                        }
                        if (dskFile.master.catalogToCreate(sector.trackC, sector.sideH, sector.sectorIdR)) {
                            sector = new DskSectorCatalogs(sector);
                        }
                        dskTrack.sectors.add(sector);
                        dskFile.master.allSectors.add(sector);
                    }
                    fis.skip(232 - dskTrack.nbSectors * 8);
                    for (DskSector sector : dskTrack.sectors) {
                        sector.scanData(fis);
                    }
                }
            }
            fis.close();
        }
        catch (IOException e) {
            return null;
        }
        for (DskSectorCatalogs catalog : dskFile.master.buildCatalogs(dskFile.tracks)) {
            catalog.scanCatalogFromData();
        }
        return dskFile;
    }

    public void addFile(DskFile dskFile, File currentDir, String fileName, Boolean generateAMSDOSHeader) throws IOException {
        File file = new File(currentDir, fileName);
        byte[] pHeader = new byte[]{};
        boolean skipHeader128 = false;
        if (generateAMSDOSHeader != null) {
            pHeader = new byte[128];
            FileInputStream fis = new FileInputStream(file);
            fis.read(pHeader);
            fis.close();
            DskMaster cfr_ignored_0 = dskFile.master;
            if (DskMaster.CheckAMSDOS(pHeader)) {
                pHeader = new byte[]{};
                if (!generateAMSDOSHeader.booleanValue()) {
                    skipHeader128 = true;
                }
            } else if (generateAMSDOSHeader.booleanValue()) {
                pHeader = dskFile.master.GenerateAMSDOSHeader(file.getName(), file.length());
            }
        }
        List<DskSectorCatalogs> catalogsC1C4 = dskFile.master.buildCatalogs(dskFile.tracks);
        DskType type = dskFile.master.type;
        HashMap<String, DskSectorCatalog> previousCats = new HashMap<String, DskSectorCatalog>();
        for (DskSectorCatalogs catalog : catalogsC1C4) {
            catalog.scanCatalog(previousCats);
        }
        previousCats.clear();
        long entryDataSize = 0L;
        if (null != type) {
            switch (type) {
                case VORTEX: {
                    entryDataSize = dskFile.master.sectorSizes[2] * 8;
                    break;
                }
                case PARADOS80: 
                case PARADOS40D: 
                case DOSD10: 
                case DOSD20: 
                case DOSD40: 
                case SDOS: 
                case DOSD2: {
                    entryDataSize = dskFile.master.sectorSizes[2] * 4;
                    break;
                }
                case PARADOS41: 
                case SS40: 
                case SYSTEM: {
                    entryDataSize = dskFile.master.sectorSizes[2] * 2;
                    break;
                }
            }
        }
        int nbEntry = (int)((file.length() + (long)pHeader.length) / entryDataSize);
        int lastEntry = (int)((file.length() + (long)pHeader.length) % entryDataSize);
        if (lastEntry > 0) {
            ++nbEntry;
        }
        ArrayList<DskSectorCatalog> catalogs = new ArrayList<DskSectorCatalog>();
        int countSectorIncrement = 0;
        int entriesSectorCount = 16;
        if (type == DskType.DOSD2 || type == DskType.DOSD10 || type == DskType.DOSD20 || type == DskType.DOSD40 || type == DskType.SDOS) {
            entriesSectorCount = 8;
        }
        block10: while (nbEntry > 0) {
            DskSectorCatalog cat = new DskSectorCatalog(dskFile.master);
            for (int j = 0; j < Math.min(nbEntry, entriesSectorCount); ++j) {
                NewFreeCatResult cats = dskFile.master.nextFreeCat();
                cat.catsId.add(cats.catId);
                cat.catsSector.addAll(cats.catSectors);
            }
            if ((type != DskType.PARADOS80 && type != DskType.PARADOS40D || cat.catsId.size() < 8) && type == DskType.VORTEX) {
                if (cat.catsId.size() >= 12) {
                    countSectorIncrement += 3;
                } else if (cat.catsId.size() >= 8) {
                    countSectorIncrement += 2;
                } else if (cat.catsId.size() >= 4) {
                    ++countSectorIncrement;
                }
            }
            cat.sectorIncrement = ++countSectorIncrement;
            ++countSectorIncrement;
            cat.filename = fileName.toUpperCase();
            catalogs.add(cat);
            if ((nbEntry -= entriesSectorCount) > 0) {
                cat.sectorLength = 128;
                continue;
            }
            if (nbEntry == 0) {
                cat.sectorLength = 128;
                continue;
            }
            if (null == type) {
                cat.sectorLength = Math.min(128, cat.catsId.size() * 128 / entriesSectorCount);
                continue;
            }
            switch (type) {
                case PARADOS80: 
                case PARADOS40D: {
                    cat.sectorLength = Math.min(128, cat.catsId.size() * 128 / (entriesSectorCount / 2));
                    if (cat.catsId.size() < 8) continue block10;
                    cat.sectorLength = Math.min(128, (cat.catsId.size() - 8) * 128 / (entriesSectorCount / 2));
                    continue block10;
                }
                case VORTEX: {
                    cat.sectorLength = Math.min(128, cat.catsId.size() * 128 / (entriesSectorCount / 4));
                    if (cat.catsId.size() >= 12) {
                        cat.sectorLength = Math.min(128, (cat.catsId.size() - 12) * 128 / (entriesSectorCount / 4));
                        continue block10;
                    }
                    if (cat.catsId.size() >= 8) {
                        cat.sectorLength = Math.min(128, (cat.catsId.size() - 8) * 128 / (entriesSectorCount / 4));
                        continue block10;
                    }
                    if (cat.catsId.size() < 4) continue block10;
                    cat.sectorLength = Math.min(128, (cat.catsId.size() - 4) * 128 / (entriesSectorCount / 4));
                    continue block10;
                }
            }
            cat.sectorLength = Math.min(128, cat.catsId.size() * 128 / entriesSectorCount);
        }
        RandomAccessFile fos = new RandomAccessFile(dskFile.file, "rw");
        ArrayList catalogsData = new ArrayList(catalogs);
        previousCats = new HashMap();
        for (DskSectorCatalogs catalogC1C4 : catalogsC1C4) {
            while (catalogC1C4.cats.size() < 16 && !catalogs.isEmpty()) {
                catalogC1C4.cats.add((DskSectorCatalog)catalogs.get(0));
                catalogs.remove(0);
                catalogC1C4.scanCatalog(previousCats);
                catalogC1C4.scanData(fos);
            }
        }
        previousCats.clear();
        FileInputStream fis = new FileInputStream(file);
        if (skipHeader128) {
            fis.skip(128L);
        }
        for (DskSectorCatalog e : catalogsData) {
            for (DskSector d : e.catsSector) {
                d.data = new byte[Math.min(dskFile.master.sectorSizes[d.sectorSizeN], fis.available() + pHeader.length)];
                if (pHeader.length > 0) {
                    System.arraycopy(pHeader, 0, d.data, 0, 128);
                }
                fis.read(d.data, pHeader.length, Math.min(d.data.length - pHeader.length, fis.available()));
                if (pHeader.length > 0) {
                    pHeader = new byte[]{};
                }
                d.scanData(fos);
            }
        }
        dskFile.master.allCatsId.clear();
        dskFile.master.allCatsSector.clear();
        for (DskSectorCatalogs catalogC1C4 : catalogsC1C4) {
            catalogC1C4.scanCatalogFromData();
        }
        fis.close();
        fos.close();
    }

    public File readFile(DskFile dskFile, File currentDir, String fileName) throws IOException {
        byte[] data = this.readFile(dskFile, fileName);
        if (data == null) {
            return null;
        }
        File output = new File(currentDir, fileName);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(output));
        bos.write(data);
        bos.close();
        return output;
    }

    public byte[] readFile(DskFile dskFile, String fileName) throws IOException {
        byte[] byArray;
        ArrayList<DskSector> sectors = new ArrayList<DskSector>();
        List<DskSectorCatalogs> catalogsC1C4 = dskFile.master.buildCatalogs(dskFile.tracks);
        for (DskSectorCatalogs dskSectorCatalogs : catalogsC1C4) {
            for (DskSectorCatalog entryFile : dskSectorCatalogs.cats) {
                if (!dskFile.master.cpcname2realname(entryFile.filename).equals(fileName)) continue;
                for (DskSector sector : entryFile.catsSector) {
                    sectors.add(sector);
                }
            }
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        if (sectors.size() > 0) {
            for (DskSector sector : sectors) {
                output.write(sector.data);
            }
            output.close();
        }
        if (DskMaster.CheckAMSDOS(byArray = output.toByteArray())) {
            System.out.println("Hey, AMSDOS here!");
            int size = DskMaster.getWord(byArray, 24) + 128;
            byte[] d = new byte[size];
            System.arraycopy(byArray, 0, d, 0, d.length);
            return d;
        }
        return byArray;
    }

    public void renameFile(DskFile dskFile, String oldFileName, String newFileName) throws IOException {
        List<DskSectorCatalogs> catalogsC1C4 = dskFile.master.buildCatalogs(dskFile.tracks);
        HashMap<String, DskSectorCatalog> previousCats = new HashMap<String, DskSectorCatalog>();
        for (DskSectorCatalogs cat : catalogsC1C4) {
            for (DskSectorCatalog entryFile : cat.cats) {
                if (!dskFile.master.cpcname2realname(entryFile.filename).equals(oldFileName)) continue;
                entryFile.filename = newFileName;
            }
            RandomAccessFile fos = new RandomAccessFile(dskFile.file, "rw");
            cat.scanCatalog(previousCats);
            cat.scanData(fos);
            fos.close();
        }
        previousCats.clear();
        dskFile.master.allCatsId.clear();
        dskFile.master.allCatsSector.clear();
        for (DskSectorCatalogs catalogC1C4 : catalogsC1C4) {
            catalogC1C4.scanCatalogFromData();
        }
    }

    public void eraseFile(DskFile dskFile, String fileName) throws IOException {
        List<DskSectorCatalogs> catalogsC1C4 = dskFile.master.buildCatalogs(dskFile.tracks);
        HashMap<String, DskSectorCatalog> previousCats = new HashMap<String, DskSectorCatalog>();
        for (DskSectorCatalogs cat : catalogsC1C4) {
            for (DskSectorCatalog entryFile : cat.cats) {
                if (!dskFile.master.cpcname2realname(entryFile.filename).equals(fileName)) continue;
                entryFile.fillerByte = 229;
            }
            RandomAccessFile fos = new RandomAccessFile(dskFile.file, "rw");
            cat.scanCatalog(previousCats);
            cat.scanData(fos);
            fos.close();
        }
        previousCats.clear();
        dskFile.master.allCatsId.clear();
        dskFile.master.allCatsSector.clear();
        for (DskSectorCatalogs catalogC1C4 : catalogsC1C4) {
            catalogC1C4.scanCatalogFromData();
        }
    }

    public LinkedHashMap<String, ByteArrayOutputStream> listFiles(DskFile dskFile) throws IOException {
        if (dskFile == null) {
            return null;
        }
        LinkedHashMap<String, ByteArrayOutputStream> listFiles = new LinkedHashMap<String, ByteArrayOutputStream>();
        List<DskSectorCatalogs> catalogsC1C4 = dskFile.master.buildCatalogs(dskFile.tracks);
        int fileLength = 0;
        boolean checkAMSDOS = false;
        for (DskSectorCatalogs cat : catalogsC1C4) {
            for (DskSectorCatalog entryFile : cat.cats) {
                for (DskSector sector : entryFile.catsSector) {
                    String key = dskFile.master.cpcname2realname(entryFile.filename);
                    if (listFiles.containsKey(key)) {
                        if (checkAMSDOS) {
                            listFiles.get(key).write(sector.data, 0, Math.min(sector.data.length, fileLength));
                            continue;
                        }
                        listFiles.get(key).write(sector.data);
                        continue;
                    }
                    DskMaster cfr_ignored_0 = dskFile.master;
                    checkAMSDOS = DskMaster.CheckAMSDOS(sector.data);
                    if (checkAMSDOS) {
                        fileLength = 128 + dskFile.master.getFileLengthAMSDOSHeader(sector.data);
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (checkAMSDOS) {
                        baos.write(sector.data, 0, Math.min(sector.data.length, fileLength));
                    } else {
                        baos.write(sector.data);
                    }
                    listFiles.put(key, baos);
                }
            }
        }
        for (String key : listFiles.keySet()) {
            listFiles.get(key).flush();
            listFiles.get(key).close();
        }
        return listFiles;
    }

    Map<String, Integer> getUserPerFile(DskFile dskFile) {
        if (dskFile == null) {
            return null;
        }
        HashMap<String, Integer> users = new HashMap<String, Integer>();
        List<DskSectorCatalogs> catalogsC1C4 = dskFile.master.buildCatalogs(dskFile.tracks);
        for (DskSectorCatalogs cat : catalogsC1C4) {
            for (DskSectorCatalog entryFile : cat.cats) {
                users.put(dskFile.master.cpcname2realname(entryFile.filename), entryFile.fillerByte);
            }
        }
        return users;
    }
}

