/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.memory;

import jemu.core.device.memory.Memory;

public class DynamicMemory
extends Memory {
    protected byte[] mem = new byte[0];
    protected int[] baseAddr;

    public DynamicMemory(String type, int size, int banks) {
        super(type, size);
        this.baseAddr = new int[banks];
        for (int i = 0; i < banks; ++i) {
            this.baseAddr[i] = -1;
        }
    }

    protected int getMem(int base, int size) {
        if (this.baseAddr[base] == -1) {
            this.baseAddr[base] = this.mem.length;
            byte[] newMem = new byte[this.mem.length + size];
            if (this.mem.length > 0) {
                System.arraycopy(this.mem, 0, newMem, 0, this.mem.length);
            }
            this.mem = newMem;
        }
        return this.baseAddr[base];
    }

    protected void freeMem(int base, int size) {
        if (this.baseAddr[base] != -1) {
            int start = this.baseAddr[base];
            this.baseAddr[base] = -1;
            byte[] newMem = new byte[this.mem.length - size];
            if (start > 0) {
                System.arraycopy(this.mem, 0, newMem, 0, start);
            }
            if (start < newMem.length) {
                System.arraycopy(this.mem, start + size, newMem, start, newMem.length - start);
            }
            for (int i = 0; i < this.baseAddr.length; ++i) {
                if (this.baseAddr[i] <= start) continue;
                int n = i;
                this.baseAddr[n] = this.baseAddr[n] - size;
            }
        }
    }

    public byte[] getMemory() {
        return this.mem;
    }
}

