/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.sound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import jemu.core.device.sound.SoundUtil;
import jemu.core.device.sound.SunAudio2;
import jemu.settings.Settings;

public class JavaSound2
extends SunAudio2 {
    public static int SAMPLE_RATE = 44100;
    public static boolean muted = false;
    protected static AudioFormat STEREO_FORMAT = new AudioFormat(SAMPLE_RATE, 8, 2, false, true);
    protected SourceDataLine line;
    protected byte[] data;
    protected int offset = 0;
    protected int channels;
    protected long startCount;
    protected int rate;

    public JavaSound2(int samples, boolean stereo) {
        super(samples, stereo);
    }

    @Override
    public int getSampleRate() {
        return SAMPLE_RATE;
    }

    @Override
    public void init() {
        this.rate = Integer.parseInt(Settings.get("samplerate", "1"));
        SAMPLE_RATE = this.frequencies[this.rate];
        System.out.println("Samplerate is " + SAMPLE_RATE + "hz");
        STEREO_FORMAT = new AudioFormat(SAMPLE_RATE, 8, 2, false, false);
        this.format = 2;
        this.channels = this.stereo ? 2 : 1;
        this.data = new byte[this.samples * this.channels];
        AudioFormat fmt = STEREO_FORMAT;
        try {
            if (this.line != null) {
                this.line.flush();
                this.line.close();
            }
            this.line = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, fmt));
            this.line.open();
            System.out.println("Line for PSG YM 2 started!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("JavaSound: " + this.samples + " x " + this.channels);
        System.out.println("Line Buffer: " + this.line.getBufferSize() + " for " + this.line.getClass());
        this.clear();
        this.resync();
    }

    public void clear() {
        if (this.data == null) {
            return;
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = -128;
        }
    }

    @Override
    public void resync() {
        int len;
        this.line.flush();
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = -128;
        }
        this.startCount = this.line.getLongFramePosition();
        for (int sample = SAMPLE_RATE / 10 * this.channels; sample > 0; sample -= len) {
            len = Math.min(this.data.length, sample);
            this.line.write(this.data, 0, len);
        }
        System.out.println("resync: start=" + this.startCount);
    }

    @Override
    public long getCount() {
        return this.line.getLongFramePosition() - this.startCount - 100L;
    }

    @Override
    public long getDeviation() {
        return SAMPLE_RATE / 10;
    }

    @Override
    public void play() {
        this.resync();
        this.line.start();
    }

    @Override
    public void stop() {
        this.line.stop();
    }

    @Override
    public void dispose() {
        this.line.close();
    }

    @Override
    public void writeStereo(int a, int b) {
        a ^= 0x80;
        b ^= 0x80;
        switch (this.format) {
            case 0: {
                this.data[this.offset] = SoundUtil.ulawToUPCM8((byte)a);
                this.data[this.offset + 1] = SoundUtil.ulawToUPCM8((byte)b);
                break;
            }
            case 2: {
                this.data[this.offset] = (byte)a;
                this.data[this.offset + 1] = (byte)b;
            }
        }
        if (muted) {
            this.data[this.offset] = 0;
            this.data[this.offset + 1] = 0;
        }
        if ((this.offset += 2) == this.data.length) {
            this.line.write(this.data, 0, this.data.length);
            this.offset = 0;
        }
    }
}

