/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.sound;

import jemu.core.device.sound.JavaSound1;
import jemu.core.device.sound.SoundPlayer1;

public class SoundUtil1 {
    public static final int ULAW = 0;
    public static final int PCM8 = 1;
    public static final int UPCM8 = 2;
    public static final int PCM16 = 3;
    public static final int UPCM16 = 4;
    protected static int[] ULAW_TO_PCM16;
    protected static byte[] PCM16_TO_ULAW;
    protected static int[] PCM16_RANGE;
    protected static int[] ULAW_PREFIX;

    public static SoundPlayer1 getSoundPlayer1(int samples, boolean stereo) {
        return new JavaSound1(samples, stereo);
    }

    public static final byte pcm16ToULaw(int value) {
        int mask;
        if (value < 0) {
            value = -value;
            mask = 255;
        } else {
            mask = 127;
        }
        if ((value >>= 3) >= 8160) {
            value = 8159;
        }
        return (byte)(PCM16_TO_ULAW[value] & mask);
    }

    public static final byte upcm16ToULaw(int value) {
        return SoundUtil1.pcm16ToULaw(value - 32768);
    }

    public static final byte pcm8ToULaw(byte value) {
        return SoundUtil1.pcm16ToULaw(value * 256);
    }

    public static final byte upcm8ToULaw(byte value) {
        return SoundUtil1.pcm16ToULaw((value - 128) * 256);
    }

    public static final int ulawToPCM16(byte value) {
        return (value & 0x80) == 0 ? ULAW_TO_PCM16[value] << 3 : -(ULAW_TO_PCM16[value & 0x7F] << 3);
    }

    public static final int ulawToUPCM16(byte value) {
        return SoundUtil1.ulawToPCM16(value) + 32768;
    }

    public static final byte ulawToPCM8(byte value) {
        return (byte)((value & 0x80) == 0 ? ULAW_TO_PCM16[value] >> 5 : -(ULAW_TO_PCM16[value & 0x7F] >> 5));
    }

    public static final byte ulawToUPCM8(byte value) {
        return (byte)(SoundUtil1.ulawToPCM8(value) + 128);
    }

    static {
        int i;
        ULAW_TO_PCM16 = new int[128];
        PCM16_TO_ULAW = new byte[8160];
        PCM16_RANGE = new int[]{0, 32, 96, 224, 480, 992, 2016, 4064, 8160};
        ULAW_PREFIX = new int[]{240, 224, 208, 192, 176, 160, 144, 128};
        block0: for (i = 0; i < 8160; ++i) {
            for (int j = 0; j < PCM16_RANGE.length - 1; ++j) {
                if (i >= PCM16_RANGE[j + 1]) continue;
                SoundUtil1.PCM16_TO_ULAW[i] = (byte)(ULAW_PREFIX[j] | 15 - (i - PCM16_RANGE[j]) / (2 << j));
                continue block0;
            }
        }
        for (i = 0; i < 127; ++i) {
            int scale = 7 - (i >> 4);
            int base = PCM16_RANGE[scale];
            SoundUtil1.ULAW_TO_PCM16[i] = base + ((15 - (i & 0xF) << 1) + 1) * (1 << scale);
        }
    }
}

