/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.sound;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import jemu.core.device.sound.JavaSound;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.ui.Display;
import jemu.ui.LCDDisplay;

public class YMControl
extends JInternalFrame
implements WindowListener,
MouseListener {
    public static LCDDisplay display;
    static BufferedImage lcd;
    public static int displaycount1;
    public static int displaycount2;
    protected static int displaycount3;
    public static int DisplayStart;
    public static int DisplayEnd;
    public static String Monitor;
    static String dot;
    protected static Font font;
    protected static Font font2;
    protected boolean playing = false;
    public JButton btnREC = new JButton("Rec");
    public JButton btnPLAY = new JButton("Play");
    public JButton btnLOAD = new JButton("Open");
    public JButton btnSTOP = new JButton("Stop");
    public JButton btnSAVE = new JButton("Save");
    public static int counter;
    public static JSlider ympos;
    public JPanel controls;
    static JFrame fram;
    static BufferedImage lcd2;
    static int dingel;
    static String lcdtext;
    static int ol;
    static int or;
    static int llc;
    static int rrc;
    static int dval;
    public static boolean showtrack;
    static int displaycount4;

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            dval = dval == 255 ? 0 : 255;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.setVisible(false);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    public YMControl() {
        display = new LCDDisplay(350, 50);
        display.addMouseListener(this);
        display.setPreferredSize(new Dimension(350, 50));
        ympos.setMaximum(0);
        ympos.setValue(0);
        this.setLayout(new BorderLayout());
        ympos.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                JavaSound.clear();
                GateArray.cpc.Slide(ympos.getValue());
            }
        });
        this.btnPLAY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CPC.YM_Rec) {
                    if (Display.skin == 1) {
                        Display.skin = 2;
                    } else if (Display.skin == 2) {
                        Display.skin = 1;
                    }
                    CPC.st_mode = false;
                    CPC.zx_mode = false;
                    CPC.YM_Minutes = 0;
                    CPC.YM_Seconds = 0;
                    displaycount1 = 0;
                    displaycount2 = 0;
                    DisplayStart = 0;
                    CPC.ymcount = 0;
                    CPC.YM_Play = true;
                    CPC.YM_Rec = false;
                    YMControl.UpdateLCD("*YM PLAYER*");
                }
            }
        });
        this.btnREC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CPC.YM_Play) {
                    CPC.doRecord = false;
                    displaycount1 = 0;
                    displaycount2 = 0;
                    DisplayStart = 0;
                    CPC.YM_registers = 16;
                    CPC.atari_st_mode = false;
                    CPC.oldYM = false;
                    CPC.YM_Minutes = 0;
                    CPC.YM_Seconds = 0;
                    CPC.ymcount = 0;
                    CPC.YM_RecCount = 0;
                    CPC.YM_vbl = 0;
                    CPC.YM_Play = false;
                    CPC.YM_Rec = true;
                    YMControl.UpdateLCD("*  PAUSE  *");
                }
            }
        });
        this.btnSTOP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CPC.YM_Minutes = 0;
                CPC.YM_Seconds = 0;
                CPC.ymcount = 0;
                CPC.YM_Play = false;
                CPC.YM_Rec = false;
                CPC.YM_Stop = true;
                displaycount1 = 0;
                displaycount2 = 0;
                DisplayStart = 0;
                YMControl.UpdateLCD("*YM PLAYER*");
            }
        });
        this.btnLOAD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CPC.YM_Rec && !CPC.YM_Play) {
                    CPC.YM_Load = true;
                }
            }
        });
        this.btnSAVE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CPC.YM_Rec && !CPC.YM_Play) {
                    CPC.YM_Save = true;
                }
            }
        });
        this.controls = new JPanel();
        this.controls.setLayout(new FlowLayout(1, 4, 4));
        this.controls.add(this.btnREC);
        this.controls.add(this.btnPLAY);
        this.controls.add(this.btnSTOP);
        this.controls.add(this.btnLOAD);
        this.controls.add(this.btnSAVE);
        this.add((Component)display, "North");
        this.add((Component)this.controls, "Center");
        this.add((Component)ympos, "South");
        this.pack();
        this.btnLOAD.setFocusable(false);
        this.btnPLAY.setFocusable(false);
        this.btnSTOP.setFocusable(false);
        this.btnSAVE.setFocusable(false);
        InputStream in = this.getClass().getResourceAsStream("tran.ttf");
        try {
            font = Font.createFont(0, in).deriveFont(0, 54.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        in = this.getClass().getResourceAsStream("pixel.ttf");
        try {
            font2 = Font.createFont(0, in).deriveFont(0, 20.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setForeground(Color.LIGHT_GRAY);
        this.setBackground(Color.DARK_GRAY);
        this.setTitle("YM-control");
        this.pack();
        this.setResizable(false);
        this.setVisible(false);
    }

    public static void UpdateLCD(String input) {
        int i;
        lcdtext = input;
        if (lcdtext.startsWith("*")) {
            YMControl.reset();
        }
        Graphics2D d = lcd2.createGraphics();
        d.setColor(Color.white);
        d.fillRect(0, 0, 175, 50);
        d.setColor(Color.black);
        if (showtrack) {
            d.fillRect(1, 4, 3, 1);
            d.fillRect(1, 5, 1, 4);
            d.fillRect(3, 5, 1, 4);
            d.fillRect(2, 6, 1, 1);
            d.fillRect(1, 14, 2, 1);
            d.fillRect(1, 15, 1, 3);
            d.fillRect(1, 16, 2, 1);
            d.fillRect(1, 18, 2, 1);
            d.fillRect(3, 15, 1, 1);
            d.fillRect(3, 17, 1, 1);
            int pos = 7;
            for (int i2 = 0; i2 < JavaSound.data.length - 182; i2 += 2) {
                int k = (JavaSound.data[i2] & 0xFF) >> 4;
                if (i2 == 0) {
                    ol = k;
                }
                d.drawLine(pos, -6 + k, pos, -6 + ol);
                ol = k;
                k = (JavaSound.data[i2 + 1] & 0xFF) >> 4;
                if (i2 == 0) {
                    or = k;
                }
                d.drawLine(pos, 4 + k, pos++, 4 + or);
                or = k;
            }
        } else {
            d.setFont(font2);
            ((Graphics)d).drawString(input, 8, 20);
        }
        int lc = JavaSound.data[0] & 0xFF;
        int rc = JavaSound.data[1] & 0xFF;
        rc ^= 0x80;
        if ((lc ^= 0x80) >> 1 > llc) {
            llc = lc >> 1;
        }
        if (rc >> 1 > rrc) {
            rrc = rc >> 1;
        }
        if (rrc == 0) {
            rrc = 1;
        }
        if (llc == 0) {
            llc = 1;
        }
        for (i = 0; i < rrc * 2; i += 2) {
            d.drawLine(7 + i, 22, 7 + i, 23);
        }
        for (i = 0; i < llc * 2; i += 2) {
            d.drawLine(171 - i, 22, 171 - i, 23);
        }
        if (llc > 0) {
            --llc;
        }
        if (rrc > 0) {
            --rrc;
        }
        for (int x = 0; x < 175; ++x) {
            for (int y = 0; y < 25; ++y) {
                display.setPixel(x * 2, y * 2, (lcd2.getRGB(x, y) & 0xFF) != dval);
            }
        }
        display.updateDisplay();
    }

    public static void reset() {
        displaycount4 = 0;
        displaycount3 = 0;
        displaycount2 = 0;
        displaycount1 = 0;
        DisplayStart = 0;
        showtrack = false;
    }

    public static void doYMDisplay(String minutes, String seconds, String milliseconds, String YMtitle, String YMauthor, String YMcreator) {
        String dispText = "        " + YMtitle + " - " + YMauthor + " - " + YMcreator + "        ";
        if (++displaycount1 >= 500 && ++displaycount2 >= 10) {
            DisplayEnd = dispText.length();
            if (++DisplayStart > DisplayEnd - 11) {
                DisplayStart = 0;
            }
            displaycount2 = 0;
            if (displaycount1 >= 500 + (DisplayEnd - 11) * 10) {
                if (++displaycount4 < 500) {
                    showtrack = true;
                    displaycount2 = 500;
                    DisplayStart = 0;
                } else {
                    displaycount4 = 0;
                    DisplayStart = 0;
                    showtrack = false;
                    displaycount1 = 0;
                }
            }
        }
        if (!showtrack) {
            if (displaycount1 >= 500) {
                YMControl.UpdateLCD(dispText.substring(DisplayStart, DisplayStart + 11));
            } else {
                minutes = minutes.replace(":", dot);
                YMControl.UpdateLCD(minutes + dot + seconds + "\"" + milliseconds + " ");
            }
        } else {
            YMControl.UpdateLCD("");
        }
        Monitor = " " + minutes + ":" + seconds + "\"" + milliseconds + " ";
        if (++displaycount3 >= 25) {
            dot = " ";
        }
        if (displaycount3 >= 50) {
            dot = ":";
            displaycount3 = 0;
        }
    }

    static {
        lcd = new BufferedImage(350, 50, 12);
        displaycount1 = 0;
        displaycount2 = 0;
        displaycount3 = 0;
        DisplayEnd = 0;
        Monitor = "";
        dot = ":";
        counter = 0;
        ympos = new JSlider();
        lcd2 = new BufferedImage(175, 25, 12);
        dingel = 0;
        dval = 255;
        showtrack = false;
    }
}

