/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.tape;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import jemu.core.device.tape.CounterDigit;

public class TapeCounter
extends JPanel {
    double counterValue = 0.0;
    private CounterDigit counterDigit1;
    private CounterDigit counterDigit2;
    private CounterDigit counterDigit3;

    public TapeCounter() {
        this.initComponents();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TapeCounter.this.setCounter(0.0);
            }
        });
    }

    public double getCounter() {
        return this.counterValue;
    }

    public void setCounter(double value) {
        value += 0.001;
        this.counterValue = value %= 1000.0;
        String p = "" + value;
        if (p.toLowerCase().contains("nan")) {
            return;
        }
        if (value < 10.0) {
            p = "00" + p;
        } else if (value < 100.0) {
            p = "0" + p;
        }
        String d1 = "" + p.charAt(0);
        String d2 = "" + p.charAt(1);
        String d3 = "" + p.charAt(2) + "." + p.charAt(4) + p.charAt(5);
        double dig1 = Double.parseDouble(d1);
        double dig2 = Double.parseDouble(d2);
        double dig3 = Double.parseDouble(d3);
        dig3 %= 10.0;
        dig2 %= 10.0;
        dig1 %= 10.0;
        if (dig3 > 9.1) {
            dig2 += (dig3 - 9.0) * 10.0 / 10.0;
        }
        if (dig2 > 9.1) {
            dig1 += (dig2 - 9.0) * 10.0 / 10.0;
        }
        this.counterDigit1.setValue(dig1);
        this.counterDigit2.setValue(dig2);
        this.counterDigit3.setValue(dig3);
    }

    private void initComponents() {
        this.counterDigit1 = new CounterDigit();
        this.counterDigit2 = new CounterDigit();
        this.counterDigit3 = new CounterDigit();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TapeCounter.this.formMouseClicked(evt);
            }
        });
        this.setLayout(new FlowLayout(1, 0, 0));
        this.counterDigit1.setFocusable(false);
        this.counterDigit1.setPreferredSize(new Dimension(11, 22));
        this.add(this.counterDigit1);
        this.counterDigit2.setFocusable(false);
        this.counterDigit2.setPreferredSize(new Dimension(11, 22));
        this.add(this.counterDigit2);
        this.counterDigit3.setFocusable(false);
        this.counterDigit3.setPreferredSize(new Dimension(11, 22));
        this.add(this.counterDigit3);
    }

    private void formMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.counterDigit1.toggleFormat();
            this.counterDigit2.toggleFormat();
            this.counterDigit3.toggleFormat();
            this.setCounter(this.getCounter());
        }
    }
}

