/*
 * Decompiled with CFR 0.152.
 */
package jemu.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class FavoriteSettings {
    private static File file = new File(System.getProperty("user.home"), "/JavaCPC/fsettings.ini");
    private static final FavoriteSettings instance = new FavoriteSettings();
    private final Properties props = new Properties();

    private FavoriteSettings() {
        try {
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkRead(file.getAbsolutePath());
            }
            this.props.load(new FileInputStream(file));
            System.out.println("loaded " + this.props.size() + " favourites");
        }
        catch (Throwable t) {
            System.out.println("can't load user settings (" + t.getMessage() + ")");
        }
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = FavoriteSettings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    public static int getInt(String key, int defaultValue) {
        String value = FavoriteSettings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static void setBoolean(String key, boolean value) {
        FavoriteSettings.instance.props.setProperty(key, value ? "true" : "false");
        FavoriteSettings.save();
    }

    public static String get(String key, String defaultValue) {
        String value = FavoriteSettings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void set(String key, String value) {
        if (value.equals(FavoriteSettings.get(key, null))) {
            return;
        }
        FavoriteSettings.instance.props.setProperty(key, value);
        FavoriteSettings.save();
    }

    public static void delete() {
        try {
            FavoriteSettings.instance.props.clear();
            FavoriteSettings.save();
            System.out.println("Fsettings deleted...");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void save() {
        try {
            File f = new File(System.getProperty("user.home"), "JavaCPC");
            f.mkdir();
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkWrite(file.getAbsolutePath());
            }
            FileOutputStream fos = new FileOutputStream(file);
            FavoriteSettings.instance.props.store(fos, "[Settings]");
            fos.close();
        }
        catch (Throwable t) {
            System.out.println("can't save user settings (" + t.getMessage() + ")");
        }
    }
}

