/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jemu.system.cpc.AnimatedGifEncoder;
import jemu.system.cpc.GateArray;

public class GifMaker
extends JFrame {
    int mode;
    boolean skip;
    boolean linear;
    boolean bit16;
    int bytewidth;
    int byteheight;
    int ramaddress;
    int tilewidth;
    int tileheight;
    int tilenum;
    BufferedImage[] screen;
    FileDialog dialog;
    int oldpen = 0;
    int tpen = 0;
    BufferedImage[] buffer;
    boolean hadloop = false;
    AnimatedGifEncoder enc;
    int sindex;
    ActionListener update = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                GifMaker.this.prev.setIcon(new ImageIcon(GifMaker.this.screen[GifMaker.this.sindex]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (GifMaker.this.screen == null) {
                GifMaker.this.fireUpdate.stop();
                return;
            }
            ++GifMaker.this.sindex;
            if (GifMaker.this.sindex >= GifMaker.this.screen.length) {
                GifMaker.this.sindex = 0;
            }
        }
    };
    Timer fireUpdate = new Timer(this.calcFPS(15), this.update);
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSlider jSlider1;
    private JCheckBox loop;
    public JLabel prev;
    public Panel trans;

    public GifMaker() {
        this.initComponents();
    }

    public void initMapper(int tiles, int addr, int width, int height, BufferedImage[] input, int mode, boolean linear, boolean bit16, boolean skip) {
        int i;
        this.loop.setSelected(false);
        this.bit16 = bit16;
        this.skip = skip;
        this.linear = linear;
        this.mode = mode;
        this.bytewidth = width;
        this.byteheight = height;
        this.ramaddress = addr;
        this.tilewidth = input[0].getWidth();
        this.tileheight = input[0].getHeight();
        this.tilenum = tiles;
        if (this.tilenum < 1) {
            this.tilenum = 512;
        }
        if (this.tilenum > 512) {
            this.tilenum = 512;
        }
        this.screen = new BufferedImage[this.tilenum];
        int buffer = 0;
        for (i = 0; i < this.screen.length; ++i) {
            try {
                this.screen[i] = new BufferedImage(this.tilewidth, this.tileheight, 2);
                this.screen[i].createGraphics().drawImage((Image)input[i], 0, 0, null);
                continue;
            }
            catch (Exception e) {
                buffer = i - 1;
            }
        }
        if (buffer != 0) {
            this.tilenum = tiles = buffer;
            if (this.tilenum < 1) {
                this.tilenum = 1;
            }
            this.screen = new BufferedImage[this.tilenum];
            for (i = 0; i < this.screen.length; ++i) {
                this.screen[i] = new BufferedImage(this.tilewidth, this.tileheight, 2);
                this.screen[i].createGraphics().drawImage((Image)input[i], 0, 0, null);
            }
        }
        this.tpen = 0;
        this.oldpen = 0;
        this.trans.setBackground(new Color(-16777216 + GateArray.getInkRGB(this.tpen)));
        this.setTransparency();
        this.pack();
    }

    public void saveGIF() {
        if (this.dialog == null) {
            this.dialog = new FileDialog((Frame)this, "Save GIF file", 1);
        }
        this.dialog.setFile("*.gif");
        this.setAlwaysOnTop(false);
        this.dialog.setVisible(true);
        String g = this.dialog.getFile();
        this.setAlwaysOnTop(true);
        if (g == null) {
            return;
        }
        g = this.dialog.getDirectory() + this.dialog.getFile();
        if (!g.toLowerCase().endsWith(".gif")) {
            g = g + ".gif";
        }
        this.saveGIF(g);
    }

    public void checkLoop(boolean hasloop) {
        if (this.screen == null) {
            return;
        }
        if (hasloop != this.hadloop) {
            if (hasloop) {
                int i;
                this.buffer = new BufferedImage[this.screen.length + this.screen.length - 2];
                int off = 0;
                for (i = 0; i < this.screen.length; ++i) {
                    this.buffer[off] = new BufferedImage(this.tilewidth, this.tileheight, 2);
                    this.buffer[off].createGraphics().drawImage((Image)this.screen[i], 0, 0, null);
                    ++off;
                }
                for (i = this.screen.length - 2; i > 0; --i) {
                    this.buffer[off] = new BufferedImage(this.tilewidth, this.tileheight, 2);
                    this.buffer[off].createGraphics().drawImage((Image)this.screen[i], 0, 0, null);
                    ++off;
                }
                this.screen = new BufferedImage[this.buffer.length];
                System.arraycopy(this.buffer, 0, this.screen, 0, this.screen.length);
            } else {
                int k = this.screen.length / 2 + 2;
                this.buffer = new BufferedImage[k];
                for (int i = 0; i < this.buffer.length; ++i) {
                    this.buffer[i] = new BufferedImage(this.tilewidth, this.tileheight, 2);
                    this.buffer[i].createGraphics().drawImage((Image)this.screen[i], 0, 0, null);
                }
                this.screen = new BufferedImage[this.buffer.length];
                System.arraycopy(this.buffer, 0, this.screen, 0, this.screen.length);
            }
        }
    }

    public void setTransparency() {
        for (int i = 0; i < this.screen.length; ++i) {
            for (int x = 0; x < this.tilewidth; ++x) {
                for (int y = 0; y < this.tileheight; ++y) {
                    if (this.jCheckBox1.isSelected()) {
                        if (this.screen[i].getRGB(x, y) != -16777216 + GateArray.getInkRGB(this.oldpen)) continue;
                        this.screen[i].setRGB(x, y, 0xFF00FF);
                        continue;
                    }
                    if (this.screen[i].getRGB(x, y) != 0xFF00FF) continue;
                    this.screen[i].setRGB(x, y, -16777216 + GateArray.getInkRGB(this.oldpen));
                }
            }
        }
        this.oldpen = this.tpen;
    }

    public void saveGIF(String savePath) {
        try {
            int i;
            this.oldpen = this.tpen;
            for (i = 0; i < this.screen.length; ++i) {
                for (int x = 0; x < this.tilewidth; ++x) {
                    for (int y = 0; y < this.tileheight; ++y) {
                        if (this.screen[i].getRGB(x, y) != 0xFF00FF) continue;
                        this.screen[i].setRGB(x, y, -16777216 + GateArray.getInkRGB(this.oldpen));
                    }
                }
            }
            this.enc = new AnimatedGifEncoder();
            this.enc.start(savePath);
            this.enc.setRepeat(0);
            if (this.jCheckBox1.isSelected()) {
                this.enc.setTransparent(new Color(-16777216 + GateArray.getInkRGB(this.tpen)));
            } else {
                this.enc.setTransparent(null);
            }
            this.enc.setDelay(this.calcFPS(this.jSlider1.getValue()));
            for (i = 0; i < this.screen.length; ++i) {
                this.enc.addFrame(this.screen[i]);
            }
            this.enc.finish();
            this.setTransparency();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void toggleTrans() {
        boolean hadtrans = false;
        if (this.jCheckBox1.isSelected()) {
            hadtrans = true;
            this.jCheckBox1.setSelected(false);
            this.setTransparency();
        }
        this.oldpen = this.tpen;
        this.trans.setBackground(new Color(-16777216 + GateArray.getInkRGB(this.tpen)));
        if (hadtrans) {
            this.jCheckBox1.setSelected(true);
            this.setTransparency();
        }
    }

    public void play() {
        this.fireUpdate.start();
    }

    public void stop() {
        this.fireUpdate.stop();
    }

    public void changeFPS() {
        boolean run = false;
        if (this.fireUpdate.isRunning()) {
            run = true;
            this.fireUpdate.stop();
        }
        this.fireUpdate = new Timer(this.calcFPS(this.jSlider1.getValue()), this.update);
        if (run) {
            this.fireUpdate.start();
        }
    }

    public int calcFPS(int fps) {
        double a = 1.0 / (double)fps;
        return (int)(a *= 1000.0);
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.prev = new JLabel();
        this.jSlider1 = new JSlider();
        this.jLabel1 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.trans = new Panel();
        this.loop = new JCheckBox();
        this.setTitle("GIFMaker");
        this.setAlwaysOnTop(true);
        this.jButton1.setText("Play");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GifMaker.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Stop");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GifMaker.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("Save");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GifMaker.this.jButton3ActionPerformed(evt);
            }
        });
        this.prev.setBackground(new Color(153, 153, 153));
        this.prev.setHorizontalAlignment(0);
        this.prev.setOpaque(true);
        this.prev.setPreferredSize(new Dimension(100, 100));
        this.jSlider1.setMaximum(15);
        this.jSlider1.setMinimum(1);
        this.jSlider1.setMinorTickSpacing(1);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.setSnapToTicks(true);
        this.jSlider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GifMaker.this.jSlider1StateChanged(evt);
            }
        });
        this.jLabel1.setText("FPS:");
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("Transparent");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GifMaker.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("(Pick transparent color in GFXViewer)");
        GroupLayout transLayout = new GroupLayout(this.trans);
        this.trans.setLayout(transLayout);
        transLayout.setHorizontalGroup(transLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        transLayout.setVerticalGroup(transLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        this.loop.setText("<--> Loop");
        this.loop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GifMaker.this.loopActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.prev, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.trans, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, 87, -2).addGap(6, 6, 6).addComponent(this.loop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3))).addContainerGap(16, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton3, -1, -1, Short.MAX_VALUE).addComponent(this.loop)).addComponent(this.jSlider1, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prev, -1, 317, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(this.jCheckBox1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.trans, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.play();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.stop();
    }

    private void jSlider1StateChanged(ChangeEvent evt) {
        this.changeFPS();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.saveGIF();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.setTransparency();
    }

    private void loopActionPerformed(ActionEvent evt) {
        this.checkLoop(this.loop.isSelected());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(GifMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(GifMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(GifMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(GifMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GifMaker make = new GifMaker();
                make.setVisible(true);
            }
        });
    }
}

