/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static BufferedImage cropImage(BufferedImage in, Point top, Point bottom) {
        if (top == null || bottom == null) {
            return in;
        }
        Dimension size = new Dimension(bottom.x - top.x, bottom.y - top.y);
        BufferedImage cropped = new BufferedImage(size.width, size.height, 1);
        cropped.createGraphics().drawImage(in, 0, 0, size.width, size.height, top.x, top.y, bottom.x, bottom.y, null);
        return cropped;
    }

    public static BufferedImage readImage(String filename) throws IOException {
        File imagein = new File(filename);
        BufferedImage bi = ImageIO.read(imagein);
        return bi;
    }

    public static boolean loadImageNow(Image toLoad, Component c, int timeout) {
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(toLoad, 0);
        try {
            tracker.waitForAll(timeout);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static BufferedImage scaleImage(BufferedImage imageIn, int width, int height) throws IOException {
        return ImageUtil.scaleImage(imageIn, width, height, 4, false);
    }

    public static BufferedImage scaleImage(BufferedImage imageIn, int width, int height, int scaleQuality) throws IOException {
        return ImageUtil.scaleImage(imageIn, width, height, scaleQuality, false);
    }

    public static BufferedImage scaleImage(BufferedImage imageIn, int width, int height, int scaleQuality, boolean maintainAspect) throws IOException {
        if (maintainAspect && width != -1 && height != -1) {
            int im_width = imageIn.getWidth(null);
            int im_height = imageIn.getHeight(null);
            int tmp_h = height;
            int tmp_w = height / im_height * im_width;
            if (tmp_w > width) {
                tmp_w = width;
                tmp_h = width / im_width * im_height;
            }
            width = tmp_w;
            height = tmp_h;
        }
        Image imageIn2 = imageIn.getScaledInstance(width, height, scaleQuality);
        BufferedImage scaled = new BufferedImage(imageIn2.getWidth(null), imageIn2.getHeight(null), 1);
        scaled.createGraphics().drawImage(imageIn2, 0, 0, null);
        return scaled;
    }

    public static void writeImage(BufferedImage toWrite, String fileout) throws IOException {
        File f = new File(fileout);
        String ext = fileout.substring(fileout.length() - 3, fileout.length());
        String filetype = "jpeg";
        if (ext.equalsIgnoreCase("jpg")) {
            filetype = "jpeg";
        } else if (ext.equalsIgnoreCase("gif")) {
            filetype = "gif";
        } else if (ext.equalsIgnoreCase("png")) {
            filetype = "png";
        }
        ImageIO.write((RenderedImage)toWrite, filetype, f);
    }

    public static BufferedImage rotateImage(BufferedImage bi, int rotations) {
        int newWidth = bi.getWidth();
        int newHeight = bi.getHeight();
        int moveX = 0;
        int moveY = 0;
        if ((rotations %= 4) % 2 != 0) {
            newHeight = bi.getWidth();
            newWidth = bi.getHeight();
        }
        if (rotations > 1) {
            moveY = newHeight;
        }
        if (rotations > 0 && rotations < 3) {
            moveX = newWidth;
        }
        BufferedImage rbi = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D g2d = rbi.createGraphics();
        AffineTransform af = new AffineTransform();
        af.concatenate(AffineTransform.getTranslateInstance(moveX, moveY));
        af.concatenate(AffineTransform.getRotateInstance((double)rotations * 0.5 * Math.PI));
        g2d.drawImage(bi, af, null);
        return rbi;
    }
}

