/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.applet.Applet;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import jemu.ui.AtariCanvas;
import org.ibex.nestedvm.Runtime;

public class Atari800
extends Applet
implements Runnable {
    AtariCanvas canvas;
    Frame frame;
    Panel panel;
    SourceDataLine line;
    byte[] soundBuffer;
    boolean isApplet;
    Thread thread;
    private volatile boolean threadSuspended;

    public Atari800() {
        this.isApplet = true;
    }

    public Atari800(Frame f) {
        this.isApplet = false;
        this.frame = f;
    }

    public Atari800(Panel f) {
        this.isApplet = false;
    }

    private void initGraphics(int scalew, int scaleh, int atari_width, int atari_height, int atari_visible_width, int atari_left_margin) {
        if (this.canvas == null) {
            this.canvas = new AtariCanvas();
        }
        this.canvas.atari_width = atari_width;
        this.canvas.atari_height = atari_height;
        this.canvas.atari_visible_width = atari_visible_width;
        this.canvas.atari_left_margin = atari_left_margin;
        this.canvas.init();
        this.canvas.setFocusTraversalKeysEnabled(false);
        this.canvas.setFocusable(true);
        if (!this.isApplet && this.frame != null) {
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowsGainedFocus(WindowEvent e) {
                    Atari800.this.canvas.requestFocusInWindow();
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    Atari800.this.canvas.setWindowClosed();
                }
            });
        }
        this.canvas.requestFocusInWindow();
        this.canvas.setSize(new Dimension(this.canvas.width * scalew, this.canvas.height * scaleh));
        this.canvas.scalew = scalew;
        this.canvas.scaleh = scaleh;
        if (this.isApplet) {
            this.add(this.canvas);
            this.canvas.requestFocus();
        } else if (this.frame != null) {
            System.out.println("adding canvas to frame");
            this.frame.add(this.canvas);
            this.frame.setResizable(false);
            this.frame.pack();
            Insets insets = this.frame.getInsets();
            this.frame.setSize(new Dimension(this.canvas.width * scalew + insets.left + insets.right, this.canvas.height * scaleh + insets.top + insets.bottom));
            this.frame.setVisible(true);
        }
    }

    private void initSound(int sampleRate, int bitsPerSample, int channels, boolean isSigned, boolean bigEndian) {
        AudioFormat format = new AudioFormat(sampleRate, bitsPerSample, channels, isSigned, bigEndian);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        try {
            if (this.line != null) {
                this.line.close();
            }
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(format);
            this.line.start();
            this.soundBuffer = new byte[this.line.getBufferSize()];
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    @Override
    public void init() {
        this.setLayout(null);
    }

    @Override
    public synchronized void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
        this.threadSuspended = false;
        this.thread.interrupt();
    }

    @Override
    public synchronized void stop() {
        this.threadSuspended = true;
    }

    @Override
    public void destroy() {
        if (this.line != null) {
            this.line.close();
        }
        if (this.canvas != null) {
            this.remove(this.canvas);
        }
        Thread dead = this.thread;
        this.thread = null;
        dead.interrupt();
    }

    @Override
    public void run() {
        String args = this.getParameter("args");
        this.main2(args.split("\\s"));
    }

    @Override
    public void paint(Graphics g) {
        if (this.canvas != null) {
            this.canvas.paint(g);
        }
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        Atari800 app = new Atari800(f);
        f.setTitle("Atari 800 XL Emulator");
        app.main2(args);
    }

    public static void atari800emu(String[] args) {
        Atari800 app = new Atari800(new Panel());
        app.main2(args);
    }

    public Panel emu() {
        return this.panel;
    }

    public void main2(String[] args) {
        String[] appArgs = new String[args.length + 1];
        try {
            final Thread thisThread = Thread.currentThread();
            appArgs[0] = "atari800";
            for (int i = 0; i < args.length; ++i) {
                appArgs[i + 1] = args[i];
            }
            String className = "atari800_runtime";
            Class<?> c = Class.forName(className);
            if (!Runtime.class.isAssignableFrom(c)) {
                System.err.println(className + " isn't a MIPS compiled class");
                try {
                    System.exit(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            final Runtime rt = (Runtime)c.newInstance();
            rt.setCallJavaCB(new Runtime.CallJavaCB(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public int call(int a, int b, int c, int d) {
                    switch (a) {
                        case 1: {
                            Atari800.this.canvas.displayScreen(rt, b);
                            return 0;
                        }
                        case 2: {
                            Atari800.this.canvas.initPalette(rt, b);
                            return 0;
                        }
                        case 3: {
                            return Atari800.this.canvas.getKbhits(b, c);
                        }
                        case 4: {
                            return Atari800.this.canvas.pollKeyEvent(rt, b);
                        }
                        case 5: {
                            return Atari800.this.canvas.getWindowClosed();
                        }
                        case 6: {
                            try {
                                Thread.sleep(b);
                                return 0;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return 0;
                        }
                        case 7: {
                            int scaleh = 2;
                            int scalew = 2;
                            int atari_width = 384;
                            int atari_height = 240;
                            int atari_visible_width = 336;
                            int atari_left_margin = 24;
                            try {
                                scalew = rt.memRead(b + 0);
                                scaleh = rt.memRead(b + 4);
                                atari_width = rt.memRead(b + 8);
                                atari_height = rt.memRead(b + 12);
                                atari_visible_width = rt.memRead(b + 16);
                                atari_left_margin = rt.memRead(b + 20);
                            }
                            catch (Exception e) {
                                System.err.println(e);
                            }
                            Atari800.this.initGraphics(scaleh, scalew, atari_width, atari_height, atari_visible_width, atari_left_margin);
                            return 0;
                        }
                        case 8: {
                            int sampleRate = 44100;
                            int bitsPerSample = 16;
                            int channels = 2;
                            boolean isSigned = true;
                            boolean bigEndian = true;
                            try {
                                sampleRate = rt.memRead(b + 0);
                                bitsPerSample = rt.memRead(b + 4);
                                channels = rt.memRead(b + 8);
                                isSigned = rt.memRead(b + 12) != 0;
                                bigEndian = rt.memRead(b + 16) != 0;
                            }
                            catch (Exception e) {
                                System.err.println(e);
                            }
                            Atari800.this.initSound(sampleRate, bitsPerSample, channels, isSigned, bigEndian);
                            return Atari800.this.line.getBufferSize();
                        }
                        case 9: {
                            return Atari800.this.line.available();
                        }
                        case 10: {
                            try {
                                rt.copyin(b, Atari800.this.soundBuffer, c);
                            }
                            catch (Exception e) {
                                System.err.println(e);
                            }
                            Atari800.this.line.write(Atari800.this.soundBuffer, 0, c);
                            return 0;
                        }
                        case 11: {
                            Atari800.this.line.stop();
                            return 0;
                        }
                        case 12: {
                            Atari800.this.line.start();
                            return 0;
                        }
                        case 13: {
                            if (!Atari800.this.isApplet || !Atari800.this.threadSuspended) return 0;
                            if (Atari800.this.line != null) {
                                Atari800.this.line.stop();
                            }
                            try {
                                2 var16_9 = this;
                                synchronized (var16_9) {
                                    while (Atari800.this.threadSuspended && Atari800.this.thread == thisThread) {
                                        this.wait();
                                    }
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (Atari800.this.thread != thisThread) {
                                return 1;
                            }
                            if (Atari800.this.line == null) return 0;
                            Atari800.this.line.start();
                            return 0;
                        }
                    }
                    return 0;
                }
            });
            if (this.isApplet) {
                // empty if block
            }
            if (!this.isApplet) {
                System.exit(rt.run(appArgs));
            } else {
                rt.run(appArgs);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

