/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import com.easycapture.recorder.Control;
import com.easycapture.recorder.Recorder;
import com.jhlabs.image.EmbossFilter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.MemoryImageSource;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.awt.image.WritableRaster;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import jemu.core.Util;
import jemu.core.device.sound.YMControl;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.system.cpc.GraphicsViewer;
import jemu.ui.CurvaturedScreen;
import jemu.ui.Desktop;
import jemu.ui.JEMU;
import jemu.ui.Main;
import jemu.ui.ScreenCapture;
import jemu.ui.StatusPanel;
import jemu.ui.Switches;

public class Display
extends JPanel {
    static FileDialog over = new FileDialog((Frame)new JFrame(), "Import Overlay graphic", 0);
    static String overfile;
    static Float trans;
    static boolean noover;
    public static BufferedImage overlay;
    public boolean joyenabled = false;
    public CurvaturedScreen curvature;
    public static boolean PAL;
    public int showdrives = 0;
    public int showtape = 0;
    public int showsna = 0;
    public Recorder mov = new Recorder();
    public static int formaterror;
    public static boolean doublesize;
    boolean odd;
    public static boolean interlace;
    public static boolean superPAL;
    public String zipinfo = "";
    public int zipcount = 0;
    public boolean showDrive = false;
    protected int flashkey = 0;
    public static int noisecount;
    public float co;
    public float cn;
    public float cm;
    public float cl;
    public int ck;
    public int cj;
    public int ci;
    public int ch = 50;
    public int zoom = 1;
    public static boolean lowperformance;
    public int mouseX;
    public int mouseY;
    int opIndex = 4;
    public static boolean remask;
    public static boolean filter_dosbox;
    public static boolean filter_dosboxb;
    public static boolean filter_eagle;
    public static boolean filter_advmame;
    public static boolean filter_eagle_smooth;
    public static boolean filter_advmame_smooth;
    public static boolean filter_embossed;
    BufferedImage laceimage;
    public static int turbotimer;
    public static int audio;
    public static int fader;
    protected boolean floppyturbo = false;
    public static int skin;
    protected boolean printjob = false;
    final URL sna = this.getClass().getResource("resources/camera.png");
    final Image snaimg = this.getToolkit().getImage(this.sna);
    final URL tap = this.getClass().getResource("resources/cassette.png");
    final Image tapeimg = this.getToolkit().getImage(this.tap);
    final URL driva = this.getClass().getResource("resources/driveAL.png");
    final Image drivea = this.getToolkit().getImage(this.driva);
    final URL driv3a = this.getClass().getResource("resources/driveA.png");
    final Image drive3a = this.getToolkit().getImage(this.driv3a);
    final URL drivb = this.getClass().getResource("resources/driveBL.png");
    final Image driveb = this.getToolkit().getImage(this.drivb);
    final URL driv3b = this.getClass().getResource("resources/driveB.png");
    final Image drive3b = this.getToolkit().getImage(this.driv3b);
    final URL drivam = this.getClass().getResource("resources/c-75.png");
    final Image driveam = this.getToolkit().getImage(this.drivam);
    final URL drivbm = this.getClass().getResource("resources/p-75.png");
    final Image drivebm = this.getToolkit().getImage(this.drivbm);
    final URL dotmat = this.getClass().getResource("dotmask2.png");
    final Image dotmatrix = this.getToolkit().getImage(this.dotmat);
    final URL mobo = this.getClass().getResource("monborder.png");
    public final Image monbord = this.getToolkit().getImage(this.mobo);
    final URL mobo2 = this.getClass().getResource("monborder2.png");
    public final Image monbord2 = this.getToolkit().getImage(this.mobo2);
    final URL cursorim = this.getClass().getResource("image/crosshair.gif");
    final Image lightGun = this.getToolkit().getImage(this.cursorim);
    final Image imagec;
    final boolean debug = true;
    final URL pauses = this.getClass().getResource("image/pause_small.png");
    final Image pauseds = this.getToolkit().getImage(this.pauses);
    final URL forma = this.getClass().getResource("image/formaterror.png");
    final Image formaterr = this.getToolkit().getImage(this.forma);
    final URL pause = this.getClass().getResource("image/pause.png");
    final Image paused = this.getToolkit().getImage(this.pause);
    final URL recym = this.getClass().getResource("image/mix_record.png");
    final Image ymrec = this.getToolkit().getImage(this.recym);
    final URL playym = this.getClass().getResource("image/player_play.png");
    final Image ymplay = this.getToolkit().getImage(this.playym);
    final URL ymmode = this.getClass().getResource("image/ymmode.png");
    final Image YMmode = this.getToolkit().getImage(this.ymmode);
    final URL ymmode2 = this.getClass().getResource("image/cpc.png");
    final Image YMmode2 = this.getToolkit().getImage(this.ymmode2);
    final URL smallball = this.getClass().getResource("image/ball_small.png");
    final Image ball = this.getToolkit().getImage(this.smallball);
    final URL bigball = this.getClass().getResource("image/ball.png");
    final Image ballb = this.getToolkit().getImage(this.bigball);
    final URL bball = this.getClass().getResource("image/ball3.png");
    final Image ballbb = this.getToolkit().getImage(this.bball);
    final URL kplayb = this.getClass().getResource("image/keyplay_big.png");
    final Image playb = this.getToolkit().getImage(this.kplayb);
    final URL krecb = this.getClass().getResource("image/keyrec_big.png");
    final Image recb = this.getToolkit().getImage(this.krecb);
    final URL kplays = this.getClass().getResource("image/keyplay_small.png");
    final Image plays = this.getToolkit().getImage(this.kplays);
    final URL krecs = this.getClass().getResource("image/keyrec_small.png");
    final Image recs = this.getToolkit().getImage(this.krecs);
    final Cursor blankCursor;
    final Cursor gunCursor;
    public static String title;
    public static String author;
    public static String creator;
    long mLastFPSTime;
    int mNextFPS;
    public static int mCurrFPS;
    final URL Mask1 = this.getClass().getResource("2.png");
    final Image mask1 = this.getToolkit().getImage(this.Mask1);
    final URL i3d = this.getClass().getResource("3d.png");
    final Image i3dmask = this.getToolkit().getImage(this.i3d);
    final URL Mask3 = this.getClass().getResource("image/FinalTele5.png");
    final Image mask3 = this.getToolkit().getImage(this.Mask3);
    Image mask = this.mask1;
    public static boolean scaneffect;
    public static boolean horizontal;
    boolean masked = false;
    private static final long serialVersionUID = 1L;
    public static int left;
    public static int right;
    protected boolean scanlines;
    protected boolean drawlines;
    protected boolean showeffect;
    public static int showpause;
    public static Color FADE;
    public static Color LED;
    public static Color GREEN;
    public static Color GREEN_BORDER;
    public static Color LED_BORDER;
    public static Color LED_OFF;
    public static Color WHITEA;
    public static Color BLACKA;
    public static Color SCAN;
    public static Color SCAN_DARK;
    public static Color SCAN_MED;
    public static Color megadark;
    public static Color TRANS;
    public static Color TRANSBLACK;
    public static Color[] RGB;
    int rgbcount = 0;
    public static final Dimension SCALE_1;
    public static final Dimension SCALE_2;
    public static final Dimension SCALE_1x2;
    public static BufferedImage image;
    protected WritableRaster raster;
    protected WritableRaster rasterb;
    protected WritableRaster mameraster;
    public static int[] pixels;
    protected int imageWidth;
    protected int imageHeight;
    protected int scaleWidth;
    protected int scaleHeight;
    protected int scaleW;
    protected int scaleH;
    public static Rectangle imageRect;
    public static Rectangle sourceRect;
    protected boolean sameSize;
    public static boolean painted;
    public int framecount = 0;
    public static boolean truecap;
    boolean halfframe = false;
    public static int initgfxviewer;
    Control MOVControl;
    int oldX;
    int oldY;
    public static boolean record;
    Kernel kernel = new Kernel(3, 3, new float[]{-2.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 2.0f});
    BufferedImageOp op = new ConvolveOp(this.kernel);
    BufferedImage emboss;
    boolean scanl;
    boolean uscanl;
    boolean rasterChanged;
    boolean lowp;
    int pix;
    int cr = 900;
    int cg = 900;
    int cb = 900;
    int cbr = 900;
    boolean up = false;
    boolean old3d;
    public static boolean initcap;
    boolean hadcap = false;
    public static int capX;
    public static int capY;
    public static int capW;
    public static int capH;
    boolean usepixels = false;
    int skip3d;
    int skippixels;
    public static int[] black;
    boolean skip;
    EmbossFilter embossFilter = new EmbossFilter();
    boolean testfilter = true;
    int pixoffset = 0;
    int off;
    boolean togglered;
    int splitrgb;
    double div = 5.0;
    protected int[] mamepixels = new int[104448];
    protected int[] mamepixelsmode0 = new int[52224];
    int CPCpixel = 0;
    int CPC_X_pixel;
    int CPC_Y_pixel;
    boolean pix1;
    boolean pix2;
    boolean pix3;
    boolean pix4;
    int A;
    int B;
    int C;
    int D;
    int E;
    int F;
    int G;
    int H;
    int I;
    int E0;
    int E1;
    int E2;
    int E3;
    int xPixel;
    int yPixel;
    int lum = 30;
    int[] rgb = new int[3];
    int addr;
    int addg;
    int addb;
    int red;
    int green;
    int blue;
    int count = 0;
    final int[] rtable = new int[256];
    final int[] gtable = new int[256];
    final int[] btable = new int[256];
    int m;
    int offset;
    int lastPix;
    public int splud;
    long mPixelFPSTime;
    int mNextPixelFPS;
    public static int mCurrPixelFPS;
    int[] measurePixels;
    int pixelDelay = 0;
    public static int blur;
    public static boolean reverse;
    public static int snow;
    BufferedImage gunImage = new BufferedImage(384, 272, 1);
    double[] glowBuffer = new double[3];
    double glowR;
    double glowG;
    double glowB;
    BufferedImage copimage;
    public GraphicsViewer gfxView;
    boolean ctrl;
    boolean shift;
    public static boolean skipframes;
    public static final float[] BLUR3x3;
    JFrame fram;
    JSlider slide1;
    JSlider slide2;
    public boolean larg;
    int wait = 0;
    public static boolean use3d;
    int screenshot = 0;
    int oldshot;
    int shotindex;
    public boolean doScreening = false;
    int paintedimage;
    int showzoom = 0;
    String zoomfactor = "";
    public boolean threeinch = true;
    public String disk1 = "";
    public String disk2 = "";
    public String disk3 = "";
    public String disk4 = "";
    public String disk5 = "";
    int checkFullScreenBorder;
    boolean redoBorders;
    int screenw;
    int screenh;
    int af;
    public static boolean cancap;
    public static boolean stopcap;
    public static float quality;
    BufferedImage bi = new BufferedImage(384, 272, 2);
    Graphics ge = this.bi.getGraphics();
    float[] scales = new float[]{0.04f, 0.04f, 0.04f, 0.03f};
    float[] offsets = new float[4];
    RescaleOp rop = new RescaleOp(this.scales, this.offsets, null);
    int xpos = 10;
    int xstep;
    boolean cG;
    public float cf;
    public float ce;
    public float cd;
    public float cc;
    public float ca;
    public float b9;
    public float b8;
    ActionListener update = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Display.this.healthLine();
        }
    };
    Timer healthLine = new Timer(250, this.update);

    @Override
    public void repaint() {
    }

    public static void LoadOverlay() {
        if (overlay != null) {
            Display.UnloadOverlay();
            return;
        }
        over.setVisible(true);
        String a = over.getDirectory();
        String b = over.getFile();
        if (b == null) {
            return;
        }
        a = a + b;
        Display.Overlay(a);
    }

    static void Overlay(String a) {
        overfile = a;
        File f = new File(a);
        try {
            BufferedImage buf = ImageIO.read(f);
            overlay = new BufferedImage(384, 272, 2);
            Graphics2D g2 = overlay.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(3, trans.floatValue()));
            System.out.println(trans);
            int xx = 0;
            int yy = 0;
            if (noover) {
                xx = 32;
                yy = 40;
            }
            g2.drawImage(buf, xx, yy, noover ? 320 : 384, noover ? 200 : 272, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void ToggleOver() {
        noover = !noover;
        Display.Overlay(overfile);
    }

    public static void IncTrans() {
        if (trans.floatValue() < 0.975f) {
            trans = Float.valueOf(trans.floatValue() + 0.025f);
            Display.Overlay(overfile);
        }
    }

    public static void DecTrans() {
        if (trans.floatValue() > 0.025f) {
            trans = Float.valueOf(trans.floatValue() - 0.025f);
            Display.Overlay(overfile);
        }
    }

    public static void UnloadOverlay() {
        overlay = null;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (this.curvature != null && use3d) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Display.this.curvature.screen3D.requestFocus();
                }
            });
        }
    }

    public void startcap() {
        Recorder.doMov();
        record = true;
    }

    public void stopcap() {
        record = false;
        Recorder.stopMov();
    }

    public void setImageSize(Dimension size, Dimension scale) {
        this.imageWidth = size.width;
        this.imageHeight = doublesize ? size.height * 2 : size.height;
        if (this.oldX != this.imageWidth || image == null) {
            image = new BufferedImage(this.imageWidth, this.imageHeight, 1);
            this.laceimage = new BufferedImage(this.imageWidth, this.imageHeight, 1);
            image.setAccelerationPriority(1.0f);
            this.laceimage.setAccelerationPriority(1.0f);
        }
        this.oldX = this.imageWidth;
        this.raster = image.getRaster();
        pixels = new int[this.imageWidth * this.imageHeight];
        for (int i = 0; i < pixels.length; ++i) {
            Display.pixels[i] = -16777216;
        }
        if (scale == null) {
            scale = SCALE_1;
        }
        this.scaleWidth = this.imageWidth * scale.width;
        this.scaleHeight = this.imageHeight * scale.height;
        this.scaleW = this.scaleWidth;
        this.scaleH = this.scaleHeight;
        this.checkSize();
        Graphics g = this.getGraphics();
        if (g != null) {
            size = this.getSize();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            this.paint(g);
            g.dispose();
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.curvature != null) {
            this.curvature.setBounds(x, y, width, height);
        }
        this.checkSize();
    }

    protected void checkDouble() {
        if (Switches.doublesize) {
            this.scaleWidth = this.scaleW * 2;
            this.scaleHeight = doublesize ? this.scaleH : this.scaleH * 2;
        }
        if (Switches.triplesize) {
            this.scaleWidth = this.scaleW * 3;
            this.scaleHeight = doublesize ? this.scaleH * 3 / 2 : this.scaleH * 3;
        }
        if (!Switches.triplesize && !Switches.doublesize) {
            this.scaleWidth = this.scaleW;
            this.scaleHeight = doublesize ? this.scaleH / 2 : this.scaleH;
        }
    }

    public void setCursor() {
        if (Switches.lightGun) {
            this.setCursor(this.gunCursor);
        } else if (Desktop.hideMouse.isSelected()) {
            this.setCursor(this.blankCursor);
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void changePerformance() {
        this.copimage = null;
        this.mask = Switches.mask ? this.mask3 : this.mask1;
        if (lowperformance) {
            LED = new Color(255, 0, 0);
            GREEN = new Color(0, 255, 0);
            GREEN_BORDER = new Color(0, 144, 0);
            LED_BORDER = new Color(144, 0, 0);
            SCAN = new Color(0, 0, 0);
            TRANS = new Color(255, 255, 255);
            TRANSBLACK = new Color(0, 0, 0);
        } else {
            LED = new Color(255, 0, 0, 64);
            GREEN = new Color(0, 255, 0, 64);
            GREEN_BORDER = new Color(0, 144, 0, 64);
            LED_BORDER = new Color(144, 0, 0, 64);
            TRANS = new Color(255, 255, 255, 176);
            TRANSBLACK = new Color(0, 0, 0, 64);
            SCAN = Switches.monitormode == 0 || Switches.monitormode == 1 || Switches.monitormode == 5 ? new Color(0, 0, 0, 80) : new Color(0, 0, 0, 80);
        }
    }

    protected void checkSize() {
        this.checkDouble();
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        int clientWidth = size.width - insets.left - insets.right;
        int clientHeight = size.height - insets.top - insets.bottom;
        if (Switches.stretch) {
            imageRect = new Rectangle(insets.left + (clientWidth - this.scaleWidth) / 2, insets.top + (clientHeight - this.scaleHeight) / 2, this.scaleWidth, this.scaleHeight);
        } else {
            imageRect = new Rectangle(insets.left, insets.top, clientWidth, clientHeight);
            this.sameSize = Display.imageRect.width == this.imageWidth && Display.imageRect.height == this.imageHeight;
        }
    }

    public int[] getPixels() {
        return pixels;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, y);
        if (this.curvature != null) {
            this.curvature.setSize(x, y);
        }
        this.setPreferredSize(new Dimension(x, y));
    }

    @Override
    public void setPreferredSize(Dimension d) {
        super.setPreferredSize(d);
        if (this.curvature != null) {
            this.curvature.setPreferredSize(d);
        }
    }

    public Display() {
        int[] pixelsc = new int[256];
        this.usepixels = Settings.getBoolean("3d_acceleration", false);
        this.imagec = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixelsc, 0, 16));
        this.blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.imagec, new Point(0, 0), "invisibleCursor");
        this.gunCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.lightGun, new Point(15, 15), "gunCursor");
        this.enableEvents(4L);
        this.setFocusTraversalKeysEnabled(false);
        this.setRequestFocusEnabled(true);
        this.setDoubleBuffered(true);
        this.healthLine.start();
    }

    public void setSourceRect(Rectangle value) {
        sourceRect = value;
    }

    public void doPixelFPS() {
        long time = System.currentTimeMillis();
        ++this.mNextPixelFPS;
        if (time - this.mPixelFPSTime >= 1000L) {
            mCurrPixelFPS = this.mNextPixelFPS;
            this.mNextPixelFPS = 0;
            this.mPixelFPSTime = time;
        }
    }

    public void measurePixelSpeed() {
        if (pixels == null) {
            return;
        }
        if (this.measurePixels == null) {
            this.measurePixels = new int[pixels.length];
        }
        for (int i = 0; i < this.measurePixels.length; i += 2) {
            if (this.measurePixels[i] == pixels[i]) continue;
            this.doPixelFPS();
            this.pixelDelay = 0;
            break;
        }
        ++this.pixelDelay;
        if (this.pixelDelay > 100) {
            this.pixelDelay = 0;
            if (mCurrPixelFPS > 0) {
                mCurrPixelFPS = 0;
            }
        }
        System.arraycopy(pixels, 0, this.measurePixels, 0, this.measurePixels.length);
    }

    public void updateImage(boolean wait) {
        if (CPC.YM_Play && use3d && !this.usepixels) {
            ++this.skip3d;
            if (this.skip3d < 4) {
                this.balls(this.ge, this.driveam, this.drivebm, this.driveam);
                this.balls(this.ge, this.driveam, this.drivebm, this.driveam);
                this.balls(this.ge, this.driveam, this.drivebm, this.driveam);
                this.doTouchFPS();
                painted = true;
                return;
            }
            this.skip3d = 0;
        }
        if (this.hadcap != initcap) {
            this.hadcap = initcap;
            if (this.hadcap) {
                int[] area = GateArray.cpc.getGateArray().getField();
                capX = area[0];
                capY = area[2];
                capW = area[1] - area[0];
                capH = area[3] - area[2];
                System.out.println(capX + "," + capY + "," + capW + "," + capH);
            }
        }
        if (initcap) {
            if (doublesize) {
                this.checkOutput();
            }
            this.checkInterlace();
            this.raster.setDataElements(0, 0, this.imageWidth, this.imageHeight, pixels);
            this.measurePixelSpeed();
            Graphics2D p = image.createGraphics();
            p.setColor(new Color(Util.random(255), Util.random(255), Util.random(255), 180));
            p.drawRect(capX, capY, capW, capH);
            this.repaint(0L, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height);
            return;
        }
        if (this.old3d != use3d) {
            System.out.println("Display changed to " + (use3d ? "3d display" : "2d display"));
            this.old3d = use3d;
            painted = true;
        }
        if (!painted) {
            return;
        }
        if (Desktop.level.isShowing() && filter_dosboxb != Desktop.level.isEnabled()) {
            Desktop.level.setEnabled(filter_dosboxb);
        }
        if (this.cr != this.addr) {
            this.cr = this.addr;
            this.up = true;
        }
        if (this.cg != this.addg) {
            this.cg = this.addg;
            this.up = true;
        }
        if (this.cb != this.addb) {
            this.cb = this.addb;
            this.up = true;
        }
        if (this.cbr != fader) {
            this.cbr = fader;
            this.up = true;
        }
        if (this.up) {
            this.init();
        }
        this.up = false;
        ++this.count;
        if (this.count == 5) {
            try {
                this.count = 0;
                if (this.addr != Desktop.red.getValue()) {
                    this.addr = Desktop.red.getValue();
                }
                if (this.addg != Desktop.green.getValue()) {
                    this.addg = Desktop.green.getValue();
                }
                if (this.addb != Desktop.blue.getValue()) {
                    this.addb = Desktop.blue.getValue();
                }
            }
            catch (Exception p) {
                // empty catch block
            }
        }
        if (Desktop.brenabled) {
            for (int i = 0; i < pixels.length; ++i) {
                Display.pixels[i] = this.putRGB(pixels[i]);
            }
        }
        painted = false;
        if (Display.imageRect.width != 0 && Display.imageRect.height != 0 && (this.isVisible() || this.curvature.isVisible())) {
            if (doublesize) {
                this.checkOutput();
            }
            this.checkInterlace();
            this.raster.setDataElements(0, 0, this.imageWidth, this.imageHeight, pixels);
            this.measurePixelSpeed();
            if (filter_embossed) {
                this.embossFilter.filter(image, image);
            }
            if (this.showtape > 0) {
                Graphics2D g = image.createGraphics();
                --this.showtape;
                g.drawImage(this.tapeimg, 128, 50, null);
                g.setFont(new Font("Monospaced", 1, 18));
                g.setColor(new Color(0, 0, 0, 200));
                ((Graphics)g).drawString(this.disk1, 168, 212);
                ((Graphics)g).drawString(this.disk2, 168, 235);
                g.setFont(new Font("Arial", 1, 26));
                ((Graphics)g).drawString(this.disk5, 420, 361);
            }
            if (this.showsna > 0) {
                Graphics2D g = image.createGraphics();
                --this.showsna;
                g.drawImage(this.snaimg, 128, 50, null);
            }
            if (this.showdrives > 0) {
                int i;
                Graphics2D g = image.createGraphics();
                --this.showdrives;
                if (JEMU.toDriveB) {
                    if (this.threeinch) {
                        g.drawImage(this.drive3b, 380, 40, null);
                        g.setFont(new Font("Monospaced", 1, 16));
                        g.setColor(new Color(0, 0, 0, 200));
                        ((Graphics)g).drawString(this.disk1, 408, 394);
                        ((Graphics)g).drawString(this.disk2, 408, 412);
                        ((Graphics)g).drawString(this.disk3, 408, 430);
                    } else {
                        g.drawImage(this.driveb, 380, 100, null);
                        g.setFont(new Font("Monospaced", 1, 18));
                        g.setColor(new Color(0, 0, 0, 200));
                        i = 272;
                        ((Graphics)g).drawString(this.disk1, 424, i += 25);
                        ((Graphics)g).drawString(this.disk2, 424, i += 25);
                        ((Graphics)g).drawString(this.disk3, 424, i += 25);
                        ((Graphics)g).drawString(this.disk4, 424, i += 25);
                        ((Graphics)g).drawString(this.disk5, 424, i += 25);
                    }
                } else if (this.threeinch) {
                    g.drawImage(this.drive3a, 20, 40, null);
                    g.setFont(new Font("Monospaced", 1, 16));
                    g.setColor(new Color(0, 0, 0, 200));
                    ((Graphics)g).drawString(this.disk1, 48, 394);
                    ((Graphics)g).drawString(this.disk2, 48, 412);
                    ((Graphics)g).drawString(this.disk3, 48, 430);
                } else {
                    g.drawImage(this.drivea, 20, 100, null);
                    g.setFont(new Font("Monospaced", 1, 18));
                    g.setColor(new Color(0, 0, 0, 200));
                    i = 272;
                    ((Graphics)g).drawString(this.disk1, 64, i += 25);
                    ((Graphics)g).drawString(this.disk2, 64, i += 25);
                    ((Graphics)g).drawString(this.disk3, 64, i += 25);
                    ((Graphics)g).drawString(this.disk4, 64, i += 25);
                    ((Graphics)g).drawString(this.disk5, 64, i += 25);
                }
            }
        }
        if (use3d && this.curvature != null && this.usepixels) {
            if (scaneffect && !lowperformance) {
                this.showeffect = true;
                this.masked = false;
            } else {
                this.showeffect = false;
                this.masked = false;
            }
            StatusPanel.fps.setText("" + mCurrFPS + ":" + mCurrPixelFPS);
            if (superPAL) {
                ConvolveOp cop = new ConvolveOp(new Kernel(3, 3, BLUR3x3), 1, null);
                this.checkCOPimage();
                Graphics2D g3 = this.copimage.createGraphics();
                g3.drawImage(image, cop, 0, 0);
                image.getGraphics().drawImage(this.copimage, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height, null);
            }
            if (skipframes) {
                boolean bl = this.skip = !this.skip;
            }
            if (!this.skip) {
                this.curvature.update(pixels, this.showeffect);
            } else {
                painted = true;
            }
        } else if (use3d && this.curvature != null && !this.usepixels) {
            this.repaint(0L, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height);
            this.paintImage(image.getGraphics());
            this.curvature.update(image, scaneffect);
        } else {
            this.repaint(0L, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height);
        }
        try {
            if (record || CPC.playSNP || CPC.StoreSNP || !doublesize && wait || ScreenCapture.record && ScreenCapture.vsync.isSelected()) {
                this.waitPainted();
            }
        }
        catch (Exception cop) {
            // empty catch block
        }
        this.doTouchFPS();
        if (!use3d) {
            if (black == null || black.length != pixels.length) {
                black = new int[pixels.length];
                for (int i = 0; i < black.length; ++i) {
                    Display.black[i] = 0;
                }
            }
            System.arraycopy(black, 0, pixels, 0, black.length);
        }
    }

    protected void checkOutput() {
        int i;
        if (lowperformance != this.lowp) {
            for (i = 0; i < pixels.length; ++i) {
                Display.pixels[i] = 0;
            }
            this.lowp = lowperformance;
        }
        if (lowperformance) {
            this.fullRender();
            return;
        }
        if (JEMU.large) {
            if (filter_advmame) {
                this.AdvMameFilter2x(false);
                if (PAL) {
                    this.PALRender();
                }
            } else if (filter_advmame_smooth) {
                this.AdvMameFilter2x(true);
                if (PAL) {
                    this.PALRender();
                }
            } else if (filter_eagle) {
                this.EagleFilter2x(false);
                if (PAL) {
                    this.PALRender();
                }
            } else if (filter_eagle_smooth) {
                this.EagleFilter2x(true);
                if (PAL) {
                    this.PALRender();
                }
            } else if (filter_dosbox) {
                this.CRTFilter3();
                if (PAL) {
                    this.PALRender();
                }
            } else if (filter_dosboxb) {
                this.CRTFilter2();
                if (PAL) {
                    this.PALRender();
                }
            } else if (!PAL) {
                this.fullRender();
            } else {
                this.PALRender();
            }
        } else {
            this.fullRender();
            if (PAL) {
                this.PALRender();
            }
        }
        if (pixels != null && this.scanl != this.scanlines) {
            for (i = 0; i < pixels.length; ++i) {
                Display.pixels[i] = 0;
            }
            this.scanl = this.scanlines;
        }
        if (pixels != null && this.uscanl != filter_dosboxb && this.uscanl != filter_dosbox) {
            for (i = 0; i < pixels.length; ++i) {
                Display.pixels[i] = 0;
            }
            this.uscanl = filter_dosbox;
        }
        if (pixels != null && this.uscanl != filter_dosboxb && this.uscanl != filter_dosbox) {
            for (i = 0; i < pixels.length; ++i) {
                Display.pixels[i] = 0;
            }
            this.uscanl = filter_dosboxb;
        }
        if (pixels != null && this.pix != this.zoom) {
            for (i = 0; i < pixels.length; ++i) {
                Display.pixels[i] = 0;
            }
            this.pix = this.zoom;
        }
    }

    protected void checkInterlace() {
        if (interlace) {
            this.rasterChanged = true;
            if (this.odd) {
                this.raster = this.laceimage.getRaster();
                this.odd = false;
            } else {
                this.raster = image.getRaster();
                this.odd = true;
            }
        } else if (this.rasterChanged) {
            this.raster = image.getRaster();
            this.rasterChanged = false;
        }
    }

    protected void CRTFilter() {
        try {
            Thread.yield();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int x = 0; x < this.imageWidth; ++x) {
            ++this.splitrgb;
            if (this.splitrgb > 3) {
                this.splitrgb = 0;
            }
            this.off = x;
            for (int y = 0; y < this.imageHeight; y += 2) {
                this.getRGB(pixels[this.off], this.rgb);
                switch (this.splitrgb) {
                    case 0: {
                        Display.pixels[this.off] = this.putRGB(this.rgb[0], (int)((double)this.rgb[1] / this.div), (int)((double)this.rgb[2] / this.div));
                        break;
                    }
                    case 1: {
                        Display.pixels[this.off] = this.putRGB((int)((double)this.rgb[0] / this.div), this.rgb[1], (int)((double)this.rgb[2] / this.div));
                        break;
                    }
                    case 2: {
                        Display.pixels[this.off] = this.putRGB((int)((double)this.rgb[0] / this.div), (int)((double)this.rgb[1] / this.div), this.rgb[2]);
                        break;
                    }
                    case 3: {
                        Display.pixels[this.off] = this.putRGB((int)((double)this.rgb[0] / this.div), (int)((double)this.rgb[1] / this.div), (int)((double)this.rgb[2] / this.div));
                    }
                }
                Display.pixels[this.off + this.imageWidth] = pixels[this.off];
                this.off += this.imageWidth * 2;
            }
        }
    }

    protected void CRTFilter4() {
        try {
            Thread.yield();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int x = 0; x < this.imageWidth; x += 2) {
            this.off = x;
            for (int y = 0; y < this.imageHeight; y += 2) {
                this.togglered = !this.togglered;
                Display.pixels[this.off + this.imageWidth + 1] = pixels[this.off + 1] & 0xFF00;
                Display.pixels[this.off + this.imageWidth] = pixels[this.off] & 0xFF;
                if (this.togglered) {
                    Display.pixels[this.off] = pixels[this.off] & 0xFF0000;
                } else {
                    Display.pixels[this.off + 1] = pixels[this.off + 1] & 0xFF0000;
                }
                this.off += this.imageWidth * 2;
            }
        }
    }

    protected void AdvMameFilter2x(boolean smooth) {
        this.scaleDown();
        this.yPixel = 1;
        while (this.yPixel < 271) {
            this.xPixel = 1;
            while (this.xPixel < 383) {
                this.A = this.mamepixels[(this.yPixel - 1) * 384 + this.xPixel - 1];
                this.B = this.mamepixels[(this.yPixel - 1) * 384 + this.xPixel];
                this.C = this.mamepixels[(this.yPixel - 1) * 384 + this.xPixel + 1];
                this.D = this.mamepixels[this.yPixel * 384 + this.xPixel - 1];
                this.E = this.mamepixels[this.yPixel * 384 + this.xPixel];
                this.F = this.mamepixels[this.yPixel * 384 + this.xPixel + 1];
                this.G = this.mamepixels[(this.yPixel + 1) * 384 + this.xPixel - 1];
                this.H = this.mamepixels[(this.yPixel + 1) * 384 + this.xPixel];
                this.I = this.mamepixels[(this.yPixel + 1) * 384 + this.xPixel + 1];
                this.E0 = this.yPixel * 1536 + (this.xPixel << 1);
                this.E1 = this.E0 + 1;
                this.E2 = this.E0 + 768;
                this.E3 = this.E2 + 1;
                if (this.B != this.H && this.D != this.F) {
                    this.pix1 = this.D == this.B;
                    this.pix2 = this.B == this.F;
                    this.pix3 = this.D == this.H;
                    boolean bl = this.pix4 = this.F == this.H;
                    if (smooth) {
                        this.getRGB(this.E, this.rgb);
                        int r = this.rgb[0];
                        int g = this.rgb[1];
                        int b = this.rgb[2];
                        this.getRGB(this.D, this.rgb);
                        int ra = this.rgb[0];
                        int rg = this.rgb[1];
                        int rb = this.rgb[2];
                        ra = (r + ra) / 2;
                        rg = (g + rg) / 2;
                        rb = (b + rb) / 2;
                        this.D = this.putRGB(ra, rg, rb);
                        this.getRGB(this.F, this.rgb);
                        ra = this.rgb[0];
                        rg = this.rgb[1];
                        rb = this.rgb[2];
                        ra = (r + ra) / 2;
                        rg = (g + rg) / 2;
                        rb = (b + rb) / 2;
                        this.F = this.putRGB(ra, rg, rb);
                    }
                    Display.pixels[this.E0] = this.pix1 ? this.D : this.E;
                    Display.pixels[this.E1] = this.pix2 ? this.F : this.E;
                    Display.pixels[this.E2] = this.pix3 ? this.D : this.E;
                    Display.pixels[this.E3] = this.pix4 ? this.F : this.E;
                } else {
                    Display.pixels[this.E0] = this.E;
                    Display.pixels[this.E1] = this.E;
                    Display.pixels[this.E2] = this.E;
                    Display.pixels[this.E3] = this.E;
                }
                ++this.xPixel;
            }
            ++this.yPixel;
        }
    }

    protected void AdvMameFilterMode0(boolean smooth) {
        this.yPixel = 1;
        while (this.yPixel < 271) {
            this.xPixel = 1;
            while (this.xPixel < 191) {
                this.A = this.mamepixelsmode0[(this.yPixel - 1) * 192 + this.xPixel - 1];
                this.B = this.mamepixelsmode0[(this.yPixel - 1) * 192 + this.xPixel];
                this.C = this.mamepixelsmode0[(this.yPixel - 1) * 192 + this.xPixel + 1];
                this.D = this.mamepixelsmode0[this.yPixel * 192 + this.xPixel - 1];
                this.E = this.mamepixelsmode0[this.yPixel * 192 + this.xPixel];
                this.F = this.mamepixelsmode0[this.yPixel * 192 + this.xPixel + 1];
                this.G = this.mamepixelsmode0[(this.yPixel + 1) * 192 + this.xPixel - 1];
                this.H = this.mamepixelsmode0[(this.yPixel + 1) * 192 + this.xPixel];
                this.I = this.mamepixelsmode0[(this.yPixel + 1) * 192 + this.xPixel + 1];
                this.E0 = this.yPixel * 384 + (this.xPixel << 1);
                this.E1 = this.E0 + 1;
                if (this.B != this.H && this.D != this.F) {
                    this.pix1 = this.D == this.B;
                    this.pix2 = this.B == this.F;
                    this.pix3 = this.D == this.H;
                    boolean bl = this.pix4 = this.F == this.H;
                    if (smooth) {
                        this.getRGB(this.E, this.rgb);
                        int r = this.rgb[0];
                        int g = this.rgb[1];
                        int b = this.rgb[2];
                        this.getRGB(this.D, this.rgb);
                        int ra = this.rgb[0];
                        int rg = this.rgb[1];
                        int rb = this.rgb[2];
                        ra = (r + ra) / 2;
                        rg = (g + rg) / 2;
                        rb = (b + rb) / 2;
                        this.D = this.putRGB(ra, rg, rb);
                        this.getRGB(this.F, this.rgb);
                        ra = this.rgb[0];
                        rg = this.rgb[1];
                        rb = this.rgb[2];
                        ra = (r + ra) / 2;
                        rg = (g + rg) / 2;
                        rb = (b + rb) / 2;
                        this.F = this.putRGB(ra, rg, rb);
                    }
                    this.mamepixels[this.E0] = this.pix1 ? this.D : this.E;
                    this.mamepixels[this.E1] = this.pix2 ? this.F : this.E;
                } else {
                    this.mamepixels[this.E0] = this.E;
                    this.mamepixels[this.E1] = this.E;
                }
                ++this.xPixel;
            }
            ++this.yPixel;
        }
    }

    protected void EagleFilter2x(boolean smooth) {
        this.scaleDown();
        this.yPixel = 1;
        while (this.yPixel < 271) {
            this.xPixel = 1;
            while (this.xPixel < 383) {
                this.A = this.mamepixels[(this.yPixel - 1) * 384 + this.xPixel - 1];
                this.B = this.mamepixels[(this.yPixel - 1) * 384 + this.xPixel];
                this.C = this.mamepixels[(this.yPixel - 1) * 384 + this.xPixel + 1];
                this.D = this.mamepixels[this.yPixel * 384 + this.xPixel - 1];
                this.E = this.mamepixels[this.yPixel * 384 + this.xPixel];
                this.F = this.mamepixels[this.yPixel * 384 + this.xPixel + 1];
                this.G = this.mamepixels[(this.yPixel + 1) * 384 + this.xPixel - 1];
                this.H = this.mamepixels[(this.yPixel + 1) * 384 + this.xPixel];
                this.I = this.mamepixels[(this.yPixel + 1) * 384 + this.xPixel + 1];
                this.E0 = this.yPixel * 1536 + (this.xPixel << 1);
                this.E1 = this.E0 + 1;
                this.E2 = this.E0 + 768;
                this.E3 = this.E2 + 1;
                this.pix1 = this.D == this.A && this.A == this.B;
                this.pix2 = this.B == this.C && this.C == this.F;
                this.pix3 = this.D == this.G && this.G == this.H;
                boolean bl = this.pix4 = this.F == this.I && this.I == this.H;
                if (smooth) {
                    this.getRGB(this.E, this.rgb);
                    int r = this.rgb[0];
                    int g = this.rgb[1];
                    int b = this.rgb[2];
                    this.getRGB(this.A, this.rgb);
                    int ra = this.rgb[0];
                    int rg = this.rgb[1];
                    int rb = this.rgb[2];
                    ra = (r + ra) / 2;
                    rg = (g + rg) / 2;
                    rb = (b + rb) / 2;
                    this.A = this.putRGB(ra, rg, rb);
                    this.getRGB(this.C, this.rgb);
                    ra = this.rgb[0];
                    rg = this.rgb[1];
                    rb = this.rgb[2];
                    ra = (r + ra) / 2;
                    rg = (g + rg) / 2;
                    rb = (b + rb) / 2;
                    this.C = this.putRGB(ra, rg, rb);
                    this.getRGB(this.G, this.rgb);
                    ra = this.rgb[0];
                    rg = this.rgb[1];
                    rb = this.rgb[2];
                    ra = (r + ra) / 2;
                    rg = (g + rg) / 2;
                    rb = (b + rb) / 2;
                    this.G = this.putRGB(ra, rg, rb);
                    this.getRGB(this.I, this.rgb);
                    ra = this.rgb[0];
                    rg = this.rgb[1];
                    rb = this.rgb[2];
                    ra = (r + ra) / 2;
                    rg = (g + rg) / 2;
                    rb = (b + rb) / 2;
                    this.I = this.putRGB(ra, rg, rb);
                }
                Display.pixels[this.E0] = this.pix1 ? this.A : this.E;
                Display.pixels[this.E1] = this.pix2 ? this.C : this.E;
                Display.pixels[this.E2] = this.pix3 ? this.G : this.E;
                Display.pixels[this.E3] = this.pix4 ? this.I : this.E;
                ++this.xPixel;
            }
            ++this.yPixel;
        }
    }

    protected void EagleFilterMode0(boolean smooth) {
        this.yPixel = 1;
        while (this.yPixel < 271) {
            this.xPixel = 1;
            while (this.xPixel < 191) {
                this.A = this.mamepixelsmode0[(this.yPixel - 1) * 192 + this.xPixel - 1];
                this.B = this.mamepixelsmode0[(this.yPixel - 1) * 192 + this.xPixel];
                this.C = this.mamepixelsmode0[(this.yPixel - 1) * 192 + this.xPixel + 1];
                this.D = this.mamepixelsmode0[this.yPixel * 192 + this.xPixel - 1];
                this.E = this.mamepixelsmode0[this.yPixel * 192 + this.xPixel];
                this.F = this.mamepixelsmode0[this.yPixel * 192 + this.xPixel + 1];
                this.G = this.mamepixelsmode0[(this.yPixel + 1) * 192 + this.xPixel - 1];
                this.H = this.mamepixelsmode0[(this.yPixel + 1) * 192 + this.xPixel];
                this.I = this.mamepixelsmode0[(this.yPixel + 1) * 192 + this.xPixel + 1];
                this.E0 = this.yPixel * 384 + (this.xPixel << 1);
                this.E1 = this.E0 + 1;
                this.pix1 = this.D == this.A && this.A == this.B;
                this.pix2 = this.B == this.C && this.C == this.F;
                this.pix3 = this.D == this.G && this.G == this.H;
                boolean bl = this.pix4 = this.F == this.I && this.I == this.H;
                if (smooth) {
                    this.getRGB(this.E, this.rgb);
                    int r = this.rgb[0];
                    int g = this.rgb[1];
                    int b = this.rgb[2];
                    this.getRGB(this.A, this.rgb);
                    int ra = this.rgb[0];
                    int rg = this.rgb[1];
                    int rb = this.rgb[2];
                    ra = (r + ra) / 2;
                    rg = (g + rg) / 2;
                    rb = (b + rb) / 2;
                    this.A = this.putRGB(ra, rg, rb);
                    this.getRGB(this.C, this.rgb);
                    ra = this.rgb[0];
                    rg = this.rgb[1];
                    rb = this.rgb[2];
                    ra = (r + ra) / 2;
                    rg = (g + rg) / 2;
                    rb = (b + rb) / 2;
                    this.C = this.putRGB(ra, rg, rb);
                    this.getRGB(this.G, this.rgb);
                    ra = this.rgb[0];
                    rg = this.rgb[1];
                    rb = this.rgb[2];
                    ra = (r + ra) / 2;
                    rg = (g + rg) / 2;
                    rb = (b + rb) / 2;
                    this.G = this.putRGB(ra, rg, rb);
                    this.getRGB(this.I, this.rgb);
                    ra = this.rgb[0];
                    rg = this.rgb[1];
                    rb = this.rgb[2];
                    ra = (r + ra) / 2;
                    rg = (g + rg) / 2;
                    rb = (b + rb) / 2;
                    this.I = this.putRGB(ra, rg, rb);
                }
                this.mamepixels[this.E0] = this.pix1 ? this.A : this.E;
                this.mamepixels[this.E1] = this.pix2 ? this.C : this.E;
                ++this.xPixel;
            }
            ++this.yPixel;
        }
    }

    protected void scaleDown() {
        this.CPCpixel = 0;
        this.CPC_Y_pixel = 0;
        while (this.CPC_Y_pixel < 544) {
            this.CPC_X_pixel = 0;
            while (this.CPC_X_pixel < 768) {
                this.mamepixels[this.CPCpixel++] = pixels[this.CPC_X_pixel + this.CPC_Y_pixel * 768];
                this.CPC_X_pixel += 2;
            }
            this.CPC_Y_pixel += 2;
        }
    }

    protected void scaleDownEagle(boolean smooth) {
        this.CPCpixel = 0;
        int width = GateArray.getSMode() == 0 ? 384 : 768;
        this.CPC_Y_pixel = 0;
        while (this.CPC_Y_pixel < 544) {
            this.CPC_X_pixel = 0;
            while (this.CPC_X_pixel < 768) {
                if (width == 384) {
                    this.mamepixelsmode0[this.CPCpixel++] = pixels[this.CPC_X_pixel + this.CPC_Y_pixel * 768];
                } else {
                    this.mamepixels[this.CPCpixel++] = pixels[this.CPC_X_pixel + this.CPC_Y_pixel * 768];
                }
                this.CPC_X_pixel += width == 384 ? 4 : 2;
            }
            this.CPC_Y_pixel += 2;
        }
        if (width == 384) {
            this.EagleFilterMode0(smooth);
        }
    }

    protected void scaleDownAdvMame(boolean smooth) {
        this.CPCpixel = 0;
        int width = GateArray.getSMode() == 0 ? 384 : 768;
        this.CPC_Y_pixel = 0;
        while (this.CPC_Y_pixel < 544) {
            this.CPC_X_pixel = 0;
            while (this.CPC_X_pixel < 768) {
                if (width == 384) {
                    this.mamepixelsmode0[this.CPCpixel++] = pixels[this.CPC_X_pixel + this.CPC_Y_pixel * 768];
                } else {
                    this.mamepixels[this.CPCpixel++] = pixels[this.CPC_X_pixel + this.CPC_Y_pixel * 768];
                }
                this.CPC_X_pixel += width == 384 ? 4 : 2;
            }
            this.CPC_Y_pixel += 2;
        }
        if (width == 384) {
            this.AdvMameFilterMode0(smooth);
        }
    }

    protected void RGBFilter2x() {
        for (int x = 0; x < this.imageWidth; x += 2) {
            this.off = x;
            for (int y = 0; y < this.imageHeight; y += 2) {
                this.getRGB(pixels[this.off], this.rgb);
                if (this.rgb[0] == 0) {
                    this.rgb[0] = this.lum;
                }
                if (this.rgb[1] == 0) {
                    this.rgb[1] = this.lum;
                }
                if (this.rgb[2] == 0) {
                    this.rgb[2] = this.lum;
                }
                Display.pixels[this.off + this.imageWidth + 1] = pixels[this.off + 1];
                Display.pixels[this.off + this.imageWidth] = this.putRGB((int)((double)this.rgb[0] / this.div), (int)((double)this.rgb[1] / this.div), this.rgb[2]);
                Display.pixels[this.off] = this.putRGB(this.rgb[0], (int)((double)this.rgb[1] / this.div), (int)((double)this.rgb[2] / this.div));
                this.getRGB(pixels[this.off + 1], this.rgb);
                if (this.rgb[0] == 0) {
                    this.rgb[0] = this.lum;
                }
                if (this.rgb[1] == 0) {
                    this.rgb[1] = this.lum;
                }
                if (this.rgb[2] == 0) {
                    this.rgb[2] = this.lum;
                }
                Display.pixels[this.off + 1] = this.putRGB((int)((double)this.rgb[0] / this.div), (int)((double)this.rgb[1] / this.div), (int)((double)this.rgb[0] / this.div));
                this.off += this.imageWidth * 2;
            }
        }
    }

    protected void CRTFilter2() {
        for (int x = 0; x < this.imageWidth; x += 2) {
            this.off = x;
            this.div = (double)Desktop.level.getValue() / 10.0;
            for (int y = 0; y < this.imageHeight; y += 2) {
                this.getRGB(pixels[this.off], this.rgb);
                Display.pixels[this.off + this.imageWidth + 1] = pixels[this.off + 1];
                Display.pixels[this.off + this.imageWidth] = this.putRGB((int)((double)this.rgb[0] / this.div), (int)((double)this.rgb[1] / this.div), this.rgb[2]);
                Display.pixels[this.off] = this.putRGB(this.rgb[0], (int)((double)this.rgb[1] / this.div), (int)((double)this.rgb[2] / this.div));
                Display.pixels[this.off + 1] = this.putRGB((int)((double)this.rgb[0] / this.div), this.rgb[1], (int)((double)this.rgb[2] / this.div));
                this.off += this.imageWidth * 2;
            }
        }
    }

    protected void CRTFilter3() {
        for (int x = 0; x < this.imageWidth; x += 2) {
            this.off = x;
            for (int y = 0; y < this.imageHeight; y += 2) {
                Display.pixels[this.off + this.imageWidth + 1] = pixels[this.off + 1];
                Display.pixels[this.off + this.imageWidth] = pixels[this.off] & 0xFF;
                Display.pixels[this.off] = pixels[this.off] & 0xFF0000;
                Display.pixels[this.off + 1] = pixels[this.off + 1] & 0xFF00;
                this.off += this.imageWidth * 2;
            }
        }
    }

    public void getRGB(int value, int[] rgb) {
        rgb[0] = value >> 16 & 0xFF;
        rgb[1] = value >> 8 & 0xFF;
        rgb[2] = value & 0xFF;
    }

    protected void getRGB(int value, double[] rgb) {
        rgb[0] = value >> 16 & 0xFF;
        rgb[1] = value >> 8 & 0xFF;
        rgb[2] = value & 0xFF;
    }

    public void init() {
        for (int i = 0; i < 256; ++i) {
            int nr = i;
            if ((nr += this.addr + fader) < 0) {
                nr = 0;
            } else if (nr > 255) {
                nr = 255;
            }
            this.rtable[i] = nr;
            nr = i;
            if ((nr += this.addg + fader) < 0) {
                nr = 0;
            } else if (nr > 255) {
                nr = 255;
            }
            this.gtable[i] = nr;
            nr = i;
            if ((nr += this.addb + fader) < 0) {
                nr = 0;
            } else if (nr > 255) {
                nr = 255;
            }
            this.btable[i] = nr;
        }
    }

    public int putRGB(int red, int green, int blue) {
        return red << 16 | green << 8 | blue;
    }

    public int putRGB(int[] rgb) {
        return rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    public int putRGB(int input) {
        this.red = input >> 16 & 0xFF;
        this.green = input >> 8 & 0xFF;
        this.blue = input & 0xFF;
        this.red = this.rtable[this.red];
        this.green = this.gtable[this.green];
        this.blue = this.btable[this.blue];
        input = this.red << 16 | this.green << 8 | this.blue;
        return input;
    }

    protected void fullRender() {
        --this.splud;
        if (this.splud < 1) {
            this.splud = 0;
            if (!this.drawlines || !JEMU.large) {
                for (int lines = 0; lines < this.imageHeight; lines += 2) {
                    System.arraycopy(pixels, lines * this.imageWidth, pixels, (lines + 1) * this.imageWidth, this.imageWidth);
                }
            }
        }
    }

    protected void PALRender() {
        block21: {
            int x;
            int y;
            int i;
            block20: {
                block19: {
                    for (i = 0; i < pixels.length; i += 2) {
                        Display.pixels[i] = this.glow(pixels[i], 0.75);
                    }
                    if (snow < 124) {
                        for (i = 0; i < pixels.length; i += Util.random(snow)) {
                            Display.pixels[i] = this.glow(pixels[i], Math.random());
                        }
                    }
                    if (filter_dosbox) break block19;
                    if (filter_dosboxb) break block19;
                    if (filter_advmame) break block19;
                    if (filter_eagle) break block19;
                    if (filter_advmame_smooth) break block19;
                    if (!filter_eagle_smooth) break block20;
                }
                if (!reverse) {
                    for (i = 0; i < blur; ++i) {
                        this.off = 0;
                        while (this.off < pixels.length) {
                            this.lastPix = Display.pixels[this.off] = (this.lastPix & 0xFEFEFE) + (pixels[this.off] & 0xFEFEFE) >> 1;
                            ++this.off;
                        }
                    }
                } else {
                    for (i = 0; i < blur; ++i) {
                        this.off = pixels.length - 1;
                        while (this.off > -1) {
                            this.lastPix = Display.pixels[this.off] = (this.lastPix & 0xFEFEFE) + (pixels[this.off] & 0xFEFEFE) >> 1;
                            --this.off;
                        }
                    }
                }
                break block21;
            }
            if (reverse) {
                for (i = 0; i < blur; ++i) {
                    for (y = 0; y < this.imageHeight; y += 2) {
                        this.off = y * this.imageWidth;
                        this.off += this.imageWidth;
                        for (x = 0; x < this.imageWidth; ++x) {
                            --this.off;
                            this.lastPix = Display.pixels[this.off] = (this.lastPix & 0xFEFEFE) + (pixels[this.off] & 0xFEFEFE) >> 1;
                        }
                    }
                }
            } else {
                for (i = 0; i < blur; ++i) {
                    for (y = 0; y < this.imageHeight; y += 2) {
                        this.off = y * this.imageWidth;
                        for (x = 0; x < this.imageWidth; ++x) {
                            ++this.off;
                            this.lastPix = Display.pixels[this.off] = (this.lastPix & 0xFEFEFE) + (pixels[this.off] & 0xFEFEFE) >> 1;
                        }
                    }
                }
            }
            if (!JEMU.large) break block21;
            for (int x2 = 0; x2 < this.imageWidth; ++x2) {
                this.off = x2;
                for (y = 0; y < this.imageHeight; y += 2) {
                    Display.pixels[this.off + this.imageWidth] = this.glow(pixels[this.off], 0.75);
                    this.off += this.imageWidth * 2;
                }
            }
        }
    }

    protected int glow(int value, double factor) {
        this.getRGB(value, this.glowBuffer);
        this.glowR = this.glowBuffer[0] * factor;
        this.glowG = this.glowBuffer[1] * factor;
        this.glowB = this.glowBuffer[2] * factor;
        return this.putRGB((int)this.glowR, (int)this.glowG, (int)this.glowB);
    }

    public int lightGun(int x, int y) {
        int xx = this.getWidth();
        int yy = this.getHeight();
        if (this.gunImage.getWidth() != xx || this.gunImage.getHeight() != yy) {
            this.gunImage = new BufferedImage(xx, yy, 1);
        }
        this.gunImage.getGraphics().drawImage(image, 0, 0, xx, yy, this);
        Color test2 = new Color(this.gunImage.getRGB(x, y));
        int redg = test2.getRed();
        int greeng = test2.getGreen();
        int blueg = test2.getBlue();
        int check = redg + blueg + greeng;
        return check;
    }

    public void checkCOPimage() {
        if (this.copimage == null || this.copimage.getWidth() != image.getWidth() || this.copimage.getHeight() != image.getHeight()) {
            this.copimage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        }
    }

    public void keyPress(int code) {
        if (initcap) {
            if (code == 17) {
                this.ctrl = true;
            }
            if (code == 16) {
                this.shift = true;
            }
            if (code == 38) {
                if (!this.ctrl && !this.shift) {
                    if (capY > 1) {
                        --capY;
                    }
                } else if (this.ctrl && !this.shift) {
                    if (capH > 2) {
                        --capH;
                    }
                } else if (this.ctrl && this.shift) {
                    if (capH > 16) {
                        capH -= 8;
                    }
                } else if (!this.ctrl && this.shift && capY > 8) {
                    capY -= 8;
                }
            }
            if (code == 37) {
                if (!this.ctrl && !this.shift) {
                    if (capX > 1) {
                        --capX;
                    }
                } else if (this.ctrl && !this.shift) {
                    if (capW > 2) {
                        --capW;
                    }
                } else if (this.ctrl && this.shift) {
                    if (capW > 16) {
                        capW -= 8;
                    }
                } else if (!this.ctrl && this.shift && capX > 8) {
                    capX -= 8;
                }
            }
            if (code == 40) {
                if (!this.ctrl && !this.shift) {
                    if (capY < image.getHeight() - 1) {
                        ++capY;
                    }
                } else if (this.ctrl && !this.shift) {
                    if (capH < image.getHeight() - 1) {
                        ++capH;
                    }
                } else if (this.ctrl && this.shift) {
                    if (capH < image.getHeight() - 8) {
                        capH += 8;
                    }
                } else if (!this.ctrl && this.shift && capY < image.getHeight() - 8) {
                    capY += 8;
                }
            }
            if (code == 39) {
                if (!this.ctrl && !this.shift) {
                    if (capW < image.getWidth() - 1) {
                        ++capW;
                    }
                } else if (this.ctrl && !this.shift) {
                    if (capW < image.getWidth() - 1) {
                        ++capW;
                    }
                } else if (this.ctrl && this.shift) {
                    if (capH < image.getWidth() - 8) {
                        capW += 8;
                    }
                } else if (!this.ctrl && this.shift && capX < image.getWidth() - 8) {
                    capX += 8;
                }
            }
            return;
        }
        if (this.gfxView != null) {
            this.gfxView.keyPress(code);
        }
        if (JEMU.mapper != null) {
            JEMU.mapper.keyPress(code);
        }
    }

    public void keyRelease(int code) {
        if (initcap) {
            if (code == 17) {
                this.ctrl = false;
            }
            if (code == 16) {
                this.shift = false;
            }
            return;
        }
        if (this.gfxView != null) {
            this.gfxView.keyRelease(code);
        }
        if (JEMU.mapper != null) {
            JEMU.mapper.keyRelease(code);
        }
    }

    public void initGFXViewer() {
        if (!Desktop.isDesktop) {
            if (this.gfxView == null) {
                this.gfxView = new GraphicsViewer();
            }
            this.gfxView.setVisible(true);
        } else {
            Desktop.gfxcount = 1;
        }
    }

    protected void healthLine() {
        if (initgfxviewer != 0 && ++initgfxviewer > 2) {
            initgfxviewer = 0;
            this.initGFXViewer();
        }
        if (this.framecount != 0) {
            ++this.framecount;
        }
        if (this.framecount == 4) {
            if (this.MOVControl == null) {
                this.MOVControl = new Control();
            }
            this.MOVControl.setVisible(true);
            this.framecount = 0;
        }
    }

    public void showZoom(String factor) {
        this.showzoom = 100;
        this.zoomfactor = factor;
    }

    protected void paintImage(Graphics g) {
        if (this.doScreening) {
            this.screenshot = 0;
            for (int i = 49152; i < 65535; ++i) {
                this.screenshot += CPC.PEEK(i);
            }
            if (this.oldshot != this.screenshot) {
                this.oldshot = this.screenshot;
                try {
                    File a = new File("C://javacpc_temp/");
                    if (!a.exists()) {
                        a.mkdir();
                    }
                    ImageIO.write((RenderedImage)image, "PNG", new File("C://javacpc_temp/" + this.shotindex++ + ".png"));
                }
                catch (Exception a) {
                    // empty catch block
                }
            }
        }
        if (scaneffect && !lowperformance) {
            if (Display.imageRect.height >= 544) {
                this.showeffect = true;
                this.masked = false;
            } else {
                this.showeffect = false;
                this.masked = true;
            }
        } else {
            this.showeffect = false;
            this.masked = false;
        }
        StatusPanel.fps.setText("" + mCurrFPS + ":" + mCurrPixelFPS);
        boolean bl = this.larg = this.getWidth() > 700;
        if (filter_dosbox) {
            Display.BLUR3x3[8] = 0.15f;
            Display.BLUR3x3[7] = 0.15f;
            Display.BLUR3x3[6] = 0.15f;
            Display.BLUR3x3[5] = 0.15f;
            Display.BLUR3x3[3] = 0.15f;
            Display.BLUR3x3[2] = 0.15f;
            Display.BLUR3x3[1] = 0.15f;
            Display.BLUR3x3[0] = 0.15f;
            Display.BLUR3x3[4] = 0.8f;
        } else if (filter_dosboxb) {
            Display.BLUR3x3[8] = 0.12f;
            Display.BLUR3x3[7] = 0.12f;
            Display.BLUR3x3[6] = 0.12f;
            Display.BLUR3x3[5] = 0.12f;
            Display.BLUR3x3[3] = 0.12f;
            Display.BLUR3x3[2] = 0.12f;
            Display.BLUR3x3[1] = 0.12f;
            Display.BLUR3x3[0] = 0.12f;
            Display.BLUR3x3[4] = 0.6f;
        } else {
            Display.BLUR3x3[8] = 0.1f;
            Display.BLUR3x3[7] = 0.1f;
            Display.BLUR3x3[6] = 0.1f;
            Display.BLUR3x3[5] = 0.1f;
            Display.BLUR3x3[3] = 0.1f;
            Display.BLUR3x3[2] = 0.1f;
            Display.BLUR3x3[1] = 0.1f;
            Display.BLUR3x3[0] = 0.1f;
            Display.BLUR3x3[4] = 0.2f;
        }
        if (image == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        ConvolveOp cop = new ConvolveOp(new Kernel(3, 3, BLUR3x3), 1, null);
        if (Switches.bilinear && !lowperformance) {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g = g2;
        }
        if (!CPC.YM_Play || CPC.playmovie) {
            Graphics2D g3;
            if (interlace) {
                g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                if (superPAL) {
                    this.checkCOPimage();
                    g3 = this.copimage.createGraphics();
                    g3.drawImage(image, cop, 0, 0);
                    g2.drawImage(this.copimage, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height, null);
                } else {
                    g2.drawImage(image, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height, null);
                }
                g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
                if (superPAL) {
                    this.checkCOPimage();
                    g3 = this.copimage.createGraphics();
                    g3.drawImage(this.laceimage, cop, 0, 0);
                    g2.drawImage(this.copimage, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height, null);
                } else {
                    g2.drawImage(this.laceimage, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height, null);
                }
                g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else if (superPAL) {
                this.checkCOPimage();
                g3 = this.copimage.createGraphics();
                g3.drawImage(image, cop, 0, 0);
                g2.drawImage(this.copimage, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height, null);
            } else {
                g2.drawImage(image, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height, null);
            }
        } else {
            if (skin == 1) {
                g2.drawImage(this.YMmode, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height, null);
            } else {
                g2.drawImage(this.YMmode2, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height, null);
            }
            if (!lowperformance) {
                this.paintBalls(g);
            }
        }
        if (overlay != null) {
            g.drawImage(overlay, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height, this);
        }
        if (Main.isrickrolling) {
            g.drawString("Rick Rolling is downloading...", 100, 20);
        }
        this.zoom = Display.imageRect.height >= 640 ? 3 : (Display.imageRect.height >= 540 ? 2 : 1);
        if (cancap) {
            this.startcap();
            cancap = false;
        }
        if (stopcap) {
            this.stopcap();
            stopcap = false;
        }
        if (record) {
            if (this.MOVControl.pause.isSelected()) {
                return;
            }
            if (truecap) {
                this.mov.step(quality);
            } else {
                boolean bl2 = this.halfframe = !this.halfframe;
                if (this.halfframe) {
                    this.mov.step(quality);
                }
            }
        }
        if (formaterror > 0) {
            g2.drawImage(this.formaterr, 0, 0, Display.imageRect.width, Display.imageRect.height, null);
            if (++formaterror > 300) {
                formaterror = 0;
            }
        }
        this.scanlines = Switches.ScanLines;
        this.drawlines = false;
        if (this.scanlines && !lowperformance) {
            this.drawlines = Display.imageRect.height >= 544;
        }
        g.setColor(Color.BLACK);
        if (turbotimer == 5 && !this.floppyturbo) {
            Switches.turbo = 10;
            this.floppyturbo = true;
        }
        if (this.floppyturbo && Switches.turbo == 1) {
            Switches.turbo = 10;
        }
        if (turbotimer >= 2) {
            --turbotimer;
        }
        if (turbotimer == 1) {
            Switches.turbo = 1;
            JEMU.turbo.setState(false);
            this.floppyturbo = false;
            --turbotimer;
        }
        if (showpause >= 0) {
            if (Display.imageRect.height >= 540) {
                g.drawImage(this.paused, Display.imageRect.width - 80, 12, this);
            } else {
                g.drawImage(this.pauseds, Display.imageRect.width - 40, 6, this);
            }
            --showpause;
        }
        if (this.showzoom != 0) {
            g.setColor(Color.red);
            g.setFont(new Font("Tahoma", 2, 18));
            g.drawString("Zoom: " + this.zoomfactor, 10, 20);
            --this.showzoom;
        }
        if (this.joyenabled) {
            if (JEMU.setJoy1 || JEMU.setJoy2) {
                g.setColor(Color.red);
                g.setFont(new Font("Tahoma", 2, this.getWidth() > 700 ? 34 : 18));
                g.drawString("Joystick found!", 10, this.getWidth() > 700 ? 40 : 20);
            }
            if (JEMU.setJoy1) {
                g.setColor(Color.red);
                g.setFont(new Font("Tahoma", 2, this.getWidth() > 700 ? 34 : 18));
                g.drawString("Press Joystick button for Fire 1", 10, this.getWidth() > 700 ? 90 : 45);
            } else if (JEMU.setJoy2) {
                g.setColor(Color.red);
                g.setFont(new Font("Tahoma", 2, this.getWidth() > 700 ? 34 : 18));
                g.drawString("Press Joystick button for Fire 2 (ESC to skip)", 10, this.getWidth() > 700 ? 90 : 45);
            }
        }
        if (CPC.YM_Play && !CPC.playmovie) {
            g.setFont(new Font("Tahoma", 1, 16));
            g.setColor(TRANSBLACK);
            g.drawImage(this.ymplay, 10, 12, this);
            if (title.length() != 1 && !CPC.oldYM) {
                if (!lowperformance) {
                    g.drawString("Title: " + title, 36, 30);
                    g.drawString("Autor: " + author, 36, 48);
                    g.drawString("Creator: " + creator, 36, 66);
                }
                g.setColor(TRANS);
                g.drawString("Title: " + title, 34, 28);
                g.drawString("Autor: " + author, 34, 46);
                g.drawString("Creator: " + creator, 34, 64);
            }
            g.setColor(TRANSBLACK);
            if (CPC.atari_st_mode) {
                if (!lowperformance) {
                    g.drawString("playing 2 MHz Atari ST file...", 36, 88);
                }
                g.setColor(TRANS);
                g.drawString("playing 2 MHz Atari ST file...", 34, 86);
            } else if (CPC.spectrum_mode) {
                if (!lowperformance) {
                    g.drawString("playing 1,77 MHz ZX Spectrum file...", 36, 88);
                }
                g.setColor(TRANS);
                g.drawString("playing 1,77 MHz ZX Spectrum file...", 34, 86);
            } else {
                if (!lowperformance) {
                    g.drawString("playing 1 MHz Amstrad CPC file...", 36, 88);
                }
                g.setColor(TRANS);
                g.drawString("playing 1 MHz Amstrad CPC file...", 34, 86);
            }
            g.setColor(TRANSBLACK);
            if (CPC.oldYM) {
                if (!lowperformance) {
                    g.drawString("Old YM2/3 file", 36, 34);
                }
                g.setColor(TRANS);
                g.drawString("Old YM2/3 file", 34, 32);
            }
            g.setFont(new Font("Tahoma", 3, 22));
            if (!lowperformance) {
                g.setColor(TRANSBLACK);
                g.drawString(YMControl.Monitor, 36, 114);
            }
            g.setColor(TRANS);
            g.drawString(YMControl.Monitor, 34, 112);
            if (left != 0) {
                for (int i = 0; i < left / 2; ++i) {
                    if (!lowperformance) {
                        g.setColor(LED_BORDER);
                        g.fillRect(2 + i * 13, 121, 16, 16);
                    }
                    g.setColor(LED);
                    g.fillRect(4 + i * 13, 123, 12, 12);
                }
            }
            if (right != 0) {
                for (int i = 0; i < right / 2; ++i) {
                    if (!lowperformance) {
                        g.setColor(GREEN_BORDER);
                        g.fillRect(2 + i * 13, 138, 16, 16);
                    }
                    g.setColor(GREEN);
                    g.fillRect(4 + i * 13, 140, 12, 12);
                }
            }
        }
        if (CPC.YM_Rec && !lowperformance) {
            g.drawImage(this.ymrec, 10, 12, this);
        }
        if (CPC.recordKeys) {
            ++this.flashkey;
            if (this.flashkey > 25) {
                if (Display.imageRect.height >= 540) {
                    g.drawImage(this.recb, 10, 12, this);
                } else {
                    g.drawImage(this.recs, 10, 12, this);
                }
            }
            if (this.flashkey == 50) {
                this.flashkey = 0;
            }
        }
        if (CPC.playKeys) {
            ++this.flashkey;
            if (this.flashkey > 25) {
                if (Display.imageRect.height >= 540) {
                    g.drawImage(this.playb, 10, 12, this);
                } else {
                    g.drawImage(this.plays, 10, 12, this);
                }
            }
            if (this.flashkey == 50) {
                this.flashkey = 0;
            }
        }
        if ((filter_dosbox || filter_dosboxb) && this.showeffect) {
            if (this.screenw != this.getSize().width) {
                this.screenw = this.getSize().width;
                this.screenh = this.getSize().height;
            }
            for (int xx = 0; xx < this.screenw; xx += 768) {
                for (int yy = 0; yy < this.screenh; yy += 544) {
                    g.drawImage(this.dotmatrix, xx, yy, 768, 544, this);
                }
            }
        }
        if (this.redoBorders != Switches.mask) {
            this.redoBorders = Switches.mask;
            this.checkFullScreenBorder = 0;
        }
        if (this.checkFullScreenBorder < 15) {
            ++this.checkFullScreenBorder;
        }
        if (this.checkFullScreenBorder < 10) {
            if (!Switches.mask) {
                JEMU.leftdistance.getGraphics().drawImage(this.monbord, 0, 0, JEMU.leftdistance.getWidth(), JEMU.leftdistance.getHeight(), this);
                JEMU.topdistance.getGraphics().drawImage(this.monbord, 0, 0, JEMU.topdistance.getWidth(), JEMU.topdistance.getHeight(), this);
            } else {
                Graphics2D l = JEMU.leftdistance.createGraphics();
                l.setColor(new Color(789774));
                l.fillRect(0, 0, JEMU.leftdistance.getWidth(), JEMU.leftdistance.getHeight());
                l = JEMU.topdistance.createGraphics();
                l.setColor(new Color(789774));
                l.fillRect(0, 0, JEMU.topdistance.getWidth(), JEMU.topdistance.getHeight());
            }
            JEMU.toplabel.repaint();
            JEMU.downlabel.repaint();
            JEMU.leftlabel.repaint();
            JEMU.rightlabel.repaint();
        }
        if (!CPC.YM_Play && !use3d) {
            if (this.showeffect) {
                g.drawImage(this.mask, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height + 1, this);
            }
            if (this.masked) {
                g.drawImage(this.mask, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height + 1, this);
            }
        } else if (!use3d) {
            g.drawImage(this.mask1, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height + 1, this);
        }
    }

    public void doTouchFPS() {
        long time = System.currentTimeMillis();
        ++this.mNextFPS;
        if (time - this.mLastFPSTime >= 1000L) {
            mCurrFPS = this.mNextFPS;
            this.mNextFPS = 0;
            this.mLastFPSTime = time;
        }
    }

    protected void drawScreenCoords(Graphics g) {
        g.setColor(Color.white);
        g.drawLine(GateArray.cpc.getBorderL(), 0, GateArray.cpc.getBorderL(), 544);
        g.drawLine(GateArray.cpc.getBorderR(), 0, GateArray.cpc.getBorderR(), 544);
        g.drawLine(0, GateArray.cpc.getBorderH(), 768, GateArray.cpc.getBorderH());
        g.drawLine(0, 560 - GateArray.cpc.getBorderH(), 768, 560 - GateArray.cpc.getBorderH());
        int x = GateArray.cpc.getHPOS();
        int y = GateArray.cpc.getVPOS();
        for (int xx = 0; xx < this.getWidth(); xx += 6) {
            g.drawLine(xx, y, xx + 2, y);
        }
        for (int yy = 0; yy < this.getHeight(); yy += 6) {
            g.drawLine(x, yy, x, yy + 2);
        }
    }

    public void paintBalls(Graphics g) {
        this.balls(g, this.driveam, this.drivebm, this.driveam);
        this.ck = 0;
        while (this.ck < this.ch) {
            this.cj = ((int)(Math.cos((double)this.co + (double)((float)this.ck / 50.0f) * 12.566370964050293) * Math.sin(this.cl) * 20.0 + Math.cos((double)(2.0f * this.cn) / 2.0 - (double)((float)this.ck / 50.0f * 6.28f)) * 40.0 - Math.sin((double)(this.cn / 2.0f + this.cm) + (double)((float)this.ck / 50.0f) * 6.283185005187988) * 60.0) + 160 - 7 + 40) * this.zoom;
            this.ci = ((int)(Math.cos((double)(this.cn * 1.5f) + (double)((float)this.ck / 50.0f) * 6.283185005187988) * Math.sin(this.cm) * 20.0 - Math.sin((double)(4.0f * this.co) / 3.0 + (double)((float)this.ck / 50.0f * 6.28f * 2.0f)) * 40.0 + Math.sin((double)(this.co / 2.0f + this.cl) + (double)((float)this.ck / 50.0f) * 6.283185005187988) * 30.0) + 100 - 7) * this.zoom;
            if (this.zoom >= 3) {
                g.drawImage(this.ballbb, this.cj, this.ci, null);
            } else if (this.zoom >= 2) {
                g.drawImage(this.ballb, this.cj, this.ci, null);
            } else {
                g.drawImage(this.ball, this.cj, this.ci, null);
            }
            ++this.ck;
        }
        this.co = (float)((double)this.co + (double)0.03f);
        this.cn = (float)((double)this.cn + (double)0.0219f);
        this.cm = (float)((double)this.cm + (double)0.0273f);
        this.cl = (float)((double)this.cl + (double)0.0309f);
    }

    @Override
    public void setBackground(Color bg) {
    }

    @Override
    public void paintComponent(Graphics g) {
        if (remask) {
            remask = false;
            this.changePerformance();
        }
        if (image == null) {
            return;
        }
        ++this.af;
        if (this.af > 4) {
            this.af = 1;
        }
        this.paintImage(g);
        if (!lowperformance && CPC.YM_Play) {
            this.paintBalls(g);
        }
        if (!GateArray.cpc.isRunning() || showpause != -1) {
            this.drawScreenCoords(g);
        }
        painted = true;
    }

    public BufferedImage getImag() {
        return image;
    }

    public BufferedImage getImage() {
        BufferedImage off_Image = new BufferedImage(Display.imageRect.width, Display.imageRect.height, 1);
        Graphics2D g = off_Image.createGraphics();
        g.setColor(Color.black);
        g.fillRect(0, 0, Display.imageRect.width, Display.imageRect.height);
        if (Switches.bilinear) {
            Graphics2D g2 = g;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g = g2;
        }
        if (!CPC.YM_Play || CPC.playmovie) {
            if (sourceRect != null) {
                g.drawImage(image, Display.imageRect.x, Display.imageRect.y, Display.imageRect.x + Display.imageRect.width, Display.imageRect.y + Display.imageRect.height, Display.sourceRect.x, Display.sourceRect.y, Display.sourceRect.x + Display.sourceRect.width, Display.sourceRect.y + Display.sourceRect.height, null);
            } else if (this.sameSize) {
                g.drawImage((Image)image, Display.imageRect.x, Display.imageRect.y, null);
            } else {
                g.drawImage(image, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height, null);
            }
        } else {
            if (skin == 1) {
                g.drawImage(this.YMmode, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height, null);
            } else {
                g.drawImage(this.YMmode2, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height, null);
            }
            if (!lowperformance) {
                this.paintBalls(g);
            }
        }
        if (this.scanlines) {
            if (Switches.monitormode == 0 || Switches.monitormode == 1 || Switches.monitormode == 5) {
                if (filter_dosbox || filter_dosboxb) {
                    int i;
                    this.rgbcount = 0;
                    for (i = 0; i < Display.imageRect.width * 2; ++i) {
                        g.setColor(RGB[this.rgbcount]);
                        ++this.rgbcount;
                        if (this.rgbcount > 2) {
                            this.rgbcount = 0;
                        }
                        g.drawLine(Display.imageRect.x + i, Display.imageRect.y, Display.imageRect.x, Display.imageRect.y + i);
                    }
                    g.setColor(SCAN_DARK);
                    for (i = 0; i < Display.imageRect.height; i += 2) {
                        g.drawLine(Display.imageRect.x, Display.imageRect.y + i, Display.imageRect.width, Display.imageRect.y + i);
                    }
                } else {
                    g.setColor(SCAN);
                    for (int i = 0; i < Display.imageRect.width; i += 2) {
                        g.drawLine(Display.imageRect.x + i, Display.imageRect.y, Display.imageRect.x + i, Display.imageRect.height);
                    }
                }
            } else {
                for (int i = 0; i < Display.imageRect.height; i += 2) {
                    g.drawLine(Display.imageRect.x, Display.imageRect.y + i, Display.imageRect.width, Display.imageRect.y + i);
                }
            }
        }
        if (CPC.YM_Play && !CPC.playmovie) {
            g.drawImage(this.ymplay, 10, 12, this);
            if (title.length() != 1) {
                g.setColor(TRANSBLACK);
                ((Graphics)g).drawString("Title: " + title, 36, 20);
                ((Graphics)g).drawString("Autor: " + author, 36, 34);
                ((Graphics)g).drawString("Creator: " + creator, 36, 48);
                g.setColor(TRANS);
                ((Graphics)g).drawString("Title: " + title, 34, 18);
                ((Graphics)g).drawString("Autor: " + author, 34, 32);
                ((Graphics)g).drawString("Creator: " + creator, 34, 46);
            }
            g.setColor(TRANSBLACK);
            if (CPC.atari_st_mode && !CPC.oldYM) {
                ((Graphics)g).drawString("playing 2 MHz Atari ST file...", 36, 62);
                g.setColor(TRANS);
                ((Graphics)g).drawString("playing 2 MHz Atari ST file...", 34, 60);
            } else if (CPC.spectrum_mode && !CPC.oldYM) {
                ((Graphics)g).drawString("playing 1,77 MHz ZX Spectrum file...", 36, 62);
                g.setColor(TRANS);
                ((Graphics)g).drawString("playing 1,77 MHz ZX Spectrum file...", 34, 60);
            } else if (CPC.atari_st_mode && CPC.oldYM) {
                ((Graphics)g).drawString("playing old YM3 file...", 36, 62);
                g.setColor(TRANS);
                ((Graphics)g).drawString("playing old YM3 file...", 34, 60);
            } else {
                ((Graphics)g).drawString("playing 1 MHz Amstrad CPC file...", 36, 62);
                g.setColor(TRANS);
                ((Graphics)g).drawString("playing 1 MHz Amstrad CPC file...", 34, 60);
            }
            g.setColor(TRANSBLACK);
            ((Graphics)g).drawString(YMControl.Monitor, 18, 114);
            g.setColor(TRANS);
            ((Graphics)g).drawString(YMControl.Monitor, 14, 110);
            if (left != 0) {
                for (int i = 0; i < left / 2; ++i) {
                    g.setColor(LED_BORDER);
                    g.fillRect(2 + i * 13, 121, 16, 16);
                    g.setColor(LED);
                    g.fillRect(4 + i * 13, 123, 12, 12);
                }
            }
            if (right != 0) {
                for (int i = 0; i < right / 2; ++i) {
                    g.setColor(GREEN_BORDER);
                    g.fillRect(2 + i * 13, 138, 16, 16);
                    g.setColor(GREEN);
                    g.fillRect(4 + i * 13, 140, 12, 12);
                }
            }
        }
        if (CPC.YM_Rec) {
            g.drawImage(this.ymrec, 10, 12, this);
        }
        if (this.showeffect) {
            g.drawImage(this.mask, Display.imageRect.x, Display.imageRect.y, Display.imageRect.width, Display.imageRect.height, this);
        }
        return off_Image;
    }

    public static void setFade(int fade) {
        fader = fade;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension(Display.imageRect.width + insets.left + insets.right, Display.imageRect.height + insets.top + insets.bottom);
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public boolean isPainted() {
        return painted;
    }

    public void setPainted(boolean value) {
        painted = value;
    }

    public void waitPainted() {
        while (!painted) {
            Thread.yield();
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1004) {
            Desktop.tofront = true;
            System.out.println("Display Focused");
            if (Desktop.hideMouse.isSelected()) {
                this.setCursor(this.blankCursor);
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            System.out.println("Display Lost Focus");
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public final void balls(Graphics g, Image image1, Image image2, Image image3) {
        this.cG = ((double)this.cd + (double)0.4f) * 100.0 % 628.0 < 157.0 || ((double)this.cd + (double)0.4f) * 100.0 % 628.0 > 471.0;
        this.ge.drawImage(image, 0, 0, 384, 272, null);
        Graphics2D g2d = (Graphics2D)g;
        this.ca = (float)(Math.cos((double)this.ce + (double)0.8f) + 1.5);
        this.b9 = (float)(Math.cos((double)this.cd + (double)0.4f) + 1.5);
        this.b8 = (float)(Math.cos(this.cc) + 1.5);
        if (this.cG && !use3d) {
            this.ck = 0;
            while (this.ck < 15) {
                this.ci = (int)(Math.sin((double)this.cf + (double)this.ck * (double)0.16f * 1.5) * 39.0 + 98.0 - 8.0 + 5.0);
                g2d.drawImage(this.bi, this.rop, this.xpos, (int)((double)this.ci * 1.5));
                g2d.drawImage(this.bi, this.rop, 384 - this.xpos, (int)((double)this.ci * 1.5));
                ++this.ck;
            }
        }
        double d = this.cc / 2.0f;
        double d2 = d;
        double d3 = this.cc;
        d2 = d3;
        double d4 = -this.cc;
        d2 = d4;
        double d5 = this.cc;
        d2 = d5;
        double d6 = (double)this.cc - (double)0.4f;
        d2 = d6;
        d2 = (double)this.cc - (double)0.4f;
        g.drawImage(image3, (int)(164.0f + (float)Math.cos(d) * 80.0f + (float)Math.sin(d3) * 30.0f * (float)Math.cos(d4)) * 2, 202 + (int)((float)Math.sin(d5) * 100.0f - (float)Math.cos(d6) * 25.0f * (float)Math.sin(d2)) * 2, (int)(30.0f * this.b8) * 4, (int)(30.0f * this.b8 * 4.0f), null);
        double d7 = (double)(this.cd / 2.0f) + (double)0.8f;
        d2 = d7;
        double d8 = (double)this.cd + (double)0.4f;
        d2 = d8;
        double d9 = (double)(-this.cd) + (double)0.4f;
        d2 = d9;
        double d10 = (double)this.cd + (double)0.4f;
        d2 = d10;
        double d11 = this.cd;
        d2 = d11;
        d2 = this.cd;
        g.drawImage(image2, (int)(164.0f + (float)Math.cos(d7) * 80.0f + (float)Math.sin(d8) * 30.0f * (float)Math.cos(d9)) * 2, 202 + (int)((float)Math.sin(d10) * 100.0f - (float)Math.cos(d11) * 25.0f * (float)Math.sin(d2)) * 2, (int)(30.0f * this.b9) * 4, (int)(30.0f * this.b9 * 4.0f), null);
        double d12 = (double)(this.ce / 2.0f) + (double)1.6f;
        d2 = d12;
        double d13 = (double)this.ce + (double)0.8f;
        d2 = d13;
        double d14 = (double)(-this.ce) + (double)0.8f;
        d2 = d14;
        double d15 = (double)this.ce + (double)0.8f;
        d2 = d15;
        double d16 = (double)this.ce + (double)0.4f;
        d2 = d16;
        d2 = (double)this.ce + (double)0.4f;
        g.drawImage(image1, (int)(164.0f + (float)Math.cos(d12) * 80.0f + (float)Math.sin(d13) * 30.0f * (float)Math.cos(d14)) * 2, 202 + (int)((float)Math.sin(d15) * 100.0f - (float)Math.cos(d16) * 25.0f * (float)Math.sin(d2)) * 2, (int)(30.0f * this.ca) * 4, (int)(30.0f * this.ca * 4.0f), null);
        if (!this.cG && !use3d) {
            this.ck = 0;
            while (this.ck < 15) {
                this.ci = (int)(Math.sin((double)this.cf + (double)this.ck * (double)0.16f * 1.5) * 39.0 + 98.0 - 8.0 + 5.0);
                g2d.drawImage(this.bi, this.rop, this.xpos, (int)((double)this.ci * 1.5));
                g2d.drawImage(this.bi, this.rop, 384 - this.xpos, (int)((double)this.ci * 1.5));
                ++this.ck;
            }
        }
        this.xpos += this.xstep;
        if (this.xpos > 192) {
            --this.xstep;
        }
        if (this.xpos < 192) {
            ++this.xstep;
        }
        this.ce += 0.03f;
        this.cd = this.ce - 0.1f;
        this.cc = this.ce - 0.2f;
        this.cf = (float)((double)this.cf + (double)0.03f);
    }

    static {
        trans = Float.valueOf(0.5f);
        noover = true;
        PAL = false;
        formaterror = 0;
        doublesize = true;
        interlace = false;
        superPAL = false;
        noisecount = 200;
        remask = false;
        filter_dosbox = false;
        filter_dosboxb = false;
        filter_eagle = false;
        filter_advmame = false;
        filter_eagle_smooth = false;
        filter_advmame_smooth = false;
        filter_embossed = false;
        skin = 1;
        title = "";
        author = "";
        creator = "";
        scaneffect = false;
        horizontal = true;
        left = 0;
        right = 0;
        showpause = 0;
        FADE = new Color(0, 0, 0, 0);
        LED = new Color(255, 0, 0, 64);
        GREEN = new Color(0, 255, 0, 64);
        GREEN_BORDER = new Color(0, 144, 0, 64);
        LED_BORDER = new Color(144, 0, 0, 64);
        LED_OFF = new Color(144, 0, 0);
        WHITEA = new Color(255, 255, 255);
        BLACKA = new Color(0, 0, 0);
        SCAN = new Color(0, 0, 0, 96);
        SCAN_DARK = new Color(0, 0, 0, 144);
        SCAN_MED = new Color(0, 0, 0, 128);
        megadark = new Color(0, 0, 0, 176);
        TRANS = new Color(255, 255, 255, 176);
        TRANSBLACK = new Color(0, 0, 0, 64);
        RGB = new Color[]{new Color(255, 0, 0, 48), new Color(0, 255, 0, 48), new Color(0, 0, 255, 48)};
        SCALE_1 = new Dimension(1, 1);
        SCALE_2 = new Dimension(2, 2);
        SCALE_1x2 = new Dimension(1, 2);
        imageRect = new Rectangle();
        sourceRect = null;
        painted = false;
        initgfxviewer = 0;
        initcap = false;
        capX = 20;
        capY = 20;
        capW = 320;
        capH = 240;
        blur = 1;
        snow = 124;
        skipframes = false;
        BLUR3x3 = new float[]{0.15f, 0.15f, 0.15f, 0.15f, 0.2f, 0.15f, 0.15f, 0.15f, 0.15f};
        use3d = false;
        quality = 0.7f;
    }
}

