/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jemu.settings.DSettings;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.ui.CMDInfo;
import jemu.ui.CheckResources;
import jemu.ui.Desktop;
import jemu.ui.JEMU;
import jemu.ui.OSValidator;
import jemu.ui.Splash;
import jemu.ui.SyntheticaLicense;

public class Main
implements MouseMotionListener {
    public static String version = "3";
    public static String subversion = ".0.2";
    public static String year = "2022";
    public static String path = "./";
    public static JPanel bg;
    public static JFrame splash;
    public static String wallpaper;
    public static String stretch;
    public static String monitor;
    public static String desk;
    static CheckResources checkresources;
    public static String fos_uptodate;
    public static String fos_update;
    public static boolean rickrolled;
    public static boolean isrickrolling;
    static Splash info;

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getXOnScreen();
        int y = e.getYOnScreen();
        splash.setLocation(x - (splash.getWidth() >> 1), y - 8);
    }

    public void parseArgs(String[] args) {
        String command = "";
        String value = "";
        boolean launched = false;
        boolean even = true;
        for (String s : args) {
            command = command + " " + s;
        }
        System.out.println("Args:" + command);
        command = "";
        for (String s : args) {
            if (even) {
                launched = false;
                command = s;
            } else {
                launched = true;
                value = s;
                this.parseArg(command, value);
            }
            even = !even;
        }
        if (!launched) {
            this.parseArg(command, value);
        }
    }

    public static void printHelp() {
        Desktop desk = new Desktop();
        desk.setLook();
        CMDInfo inf = new CMDInfo();
        System.out.println(CMDInfo.h);
        inf.setVisible(true);
    }

    public void parseArg(String cmd, String val) {
        val = val.replace("&quot;", "\"");
        if (cmd.contains("assemble")) {
            System.out.println("JavaCPC will assemble: " + val);
            CPC.assemblercode = val;
        }
        if (cmd.contains("cpctype")) {
            System.out.println("Choosen CPCtype:" + val);
            CPC.cpctype = val;
        }
        if (cmd.contains("df0")) {
            System.out.println("Choosen DSK for drive A:" + val);
            CPC.drivea = val;
        }
        if (cmd.contains("sna")) {
            System.out.println("Choosen Snapshot file:" + val);
            CPC.snapshot = val;
        }
        if (cmd.contains("df1")) {
            System.out.println("Choosen DSK for drive B:" + val);
            CPC.driveb = val;
        }
        if (cmd.contains("drivea")) {
            System.out.println("Choosen DSK for drive A:" + val);
            CPC.drivea = val;
        }
        if (cmd.contains("driveb")) {
            System.out.println("Choosen DSK for drive B:" + val);
            CPC.driveb = val;
        }
        if (cmd.contains("tape")) {
            System.out.println("Choosen CDT for tapedrive:" + val);
            CPC.tape = val;
        }
        if (cmd.contains("boot")) {
            System.out.println("You want to boot from " + val);
            CPC.bootdrive = val;
        }
        if (cmd.contains("amsdos")) {
            System.out.println("Amsdos will be: " + val);
            if (val.contains("false") || val.contains("0")) {
                val = "no";
            }
            CPC.amsdos = val;
        }
        if (cmd.contains("crtc")) {
            System.out.println("CRTC type will be: " + val);
            CPC.crtctype = val;
        }
        if (cmd.contains("autotype")) {
            System.out.println("JavaCPC will enter this text: " + val);
            CPC.autotypetext = val;
        }
        if (cmd.contains("desktop")) {
            System.out.println("Desktop is used: " + val);
            desk = val;
        }
        if (cmd.contains("wallpaper")) {
            System.out.println("Wallpaper: " + val);
            wallpaper = val;
        }
        if (cmd.contains("stretch")) {
            System.out.println("Stretch wallpaper: " + val);
            stretch = val;
        }
        if (cmd.contains("mem")) {
            System.out.println("Memory will be set to: " + val + "k");
            CPC.usemem = val;
        }
        if (cmd.contains("monitor")) {
            System.out.println("Monitor emulation is: " + val);
            monitor = val;
        }
        if (cmd.contains("polarity")) {
            System.out.println("Tape polarity is: " + val);
            JEMU.tapepolarity = val;
        }
        if (cmd.contains("help")) {
            Main.printHelp();
        }
    }

    protected static void setupReg() {
        try {
            String line;
            String command = "reg.exe QUERY \"HKCU\\Software\\Classes\\.DSK\" /ve";
            Process process = Runtime.getRuntime().exec(command);
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String result = "";
            while ((line = br.readLine()) != null) {
                result = result + line;
            }
            if (result.contains("REG_SZ")) {
                while (!result.startsWith("REG_SZ")) {
                    result = result.substring(1);
                }
                result = result.substring(7);
                while (result.startsWith(" ")) {
                    result = result.substring(1);
                }
            }
            br.close();
            boolean wincpc = false;
            if (result.toLowerCase().contains("wincpc")) {
                wincpc = true;
            }
            process = null;
            String rem = "testpath";
            File checkit = new File(rem);
            String got = "\"\\\"" + checkit.getAbsolutePath().replace(rem, "");
            got = Main.is64bit() ? got + "JavaCPC64.exe\\\" \\\"%1\\\"\"" : got + "JavaCPC32.exe\\\" \\\"%1\\\"\"";
            if (result.length() > 0) {
                command = "reg.exe ADD \"HKLM\\Software\\Classes\\" + result + "\\shell\\Mount DSK in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
                Runtime.getRuntime().exec(command);
            } else {
                command = "reg.exe ADD \"HKLM\\Software\\Classes\\.DSK\" /ve /t REG_SZ /d dskfile /f";
                Runtime.getRuntime().exec(command);
                command = "reg.exe ADD \"HKCU\\Software\\Classes\\.DSK\" /ve /t REG_SZ /d dskfile /f";
                Runtime.getRuntime().exec(command);
                command = "reg.exe ADD \"HKLM\\Software\\Classes\\dskfile\\shell\\Mount DSK in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
                Runtime.getRuntime().exec(command);
            }
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\.DSK\" /ve /t REG_SZ /d dskfile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKCU\\Software\\Classes\\.DSK\" /ve /t REG_SZ /d dskfile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\.ASM\" /ve /t REG_SZ /d asmfile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\.ASM\" /v PerceivedType /t REG_SZ /d text /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKCU\\Software\\Classes\\.ASM\" /ve /t REG_SZ /d asmfile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\.CDT\" /ve /t REG_SZ /d cdtfile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\.SNA\" /ve /t REG_SZ /d snafile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\.ANI\" /ve /t REG_SZ /d anifile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\.ANZ\" /ve /t REG_SZ /d anifile /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\cdtfile\\shell\\Mount CDT in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\asmfile\\shell\\Edit with JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKCU\\Software\\Classes\\cdtfile\\shell\\Mount CDT in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKCU\\Software\\Classes\\asmfile\\shell\\Edit with JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\snafile\\shell\\Load SNA in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\anifile\\shell\\Play in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\WinCPC.DSK\\shell\\Mount DSK in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\WinCPC.CDT\\shell\\Mount CDT in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\WinCPC.SNA\\shell\\Load SNA in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
            command = "reg.exe ADD \"HKLM\\Software\\Classes\\dsk.Document\\shell\\Mount DSK in JavaCPC\\command\" /ve /t REG_SZ /d " + got + " /f";
            Runtime.getRuntime().exec(command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean is64bit() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    public static void verifyJavaCPC() {
        checkresources.checkResources();
    }

    public static void checkFOSUpdate() {
        String inputLine = null;
        String result = "";
        String ver = Settings.get("futureos_version", "not_installed");
        try {
            URL oracle = new URL("http://futureos.cpc-live.com/javacpc/version.txt");
            URLConnection yc = oracle.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                result = result + inputLine;
            }
            in.close();
            System.out.println(result);
            System.out.println(ver);
        }
        catch (Exception e) {
            return;
        }
        if (!ver.equals(result)) {
            Main.UpdateFOS(result);
        } else {
            String info = fos_uptodate;
            JOptionPane.showMessageDialog(null, info);
        }
    }

    protected static void UpdateFOS(String result) {
        String pathFrom = "http://futureos.cpc-live.com/javacpc/";
        String pathTo = "./system/cpc/rom/";
        String[] files = new String[]{"FOSC-E-A.ROM", "FOSC-E-B.ROM", "FOSC-E-C.ROM", "FOSC-E-D.ROM", "ROManager.ROM", "TOOL-ROM-ENG.ROM", "Wallpaper_1.ROM"};
        Boolean success = true;
        for (int i = 0; i < files.length; ++i) {
            try {
                Main.saveUrl(pathTo + files[i], pathFrom + files[i]);
                continue;
            }
            catch (Exception e) {
                success = false;
                break;
            }
        }
        if (success.booleanValue()) {
            Settings.set("futureos_version", result);
            String info = fos_update.replace("%s1", result);
            JOptionPane.showMessageDialog(null, info);
        } else {
            JOptionPane.showMessageDialog(null, "FutureOS update Error!");
        }
    }

    public static void RickRollMe() {
        rickrolled = false;
        Thread f = new Thread(){

            @Override
            public void run() {
                isrickrolling = true;
                String url1 = "http://cpc-live.com/javacpc_update/RickAstley.anz";
                String file = "./IHaveBeenRickRolled/";
                File a = new File(file);
                if (!a.exists()) {
                    String error = "Rick is not here.\r\nHe may appear if you shout\r\n\"IHaveBeenRickRolled\"\r\nat the right place.";
                    JOptionPane.showMessageDialog(null, error);
                    rickrolled = true;
                    isrickrolling = false;
                    return;
                }
                String file1 = file + "RickAstley.anz";
                try {
                    Main.saveUrl(file1, url1);
                    file1 = file + "RickAstley.mp3";
                    url1 = "http://cpc-live.com/javacpc_update/RickAstley.mp3";
                    Main.saveUrl(file1, url1);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Rick Rolling Error!");
                }
                rickrolled = true;
                isrickrolling = false;
            }
        };
        f.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveUrl(String filename, String urlString) throws MalformedURLException, IOException {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            File a = new File(filename);
            if (a.exists()) {
                a.delete();
            }
            in = new BufferedInputStream(new URL(urlString).openStream());
            fout = new FileOutputStream(filename);
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }

    public static void checkUpdate(boolean autocheck) {
        String inputLine = null;
        String result = "";
        String ver = version + subversion;
        try {
            URL oracle = new URL("http://cpc-live.com/javacpc_update/javacpc_version.txt");
            URLConnection yc = oracle.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                result = result + inputLine;
            }
            in.close();
            System.out.println(result);
            System.out.println(ver);
        }
        catch (Exception e) {
            return;
        }
        if (!ver.equals(result) && !result.contains("al")) {
            int n;
            if (splash != null) {
                splash.setVisible(false);
            }
            if ((n = JOptionPane.showConfirmDialog(new JFrame(), "Your JavaCPC version is " + ver + ".\r\nDo you want to download and install\r\nJavaCPC version " + result + "?", "JavaCPC update version " + result + " is available...", 0)) == 0) {
                try {
                    checkresources.checkResources();
                    String command = "java -jar update.jar";
                    Runtime.getRuntime().exec(command);
                    System.exit(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(0);
                }
            }
        } else if (result.contains("al") && !autocheck) {
            int n;
            String up = result.contains("al") ? "\r\nBe careful! It's Alpha!" : "";
            System.out.println(up);
            if (splash != null) {
                splash.setVisible(false);
            }
            if ((n = JOptionPane.showConfirmDialog(new JFrame(), "Your JavaCPC version is " + ver + ".\r\nDo you want to download and install\r\nJavaCPC version " + result + "?" + up, "JavaCPC update version " + result + " is available...", 0)) == 0) {
                try {
                    checkresources.checkResources();
                    String command = "java -jar update.jar";
                    Runtime.getRuntime().exec(command);
                    System.exit(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(0);
                }
            }
        } else if (!autocheck) {
            JOptionPane.showMessageDialog(null, "Your copy of JavaCPC is up to date.");
        }
    }

    public static void main(String[] args) {
        try {
            Object[] optionss;
            int nf;
            System.setProperty("http.agent", "BDDBrowser/" + version + subversion);
            Main main = new Main();
            path = System.getProperty("user.dir");
            checkresources.checkFileResources();
            Settings.set("version", version + subversion);
            File a = new File("JavaCPC.jar");
            String path = a.getAbsolutePath();
            path = path.substring(0, path.length() - 11);
            Settings.set("javacpc_path", path);
            String[] orgargs = args;
            boolean ret = false;
            if (args != null && args.length > 0 && args[0].startsWith("-")) {
                for (int i = 0; i < args.length; ++i) {
                    if (!args[i].contains("-help")) continue;
                    ret = true;
                    break;
                }
                orgargs = new String[]{""};
                main.parseArgs(args);
            }
            if (ret) {
                return;
            }
            args = orgargs;
            if (OSValidator.isWindows() && OSValidator.needNewJava() && (nf = JOptionPane.showOptionDialog(new JFrame(), "Your Java is outdated.\nPlease visit www.java.com\nand install the latest update.", "Problem", 1, 2, null, optionss = new Object[]{"Ignore", "Quit JavaCPC"}, optionss[1])) == 1) {
                JEMU.openWebPage("http://www.java.com");
                System.exit(0);
            }
            String desktop = DSettings.get("use_desktop", "not_set");
            if (desk != null && ((desktop = desk.toLowerCase()).contains("true") || desktop.contains("1"))) {
                desktop = "yes";
            }
            if (desktop.equals("not_set")) {
                Object[] options = new Object[]{"Desktop", "Normal", "Cancel"};
                int n = JOptionPane.showOptionDialog(new JFrame(), "Would you like to run JavaCPC Desktop?", "Please choose", 1, 3, null, options, options[0]);
                if (n == 2) {
                    System.exit(0);
                }
                if (n == 0) {
                    main.initsplash(50);
                    DSettings.set("use_desktop", "yes");
                    main.launchDesktop(args);
                } else {
                    main.initsplash(70);
                    DSettings.set("use_desktop", "no");
                    main.launchClassic(args);
                }
            } else if (desktop.equals("yes")) {
                main.initsplash(50);
                int look = Integer.parseInt(DSettings.get("look", "4"));
                if (look == 30) {
                    try {
                        new SyntheticaLicense().register();
                        UIManager.setLookAndFeel("de.javasoft.plaf.synthetica.SyntheticaBlackEyeLookAndFeel");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                main.launchDesktop(args);
            } else {
                main.initsplash(70);
                main.launchClassic(args);
            }
            Desktop.aboutline.setText("\u00a92004-" + year + " by Markus Hohmann");
        }
        catch (Exception e) {
            Main.verifyJavaCPC();
        }
    }

    protected void initsplash(int speed) {
        try {
            splash.setResizable(false);
            info = new Splash(speed);
            splash.setLayout(new BorderLayout());
            splash.add((Component)info, "Center");
            try {
                splash.setUndecorated(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!splash.isUndecorated()) {
                System.out.println("Error in Splash screen.");
                info.removeClose();
            } else {
                try {
                    splash.setOpacity(0.0f);
                    Thread splasher = new Thread(){

                        @Override
                        public void run() {
                            float sweep = 0.0f;
                            while (sweep < 0.9f) {
                                if ((sweep += 0.00125f) > 1.0f) {
                                    sweep = 1.0f;
                                }
                                splash.setOpacity(sweep);
                                try {
                                    Thread.sleep(1L);
                                }
                                catch (Exception exception) {}
                            }
                        }
                    };
                    splasher.start();
                }
                catch (Exception e) {
                    System.out.println("Error in Splash screen.");
                    info.removeClose();
                }
            }
            splash.setDefaultCloseOperation(3);
            splash.pack();
            bg = new JPanel();
            splash.setAlwaysOnTop(true);
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            splash.setLocation((d.width - Main.splash.getSize().width) / 2, (d.height - Main.splash.getSize().height) / 2);
            splash.getContentPane().add(bg);
            splash.addMouseMotionListener(this);
            splash.setVisible(true);
            final Thread colorEffect = new Thread(){

                @Override
                public void run() {
                    while (splash.isVisible()) {
                        info.updateCube();
                        try {
                            Thread.sleep(4L);
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        colorEffect.start();
                    }
                });
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            splash = null;
        }
    }

    protected void launchDesktop(String[] args) {
        Desktop.isDesktop = true;
        Desktop.addToEmu = args;
        Desktop.Main(args);
    }

    protected void launchClassic(String[] args) {
        Desktop.isDesktop = false;
        JEMU.Main(args);
    }

    static {
        splash = new JFrame();
        wallpaper = null;
        stretch = null;
        monitor = null;
        desk = null;
        checkresources = new CheckResources();
        fos_uptodate = "FutureOS ROMs are up to date.";
        fos_update = "FutureOS Roms updated to Version %s1";
    }
}

