/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.paint;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jemu.core.Util;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.ui.paint.OverscanCanvas;
import jemu.ui.paint.PaintCanvas;
import jemu.ui.paint.normalPaint;
import jemu.ui.paint.overscanPaint;

public class RGBSlider
extends JFrame {
    protected int choosenpen = 0;
    protected int choosenvalue = 0;
    private JTextField bf;
    public JSlider bs;
    private Panel col;
    private JTextField gf;
    public JSlider gs;
    private JLabel ind;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JTextField rf;
    public JSlider rs;

    public RGBSlider() {
        this.initComponents();
        this.jButton1.setSize(this.jButton2.getWidth(), this.jButton2.getHeight());
        this.jButton1.setPreferredSize(new Dimension(this.jButton2.getWidth(), this.jButton2.getHeight()));
        this.updatePanel();
        this.rs.setValue(0);
        this.gs.setValue(0);
        this.bs.setValue(0);
    }

    public void PEN(int pen, int value) {
        this.choosenpen = pen;
        this.choosenvalue = value;
        try {
            this.col.setBackground(new Color(value));
            int r = this.col.getBackground().getRed() / 17;
            int g = this.col.getBackground().getGreen() / 17;
            int b = this.col.getBackground().getBlue() / 17;
            this.rs.setValue(r);
            this.gs.setValue(g);
            this.bs.setValue(b);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public int getValue() {
        int value = 0;
        int[] result = new int[3];
        try {
            String f = this.ind.getText();
            result[0] = GateArray.LUM(Util.hexValue("" + f.charAt(2)));
            result[1] = GateArray.LUM(Util.hexValue("" + f.charAt(1)));
            result[2] = GateArray.LUM(Util.hexValue("" + f.charAt(3)));
            value = GateArray.putRGB(result[0], result[1], result[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        return value;
    }

    public void updatePanel() {
        try {
            String f = this.ind.getText();
            int r = GateArray.LUM(Util.hexValue("" + f.charAt(2)));
            int g = GateArray.LUM(Util.hexValue("" + f.charAt(1)));
            int b = GateArray.LUM(Util.hexValue("" + f.charAt(3)));
            this.col.setBackground(new Color(r, g, b));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRed(int value) {
        try {
            this.rf.setText("" + value);
            String f = this.ind.getText();
            int r = Util.hexValue("" + f.charAt(2));
            int g = Util.hexValue("" + f.charAt(1));
            int b = Util.hexValue("" + f.charAt(3));
            r = value;
            String re = "#" + Integer.toHexString(g) + Integer.toHexString(r) + Integer.toHexString(b);
            re = re.toUpperCase();
            this.ind.setText(re);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updatePanel();
    }

    public void setGreen(int value) {
        try {
            this.gf.setText("" + value);
            String f = this.ind.getText();
            int r = Util.hexValue("" + f.charAt(2));
            int g = Util.hexValue("" + f.charAt(1));
            int b = Util.hexValue("" + f.charAt(3));
            g = value;
            String re = "#" + Integer.toHexString(g) + Integer.toHexString(r) + Integer.toHexString(b);
            re = re.toUpperCase();
            this.ind.setText(re);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updatePanel();
    }

    public void setBlue(int value) {
        try {
            this.bf.setText("" + value);
            String f = this.ind.getText();
            int r = Util.hexValue("" + f.charAt(2));
            int g = Util.hexValue("" + f.charAt(1));
            int b = Util.hexValue("" + f.charAt(3));
            b = value;
            String re = "#" + Integer.toHexString(g) + Integer.toHexString(r) + Integer.toHexString(b);
            re = re.toUpperCase();
            this.ind.setText(re);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updatePanel();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.rs = new JSlider();
        this.rf = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.gs = new JSlider();
        this.gf = new JTextField();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.bs = new JSlider();
        this.bf = new JTextField();
        this.jPanel5 = new JPanel();
        this.col = new Panel();
        this.ind = new JLabel();
        this.jPanel6 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setTitle("Color Selection");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setLayout(new FlowLayout(1, 0, 0));
        this.jLabel1.setText("Red");
        this.jLabel1.setPreferredSize(new Dimension(38, 14));
        this.jPanel2.add(this.jLabel1);
        this.rs.setMaximum(15);
        this.rs.setValue(0);
        this.rs.setMaximumSize(new Dimension(36, 24));
        this.rs.setPreferredSize(new Dimension(100, 24));
        this.rs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RGBSlider.this.rsStateChanged(evt);
            }
        });
        this.jPanel2.add(this.rs);
        this.rf.setColumns(2);
        this.rf.setEditable(false);
        this.rf.setText("0");
        this.jPanel2.add(this.rf);
        this.jPanel3.setLayout(new FlowLayout(1, 0, 0));
        this.jLabel2.setText("Green");
        this.jLabel2.setPreferredSize(new Dimension(38, 14));
        this.jPanel3.add(this.jLabel2);
        this.gs.setMaximum(15);
        this.gs.setValue(0);
        this.gs.setMaximumSize(new Dimension(36, 24));
        this.gs.setPreferredSize(new Dimension(100, 24));
        this.gs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RGBSlider.this.gsStateChanged(evt);
            }
        });
        this.jPanel3.add(this.gs);
        this.gf.setColumns(2);
        this.gf.setEditable(false);
        this.gf.setText("0");
        this.jPanel3.add(this.gf);
        this.jPanel4.setLayout(new FlowLayout(1, 0, 0));
        this.jLabel3.setText("Blue");
        this.jLabel3.setPreferredSize(new Dimension(38, 14));
        this.jPanel4.add(this.jLabel3);
        this.bs.setMaximum(15);
        this.bs.setValue(0);
        this.bs.setMaximumSize(new Dimension(36, 24));
        this.bs.setPreferredSize(new Dimension(100, 24));
        this.bs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RGBSlider.this.bsStateChanged(evt);
            }
        });
        this.jPanel4.add(this.bs);
        this.bf.setColumns(2);
        this.bf.setEditable(false);
        this.bf.setText("0");
        this.jPanel4.add(this.bf);
        this.jPanel5.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel5.setLayout(new BorderLayout());
        this.col.setBackground(new Color(0, 0, 0));
        GroupLayout colLayout = new GroupLayout(this.col);
        this.col.setLayout(colLayout);
        colLayout.setHorizontalGroup(colLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 80, Short.MAX_VALUE));
        colLayout.setVerticalGroup(colLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 80, Short.MAX_VALUE));
        this.jPanel5.add((Component)this.col, "Center");
        this.ind.setHorizontalAlignment(0);
        this.ind.setText("#000");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jPanel3, -2, -1, -2).addComponent(this.jPanel4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ind, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, GroupLayout.Alignment.TRAILING, -1, 84, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel5, GroupLayout.Alignment.LEADING, -1, 84, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ind).addContainerGap(13, Short.MAX_VALUE)));
        this.jPanel6.setLayout(new FlowLayout(1, 5, 0));
        this.jButton1.setText("OK");
        this.jButton1.setPreferredSize(this.jButton2.getPreferredSize());
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RGBSlider.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton1);
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RGBSlider.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.jPanel6, -1, 278, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void rsStateChanged(ChangeEvent evt) {
        this.setRed(this.rs.getValue());
    }

    private void gsStateChanged(ChangeEvent evt) {
        this.setGreen(this.gs.getValue());
    }

    private void bsStateChanged(ChangeEvent evt) {
        this.setBlue(this.bs.getValue());
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (CPC.normalPaintBox != null && CPC.normalPaintBox.isVisible()) {
            PaintCanvas.setPlusInk(this.choosenpen, this.getValue());
            PaintCanvas.recalculate = 1;
            normalPaint.reset();
        } else {
            OverscanCanvas.setPlusInk(this.choosenpen, this.getValue());
            OverscanCanvas.recalculate = 1;
            overscanPaint.reset();
        }
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new RGBSlider().setVisible(true);
            }
        });
    }
}

