/*
 * Decompiled with CFR 0.152.
 */
package jemu.util.ass;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jemu.core.Util;
import jemu.core.device.Computer;
import jemu.core.device.Device;
import jemu.core.device.filesystem.CPCFileSystem;
import jemu.core.device.memory.Memory;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.ui.Autotype;
import jemu.ui.Debugger;
import jemu.ui.JEMU;
import jemu.ui.Switches;
import jemu.ui.dskutil.DSKUtil;
import jemu.util.ass.Firmware;
import jemu.util.ass.Interface;
import jemu.util.ass.JTabbedPaneC;
import jemu.util.ass.Set;
import jemu.util.ass.Z80Assembler;
import jemu.util.diss.DissZ80;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.RTextScrollPane;

public class EditorPanel
extends JPanel
implements ActionListener,
MouseListener,
KeyListener {
    JPanel sizepanel;
    boolean isBusy = false;
    public boolean printInfo;
    public String asmFile;
    protected GutterIconInfo[] breakinfo;
    protected CPCFileSystem disk;
    public boolean show = false;
    public static boolean[] hasdata;
    protected final String[] multiCommands = new String[]{"BASRUN ", "BASCALL ", "RUN ", "ENT ", "ORG ", "CREATE_DSK ", "MAKEDISK ", "ADD_LOADER", "MAKELOADER", "WRITE ", "LIMIT ", "LD ", "LR ", "CALL ", "JR ", "JP ", "ADD ", "SUB ", "OR ", "XOR ", "DW ", "DEFB ", "DEFS ", "DB ", "DEFW ", "ADC ", "SBC ", "AND ", "CP ", "SLL ", "INC ", "DEC ", "EX ", "DJNZ ", "RET ", "POP ", "PUSH ", "RST ", "RLC ", "RRC ", "RL ", "RR ", "SLA ", "SRA ", "SRL ", "BIT ", "RES ", "SET ", "OUT ", "IN ", "IM ", "DS ", "RETI ", "DEFM ", "RLA", "RRA", "DAA", "CPL", "SCF", "RRCA", "IF ", "IFDEF ", "ELSE", "ENDIF", "ENDM", "READ ", "INCLUDE", "INCBIN", "DEFINE", "END ", "REPEAT", "REPT", "REND", "ALIGN"};
    protected final String[] singleCommands = new String[]{"LIST", "NOLIST", "RRD", "RLD", "LDI", "CPI", "INI", "OUTI", "LDD", "CPD", "IND", "OUTD", "LDIR", "NOP", "RLA", "RRA", "DAA", "CPL", "SCF", "RRCA", "BRK", "BREAK", "RLCA", "CCF", "HALT", "RET", "EXX", "NEG", "RETN", "CPIR", "INIR", "OTIR", "LDDR", "CPDR", "INDR", "OTDR", "DI", "EI", "RETI"};
    protected final String[] canLabel = new String[]{"LD", "CALL", "JR", "JP", "DJNZ"};
    boolean DEBUG = false;
    boolean org = true;
    public RSyntaxTextArea codeField;
    public RTextScrollPane scrollField;
    DissZ80 diss;
    Memory asmmemory;
    Z80Assembler asm;
    int ret = 13;
    String[] compiledLine;
    int line = 0;
    int address = 16384;
    public boolean modified;
    public int choosentab;
    public boolean keycombo = false;
    JButton incbutt;
    JButton decbutt;
    JLabel fontsize;
    JLabel issize;
    JTabbedPaneC jtab;
    int tabpos;
    public String opened = "";
    public String open = "";
    protected String filename;
    protected boolean write = false;
    protected String writename = "";
    protected String writepath = "";
    protected String writestring = "";
    protected boolean create = false;
    protected String createname = "";
    protected String createpath = "";
    protected String createstring = "";
    String input;
    String[] array;
    int check;
    public int[] lines;
    public static int errors;
    public static int actualLine;
    Thread Compiler;
    Thread Search;
    boolean useheader = true;
    protected int additionallines = 0;
    protected int additionallinesb = 0;
    public int search = 0;
    public int found = 0;
    private int loops = 0;
    protected String[] codelabels;
    protected String[] equs;
    public boolean stop = false;
    Firmware ware;
    protected int warnings = 0;
    String loadername;
    String[] checkread;
    int LineSize = 0;
    int PlaceHolder = 0;
    Interface tempInterface;
    int linenumber = 10;
    boolean opentab = false;
    boolean reads = false;
    int addpos = 0;
    String[] inputtext = new String[500];
    String[] objecttext = new String[500];
    protected static String BIN_HEADER;
    protected static String BIN_EYECATCHER;
    boolean todiska = false;
    boolean todiskb = false;
    boolean todiskc = false;
    boolean todiskd = false;
    boolean addloader = true;
    byte[] pdsheader = new byte[]{1, 0, 5, 2};
    boolean remarking = false;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.incbutt) {
            this.increaseFontSize();
        }
        if (e.getSource() == this.decbutt) {
            this.decreaseFontSize();
        }
    }

    public void dispose() {
        this.modified = false;
        String g = this.jtab.getTitleAt(this.tabpos);
        if (g.endsWith("*")) {
            g = g.replace("*", "");
            this.jtab.setTitleAt(this.tabpos, g);
        }
        hasdata = null;
        this.compiledLine = null;
        this.codeField.setText("");
        this.array = null;
        System.gc();
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String assembleFile(String writepath, String filename) {
        this.isBusy = true;
        this.filename = filename;
        this.writepath = writepath;
        this.opened = filename;
        if (filename != null) {
            File file = new File(writepath + filename);
            StringBuffer contents = new StringBuffer();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String text = null;
                while ((text = reader.readLine()) != null) {
                    contents.append(text).append(System.getProperty("line.separator"));
                }
            }
            catch (FileNotFoundException e) {
                this.isBusy = false;
                e.printStackTrace();
            }
            catch (IOException e) {
                this.isBusy = false;
                e.printStackTrace();
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    this.isBusy = false;
                    e.printStackTrace();
                }
            }
            String in = contents.toString();
            in = in.replace("\r", "");
            this.codeField.setText(in);
            this.codeField.select(0, 0);
            this.Assemble(false);
            this.isBusy = false;
        }
        return filename;
    }

    public void replace(String a, String b) {
        int g = this.codeField.getCaretPosition();
        String has = this.codeField.getText();
        has = has.replace(a, b);
        this.codeField.setText(has);
        this.codeField.setCaretPosition(g);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (!this.keycombo) {
            if (e.getKeyCode() != 16 && e.getKeyCode() != 17 && e.getKeyCode() != 20 && e.getKeyCode() != 18 && e.getKeyCode() != 65406 && e.getKeyCode() != 38 && e.getKeyCode() != 40 && e.getKeyCode() != 39 && e.getKeyCode() != 37 && e.getKeyCode() != 27) {
                this.modified = true;
                Interface.modified.setText("Modified");
                String tit = this.jtab.getTitleAt(this.tabpos);
                if (!tit.contains("*")) {
                    tit = tit + "*";
                    this.jtab.setTitleAt(this.tabpos, tit);
                }
            }
            this.getPosition();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.getPosition();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.getPosition();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.getPosition();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.getPosition();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.getPosition();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.getPosition();
    }

    public void getPosition() {
        Interface.position.setText(this.codeField.getCaretLineNumber() + 1 + ":" + (this.codeField.getCaretOffsetFromLineStart() + 1));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public void increaseFontSize() {
        int size = this.codeField.getFont().getSize();
        if (size < 80) {
            ++size;
        }
        if (size > 10 && size < 14) {
            this.codeField.setSyntaxEditingStyle("text/asm");
        } else {
            this.codeField.setSyntaxEditingStyle("text/plain");
        }
        this.issize.setText("" + size);
        this.codeField.setFontSize(size);
    }

    public void decreaseFontSize() {
        int size = this.codeField.getFont().getSize();
        if (size > 9) {
            --size;
        }
        if (size > 10 && size < 14) {
            this.codeField.setSyntaxEditingStyle("text/asm");
        } else {
            this.codeField.setSyntaxEditingStyle("text/plain");
        }
        this.issize.setText("" + size);
        this.codeField.setFontSize(size);
    }

    public EditorPanel(JTabbedPaneC tab, int pos) {
        this.tabpos = pos;
        this.jtab = tab;
        this.sizepanel = new JPanel();
        this.incbutt = new JButton("+");
        this.decbutt = new JButton("-");
        this.incbutt.setFocusable(false);
        this.decbutt.setFocusable(false);
        this.fontsize = new JLabel("Fontsize:");
        this.issize = new JLabel("12");
        FlowLayout layer = new FlowLayout();
        layer.setAlignment(3);
        layer.setHgap(1);
        layer.setVgap(8);
        this.sizepanel.setLayout(layer);
        this.sizepanel.add(this.fontsize);
        this.sizepanel.add(this.decbutt);
        this.sizepanel.add(this.incbutt);
        this.sizepanel.add(this.issize);
        this.decbutt.addActionListener(this);
        this.incbutt.addActionListener(this);
        this.asm = new Z80Assembler();
        this.codeField = new RSyntaxTextArea();
        this.codeField.setLocale(Locale.ENGLISH);
        try {
            this.codeField.setSyntaxEditingStyle("text/asm");
            this.codeField.setAnimateBracketMatching(true);
            this.codeField.setCaretColor(Color.BLUE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.diss = new DissZ80();
        this.initComponents();
        if (this.disk == null) {
            this.disk = new CPCFileSystem();
        }
        this.scrollField = new RTextScrollPane(this.codeField);
        this.scrollField.gutter.setBackground(this.getBackground());
        this.scrollField.gutter.setLineNumberColor(this.getForeground());
        this.scrollField.getGutter().setBookmarkIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/ico/breakpoint.gif")));
        this.scrollField.getGutter().setBookmarkingEnabled(true);
        this.scrollField.setIconRowHeaderEnabled(true);
        this.scrollField.setBackground(this.getBackground());
        this.scrollField.setLineNumbersEnabled(true);
        this.codeField.addMouseListener(this);
        this.codeField.addKeyListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollField, "Center");
        this.add((Component)this.sizepanel, "South");
        this.asmmemory = CPC.getMem();
    }

    public void disassembles() {
        FileDialog filedia = new FileDialog((Frame)new JFrame(), "Import Binary...", 0);
        filedia.setFile("*.bin");
        filedia.setVisible(true);
        this.filename = filedia.getFile();
        if (this.filename == null) {
            return;
        }
        this.writepath = filedia.getDirectory();
        this.opened = this.filename;
        this.open = this.filename;
        this.opened = this.opened.substring(0, this.opened.length() - 4);
        this.opened = this.opened + ".asm";
        this.filename = filedia.getDirectory() + filedia.getFile();
        if (this.filename != null) {
            Thread SPEECH = new Thread(){

                @Override
                public void run() {
                    try {
                        int n = JOptionPane.showConfirmDialog(new JFrame(), "Make the disassembly WinApe compatible?\n", "Info:", 0);
                        if (n == 0) {
                            Debugger.bWinape.setSelected(true);
                        } else {
                            Debugger.bWinape.setSelected(false);
                        }
                        Calendar cal = Calendar.getInstance();
                        FileInputStream get = new FileInputStream(new File(EditorPanel.this.filename));
                        byte[] input = new byte[get.available()];
                        Interface.compileprogress.setMaximum(input.length);
                        Interface.compileprogress.setStringPainted(true);
                        Interface.compileprogress.setString("Loading " + EditorPanel.this.open);
                        int count = 0;
                        while (get.available() != 0) {
                            input[count] = (byte)get.read();
                            Interface.compileprogress.setValue(count);
                            ++count;
                        }
                        String addre = null;
                        String runad = null;
                        if (Computer.CheckAMSDOS(input)) {
                            byte[] newinput = new byte[input.length - 128];
                            byte st1 = input[21];
                            byte st2 = input[22];
                            if (st1 != 0 || st2 != 0) {
                                addre = Util.hex(st2);
                                addre = addre + Util.hex(st1);
                            }
                            st1 = input[26];
                            st2 = input[27];
                            if (st1 != 0 || st2 != 0) {
                                runad = Util.hex(st2);
                                runad = runad + Util.hex(st1);
                            }
                            System.arraycopy(input, 128, newinput, 0, newinput.length);
                            input = new byte[newinput.length];
                            System.arraycopy(newinput, 0, input, 0, input.length);
                            System.out.println("Filelength is: " + input.length);
                        }
                        count = input.length;
                        get.close();
                        String result = null;
                        if (addre == null) {
                            result = JOptionPane.showInputDialog(new JFrame(), "Please enter start address:\n(Hexadecimal)\n", addre);
                            if (result == null) {
                                return;
                            }
                        } else {
                            result = addre;
                        }
                        long time = System.currentTimeMillis();
                        EditorPanel.this.address = Util.hexValue(result);
                        System.out.println("Disassembling " + EditorPanel.this.opened + "...");
                        int[] addr = new int[]{EditorPanel.this.address};
                        int len = input.length;
                        int truncated = 0;
                        while (EditorPanel.this.address + len - 1 > 65535) {
                            ++truncated;
                            --len;
                        }
                        count = len;
                        for (int p = 0; p < len; ++p) {
                            Interface.compileprogress.setValue(count);
                            EditorPanel.this.asmmemory.writeByte(EditorPanel.this.address + p, input[p]);
                        }
                        if (Debugger.bWinape.isSelected()) {
                            EditorPanel.this.codeField.append("                ;; JavaCPC disassembled binary\n                ;; disassembled from #" + Util.hex((short)EditorPanel.this.address) + " to #\n                ;; " + cal.getTime() + "\r\n\r\n");
                        } else {
                            EditorPanel.this.codeField.append("                ; JavaCPC disassembled binary\n                ; disassembled from #" + Util.hex((short)EditorPanel.this.address) + " to #\n                ; " + cal.getTime() + "\r\n\r\n");
                        }
                        EditorPanel.this.codeField.append("                ORG     &" + Util.hex((short)EditorPanel.this.address) + "\n\n");
                        if (runad != null) {
                            EditorPanel.this.codeField.append("                RUN     &" + Util.hex((short)Util.hexValue(runad)) + "\n\n");
                        }
                        boolean compileFFFF = false;
                        int max = 0;
                        while (addr[0] <= count + (EditorPanel.this.address - 1)) {
                            Interface.compileprogress.setValue(addr[0]);
                            Interface.compileprogress.setString("Disassembling &" + Util.hex((short)addr[0]));
                            EditorPanel.this.codeField.append("                " + EditorPanel.this.diss.disass(EditorPanel.this.asmmemory, addr, true, 31, 50) + "\n");
                            if (addr[0] >= 65535) {
                                compileFFFF = true;
                                break;
                            }
                            max = addr[0];
                        }
                        if (compileFFFF) {
                            addr[0] = 65535;
                            max = 65535;
                            EditorPanel.this.codeField.append("                " + EditorPanel.this.diss.disass(EditorPanel.this.asmmemory, addr, true, 31, 50) + "\n");
                        }
                        String have = EditorPanel.this.codeField.getText();
                        have = have.replace("to #", "to #" + Util.hex((short)max));
                        EditorPanel.this.codeField.setText(have);
                        long time2 = System.currentTimeMillis();
                        double time3 = time2 - time;
                        double time4 = time3 / 1000.0;
                        Interface.compileInfo.append(EditorPanel.this.open + " disassembled in " + time4 + "s to " + EditorPanel.this.opened + "\n");
                        if (truncated != 0) {
                            Interface.compileInfo.append("*WARNING* Code truncated " + truncated + " bytes!\nFile did not fit into memory! Please check start address / file length!\n");
                        }
                        Interface.compileprogress.setStringPainted(false);
                        Interface.compileprogress.setValue(0);
                        System.out.println("Done " + EditorPanel.this.opened + "...");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            SPEECH.start();
        }
    }

    public void disassemble() {
        Thread SPEECH = new Thread(){

            @Override
            public void run() {
                try {
                    int n = JOptionPane.showConfirmDialog(new JFrame(), "Make the disassembly WinApe compatible?\n", "Info:", 0);
                    if (n == 0) {
                        Debugger.bWinape.setSelected(true);
                    } else {
                        Debugger.bWinape.setSelected(true);
                    }
                    String start = JOptionPane.showInputDialog(new JFrame(), (Object)"Please enter start address:\n(Hexadecimal)\n");
                    if (start == null) {
                        return;
                    }
                    String len = JOptionPane.showInputDialog(new JFrame(), (Object)"Please enter length:\n(Hexadecimal)\n");
                    if (start == null) {
                        return;
                    }
                    int length = Util.hexValue(len);
                    long time = System.currentTimeMillis();
                    EditorPanel.this.address = Util.hexValue(start);
                    if (length + EditorPanel.this.address > 65535) {
                        return;
                    }
                    Calendar cal = Calendar.getInstance();
                    Interface.compileprogress.setMaximum(length);
                    Interface.compileprogress.setStringPainted(true);
                    Interface.compileprogress.setString("Loading " + EditorPanel.this.open);
                    int count = 0;
                    System.out.println("Disassembling " + EditorPanel.this.opened + "...");
                    int[] addr = new int[]{EditorPanel.this.address};
                    if (Debugger.bWinape.isSelected()) {
                        EditorPanel.this.codeField.append("                ;; JavaCPC disassembled binary\n                ;; disassembled from #" + Util.hex((short)EditorPanel.this.address) + " to #\n                ;; " + cal.getTime() + "\r\n\r\n");
                    } else {
                        EditorPanel.this.codeField.append("                ; JavaCPC disassembled binary\n                ; disassembled from #" + Util.hex((short)EditorPanel.this.address) + " to #\n                ; " + cal.getTime() + "\r\n\r\n");
                    }
                    EditorPanel.this.codeField.append("                ORG     &" + Util.hex((short)EditorPanel.this.address) + "\n\n");
                    for (int p = 0; p < length; ++p) {
                        Interface.compileprogress.setValue(count);
                        EditorPanel.this.asmmemory.writeByte(EditorPanel.this.address + p, GateArray.screenmemory[EditorPanel.this.address + p]);
                    }
                    int max = 0;
                    while (addr[0] <= length + (EditorPanel.this.address - 1)) {
                        Interface.compileprogress.setValue(addr[0]);
                        max = addr[0];
                        Interface.compileprogress.setString("Disassembling &" + Util.hex((short)addr[0]));
                        EditorPanel.this.codeField.append("                " + EditorPanel.this.diss.disass(EditorPanel.this.asmmemory, addr, true, 31, 50) + "\n");
                    }
                    String have = EditorPanel.this.codeField.getText();
                    have = have.replace("to #", "to #" + Util.hex((short)max));
                    EditorPanel.this.codeField.setText(have);
                    long time2 = System.currentTimeMillis();
                    double time3 = time2 - time;
                    double time4 = time3 / 1000.0;
                    Interface.compileInfo.append("Disassembled in " + time4 + "s to Assembler interface\n");
                    Interface.compileprogress.setStringPainted(false);
                    Interface.compileprogress.setValue(0);
                    System.out.println("Done " + EditorPanel.this.opened + "...");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        SPEECH.start();
    }

    public void find(String find) {
        String text = this.codeField.getText();
        for (int p = this.found; p < text.length(); ++p) {
            String rem;
            ++this.search;
            try {
                rem = text.substring(p, p + find.length());
            }
            catch (Exception e) {
                this.found = 0;
                this.search = 0;
                ++this.loops;
                if (this.loops < 2) {
                    this.find(find);
                    return;
                }
                Interface.compileInfo.append("'" + find + "' not found...\n");
                return;
            }
            if (rem.toUpperCase().equals(find.toUpperCase())) break;
        }
        this.loops = 0;
        this.found = this.search;
        this.codeField.select(this.search - 1, this.search - 1 + find.length());
    }

    public void cut() {
        this.codeField.cut();
    }

    public void copy() {
        this.codeField.copy();
    }

    public void paste() {
        this.codeField.paste();
    }

    public void undo() {
        this.codeField.undoLastAction();
    }

    public void redo() {
        this.codeField.redoLastAction();
    }

    public void selectAll() {
        this.codeField.selectAll();
    }

    public void setNull() {
        Interface.symbolInfo.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                EditorPanel.this.codelabels = new String[1];
                return EditorPanel.this.codelabels.length;
            }

            @Override
            public Object getElementAt(int i) {
                EditorPanel.this.codelabels = new String[1];
                return EditorPanel.this.codelabels[i];
            }
        });
        Interface.equInfo.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                EditorPanel.this.equs = new String[1];
                return EditorPanel.this.equs.length;
            }

            @Override
            public Object getElementAt(int i) {
                EditorPanel.this.equs = new String[1];
                return EditorPanel.this.equs[i];
            }
        });
    }

    public void setSymbolInfo() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int i;
                EditorPanel.this.codelabels = null;
                EditorPanel.this.equs = null;
                System.gc();
                Z80Assembler cfr_ignored_0 = EditorPanel.this.asm;
                EditorPanel.this.codelabels = new String[Z80Assembler.maxlabel];
                int p = 0;
                while (true) {
                    Z80Assembler cfr_ignored_1 = EditorPanel.this.asm;
                    if (p >= Z80Assembler.maxlabel) break;
                    try {
                        Z80Assembler cfr_ignored_2 = EditorPanel.this.asm;
                        EditorPanel.this.codelabels[p] = Z80Assembler.labels[p];
                        Z80Assembler cfr_ignored_3 = EditorPanel.this.asm;
                        int div = 40 - Z80Assembler.labels[p].length();
                        for (i = 0; i < div; ++i) {
                            int n = p;
                            EditorPanel.this.codelabels[n] = EditorPanel.this.codelabels[n] + " ";
                        }
                        int n = p;
                        Z80Assembler cfr_ignored_4 = EditorPanel.this.asm;
                        EditorPanel.this.codelabels[n] = EditorPanel.this.codelabels[n] + Z80Assembler.labeladdresses[p];
                    }
                    catch (Exception div) {
                        // empty catch block
                    }
                    ++p;
                }
                Arrays.sort(EditorPanel.this.codelabels);
                Interface.symbolInfo.setModel(new AbstractListModel(){

                    @Override
                    public int getSize() {
                        return EditorPanel.this.codelabels.length;
                    }

                    @Override
                    public Object getElementAt(int i) {
                        return EditorPanel.this.codelabels[i];
                    }
                });
                Z80Assembler cfr_ignored_5 = EditorPanel.this.asm;
                EditorPanel.this.equs = new String[Z80Assembler.maxequ];
                p = 0;
                while (true) {
                    Z80Assembler cfr_ignored_6 = EditorPanel.this.asm;
                    if (p >= Z80Assembler.maxequ) break;
                    Z80Assembler cfr_ignored_7 = EditorPanel.this.asm;
                    EditorPanel.this.equs[p] = Z80Assembler.EQULABEL[p];
                    try {
                        Z80Assembler cfr_ignored_8 = EditorPanel.this.asm;
                        int div = 40 - Z80Assembler.EQULABEL[p].length();
                        for (i = 0; i < div; ++i) {
                            int n = p;
                            EditorPanel.this.equs[n] = EditorPanel.this.equs[n] + " ";
                        }
                        int n = p;
                        Z80Assembler cfr_ignored_9 = EditorPanel.this.asm;
                        EditorPanel.this.equs[n] = EditorPanel.this.equs[n] + "&" + Util.hex((short)Integer.parseInt(Z80Assembler.EQU[p]));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++p;
                }
                Arrays.sort(EditorPanel.this.equs);
                Interface.equInfo.setModel(new AbstractListModel(){

                    @Override
                    public int getSize() {
                        return EditorPanel.this.equs.length;
                    }

                    @Override
                    public Object getElementAt(int i) {
                        return EditorPanel.this.equs[i];
                    }
                });
            }
        });
    }

    public void makeLabels(final boolean depth, final boolean firmw) {
        Thread co = new Thread(){

            @Override
            public void run() {
                boolean remmarks = false;
                int n = JOptionPane.showConfirmDialog(new JFrame(), "Remove the marks?\n", "Info:", 0);
                if (n == 0) {
                    remmarks = true;
                }
                if (JEMU.iframe == null && JEMU.debugframe == null) {
                    JEMU.showdebug = true;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                JEMU.debugger.getDebuggerComputer().stop();
                if (EditorPanel.this.ware == null) {
                    EditorPanel.this.ware = new Firmware();
                }
                Firmware cfr_ignored_0 = EditorPanel.this.ware;
                String codecs = Firmware.firmware.getText();
                codecs = codecs.replace("\r", "");
                String[] labels = codecs.split("\n");
                String[] codes = codecs.split("\n");
                if (firmw) {
                    for (int g = 0; g < codes.length; ++g) {
                        codes[g] = codes[g].substring(codes[g].length() - 4);
                        int recheck = labels[g].indexOf("\t");
                        if (recheck != -1) {
                            labels[g] = labels[g].substring(0, recheck);
                        }
                        labels[g] = labels[g].substring(1);
                        codes[g] = "&" + codes[g].toUpperCase();
                    }
                }
                EditorPanel.this.codeField.setEnabled(false);
                EditorPanel.this.codeField.setBackground(Color.lightGray);
                String ass = EditorPanel.this.codeField.getText();
                String[] code = ass.split("\n");
                String[] codeb = ass.split("\n");
                Interface.compileprogress.setMinimum(0);
                Interface.compileprogress.setMaximum(code.length);
                Interface.compileprogress.setStringPainted(true);
                Interface.compileprogress.setString("Reorganizing source...");
                ass = "";
                int len = codeb.length;
                if (!firmw) {
                    for (int c = 0; c < len; ++c) {
                        String codebl;
                        Interface.compileprogress.setValue(c);
                        String codebstr = codeb[c];
                        if (codebstr == null || codebstr.length() == 0 || codebstr.charAt(0) == ';' || (codebl = codebstr.toLowerCase()).startsWith("run") || codebl.startsWith("basrun") || codebl.startsWith("bascall") || codebl.contains("org")) continue;
                        if ((codebstr = codebstr.replace(" ", "")).contains(":")) {
                            while (!codebstr.endsWith(":")) {
                                codebstr = codebstr.substring(0, codebstr.length() - 1);
                            }
                        }
                        if (codebstr.contains(";")) {
                            if (codebstr.contains("&")) {
                                while (!codebstr.startsWith("&")) {
                                    codebstr = codebstr.substring(1);
                                }
                            } else {
                                while (!codebstr.startsWith(";")) {
                                    codebstr = codebstr.substring(1);
                                }
                            }
                        }
                        ass = ass + codebstr;
                    }
                }
                ass = ass.replace(":", "");
                ass = ass.replace(";;", ";");
                System.out.println(code[0]);
                if (!code[0].contains("JavaCPC disassembled binary")) {
                    JOptionPane.showMessageDialog(new JFrame(), "No JavaCPC Disassembly file.\nSorry, can't search for labels.");
                    Interface.compileprogress.setValue(0);
                    Interface.compileprogress.setStringPainted(false);
                    EditorPanel.this.codeField.setEnabled(true);
                    EditorPanel.this.codeField.setBackground(Color.white);
                    EditorPanel.this.stop = false;
                    return;
                }
                try {
                    int start = 0;
                    int end = 0;
                    String ende = "";
                    Interface.compileprogress.setStringPainted(true);
                    Interface.compileprogress.setString("Probing filesize");
                    for (int i = 0; i < code.length; ++i) {
                        Interface.compileprogress.setValue(i);
                        if (code[i].contains("ORG")) {
                            String org = code[i].replace(" ", "");
                            org = EditorPanel.this.asm.parseMath(org.substring(3));
                            start = Integer.parseInt(org);
                        }
                        if (code[i].length() <= 4 || !code[i].contains(";") || !code[i].contains(":")) continue;
                        ende = code[i];
                    }
                    if ((ende = ende.replace(" ", "")).contains(";")) {
                        while (!ende.startsWith(";")) {
                            ende = ende.substring(1);
                        }
                    }
                    ende = ende.replace(";", "");
                    String e = "";
                    for (int i = 0; i < 4; ++i) {
                        try {
                            e = e + ende.charAt(i);
                            continue;
                        }
                        catch (Exception ee) {
                            JOptionPane.showMessageDialog(new JFrame(), "No JavaCPC Disassembly file.\nSorry, can't search for labels.");
                            Interface.compileprogress.setValue(0);
                            Interface.compileprogress.setStringPainted(false);
                            EditorPanel.this.codeField.setEnabled(true);
                            EditorPanel.this.codeField.setBackground(Color.white);
                            EditorPanel.this.stop = false;
                            return;
                        }
                    }
                    ende = e;
                    Interface.compileprogress.setString("Start: &" + Util.hex(start) + " End: &" + ende);
                    ende = EditorPanel.this.asm.parseMath("&" + ende);
                    end = Integer.parseInt(ende);
                    System.out.println("Start is " + Util.hex(start));
                    System.out.println("End is " + Util.hex(end));
                    boolean hasfirmware = true;
                    if (start > 47359 && start < 48640) {
                        hasfirmware = false;
                    }
                    if (start < 36) {
                        hasfirmware = false;
                    }
                    if (start < 47360 && start + (end - start) > 47359) {
                        hasfirmware = false;
                    }
                    String label = "label_";
                    String label2 = "rel_label_";
                    String lastlabel = "";
                    String[] address = new String[131070];
                    String[] putlabel = new String[131070];
                    int putcount = 0;
                    int[] puts = new int[131070];
                    Interface.compileprogress.setStringPainted(true);
                    int b = 0;
                    boolean g = false;
                    boolean addfirmware = false;
                    if (firmw && hasfirmware) {
                        block14: for (int l = 0; l < code.length; ++l) {
                            for (int k = 0; k < codes.length; ++k) {
                                Interface.compileprogress.setValue(l);
                                if (!code[l].contains(codes[k])) continue;
                                String spaces = "";
                                int h = labels[k].length() - 5;
                                for (int m = 0; m < h; ++m) {
                                    spaces = spaces + " ";
                                }
                                spaces = spaces + ";";
                                Interface.compileprogress.setString(labels[k]);
                                code[l] = code[l].replace(codes[k], labels[k]);
                                code[l] = code[l].replace(spaces, ";");
                                addfirmware = true;
                                continue block14;
                            }
                        }
                    }
                    if (!firmw) {
                        for (int c = 0; c < code.length; ++c) {
                            if (code[c].length() < 3) continue;
                            String codebstr = code[c];
                            String codestr = code[c].toLowerCase();
                            if (EditorPanel.this.stop) {
                                Interface.compileprogress.setValue(0);
                                Interface.compileprogress.setStringPainted(false);
                                EditorPanel.this.codeField.setEnabled(true);
                                EditorPanel.this.codeField.setBackground(Color.white);
                                EditorPanel.this.stop = false;
                                JEMU.debugger.getDebuggerComputer().start();
                                return;
                            }
                            if (++b > 100) {
                                b = 0;
                                Interface.compileprogress.setValue(c);
                                Interface.compileprogress.setString("Line: " + (c + 1) + " To do: " + (code.length - c) + " last label: " + lastlabel);
                            }
                            if (codestr.contains("org")) continue;
                            block18: for (int i = start; i < end; ++i) {
                                String checkLabel = Util.hex((short)i);
                                if (!depth && codebstr.contains(";" + checkLabel)) {
                                    if (ass.contains("&" + checkLabel)) {
                                        lastlabel = "set:" + label + checkLabel;
                                        Interface.compileprogress.setString("Line: " + (c + 1) + " To do: " + (code.length - c) + " last label: " + lastlabel);
                                        code[c] = codebstr = codebstr.replace(codebstr, label + checkLabel + "\n" + codebstr);
                                    }
                                } else if (depth) {
                                    int f = i + 1;
                                    String checkRelLabel = Util.hex((short)f);
                                    if (codebstr.contains(";" + checkRelLabel) && !codebstr.startsWith(label2 + checkRelLabel)) {
                                        if (ass.contains("&" + checkLabel)) {
                                            lastlabel = "set+1:" + label2 + checkLabel;
                                            Interface.compileprogress.setString("Line: " + (c + 1) + " To do: " + (code.length - c) + " last label: " + lastlabel);
                                            code[c] = codebstr = codebstr.replace(codebstr, label2 + checkRelLabel + "\n" + codebstr);
                                        }
                                    } else {
                                        f = i - 1;
                                        checkRelLabel = Util.hex((short)f);
                                        if (codebstr.contains(";" + checkRelLabel) && !codebstr.startsWith(label2 + checkRelLabel) && ass.contains("&" + checkLabel)) {
                                            lastlabel = "set-1:" + label2 + checkLabel;
                                            Interface.compileprogress.setString("Line: " + (c + 1) + " To do: " + (code.length - c) + " last label: " + lastlabel);
                                            code[c] = codebstr = codebstr.replace(codebstr, label2 + checkRelLabel + "\n" + codebstr);
                                        }
                                    }
                                }
                                for (int h = 0; h < EditorPanel.this.canLabel.length; ++h) {
                                    if (!codebstr.contains(EditorPanel.this.canLabel[h])) continue;
                                    if (!depth && !codebstr.contains(";" + checkLabel) && codebstr.contains("&" + checkLabel)) {
                                        if (!ass.contains(";" + checkLabel)) continue block18;
                                        code[c] = codebstr = codebstr.replace("&" + checkLabel, label + checkLabel);
                                        code[c] = codebstr = codebstr.replace("     ;", ";");
                                        continue block18;
                                    }
                                    if (!depth) continue block18;
                                    int f = i + 1;
                                    String checkass2 = Util.hex((short)f);
                                    if (!codebstr.contains(";" + checkLabel) && codebstr.contains("&" + checkass2)) {
                                        if (!ass.contains(";" + checkLabel)) continue block18;
                                        code[c] = codebstr = codebstr.replace("&" + checkass2, label2 + checkLabel + "+1");
                                        code[c] = codebstr = codebstr.replace("           ;", ";");
                                        continue block18;
                                    }
                                    f = i - 1;
                                    checkass2 = Util.hex((short)f);
                                    if (codebstr.contains(";" + checkLabel) || !codebstr.contains("&" + checkass2) || !ass.contains(";" + checkLabel)) continue block18;
                                    code[c] = codebstr = codebstr.replace("&" + checkass2, label2 + checkLabel + "-1");
                                    code[c] = codebstr = codebstr.replace("           ;", ";");
                                    continue block18;
                                }
                            }
                        }
                    }
                    if (!firmw) {
                        for (int i = 0; i < putcount; ++i) {
                            code[puts[i]] = code[puts[i]].replace(address[i], putlabel[i]);
                        }
                    }
                    String out = "";
                    EditorPanel.this.codeField.setText("");
                    Interface.compileprogress.setString("Rebuilding sourcecode...");
                    for (int p = 0; p < code.length; ++p) {
                        if (remmarks && code[p].contains(";") && code[p].contains(":") && !code[p].contains("assembly")) {
                            while (!code[p].endsWith(":")) {
                                code[p] = code[p].substring(0, code[p].length() - 1);
                            }
                            while (!code[p].endsWith(";")) {
                                code[p] = code[p].substring(0, code[p].length() - 1);
                            }
                            while (!code[p].endsWith(" ")) {
                                code[p] = code[p].substring(0, code[p].length() - 1);
                            }
                            while (code[p].endsWith(" ")) {
                                code[p] = code[p].substring(0, code[p].length() - 1);
                            }
                        }
                        Interface.compileprogress.setValue(p);
                        EditorPanel.this.codeField.append(code[p] + "\n");
                    }
                    if (firmw && addfirmware) {
                        String get = EditorPanel.this.codeField.getText();
                        out = out + "\nNOLIST\n\n;; ---- USED FIRMWARE LABELS ---- ;;\n";
                        Firmware cfr_ignored_1 = EditorPanel.this.ware;
                        String[] firm = Firmware.firmware.getText().split("\n");
                        for (int t = 0; t < firm.length; ++t) {
                            if (!get.contains(labels[t])) continue;
                            out = out + firm[t] + "\n";
                        }
                    }
                    out = out.replace("\r", "");
                    EditorPanel.this.codeField.append(out);
                    Interface.compileprogress.setValue(0);
                    Interface.compileprogress.setStringPainted(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                EditorPanel.this.codeField.setEnabled(true);
                EditorPanel.this.codeField.setBackground(Color.white);
                JEMU.debugger.getDebuggerComputer().start();
            }
        };
        co.start();
    }

    public void makeLabels2(final boolean depth) {
        Thread co = new Thread(){

            @Override
            public void run() {
                if (JEMU.iframe == null && JEMU.debugframe == null) {
                    JEMU.showdebug = true;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                JEMU.debugger.getDebuggerComputer().stop();
                EditorPanel.this.codeField.setEnabled(false);
                EditorPanel.this.codeField.setBackground(Color.lightGray);
                String ass = EditorPanel.this.codeField.getText();
                String[] code = ass.split("\n");
                String[] codeb = ass.split("\n");
                ass = "";
                for (int c = 0; c < codeb.length; ++c) {
                    codeb[c] = codeb[c].replace(" ", "");
                    if (codeb[c].toLowerCase().contains("org")) {
                        codeb[c] = "";
                    } else if (codeb[c].startsWith(";") || codeb[c].toLowerCase().startsWith("run") || codeb[c].toLowerCase().startsWith("basrun") || codeb[c].toLowerCase().startsWith("bascall")) {
                        codeb[c] = "";
                    } else if (codeb[c].contains(":")) {
                        while (!codeb[c].endsWith(":")) {
                            codeb[c] = codeb[c].substring(0, codeb[c].length() - 1);
                        }
                    }
                    if (codeb[c].contains(";")) {
                        if (codeb[c].contains("&")) {
                            while (!codeb[c].startsWith("&")) {
                                codeb[c] = codeb[c].substring(1);
                            }
                        } else {
                            while (!codeb[c].startsWith(";")) {
                                codeb[c] = codeb[c].substring(1);
                            }
                        }
                    }
                    ass = ass + codeb[c];
                }
                System.out.println(ass);
                if (!code[0].contains("JavaCPC disassembled binary")) {
                    JOptionPane.showMessageDialog(new JFrame(), "No JavaCPC Disassembly file.\nSorry, can't search for labels.");
                    Interface.compileprogress.setValue(0);
                    Interface.compileprogress.setStringPainted(false);
                    EditorPanel.this.codeField.setEnabled(true);
                    EditorPanel.this.codeField.setBackground(Color.white);
                    EditorPanel.this.stop = false;
                    return;
                }
                try {
                    int start = 0;
                    int end = 0;
                    String ende = "";
                    for (int i = 0; i < code.length; ++i) {
                        Interface.compileprogress.setValue(i);
                        if (code[i].contains("ORG")) {
                            String org = code[i].replace(" ", "");
                            org = EditorPanel.this.asm.parseMath(org.substring(3));
                            start = Integer.parseInt(org);
                        }
                        if (code[i].length() <= 4) continue;
                        ende = code[i];
                    }
                    ende = ende.replace(" ", "");
                    while (!ende.startsWith(";")) {
                        ende = ende.substring(1);
                    }
                    ende = ende.replace(";", "");
                    String e = "";
                    for (int i = 0; i < 4; ++i) {
                        e = e + ende.charAt(i);
                    }
                    ende = e;
                    ende = EditorPanel.this.asm.parseMath("&" + ende);
                    end = Integer.parseInt(ende);
                    System.out.println("Start is " + Util.hex(start));
                    System.out.println("End is " + Util.hex(end));
                    String label = "label_";
                    String label2 = "rel_label_";
                    Interface.compileprogress.setMinimum(0);
                    Interface.compileprogress.setMaximum(code.length);
                    String lastlabel = "";
                    String[] address = new String[131070];
                    String[] putlabel = new String[131070];
                    int putcount = 0;
                    int[] puts = new int[131070];
                    Interface.compileprogress.setStringPainted(false);
                    int b = 0;
                    for (int c = 0; c < code.length; ++c) {
                        if (EditorPanel.this.stop) {
                            Interface.compileprogress.setValue(0);
                            Interface.compileprogress.setStringPainted(false);
                            EditorPanel.this.codeField.setEnabled(true);
                            EditorPanel.this.codeField.setBackground(Color.white);
                            EditorPanel.this.stop = false;
                            JEMU.debugger.getDebuggerComputer().start();
                            return;
                        }
                        if (++b > 20) {
                            Interface.compileprogress.setValue(c);
                            b = 0;
                        }
                        if (code[c].toLowerCase().contains("org")) continue;
                        for (int i = start; i < end; ++i) {
                            String checkass2;
                            int f;
                            String checkass = Util.hex((short)i);
                            if (code[c].contains(";" + checkass)) {
                                if (ass.contains("&" + checkass)) {
                                    lastlabel = "set:" + label + checkass;
                                    code[c] = code[c].replace(code[c], label + checkass + "\n" + code[c]);
                                }
                            } else if (depth) {
                                f = i + 1;
                                checkass2 = Util.hex((short)f);
                                if (code[c].contains(";" + checkass2)) {
                                    if (ass.contains("&" + checkass)) {
                                        lastlabel = "set+1:" + label2 + checkass;
                                        code[c] = code[c].replace(code[c], label2 + checkass2 + "\n" + code[c]);
                                    }
                                } else {
                                    f = i - 1;
                                    checkass2 = Util.hex((short)f);
                                    if (code[c].contains(";" + checkass2) && ass.contains("&" + checkass)) {
                                        lastlabel = "set-1:" + label2 + checkass;
                                        code[c] = code[c].replace(code[c], label2 + checkass2 + "\n" + code[c]);
                                    }
                                }
                            }
                            if (!code[c].contains(";" + checkass) && code[c].contains("&" + checkass)) {
                                if (!ass.contains(";" + checkass)) continue;
                                code[c] = code[c].replace("&" + checkass, label + checkass);
                                continue;
                            }
                            if (!depth) continue;
                            f = i + 1;
                            checkass2 = Util.hex((short)f);
                            if (!code[c].contains(";" + checkass) && code[c].contains("&" + checkass2)) {
                                if (!ass.contains(";" + checkass)) continue;
                                code[c] = code[c].replace("&" + checkass2, label2 + checkass + "+1");
                                continue;
                            }
                            f = i - 1;
                            checkass2 = Util.hex((short)f);
                            if (code[c].contains(";" + checkass) || !code[c].contains("&" + checkass2) || !ass.contains(";" + checkass)) continue;
                            code[c] = code[c].replace("&" + checkass2, label2 + checkass + "-1");
                        }
                    }
                    for (int i = 0; i < putcount; ++i) {
                        code[puts[i]] = code[puts[i]].replace(address[i], putlabel[i]);
                    }
                    String out = "";
                    for (int p = 0; p < code.length; ++p) {
                        if (++b > 5) {
                            Interface.compileprogress.setValue(p);
                            b = 0;
                        }
                        out = out + code[p] + "\n";
                    }
                    EditorPanel.this.codeField.setText(out);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                EditorPanel.this.codeField.setEnabled(true);
                EditorPanel.this.codeField.setBackground(Color.white);
                JEMU.debugger.getDebuggerComputer().start();
            }
        };
        co.setPriority(10);
        co.start();
    }

    protected String checkSemicolon(String in) {
        String content = in;
        while (content.contains(";")) {
            content = content.substring(0, content.length() - 1);
        }
        if (content.contains("\"") || content.contains("'")) {
            in = in.replace(";", "~semlc0I0n~");
        }
        return in;
    }

    public int getLineSize() {
        return this.PlaceHolder + this.LineSize;
    }

    protected void Align(String input) {
        String alignit = input.replace("ALIGN ", "");
        System.out.println("Align with " + alignit);
        System.out.print(Util.hex((short)this.asm.pos) + " to ");
        double doubleaddr = this.asm.pos;
        int addr = this.asm.pos;
        double doublealign = Integer.parseInt(alignit);
        int align = Integer.parseInt(alignit);
        double rest = 1.0;
        while (rest != 0.0) {
            rest = (doubleaddr += 1.0) / doublealign - (double)(++addr / align);
            if (!this.DEBUG) continue;
            System.out.println(Util.hex((short)addr) + " - " + rest);
        }
        this.asm.pos = addr;
        System.out.println(Util.hex((short)this.asm.pos));
    }

    public void Assemble(final String code, final boolean SyntaxCheck) {
        if (Interface.compileprogress == null) {
            this.tempInterface = new Interface();
            this.printInfo = true;
        }
        final EditorPanel epanel = this;
        this.Compiler = new Thread(){

            @Override
            public void run() {
                String place;
                int p;
                int p2;
                String check;
                int v;
                if (EditorPanel.this.printInfo) {
                    GateArray.cpc.fromautoboot = true;
                    GateArray.cpc.BasicAutoType("MODE 2:PRINT\"Assembling " + EditorPanel.this.asmFile + "\"");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                GateArray.cpc.getPSG().resetRegisters();
                System.gc();
                EditorPanel.this.addpos = 0;
                EditorPanel.this.breakinfo = EditorPanel.this.scrollField.getGutter().getBookmarks();
                int[] breakline = new int[EditorPanel.this.breakinfo.length];
                Interface.compileprogress.setStringPainted(true);
                Interface.compileprogress.setString("Checking for breakpoints");
                Interface.compileprogress.setMaximum(EditorPanel.this.breakinfo.length);
                for (int i = 0; i < EditorPanel.this.breakinfo.length; ++i) {
                    Interface.compileprogress.setValue(i);
                    EditorPanel.this.codeField.setCaretPosition(EditorPanel.this.breakinfo[i].getMarkedOffset());
                    breakline[i] = EditorPanel.this.codeField.getCaretLineNumber();
                }
                EditorPanel.this.show = Interface.show.isSelected();
                if (JEMU.iframe == null && JEMU.debugframe == null) {
                    JEMU.showdebug = true;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception i) {
                        // empty catch block
                    }
                }
                JEMU.debugger.getDebuggerComputer().stop();
                JEMU.debugger.removeAllBreakpoints();
                Interface.compileprogress.setString("Initialising...");
                EditorPanel.this.lines = new int[code.split("\n").length + 50000];
                EditorPanel.this.useheader = true;
                EditorPanel.this.codeField.setEnabled(false);
                long time = System.currentTimeMillis();
                for (int i = 0; i < 100; ++i) {
                    EditorPanel.this.asm.deflabels[i] = null;
                    EditorPanel.this.asm.defs[i] = null;
                }
                EditorPanel.this.asm.defpos = 0;
                EditorPanel.this.asm.lowest = 65535;
                EditorPanel.this.asm.highest = 0;
                EditorPanel.this.asm.launch = 0;
                EditorPanel.this.asm.baslaunch = 0;
                EditorPanel.this.asm.bascall = 0;
                EditorPanel.this.asm.limit = 65535;
                EditorPanel.this.asm.equ = 0;
                EditorPanel.this.writename = "";
                EditorPanel.this.createname = "";
                EditorPanel.this.asm.hasorg = false;
                errors = 0;
                EditorPanel.this.line = 0;
                Interface.compileInfo.setText("");
                EditorPanel.this.setNull();
                Interface.errorInfo.setText("");
                Interface.breakpoints.setText("");
                Interface.stringsInfo.setText("");
                EditorPanel.this.input = code + "\n";
                EditorPanel.this.warnings = 0;
                EditorPanel.this.checkread = EditorPanel.this.input.split("\n");
                Interface.compileprogress.setMaximum(EditorPanel.this.checkread.length);
                StringBuilder build = new StringBuilder();
                for (v = 0; v < EditorPanel.this.checkread.length; ++v) {
                    check = EditorPanel.this.checkread[v];
                    while (check.startsWith(" ")) {
                        check = check.substring(1);
                    }
                    while (check.startsWith("\t")) {
                        check = check.substring(1);
                    }
                    if (!(!check.contains(";") || check.contains("\"") && check.contains("'"))) {
                        String[] p3 = check.split(";");
                        try {
                            check = p3[0];
                        }
                        catch (Exception e) {
                            check = "";
                        }
                    }
                    while (check.endsWith(" ")) {
                        check = check.substring(0, check.length() - 1);
                    }
                    while (check.endsWith("\t")) {
                        check = check.substring(0, check.length() - 1);
                    }
                    build.append(check).append('\n');
                }
                EditorPanel.this.input = build.toString();
                for (v = 0; v < EditorPanel.this.checkread.length; ++v) {
                    Interface.compileprogress.setValue(v);
                    check = EditorPanel.this.checkread[v];
                    while (check.startsWith(" ")) {
                        check = check.substring(1);
                    }
                    while (check.startsWith("\t")) {
                        check = check.substring(1);
                    }
                    if (check.toLowerCase().startsWith("read ") || check.toLowerCase().startsWith("read\t")) {
                        System.out.println("Reading!");
                        EditorPanel.this.input = EditorPanel.this.searchReads(EditorPanel.this.input);
                        continue;
                    }
                    if ((check.toLowerCase().startsWith("repeat ") || check.toLowerCase().startsWith("repeat\t")) && !check.contains("\"")) {
                        System.out.println("Repeating!");
                        EditorPanel.this.input = EditorPanel.this.Repeat(EditorPanel.this.input, false);
                        continue;
                    }
                    if ((check.toLowerCase().startsWith("rept ") || check.toLowerCase().startsWith("rept\t")) && !check.contains("\"")) {
                        System.out.println("Repeating!");
                        EditorPanel.this.input = EditorPanel.this.Repeat(EditorPanel.this.input, true);
                        continue;
                    }
                    if (!check.toLowerCase().startsWith("include ") && !check.toLowerCase().startsWith("include\t")) continue;
                    System.out.println("Including!");
                    EditorPanel.this.input = EditorPanel.this.searchInclude(EditorPanel.this.input);
                }
                EditorPanel.this.compiledLine = new String[EditorPanel.this.lines.length + 50000];
                System.gc();
                int oldline = 0;
                int pos = 0;
                Interface.compileprogress.setStringPainted(true);
                Interface.compileprogress.setString("Parsing source code");
                Interface.compileprogress.setMaximum(EditorPanel.this.input.length());
                for (p2 = 0; p2 < EditorPanel.this.input.length(); ++p2) {
                    Interface.compileprogress.setValue(p2);
                    if (EditorPanel.this.compiledLine[EditorPanel.this.line] == null) {
                        EditorPanel.this.compiledLine[EditorPanel.this.line] = "";
                    }
                    EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].replace("\t", " ");
                    if (EditorPanel.this.compiledLine[EditorPanel.this.line].contains(":equ")) {
                        EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].replace(":equ", " equ");
                    }
                    if (EditorPanel.this.compiledLine[EditorPanel.this.line].contains(":EQU")) {
                        EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].replace(":EQU", " EQU");
                    }
                    if (EditorPanel.this.compiledLine[EditorPanel.this.line].contains(":defw")) {
                        EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].replace(":defw", " dw");
                    }
                    if (EditorPanel.this.compiledLine[EditorPanel.this.line].contains(":DEFW")) {
                        EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].replace(":DEFW", " DW");
                    }
                    if (EditorPanel.this.compiledLine[EditorPanel.this.line].contains(":defb")) {
                        EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].replace(":defb", " db");
                    }
                    if (EditorPanel.this.compiledLine[EditorPanel.this.line].contains(":DEFB")) {
                        EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].replace(":DEFB", " DB");
                    }
                    if (EditorPanel.this.compiledLine[EditorPanel.this.line].contains(":dw")) {
                        EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].replace(":dw", " dw");
                    }
                    if (EditorPanel.this.compiledLine[EditorPanel.this.line].contains(":DW")) {
                        EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].replace(":DW", " DW");
                    }
                    if (EditorPanel.this.compiledLine[EditorPanel.this.line].contains(":db")) {
                        EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].replace(":db", " db");
                    }
                    if (EditorPanel.this.compiledLine[EditorPanel.this.line].contains(":DB")) {
                        EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].replace(":DB", " DB");
                    }
                    if (EditorPanel.this.compiledLine[EditorPanel.this.line].contains(":") && !EditorPanel.this.compiledLine[EditorPanel.this.line].contains("\"") && !EditorPanel.this.compiledLine[EditorPanel.this.line].contains("'")) {
                        EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].replace(":", ": ");
                    }
                    EditorPanel.this.check = EditorPanel.this.input.charAt(p2);
                    if (EditorPanel.this.check == 10) {
                        int tg;
                        ++oldline;
                        try {
                            EditorPanel.this.lines[pos] = oldline;
                        }
                        catch (Exception e) {
                            int[] blines = new int[EditorPanel.this.lines.length + 100];
                            System.arraycopy(EditorPanel.this.lines, 0, blines, 0, EditorPanel.this.lines.length);
                            EditorPanel.this.lines = new int[blines.length];
                            System.arraycopy(blines, 0, EditorPanel.this.lines, 0, EditorPanel.this.lines.length);
                            EditorPanel.this.lines[pos] = oldline;
                        }
                        while (EditorPanel.this.compiledLine[EditorPanel.this.line].endsWith(" ")) {
                            EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].substring(0, EditorPanel.this.compiledLine[EditorPanel.this.line].length() - 1);
                        }
                        if (EditorPanel.this.compiledLine[EditorPanel.this.line] != null) {
                            while (EditorPanel.this.compiledLine[EditorPanel.this.line].startsWith(" ")) {
                                EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].substring(1);
                            }
                            while (EditorPanel.this.compiledLine[EditorPanel.this.line].startsWith("\t")) {
                                EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].substring(1);
                            }
                        }
                        if (EditorPanel.this.compiledLine[EditorPanel.this.line] != null) {
                            int recheck;
                            if (EditorPanel.this.compiledLine[EditorPanel.this.line].contains(";") && (EditorPanel.this.compiledLine[EditorPanel.this.line].contains("\"") || EditorPanel.this.compiledLine[EditorPanel.this.line].contains("'")) && (EditorPanel.this.compiledLine[EditorPanel.this.line].toUpperCase().startsWith("DB ") || EditorPanel.this.compiledLine[EditorPanel.this.line].toUpperCase().startsWith("DEFB ") || EditorPanel.this.compiledLine[EditorPanel.this.line].toUpperCase().startsWith("DEFM ") || EditorPanel.this.compiledLine[EditorPanel.this.line].toUpperCase().startsWith("CP "))) {
                                EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.checkSemicolon(EditorPanel.this.compiledLine[EditorPanel.this.line]);
                            }
                            if ((recheck = EditorPanel.this.compiledLine[EditorPanel.this.line].indexOf(";")) != -1) {
                                EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].substring(0, recheck);
                            }
                        }
                        if (EditorPanel.this.compiledLine[EditorPanel.this.line] != null && EditorPanel.this.compiledLine[EditorPanel.this.line].startsWith(".")) {
                            String c = EditorPanel.this.compiledLine[EditorPanel.this.line];
                            c = c.substring(1);
                            String d = "";
                            boolean replace = true;
                            while (c.length() > 0 && !c.startsWith(" ")) {
                                try {
                                    d = d + c.charAt(0);
                                    c = c.substring(1);
                                }
                                catch (Exception e) {
                                    replace = false;
                                    break;
                                }
                            }
                            if (replace) {
                                EditorPanel.this.compiledLine[EditorPanel.this.line] = c = "." + d + ": " + c;
                            }
                        }
                        if (EditorPanel.this.compiledLine[EditorPanel.this.line].startsWith(".")) {
                            EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].substring(1);
                        }
                        EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.checkString(EditorPanel.this.compiledLine[EditorPanel.this.line]);
                        if (EditorPanel.this.compiledLine[EditorPanel.this.line] != null && EditorPanel.this.compiledLine[EditorPanel.this.line].contains("~breakMEhere~")) {
                            String[] a2 = EditorPanel.this.compiledLine[EditorPanel.this.line].split("~breakMEhere~");
                            for (int g = 0; g < a2.length; ++g) {
                                a2[g] = a2[g].replace("~breakMEhere~", "");
                                if (a2[g].length() <= 0) continue;
                                EditorPanel.this.compiledLine[EditorPanel.this.line] = "";
                                for (tg = 0; tg < a2[g].length(); ++tg) {
                                    if (a2[g].charAt(tg) > '\u0019' || a2[g].charAt(tg) == '\t') {
                                        if (a2[g].charAt(tg) == '\t') {
                                            int n = EditorPanel.this.line;
                                            EditorPanel.this.compiledLine[n] = EditorPanel.this.compiledLine[n] + " ";
                                            continue;
                                        }
                                        int n = EditorPanel.this.line;
                                        EditorPanel.this.compiledLine[n] = EditorPanel.this.compiledLine[n] + a2[g].charAt(tg);
                                        continue;
                                    }
                                    int n = EditorPanel.this.line;
                                    EditorPanel.this.compiledLine[n] = EditorPanel.this.compiledLine[n] + " ";
                                }
                                EditorPanel.this.additionallinesb = a2.length;
                                while (EditorPanel.this.compiledLine[EditorPanel.this.line].startsWith(" ")) {
                                    EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].substring(1);
                                }
                                while (EditorPanel.this.compiledLine[EditorPanel.this.line].endsWith(" ")) {
                                    EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].substring(0, EditorPanel.this.compiledLine[EditorPanel.this.line].length() - 1);
                                }
                                if (EditorPanel.this.compiledLine[EditorPanel.this.line].length() <= 0) continue;
                                ++EditorPanel.this.line;
                                EditorPanel.this.lines[pos] = oldline;
                                ++pos;
                            }
                        }
                        if (EditorPanel.this.compiledLine[EditorPanel.this.line] != null && EditorPanel.this.compiledLine[EditorPanel.this.line].startsWith(":")) {
                            EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].substring(1);
                        }
                        if (EditorPanel.this.compiledLine[EditorPanel.this.line] != null) {
                            while (EditorPanel.this.compiledLine[EditorPanel.this.line].endsWith(" ")) {
                                EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].substring(0, EditorPanel.this.compiledLine[EditorPanel.this.line].length() - 1);
                            }
                        }
                        if (EditorPanel.this.compiledLine[EditorPanel.this.line] != null) {
                            if (EditorPanel.this.compiledLine[EditorPanel.this.line].contains(":") && !EditorPanel.this.compiledLine[EditorPanel.this.line].endsWith(":") && !EditorPanel.this.compiledLine[EditorPanel.this.line].contains("\"") && !EditorPanel.this.compiledLine[EditorPanel.this.line].toUpperCase().contains("EQU")) {
                                String[] a2 = EditorPanel.this.compiledLine[EditorPanel.this.line].split(":");
                                for (int g = 0; g < a2.length; ++g) {
                                    a2[g] = a2[g].replace(":", "");
                                    if (a2[g].length() <= 0) continue;
                                    EditorPanel.this.compiledLine[EditorPanel.this.line] = "";
                                    for (tg = 0; tg < a2[g].length(); ++tg) {
                                        if (a2[g].charAt(tg) > '\u0019' || a2[g].charAt(tg) == '\t') {
                                            if (a2[g].charAt(tg) == '\t') {
                                                int n = EditorPanel.this.line;
                                                EditorPanel.this.compiledLine[n] = EditorPanel.this.compiledLine[n] + " ";
                                                continue;
                                            }
                                            int n = EditorPanel.this.line;
                                            EditorPanel.this.compiledLine[n] = EditorPanel.this.compiledLine[n] + a2[g].charAt(tg);
                                            continue;
                                        }
                                        int n = EditorPanel.this.line;
                                        EditorPanel.this.compiledLine[n] = EditorPanel.this.compiledLine[n] + " ";
                                    }
                                    EditorPanel.this.additionallines = a2.length;
                                    while (EditorPanel.this.compiledLine[EditorPanel.this.line].startsWith(" ")) {
                                        EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].substring(1);
                                    }
                                    while (EditorPanel.this.compiledLine[EditorPanel.this.line].endsWith(" ")) {
                                        EditorPanel.this.compiledLine[EditorPanel.this.line] = EditorPanel.this.compiledLine[EditorPanel.this.line].substring(0, EditorPanel.this.compiledLine[EditorPanel.this.line].length() - 1);
                                    }
                                    if (EditorPanel.this.compiledLine[EditorPanel.this.line].length() <= 0) continue;
                                    ++EditorPanel.this.line;
                                    EditorPanel.this.lines[pos] = oldline;
                                    ++pos;
                                }
                            } else if (EditorPanel.this.compiledLine[EditorPanel.this.line].length() > 0) {
                                ++EditorPanel.this.line;
                                ++pos;
                            }
                        }
                    }
                    if (EditorPanel.this.check == 10 || EditorPanel.this.check == 13) continue;
                    if (EditorPanel.this.check == 9) {
                        int n = EditorPanel.this.line;
                        EditorPanel.this.compiledLine[n] = EditorPanel.this.compiledLine[n] + " ";
                        continue;
                    }
                    int n = EditorPanel.this.line;
                    EditorPanel.this.compiledLine[n] = EditorPanel.this.compiledLine[n] + EditorPanel.this.input.charAt(p2);
                }
                Interface.compileprogress.setMaximum(EditorPanel.this.line);
                for (p2 = 0; p2 < EditorPanel.this.line; ++p2) {
                    Interface.compileprogress.setValue(p2);
                    EditorPanel.this.compiledLine[p2] = EditorPanel.this.formatString(EditorPanel.this.compiledLine[p2]);
                }
                pos = 0;
                EditorPanel.this.array = new String[EditorPanel.this.line + EditorPanel.this.additionallines + EditorPanel.this.additionallinesb];
                for (p2 = 0; p2 < EditorPanel.this.line; ++p2) {
                    if (EditorPanel.this.compiledLine[p2].length() <= 0) continue;
                    EditorPanel.this.array[pos] = EditorPanel.this.compiledLine[p2];
                    ++pos;
                }
                EditorPanel.this.compiledLine = new String[pos];
                for (p2 = 0; p2 < pos; ++p2) {
                    EditorPanel.this.compiledLine[p2] = EditorPanel.this.array[p2];
                }
                boolean nolist = false;
                EditorPanel.this.asm.pos = 0;
                hasdata = new boolean[65537];
                for (p = 0; p < EditorPanel.this.compiledLine.length; ++p) {
                    if (!EditorPanel.this.compiledLine[p].toUpperCase().contains("ORG ")) continue;
                    String org = EditorPanel.this.asm.parseMath(EditorPanel.this.compiledLine[p].substring(3));
                    EditorPanel.this.asm.lowest = EditorPanel.this.asm.pos = Integer.parseInt(org);
                    EditorPanel.this.asm.hasorg = true;
                    EditorPanel.this.asm.startoff = EditorPanel.this.asm.pos;
                    break;
                }
                EditorPanel.this.asm.prepareLabels();
                EditorPanel.this.asm.prepareEQU();
                Interface.compileprogress.setMinimum(0);
                Interface.compileprogress.setMaximum(EditorPanel.this.compiledLine.length);
                Interface.compileprogress.setStringPainted(true);
                EditorPanel.this.write = false;
                EditorPanel.this.create = false;
                EditorPanel.this.addloader = false;
                EditorPanel.this.loadername = "";
                for (p = 0; p < EditorPanel.this.compiledLine.length; ++p) {
                    Interface.compileprogress.setValue(p);
                    Interface.compileprogress.setString("PASS 1 - Assembling line " + actualLine);
                    if (EditorPanel.this.compiledLine[p] == null) continue;
                    actualLine = EditorPanel.this.lines[p];
                    EditorPanel.this.org = EditorPanel.this.compiledLine[p].toUpperCase().contains("ORG");
                    if (EditorPanel.this.compiledLine[p].startsWith("ADD_LOADER")) {
                        EditorPanel.this.addloader = true;
                        EditorPanel.this.loadername = EditorPanel.this.compiledLine[p].substring(10);
                    } else if (EditorPanel.this.compiledLine[p].startsWith("WRITE") && EditorPanel.this.compiledLine[p].contains("\"")) {
                        EditorPanel.this.write = true;
                        EditorPanel.this.writestring = EditorPanel.this.compiledLine[p].substring(5);
                    } else if ((EditorPanel.this.compiledLine[p].startsWith("CREATE_DSK") || EditorPanel.this.compiledLine[p].startsWith("MAKEDISK")) && EditorPanel.this.compiledLine[p].contains("\"")) {
                        EditorPanel.this.create = true;
                        EditorPanel.this.createstring = EditorPanel.this.compiledLine[p].substring(10);
                    } else if (EditorPanel.this.compiledLine[p].equals("NOLIST")) {
                        nolist = true;
                    } else if (EditorPanel.this.compiledLine[p].equals("NOHEADER")) {
                        EditorPanel.this.useheader = false;
                    } else if (EditorPanel.this.compiledLine[p].equals("LIST")) {
                        nolist = false;
                    } else if (EditorPanel.this.compiledLine[p].startsWith("ALIGN ") && !EditorPanel.this.compiledLine[p].contains("\"")) {
                        EditorPanel.this.Align(EditorPanel.this.compiledLine[p]);
                    } else {
                        if (!EditorPanel.this.org && !EditorPanel.this.asm.hasorg) {
                            EditorPanel.this.asm.lowest = pos = 0;
                            EditorPanel.this.asm.startoff = pos;
                            EditorPanel.this.asm.hasorg = true;
                        }
                        EditorPanel.this.asm.Assemble(EditorPanel.this.compiledLine[p], 1, epanel);
                    }
                    if (EditorPanel.this.LineSize < EditorPanel.this.compiledLine[p].length()) {
                        EditorPanel.this.LineSize = EditorPanel.this.compiledLine[p].length();
                    }
                    if (!EditorPanel.this.DEBUG || nolist) continue;
                    String placeholder = "  ";
                    for (int h = 0; h < EditorPanel.this.LineSize; ++h) {
                        placeholder = placeholder + " ";
                    }
                    placeholder = placeholder.substring(EditorPanel.this.compiledLine[p].length());
                    String feedback = EditorPanel.this.compiledLine[p];
                    place = "";
                    if (actualLine < 100000) {
                        place = place + "0";
                    }
                    if (actualLine < 10000) {
                        place = place + "0";
                    }
                    if (actualLine < 1000) {
                        place = place + "0";
                    }
                    if (actualLine < 100) {
                        place = place + "0";
                    }
                    if (actualLine < 10) {
                        place = place + "0";
                    }
                    Interface.compileInfo.append(place + actualLine + " " + EditorPanel.this.asm.getPos() + placeholder + feedback + EditorPanel.this.asm.out + "\n");
                    if (!feedback.contains("RET")) continue;
                    Interface.compileInfo.append("\n");
                }
                EditorPanel.this.asm.equ = 0;
                Interface.compileprogress.setMinimum(0);
                Interface.compileprogress.setMaximum(EditorPanel.this.compiledLine.length);
                EditorPanel.this.asm.lowest = 65535;
                EditorPanel.this.asm.launch = 0;
                EditorPanel.this.asm.baslaunch = 0;
                EditorPanel.this.asm.bascall = 0;
                EditorPanel.this.asm.limit = 65535;
                EditorPanel.this.asm.highest = 0;
                EditorPanel.this.asm.pos = 0;
                EditorPanel.this.asm.defpos = 0;
                nolist = false;
                EditorPanel.this.asm.hasorg = false;
                hasdata = new boolean[65537];
                for (p = 0; p < EditorPanel.this.compiledLine.length; ++p) {
                    if (!EditorPanel.this.compiledLine[p].toUpperCase().contains("ORG ")) continue;
                    String org = EditorPanel.this.asm.parseMath(EditorPanel.this.compiledLine[p].substring(3));
                    EditorPanel.this.asm.lowest = EditorPanel.this.asm.pos = Integer.parseInt(org);
                    EditorPanel.this.asm.hasorg = true;
                    EditorPanel.this.asm.startoff = EditorPanel.this.asm.pos;
                    break;
                }
                for (p = 0; p < EditorPanel.this.compiledLine.length; ++p) {
                    Interface.compileprogress.setValue(p);
                    Interface.compileprogress.setString("PASS 2 - Assembling line " + actualLine);
                    if (EditorPanel.this.compiledLine[p] != null) {
                        actualLine = EditorPanel.this.lines[p];
                        EditorPanel.this.org = EditorPanel.this.compiledLine[p].toUpperCase().contains("ORG");
                        if ((EditorPanel.this.compiledLine[p].startsWith("CREATE_DSK") || EditorPanel.this.compiledLine[p].startsWith("MAKEDISK")) && EditorPanel.this.compiledLine[p].contains("\"")) {
                            EditorPanel.this.create = true;
                        } else if (EditorPanel.this.compiledLine[p].startsWith("ADD_LOADER")) {
                            EditorPanel.this.addloader = true;
                        } else if (EditorPanel.this.compiledLine[p].startsWith("WRITE") && EditorPanel.this.compiledLine[p].contains("\"")) {
                            EditorPanel.this.write = true;
                        } else if (EditorPanel.this.compiledLine[p].equals("NOLIST")) {
                            nolist = true;
                        } else if (EditorPanel.this.compiledLine[p].equals("NOHEADER")) {
                            EditorPanel.this.useheader = false;
                        } else if (EditorPanel.this.compiledLine[p].equals("LIST")) {
                            nolist = false;
                        } else if (EditorPanel.this.compiledLine[p].startsWith("ALIGN ") && !EditorPanel.this.compiledLine[p].contains("\"")) {
                            EditorPanel.this.Align(EditorPanel.this.compiledLine[p]);
                        } else {
                            if (!EditorPanel.this.org && !EditorPanel.this.asm.hasorg) {
                                EditorPanel.this.asm.lowest = pos = 0;
                                EditorPanel.this.asm.startoff = pos;
                                EditorPanel.this.asm.hasorg = true;
                                EditorPanel.this.asm.err = false;
                            }
                            EditorPanel.this.asm.Assemble(EditorPanel.this.compiledLine[p], 2, epanel);
                        }
                        for (int i = 0; i < breakline.length; ++i) {
                            if (actualLine != breakline[i]) continue;
                            EditorPanel.this.asm.setBreakpoint("" + EditorPanel.this.asm.pos);
                            if (!JEMU.debugger.bPoints.isSelected()) {
                                JEMU.debugger.bPoints.setSelected(true);
                            }
                            Interface.breakpoints.append("Line: " + actualLine + " Breakaddress: &" + Util.hex((short)EditorPanel.this.asm.pos) + "\n");
                        }
                    }
                    if (nolist) continue;
                    String placeholder = "  ";
                    for (int h = 0; h < EditorPanel.this.LineSize; ++h) {
                        placeholder = placeholder + " ";
                    }
                    placeholder = placeholder.substring(EditorPanel.this.compiledLine[p].length());
                    if (EditorPanel.this.compiledLine[p] == null) continue;
                    String feedback = EditorPanel.this.compiledLine[p];
                    feedback = feedback.replace('\u0001', ',');
                    place = "";
                    if (actualLine < 100000) {
                        place = place + "0";
                    }
                    if (actualLine < 10000) {
                        place = place + "0";
                    }
                    if (actualLine < 1000) {
                        place = place + "0";
                    }
                    if (actualLine < 100) {
                        place = place + "0";
                    }
                    if (actualLine < 10) {
                        place = place + "0";
                    }
                    String inf1 = feedback;
                    String inf2 = EditorPanel.this.asm.out;
                    String before = "";
                    String inf3 = ";; " + EditorPanel.this.asm.getPos() + ": ";
                    if (EditorPanel.this.show) {
                        before = place + actualLine + " " + EditorPanel.this.asm.getPos();
                        inf3 = "";
                    }
                    EditorPanel.this.PlaceHolder = before.length() + 2;
                    Interface.compileInfo.append(before + inf1 + placeholder + inf3 + inf2 + "\n");
                    if (!feedback.startsWith("RET")) continue;
                    Interface.compileInfo.append("\n");
                }
                long time2 = System.currentTimeMillis();
                double time3 = time2 - time;
                double time4 = time3 / 1000.0;
                Interface.compileprogress.setValue(0);
                Interface.compileprogress.setStringPainted(false);
                Interface.compileInfo.append("_______________________________________________________\n");
                String info = "Assembled in " + time4 + "s from &" + Util.hex((short)EditorPanel.this.asm.lowest) + " to &" + Util.hex((short)(EditorPanel.this.asm.highest - 1)) + " length is &" + Util.hex((short)(EditorPanel.this.asm.highest - EditorPanel.this.asm.lowest)) + " exec: &" + Util.hex((short)EditorPanel.this.asm.launch) + "\n";
                Interface.compileInfo.append(info);
                Interface.compileInfo.select(20000000, 20000000);
                EditorPanel.this.setSymbolInfo();
                int low = EditorPanel.this.asm.lowest;
                int length = EditorPanel.this.asm.highest - EditorPanel.this.asm.lowest;
                byte[] result = null;
                try {
                    result = new byte[length];
                    System.arraycopy(EditorPanel.this.asm.output, low, result, 0, length);
                    Interface.hexdump.setText(Util.dumpBytes(result, low));
                    int feed = 0;
                    Interface.basic.setText("");
                    EditorPanel.this.linenumber = 10;
                    EditorPanel.this.BASIC("LN=80:D=0:MEMORY &" + Util.hex((short)(EditorPanel.this.asm.lowest - 1)) + ":AD=&" + Util.hex((short)EditorPanel.this.asm.lowest) + ":L=&" + Util.hex((short)(EditorPanel.this.asm.highest - EditorPanel.this.asm.lowest)));
                    EditorPanel.this.BASIC("IF D=0 THEN GOSUB 70");
                    EditorPanel.this.BASIC("READ a$:POKE AD+P,VAL(\"&\"+a$)");
                    EditorPanel.this.BASIC("D=D+1:ch2=ch2+VAL(\"&\"+a$):IF D=16 THEN D=0:IF ch1<>ch2 THEN PRINT\"CHECKSUM ERROR in line \";LN:STOP ELSE LN=LN+10:ch2=0:ch1=0");
                    EditorPanel.this.BASIC("P=P+1:IF P=L THEN END");
                    EditorPanel.this.BASIC("GOTO 20");
                    EditorPanel.this.BASIC("READ a$:ch1=VAL(\"&\"+a$):RETURN");
                    String bascode = "DATA ";
                    String datas = "";
                    for (int i = 0; i < result.length; ++i) {
                        datas = datas + Util.hex(result[i]);
                        if (++feed == 16) {
                            feed = 0;
                            String[] checksum = datas.split(",");
                            System.out.println("Calculating checksum with length of " + checksum.length);
                            int check2 = 0;
                            for (int c = 0; c < checksum.length; ++c) {
                                check2 += Util.hexValue(checksum[c]);
                            }
                            System.out.println("Checksum is: " + Util.hex((short)check2));
                            datas = Util.hex((short)check2) + "," + datas;
                            EditorPanel.this.BASIC(bascode + datas);
                            bascode = "DATA ";
                            datas = "";
                            continue;
                        }
                        datas = datas + ",";
                    }
                    if (bascode.startsWith("DATA") && datas.endsWith(",")) {
                        datas = datas.substring(0, datas.length() - 1);
                        String[] checksum = datas.split(",");
                        int check3 = 0;
                        for (int c = 0; c < checksum.length; ++c) {
                            check3 += Util.hexValue(checksum[c]);
                        }
                        datas = Util.hex((short)check3) + "," + datas;
                        EditorPanel.this.BASIC(bascode + datas);
                    }
                }
                catch (Exception e) {
                    Interface.compileInfo.setText("*Fatal error!* (ORG not set?)\n");
                }
                if (errors == 0) {
                    if (EditorPanel.this.create) {
                        Interface.compileInfo.append("Creating DSK to '" + EditorPanel.this.createstring + "'\n");
                        EditorPanel.this.create(EditorPanel.this.createstring);
                    }
                    if (EditorPanel.this.write) {
                        Interface.compileInfo.append("Storing to '" + EditorPanel.this.writestring + "'\n");
                        EditorPanel.this.save(result, EditorPanel.this.writestring);
                    } else if (!SyntaxCheck) {
                        byte[] actualmem = new byte[65536];
                        System.arraycopy(GateArray.screenmemory, 0, actualmem, 0, 65535);
                        try {
                            for (int p4 = 0; p4 < result.length; ++p4) {
                                if (!hasdata[low + p4]) continue;
                                if (low + p4 > 47359 && low + p4 < 48896) {
                                    Interface.firmware.setSelected(true);
                                }
                                actualmem[low + p4] = result[p4];
                            }
                        }
                        catch (Exception e) {
                            EditorPanel.this.codeField.setEnabled(true);
                            EditorPanel.this.isBusy = false;
                            return;
                        }
                        if (Interface.firmware.isSelected()) {
                            CPC.firmwareErased = true;
                        }
                        if (EditorPanel.this.printInfo) {
                            if (EditorPanel.this.asm.launch != 0) {
                                if (CPC.firmwareErased) {
                                    GateArray.cpc.runBinary(EditorPanel.this.asm.launch);
                                }
                                info = info + "'CALL &" + Util.hex((short)EditorPanel.this.asm.launch);
                            }
                            if (!CPC.firmwareErased) {
                                GateArray.cpc.fromautoboot = true;
                                GateArray.cpc.BasicAutoType("'" + info);
                            }
                        }
                        System.arraycopy(actualmem, 0, GateArray.screenmemory, 0, 65535);
                        if (EditorPanel.this.asm.launch != 0 && !EditorPanel.this.write) {
                            System.out.println("Trying to CALL &" + Util.hex((short)EditorPanel.this.asm.launch));
                            GateArray.cpc.runBinary(EditorPanel.this.asm.launch);
                        }
                        if (EditorPanel.this.asm.baslaunch != 0 && !EditorPanel.this.write) {
                            System.out.println("Trying to RUN");
                            Autotype.autotext = "RUN\n";
                            Switches.getfromautotype = 1;
                        }
                        if (EditorPanel.this.asm.bascall != 0 && !EditorPanel.this.write) {
                            System.out.println("Trying to CALL &");
                            Autotype.autotext = "CALL &" + Util.hex((short)EditorPanel.this.asm.bascall) + "\n";
                            Switches.getfromautotype = 1;
                        }
                    }
                } else {
                    if (errors == 8888888) {
                        Interface.compileInfo.append("****** Limit reached!!!\nYou tried to assemble above &" + Util.hex((short)EditorPanel.this.asm.limit));
                    } else if (errors == 9999999) {
                        Interface.compileInfo.append("****** Out of Memory!!!\nYou tried to assemble above &FFFF!");
                    } else {
                        Interface.compileInfo.append("****** " + errors + " ERRORS!!!\n");
                    }
                    Interface.compileInfo.select(20000000, 20000000);
                    String errors = Interface.errorInfo.getText();
                    String[] found = errors.split("\n");
                    try {
                        for (int i = 0; i < found.length; ++i) {
                            if (!found[i].contains("[Error]")) continue;
                            String line = found[i];
                            while (line.contains(" ")) {
                                line = line.substring(1);
                            }
                            String b = EditorPanel.this.checkread[Integer.parseInt(line) - 1];
                            while (b.startsWith(" ")) {
                                b = b.substring(1);
                            }
                            while (b.endsWith(" ")) {
                                b = b.substring(b.length() - 1);
                            }
                            EditorPanel.this.find(b);
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (EditorPanel.this.warnings > 0) {
                    Interface.compileInfo.append("****** " + EditorPanel.this.warnings + " WARNINGS!\n");
                }
                EditorPanel.this.codeField.setEnabled(true);
                System.gc();
                JEMU.debugger.getDebuggerComputer().start();
                CPC.resync = true;
                EditorPanel.this.isBusy = false;
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorPanel.this.Compiler.start();
            }
        });
    }

    public void Assemble(boolean SyntaxCheck) {
        this.Assemble(this.codeField.getText(), SyntaxCheck);
    }

    public void BASIC(String in) {
        Interface.basic.append(this.linenumber + " " + in + "\r\n");
        this.linenumber += 10;
    }

    protected String Repeat(String in, boolean rept) {
        String add = "";
        String[] toCheck = in.split("\n");
        for (int p = 0; p < toCheck.length; ++p) {
            while (toCheck[p].startsWith(" ")) {
                toCheck[p] = toCheck[p].substring(1);
            }
            while (toCheck[p].startsWith("\t")) {
                toCheck[p] = toCheck[p].substring(1);
            }
            if (toCheck[p].toLowerCase().startsWith(rept ? "rept" : "repeat") && !toCheck[p].contains("\"") && !toCheck[p].contains("'")) {
                String o = "; " + toCheck[p];
                toCheck[p] = toCheck[p].replace("\t", "");
                while (toCheck[p].startsWith(" ")) {
                    toCheck[p] = toCheck[p].substring(1);
                }
                while (toCheck[p].endsWith(" ")) {
                    toCheck[p] = toCheck[p].substring(0, toCheck[p].length() - 1);
                }
                toCheck[p] = toCheck[p].toLowerCase().replace(rept ? "rept" : "repeat", "");
                toCheck[p] = toCheck[p].replace("(", "");
                toCheck[p] = toCheck[p].replace(")", "");
                toCheck[p] = toCheck[p].replace(" ", "");
                String repeattext = "";
                try {
                    int repeat = Integer.parseInt(toCheck[p]);
                    for (int g = p + 1; g < toCheck.length; ++g) {
                        if (toCheck[g].toLowerCase().contains("rend") || toCheck[g].toLowerCase().contains("endm")) {
                            p = g;
                            break;
                        }
                        repeattext = repeattext + toCheck[g] + "\n";
                    }
                    String result = "";
                    for (int i = 0; i < repeat; ++i) {
                        result = result + repeattext;
                    }
                    add = add + result;
                    toCheck[p] = o;
                }
                catch (Exception e) {
                    Interface.errorInfo.append("Error in Repeat instruction around line " + (p + 1) + "\r\n");
                    ++errors;
                }
                continue;
            }
            add = add + toCheck[p] + "\n";
        }
        return add;
    }

    protected String searchReads(String in) {
        String add = "";
        String[] toCheck = in.split("\n");
        this.reads = false;
        for (int p = 0; p < toCheck.length; ++p) {
            while (toCheck[p].startsWith(" ")) {
                toCheck[p] = toCheck[p].substring(1);
            }
            while (toCheck[p].startsWith("\t")) {
                toCheck[p] = toCheck[p].substring(1);
            }
            if (toCheck[p].toLowerCase().startsWith("read ") || toCheck[p].toLowerCase().startsWith("read\t")) {
                String o = "; " + toCheck[p];
                toCheck[p] = toCheck[p].replace("\r", "");
                toCheck[p] = toCheck[p].replace("\t", "");
                toCheck[p] = toCheck[p].replace("\n", "");
                toCheck[p] = toCheck[p].substring(4);
                toCheck[p] = toCheck[p].replace("\"", "");
                toCheck[p] = toCheck[p].replace("'", "");
                while (toCheck[p].startsWith(" ")) {
                    toCheck[p] = toCheck[p].substring(1);
                }
                while (toCheck[p].endsWith(" ")) {
                    toCheck[p] = toCheck[p].substring(0, toCheck[p].length() - 1);
                }
                String filename = this.writepath + toCheck[p];
                for (int i = 0; i < toCheck.length; ++i) {
                    if (!toCheck[i].toLowerCase().startsWith("define ") && !toCheck[i].toLowerCase().startsWith("define\t")) continue;
                    String input = toCheck[i];
                    input = input.substring(6);
                    while (input.startsWith(" ")) {
                        input = input.substring(1);
                    }
                    while (input.startsWith("\t")) {
                        input = input.substring(1);
                    }
                    String[] split = input.split("=");
                    while (split[1].startsWith(" ")) {
                        split[1] = split[1].substring(1);
                    }
                    while (split[1].endsWith(" ")) {
                        split[1] = split[1].substring(0, split[1].length() - 1);
                    }
                    while (split[0].startsWith(" ")) {
                        split[0] = split[0].substring(1);
                    }
                    while (split[0].endsWith(" ")) {
                        split[0] = split[0].substring(0, split[0].length() - 1);
                    }
                    System.out.println(split[0] + " - " + split[1]);
                    if (!toCheck[p].toUpperCase().contains(split[0].toUpperCase())) continue;
                    filename = this.writepath + split[1].replace("\"", "");
                    break;
                }
                add = add + this.replace(filename);
                System.out.println("Reading:" + filename);
                this.reads = true;
                Interface.compileInfo.append("Reading " + filename + "\n");
                toCheck[p] = o;
                continue;
            }
            add = add + toCheck[p] + "\n";
        }
        if (this.reads) {
            this.opentab = true;
        }
        String out = "";
        out = add;
        return out;
    }

    protected String searchInclude(String in) {
        String add = "";
        String[] toCheck = in.split("\n");
        this.reads = false;
        for (int p = 0; p < toCheck.length; ++p) {
            while (toCheck[p].startsWith(" ")) {
                toCheck[p] = toCheck[p].substring(1);
            }
            while (toCheck[p].startsWith("\t")) {
                toCheck[p] = toCheck[p].substring(1);
            }
            if (toCheck[p].toLowerCase().startsWith("include ") || toCheck[p].toLowerCase().startsWith("include\t")) {
                String o = "; " + toCheck[p];
                toCheck[p] = toCheck[p].replace("\r", "");
                toCheck[p] = toCheck[p].replace("\t", "");
                toCheck[p] = toCheck[p].replace("\n", "");
                toCheck[p] = toCheck[p].substring(7);
                toCheck[p] = toCheck[p].replace("\"", "");
                toCheck[p] = toCheck[p].replace("'", "");
                while (toCheck[p].startsWith(" ")) {
                    toCheck[p] = toCheck[p].substring(1);
                }
                while (toCheck[p].endsWith(" ")) {
                    toCheck[p] = toCheck[p].substring(0, toCheck[p].length() - 1);
                }
                String filename = this.writepath + toCheck[p];
                for (int i = 0; i < toCheck.length; ++i) {
                    if (!toCheck[i].toLowerCase().startsWith("define ") && !toCheck[i].toLowerCase().startsWith("define\t")) continue;
                    System.out.println(toCheck[i]);
                    String input = toCheck[i];
                    input = input.substring(6);
                    while (input.startsWith(" ")) {
                        input = input.substring(1);
                    }
                    while (input.startsWith("\t")) {
                        input = input.substring(1);
                    }
                    String[] split = input.split("=");
                    while (split[1].startsWith(" ")) {
                        split[1] = split[1].substring(1);
                    }
                    while (split[1].endsWith(" ")) {
                        split[1] = split[1].substring(0, split[1].length() - 1);
                    }
                    while (split[0].startsWith(" ")) {
                        split[0] = split[0].substring(1);
                    }
                    while (split[0].endsWith(" ")) {
                        split[0] = split[0].substring(0, split[0].length() - 1);
                    }
                    System.out.println(split[0] + " - " + split[1]);
                    if (!toCheck[p].toUpperCase().contains(split[0].toUpperCase())) continue;
                    filename = this.writepath + split[1].replace("\"", "");
                    break;
                }
                add = add + this.replace(filename);
                System.out.println("Including:" + filename);
                this.reads = true;
                Interface.compileInfo.append("Including " + filename + "\n");
                toCheck[p] = o;
                continue;
            }
            add = add + toCheck[p] + "\n";
        }
        if (this.reads) {
            this.opentab = true;
        }
        String out = "";
        out = add;
        System.out.println(out);
        return out;
    }

    public String searchIncBin(String in) {
        String add = "";
        while (in.startsWith(" ")) {
            in = in.substring(1);
        }
        while (in.startsWith("\t")) {
            in = in.substring(1);
        }
        if (in.toLowerCase().startsWith("incbin") && (in.contains("\"") || in.contains("'"))) {
            in = in.replace("\r", "");
            in = in.replace("\t", "");
            in = in.replace("\n", "");
            in = in.toLowerCase().replace("incbin", "");
            in = in.replace("\"", "");
            in = in.replace("'", "");
            while (in.startsWith(" ")) {
                in = in.substring(1);
            }
            while (in.endsWith(" ")) {
                in = in.substring(0, in.length() - 1);
            }
            add = this.writepath + in;
        }
        return add;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String replace(String filen) {
        File file = new File(filen);
        StringBuffer contents = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String text = null;
            while ((text = reader.readLine()) != null) {
                contents.append(text).append(System.getProperty("line.separator"));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String in = contents.toString();
        return in;
    }

    protected void save(byte[] result, String file) {
        this.todiska = false;
        this.todiskb = false;
        while (file.startsWith(" ")) {
            file = file.substring(1);
        }
        if (file.toLowerCase().startsWith("direct")) {
            file = file.substring(6);
            while (file.startsWith(" ")) {
                file = file.substring(1);
            }
            if ((file = file.substring(1)).toLowerCase().startsWith("a:")) {
                file = file.substring(2);
                this.todiska = true;
            } else if (file.toLowerCase().startsWith("b:")) {
                file = file.substring(2);
                this.todiskb = true;
            } else if (file.toLowerCase().startsWith("c:")) {
                file = file.substring(2);
                this.todiskc = true;
            } else if (file.toLowerCase().startsWith("d:")) {
                file = file.substring(2);
                this.todiskd = true;
            } else {
                this.todiska = true;
            }
        }
        file = file.replace("\"", "");
        file = file.replace("/", "");
        try {
            byte[][] code = new byte[50][65536];
            int[] startcode = new int[50];
            int[] lengthcode = new int[50];
            boolean[] hascall = new boolean[50];
            int count = 0;
            int low = this.asm.lowest;
            int bytes = 0;
            int newcount = 0;
            boolean feed = true;
            boolean hasstart = false;
            int launch = this.asm.launch;
            for (int p = 0; p < result.length; ++p) {
                if (hasdata[low + p]) {
                    if (!hasstart) {
                        hasstart = true;
                        startcode[count] = low + p;
                    }
                    if (low + p == launch) {
                        hascall[count] = true;
                    }
                    code[count][newcount++] = result[p];
                    ++bytes;
                    feed = true;
                    continue;
                }
                if (!feed) continue;
                lengthcode[count] = bytes;
                byte[] temp = new byte[bytes];
                System.arraycopy(code[count], 0, temp, 0, bytes);
                code[count] = temp;
                newcount = 0;
                launch = 0;
                if (hascall[count]) {
                    launch = this.asm.launch;
                }
                this.write(code[count], file, launch, startcode[count], lengthcode[count], count);
                ++count;
                hasstart = false;
                bytes = 0;
                feed = false;
            }
            if (feed) {
                lengthcode[count] = bytes;
                byte[] temp = new byte[bytes];
                for (int i = 0; i < bytes; ++i) {
                    temp[i] = code[count][i];
                }
                code[count] = temp;
                newcount = 0;
                launch = 0;
                if (hascall[count]) {
                    launch = this.asm.launch;
                }
                this.write(code[count], file, launch, startcode[count], lengthcode[count], count);
                ++count;
                bytes = 0;
            }
            System.out.println("done...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void create(String file) {
        while (file.startsWith(" ")) {
            file = file.substring(1);
        }
        file = file.replace("\"", "");
        String[] fil = file.split(",");
        System.out.println(file);
        int drive = 0;
        if (fil[0].toLowerCase().startsWith("a:")) {
            drive = 0;
            fil[0] = fil[0].substring(2);
        }
        if (fil[0].toLowerCase().startsWith("b:")) {
            drive = 1;
            fil[0] = fil[0].substring(2);
        }
        String form = "data";
        if (fil.length > 1 && fil[1].toLowerCase().contains("sys")) {
            form = "system";
        }
        int tracks = 40;
        if (fil.length > 2 && fil[2].toLowerCase().contains("80")) {
            tracks = 80;
        }
        System.out.println("Writing DSK to " + this.writepath + fil[0]);
        GateArray.cpc.ASMDisk(this.writepath + fil[0], drive, form, tracks);
    }

    protected void write(byte[] result, String file, int launch, int start, int length, int pos) {
        file = file.toUpperCase();
        while (file.startsWith(" ")) {
            file = file.substring(1);
        }
        if (file.endsWith(".BIN") && pos != 0) {
            file = file.replace(".BIN", "");
            file = pos <= 9 ? file + ".BI" + pos : file + ".B" + pos;
        } else if (pos != 0) {
            file = file.substring(0, file.length() - 1);
            file = file + pos;
        }
        Interface.compileInfo.append("Write " + file + " - start:&" + Util.hex((short)start) + " - length:&" + Util.hex((short)length) + " - exec.:&" + Util.hex((short)launch) + "\n");
        Interface.compileInfo.select(2000000, 2000000);
        if (!file.contains("\\") || !file.contains("/")) {
            file = this.writepath + file;
        }
        if (pos == 1 && file.endsWith(".BI1")) {
            File f1 = new File(file.replace(".BI1", ".BIN"));
            File f2 = new File(file.replace(".BI1", ".BI0"));
            if (f1.exists()) {
                f1.renameTo(f2);
            }
        }
        this.store(result, file, launch, start, length);
    }

    protected void store(byte[] result, String file, int launch, int start, int length) {
        try {
            byte[] rs;
            File export = new File(file);
            File bak = new File(file + ".bak");
            try {
                try {
                    bak.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                export.renameTo(bak);
            }
            catch (Exception exception) {
                // empty catch block
            }
            byte[] header = new byte[128];
            Device.putWord(header, 21, start);
            Device.putWord(header, 26, launch);
            Device.putWord(header, 24, length);
            Device.putWord(header, 64, length);
            header[18] = 2;
            if (file.toLowerCase().endsWith(".bas")) {
                header[18] = 0;
            }
            try {
                System.arraycopy(BIN_HEADER.getBytes("UTF-8"), 0, header, 1, BIN_HEADER.length());
                System.arraycopy(BIN_EYECATCHER.getBytes("UTF-8"), 0, header, 96, BIN_EYECATCHER.length());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Device.putWord(header, 67, CPC.ChecksumAMSDOS(header));
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(export));
            if (this.useheader) {
                bos.write(header);
            }
            bos.write(result);
            bos.close();
            if (this.todiska) {
                System.out.println("Writing:" + file);
                if (this.useheader) {
                    rs = new byte[result.length + header.length];
                    System.arraycopy(header, 0, rs, 0, header.length);
                    System.arraycopy(result, 0, rs, header.length, result.length);
                    this.disk.addFile(rs, 0, file);
                } else {
                    this.disk.addFile(result, 0, file);
                }
                if (this.addloader) {
                    this.loadername = file.toUpperCase();
                    while (this.loadername.contains("/") || this.loadername.contains("\\")) {
                        this.loadername = this.loadername.substring(1);
                    }
                    this.loadername = this.loadername.contains(".BIN") ? this.loadername.replace(".BIN", ".BAS") : this.loadername + ".BAS";
                    this.loadername = this.loadername.replace("\"", "");
                    this.loadername = this.loadername.replace(",", "");
                    while (this.loadername.startsWith(" ")) {
                        this.loadername = this.loadername.substring(1);
                    }
                    if (this.loadername.length() > 12) {
                        this.loadername = "NONAME.BAS";
                    } else if (this.loadername.length() < 1) {
                        this.loadername = "LOADER.BAS";
                    }
                    System.out.println(this.loadername);
                    if (!this.loadername.endsWith(".BAS")) {
                        this.loadername = this.loadername + ".BAS";
                    }
                    if (this.loadername.length() > 12) {
                        this.loadername = "NONAME.BAS";
                    }
                    String toload = file;
                    while (toload.contains("\\")) {
                        toload = toload.substring(1);
                    }
                    while (toload.contains("/")) {
                        toload = toload.substring(1);
                    }
                    String loader = "10 MEMORY &" + Util.hex((short)(start - 1)) + ":LOAD\"" + toload.toUpperCase() + "\",&" + Util.hex((short)start);
                    loader = loader + "\r\n20 CALL &" + Util.hex((short)launch != 0 ? launch : start) + "\r\n";
                    loader = loader + '\u001a';
                    loader = loader + '0';
                    loader = loader + '\r';
                    loader = loader + '\n';
                    byte[] bz = loader.getBytes("UTF-8");
                    File i = new File(this.writepath + this.loadername);
                    BufferedOutputStream nos = new BufferedOutputStream(new FileOutputStream(i));
                    nos.write(bz);
                    nos.close();
                    this.disk.addFile(bz, 0, this.writepath + this.loadername);
                    System.out.println("Writing:" + this.writepath + this.loadername);
                    i.delete();
                    if (DSKUtil.isPresent) {
                        JEMU.updateDrive = 0;
                    }
                }
                CPC.up0 = true;
            }
            if (this.todiskb) {
                if (this.useheader) {
                    rs = new byte[result.length + header.length];
                    System.arraycopy(header, 0, rs, 0, header.length);
                    System.arraycopy(result, 0, rs, header.length, result.length);
                    this.disk.addFile(rs, 1, file);
                } else {
                    this.disk.addFile(result, 1, file);
                }
                if (DSKUtil.isPresent) {
                    JEMU.updateDrive = 1;
                }
                CPC.up1 = true;
            }
            if (this.todiskc) {
                if (this.useheader) {
                    rs = new byte[result.length + header.length];
                    System.arraycopy(header, 0, rs, 0, header.length);
                    System.arraycopy(result, 0, rs, header.length, result.length);
                    this.disk.addFile(rs, 2, file);
                } else {
                    this.disk.addFile(result, 2, file);
                }
                if (DSKUtil.isPresent) {
                    JEMU.updateDrive = 2;
                }
                CPC.up2 = true;
            }
            if (this.todiskd) {
                if (this.useheader) {
                    rs = new byte[result.length + header.length];
                    System.arraycopy(header, 0, rs, 0, header.length);
                    System.arraycopy(result, 0, rs, header.length, result.length);
                    this.disk.addFile(rs, 3, file);
                } else {
                    this.disk.addFile(result, 3, file);
                }
                if (DSKUtil.isPresent) {
                    JEMU.updateDrive = 3;
                }
                CPC.up3 = true;
            }
        }
        catch (Exception e) {
            String g = e.getMessage();
            e.printStackTrace();
        }
    }

    protected String checkString(String inp) {
        if (inp.length() < 2) {
            return inp;
        }
        if (inp.toUpperCase().contains(" EQU ")) {
            return inp;
        }
        if (inp.toUpperCase().startsWith("LET ")) {
            return inp;
        }
        if (!inp.contains(" ")) {
            return inp;
        }
        boolean breakme = true;
        for (String multiCommand : this.multiCommands) {
            if (!inp.toUpperCase().startsWith(multiCommand)) continue;
            breakme = false;
            break;
        }
        if (breakme) {
            for (String singleCommand : this.singleCommands) {
                if (!inp.toUpperCase().equals(singleCommand)) continue;
                breakme = false;
                break;
            }
        }
        if (breakme) {
            int p = 0;
            String newString = "";
            while (inp.charAt(p) >= '0' && inp.charAt(p) <= '9' || inp.charAt(p) >= 'A' && inp.charAt(p) <= 'Z' || inp.charAt(p) >= 'a' && inp.charAt(p) <= 'z' || inp.charAt(p) == ':' || inp.charAt(p) == '_') {
                newString = newString + inp.charAt(p);
                if (++p < inp.length()) continue;
            }
            inp = inp.replace(newString, newString + "~breakMEhere~");
        }
        return inp;
    }

    public String formatString(String s) {
        int p;
        String objectString;
        String inputString;
        boolean isinputtext;
        int p2;
        int recheck;
        boolean hascontent = false;
        boolean charcase = false;
        if (s.toLowerCase().startsWith("cp ")) {
            s = s.substring(3);
            while (s.startsWith(" ")) {
                s = s.substring(1);
            }
            s = "CP " + s;
        }
        if (s.toLowerCase().startsWith("define ")) {
            s = s.substring(7);
            while (s.startsWith(" ")) {
                s = s.substring(1);
            }
            if (s.startsWith("'")) {
                charcase = true;
            }
            s = "DEFINE " + s;
        }
        if (s.toLowerCase().startsWith("write direct ")) {
            s = s.substring(13);
            while (s.startsWith(" ")) {
                s = s.substring(1);
            }
            if (s.startsWith("'")) {
                charcase = true;
            }
            s = "WRITE DIRECT " + s;
        } else if (s.toLowerCase().startsWith("write ")) {
            s = s.substring(6);
            while (s.startsWith(" ")) {
                s = s.substring(1);
            }
            if (s.startsWith("'")) {
                charcase = true;
            }
            s = "WRITE " + s;
        }
        if (s.toLowerCase().startsWith("include ")) {
            s = s.substring(8);
            while (s.startsWith(" ")) {
                s = s.substring(1);
            }
            if (s.startsWith("'")) {
                charcase = true;
            }
            s = "INCLUDE " + s;
        }
        if (s.toLowerCase().startsWith("read ")) {
            s = s.substring(5);
            while (s.startsWith(" ")) {
                s = s.substring(1);
            }
            if (s.startsWith("'")) {
                charcase = true;
            }
            s = "READ " + s;
        }
        if (s.toLowerCase().startsWith("incbin ")) {
            s = s.substring(7);
            while (s.startsWith(" ")) {
                s = s.substring(1);
            }
            if (s.startsWith("'")) {
                charcase = true;
            }
            s = "INCBIN " + s;
        }
        if (s.toLowerCase().startsWith("cp ")) {
            s = s.substring(3);
            while (s.startsWith(" ")) {
                s = s.substring(1);
            }
            if (s.startsWith("'")) {
                charcase = true;
            }
            s = "CP " + s;
        }
        if (s.toLowerCase().startsWith("cp ")) {
            s = s.substring(3);
            while (s.startsWith(" ")) {
                s = s.substring(1);
            }
            if (s.startsWith("'")) {
                charcase = true;
            }
            s = "CP " + s;
        }
        if (s.toLowerCase().startsWith("db ")) {
            s = s.substring(3);
            while (s.startsWith(" ")) {
                s = s.substring(1);
            }
            if (s.startsWith("'")) {
                charcase = true;
            }
            s = "DB " + s;
        }
        if (s.toLowerCase().startsWith("defb ")) {
            s = s.substring(5);
            while (s.startsWith(" ")) {
                s = s.substring(1);
            }
            if (s.startsWith("'")) {
                charcase = true;
            }
            s = "DEFB " + s;
        }
        if (s.toLowerCase().startsWith("defm ")) {
            s = s.substring(5);
            while (s.startsWith(" ")) {
                s = s.substring(1);
            }
            if (s.startsWith("'")) {
                charcase = true;
            }
            s = "DEFM " + s;
        }
        if (!(!s.contains("~SEMLC0I0N~") || s.contains("DB ") && s.contains("DEFB ") && s.contains("DEFM ") && s.contains("CP ") || (recheck = s.indexOf("~SEMLC0I0N~")) == -1)) {
            s = s.substring(0, recheck);
        }
        if (!charcase && s.contains("\"") && (s.contains("DEFM ") || s.contains("DB ") || s.contains("INCBIN ") || s.contains("WRITE ") || s.contains("INCLUDE ") || s.contains("READ ") || s.contains("DEFINE ") || s.contains("DEFB ") || s.contains("CP "))) {
            for (p2 = 0; p2 < 500; ++p2) {
                this.inputtext[p2] = "";
                this.objecttext[p2] = "";
            }
            hascontent = true;
            isinputtext = false;
            inputString = "";
            objectString = "";
            s = s + ",\"DUMMY\"";
            for (p = 0; p < s.length(); ++p) {
                if (s.charAt(p) == '\"') {
                    boolean bl = isinputtext = !isinputtext;
                }
                if (isinputtext) {
                    inputString = inputString + s.charAt(p);
                    this.objecttext[p] = objectString;
                    objectString = "";
                    continue;
                }
                objectString = objectString + s.charAt(p);
                this.inputtext[p] = inputString;
                inputString = "";
            }
        } else if (s.contains("'") && (s.contains("DB") || s.contains("DEFM") || s.contains("DEFB") || s.contains("CP"))) {
            for (p2 = 0; p2 < 500; ++p2) {
                this.inputtext[p2] = "";
                this.objecttext[p2] = "";
            }
            hascontent = true;
            isinputtext = false;
            inputString = "";
            objectString = "";
            s = s + ",'DUMMY'";
            for (p = 0; p < s.length(); ++p) {
                if (s.charAt(p) == '\'') {
                    boolean bl = isinputtext = !isinputtext;
                }
                if (isinputtext) {
                    inputString = inputString + s.charAt(p);
                    this.objecttext[p] = objectString;
                    objectString = "";
                    continue;
                }
                objectString = objectString + s.charAt(p);
                this.inputtext[p] = inputString;
                inputString = "";
            }
        }
        if (hascontent) {
            String newString = "";
            for (int p3 = 0; p3 < 500; ++p3) {
                this.inputtext[p3] = this.inputtext[p3].replace(',', '\u0001');
                this.inputtext[p3] = this.inputtext[p3].replace("~semlc0I0n~", ";");
                this.objecttext[p3] = this.reDo(this.objecttext[p3]);
                newString = newString + this.objecttext[p3];
                newString = newString + this.inputtext[p3];
            }
            if (newString.contains("~SEMLC0I0N~")) {
                int recheck2 = newString.indexOf("~SEMLC0I0N~");
                if (recheck2 != -1) {
                    newString = newString.substring(0, recheck2);
                }
            } else {
                newString = newString.substring(0, newString.length() - 7);
            }
            Interface.stringsInfo.append(newString + "\n");
            s = newString;
        } else {
            if (s.contains("~SEMLC0I0N~") && (recheck = s.indexOf("~SEMLC0I0N~")) != -1) {
                s = s.substring(0, recheck);
            }
            s = this.reDo(s);
        }
        while (s.endsWith(" ")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String reDo(String s) {
        if (s == null) {
            return s;
        }
        StringTokenizer st = new StringTokenizer(s, " ", false);
        String t = "";
        while (st.hasMoreElements()) {
            t = t + st.nextElement() + " ";
        }
        t = t.toUpperCase();
        t = t.replace(", ", ",");
        t = t.replace(" ,", ",");
        t = t.replace("+ ", "+");
        t = t.replace(" +", "+");
        t = t.replace("- ", "-");
        t = t.replace(" -", "-");
        t = t.replace("( ", "(");
        t = t.replace(" )", ")");
        t = t.replace(" ]", "]");
        t = t.replace("[ ", "[");
        t = t.replace("#", "&");
        t = t.replace("& ", "&");
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String openFile() throws UnsupportedEncodingException {
        FileDialog filedia = new FileDialog((Frame)new JFrame(), "Import ASCII...", 0);
        filedia.setFile("*.txt; *.asm; *.pds");
        filedia.setVisible(true);
        this.filename = filedia.getFile();
        this.writepath = filedia.getDirectory();
        this.opened = this.filename;
        if (this.filename != null) {
            this.filename = filedia.getDirectory() + filedia.getFile();
            File file = new File(this.filename);
            StringBuffer contents = new StringBuffer();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String text = null;
                while ((text = reader.readLine()) != null) {
                    contents.append(text).append(System.getProperty("line.separator"));
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            String in = contents.toString();
            byte[] pdscheck = in.getBytes("UTF-8");
            boolean pds = false;
            for (int i = 0; i < this.pdsheader.length; ++i) {
                if (pdscheck[i] != this.pdsheader[i]) continue;
                pds = true;
            }
            if (pds) {
                System.out.println("Opening PDS File");
                byte[] buffer = new byte[pdscheck.length - 512];
                System.arraycopy(pdscheck, 512, buffer, 0, buffer.length);
                contents = new StringBuffer();
                for (int i = 0; i < buffer.length; ++i) {
                    contents.append((char)(buffer[i] & 0x7F));
                }
                in = contents.toString();
            }
            while (in.startsWith("\u0000")) {
                in = in.substring(1);
            }
            in = in.replace("\r", "");
            in = in.replace("\u0000", "\n");
            this.codeField.setText(in);
            this.codeField.select(0, 0);
        }
        filedia.dispose();
        return this.filename;
    }

    public void remark(final boolean unmark, final boolean tabs, final boolean rems) {
        if (this.remarking) {
            return;
        }
        Thread co = new Thread(){

            @Override
            public void run() {
                String vault;
                EditorPanel.this.codeField.setEditable(false);
                EditorPanel.this.modified = true;
                EditorPanel.this.remarking = true;
                int textsize = EditorPanel.this.codeField.getText().length();
                int start = EditorPanel.this.codeField.getSelectionStart();
                int end = EditorPanel.this.codeField.getSelectionEnd();
                if (rems) {
                    start = 0;
                    end = textsize;
                    EditorPanel.this.codeField.setSelectionStart(start);
                    EditorPanel.this.codeField.setSelectionEnd(end);
                    vault = EditorPanel.this.codeField.getSelectedText();
                } else {
                    vault = EditorPanel.this.codeField.getSelectedText();
                    if (EditorPanel.this.codeField.getCaretLineNumber() > 0) {
                        while (!(vault != null && vault.startsWith("\n") || --start < 0)) {
                            try {
                                EditorPanel.this.codeField.setSelectionStart(start);
                            }
                            catch (Exception e) {
                                EditorPanel.this.codeField.setEditable(true);
                                return;
                            }
                            vault = EditorPanel.this.codeField.getSelectedText();
                        }
                        ++start;
                    } else {
                        start = 0;
                    }
                    EditorPanel.this.codeField.setSelectionStart(start);
                    vault = EditorPanel.this.codeField.getSelectedText();
                    if (end < textsize) {
                        while (!(vault != null && vault.endsWith("\n") || ++end >= textsize)) {
                            try {
                                EditorPanel.this.codeField.setSelectionEnd(end);
                            }
                            catch (Exception e) {
                                EditorPanel.this.codeField.setEditable(true);
                                return;
                            }
                            vault = EditorPanel.this.codeField.getSelectedText();
                        }
                    } else {
                        end = textsize;
                    }
                    --end;
                }
                int pend = 0;
                EditorPanel.this.codeField.setSelectionEnd(end);
                vault = EditorPanel.this.codeField.getSelectedText();
                if (vault == null) {
                    EditorPanel.this.codeField.setEditable(true);
                    EditorPanel.this.modified = true;
                    EditorPanel.this.remarking = false;
                    return;
                }
                String[] cont = vault.split("\n");
                Interface.compileprogress.setMaximum(cont.length);
                for (int i = 0; i < cont.length; ++i) {
                    Interface.compileprogress.setValue(i);
                    String toreplace = cont[i];
                    if (unmark) {
                        if (tabs) {
                            if (toreplace.startsWith("\t")) {
                                toreplace = toreplace.substring(1);
                                --pend;
                            } else {
                                while (toreplace.startsWith(" ")) {
                                    toreplace = toreplace.substring(1);
                                    --pend;
                                }
                            }
                        } else {
                            int tabcount = 0;
                            while (toreplace.startsWith(" ") || toreplace.startsWith("\t")) {
                                if (toreplace.startsWith("\t")) {
                                    ++tabcount;
                                }
                                toreplace = toreplace.substring(1);
                                --pend;
                            }
                            while (toreplace.startsWith(";")) {
                                toreplace = toreplace.substring(1);
                                --pend;
                            }
                            for (int g = 0; g < tabcount; ++g) {
                                toreplace = '\t' + toreplace;
                                ++pend;
                            }
                        }
                    } else if (tabs) {
                        if (rems) {
                            toreplace = toreplace.replace("\t", " ");
                            while (toreplace.startsWith(" ")) {
                                toreplace = toreplace.substring(1);
                            }
                            if (toreplace.startsWith(";")) {
                                toreplace = '\t' + toreplace;
                                ++pend;
                                toreplace = '\t' + toreplace;
                                ++pend;
                            } else {
                                boolean skip = false;
                                for (String multiCommand : EditorPanel.this.multiCommands) {
                                    if (!toreplace.toUpperCase().startsWith(multiCommand) && !toreplace.toLowerCase().contains(" equ ")) continue;
                                    toreplace = '\t' + toreplace;
                                    ++pend;
                                    toreplace = '\t' + toreplace;
                                    ++pend;
                                    skip = true;
                                    break;
                                }
                                if (!skip) {
                                    for (String singleCommand : EditorPanel.this.singleCommands) {
                                        if (!toreplace.toUpperCase().startsWith(singleCommand)) continue;
                                        toreplace = '\t' + toreplace;
                                        ++pend;
                                        toreplace = '\t' + toreplace;
                                        ++pend;
                                    }
                                }
                            }
                            if (toreplace.length() > 1 && toreplace.contains(" ")) {
                                String command = "";
                                while (!toreplace.startsWith(" ")) {
                                    try {
                                        command = command + toreplace.charAt(0);
                                    }
                                    catch (Exception e) {
                                        System.out.println("'" + toreplace + "'");
                                    }
                                    toreplace = toreplace.substring(1);
                                }
                                while (toreplace.startsWith(" ")) {
                                    toreplace = toreplace.substring(1);
                                    --pend;
                                }
                                toreplace = command + '\t' + '\t' + toreplace;
                                pend += 2;
                            }
                        } else {
                            toreplace = '\t' + toreplace;
                            ++pend;
                        }
                    } else if (!toreplace.startsWith(";")) {
                        toreplace = ";;" + toreplace;
                        pend += 2;
                    }
                    while (toreplace.endsWith(" ")) {
                        toreplace = toreplace.substring(0, toreplace.length() - 1);
                        --pend;
                    }
                    while (toreplace.endsWith("\t")) {
                        toreplace = toreplace.substring(0, toreplace.length() - 1);
                        --pend;
                    }
                    cont[i] = toreplace;
                }
                String out = "";
                if (rems) {
                    EditorPanel.this.codeField.setText("");
                }
                for (int p = 0; p < cont.length; ++p) {
                    Interface.compileprogress.setValue(p);
                    if (rems) {
                        EditorPanel.this.codeField.append(cont[p] + '\n');
                        continue;
                    }
                    out = out + cont[p] + '\n';
                }
                if (!rems) {
                    out = out.substring(0, out.length() - 1);
                    EditorPanel.this.codeField.replaceRange(out, start, end);
                }
                end += pend;
                textsize = EditorPanel.this.codeField.getText().length();
                while (end > textsize) {
                    --end;
                }
                EditorPanel.this.codeField.setEditable(true);
                if (rems) {
                    EditorPanel.this.codeField.setSelectionStart(0);
                    EditorPanel.this.codeField.setSelectionEnd(0);
                    EditorPanel.this.codeField.setCaretPosition(0);
                } else {
                    EditorPanel.this.codeField.setSelectionStart(start);
                    EditorPanel.this.codeField.setSelectionEnd(end);
                }
                EditorPanel.this.remarking = false;
                Interface.compileprogress.setValue(0);
            }
        };
        co.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(String filename) throws UnsupportedEncodingException {
        this.opened = filename;
        this.writepath = new File(filename).getParent();
        this.writepath = this.writepath.contains("/") ? this.writepath + "/" : this.writepath + "\\";
        System.out.println("Writepath = " + this.writepath);
        while (this.opened.contains("\\")) {
            this.opened = this.opened.substring(1);
        }
        while (this.opened.contains("/")) {
            this.opened = this.opened.substring(1);
        }
        try {
            System.out.println(Util.dumpBytes(filename.getBytes("UTF-8")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        File file = new File(filename);
        StringBuffer contents = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String text = null;
            while ((text = reader.readLine()) != null) {
                contents.append(text).append(System.getProperty("line.separator"));
            }
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.modified = false;
        Interface.modified.setText("");
        try {
            this.jtab.setTitleAt(this.tabpos, this.opened);
        }
        catch (Exception e) {
            // empty catch block
        }
        String in = contents.toString();
        byte[] pdscheck = in.getBytes("UTF-8");
        boolean pds = false;
        for (int i = 0; i < this.pdsheader.length; ++i) {
            if (pdscheck[i] != this.pdsheader[i]) continue;
            pds = true;
        }
        if (pds) {
            System.out.println("Opening PDS File");
            byte[] buffer = new byte[pdscheck.length - 512];
            System.arraycopy(pdscheck, 512, buffer, 0, buffer.length);
            contents = new StringBuffer();
            for (int i = 0; i < buffer.length; ++i) {
                contents.append((char)(buffer[i] & 0x7F));
            }
            in = contents.toString();
        }
        while (in.startsWith("\u0000")) {
            in = in.substring(1);
        }
        in = in.replace("\r", "");
        this.codeField.setText(in);
        this.codeField.select(0, 0);
    }

    public void saveFileAs() {
        FileDialog filedia = new FileDialog((Frame)new JFrame(), "Save ASM...", 1);
        filedia.setFile("*.asm");
        filedia.setVisible(true);
        this.filename = filedia.getFile();
        this.writepath = filedia.getDirectory();
        if (this.filename != null) {
            this.filename = filedia.getDirectory() + filedia.getFile();
            String tabname = filedia.getFile();
            String savename = this.filename;
            this.opened = this.filename;
            while (this.opened.contains("\\")) {
                this.opened = this.opened.substring(1);
            }
            while (this.opened.contains("/")) {
                this.opened = this.opened.substring(1);
            }
            if (!savename.toLowerCase().endsWith(".asm")) {
                savename = savename + ".asm";
            }
            if (!tabname.toLowerCase().endsWith(".asm")) {
                tabname = tabname + ".asm";
            }
            File file = new File(savename);
            String exportedText = this.codeField.getText();
            exportedText = exportedText.replace("\r", "");
            exportedText = exportedText.replace("\n", "\r\n");
            try {
                FileWriter fw = new FileWriter(file);
                fw.write(exportedText);
                fw.close();
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        for (int i = 0; i < 100; ++i) {
                            EditorPanel.this.modified = false;
                            Interface.modified.setText("");
                            String g = EditorPanel.this.jtab.getTitleAt(EditorPanel.this.tabpos);
                            if (g.endsWith("*")) {
                                g = g.replace("*", "");
                                EditorPanel.this.jtab.setTitleAt(EditorPanel.this.tabpos, g);
                            }
                            try {
                                Thread.sleep(10L);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
                thread.start();
                this.jtab.setTitleAt(this.tabpos, tabname);
                Set.set("file_" + this.tabpos, savename);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        filedia.dispose();
    }

    public void saveFile() {
        String exportedText = this.codeField.getText();
        System.out.println("Storing " + this.writepath + this.opened);
        if (this.opened != null && !this.opened.toLowerCase().contains("noname")) {
            String savename = this.writepath + this.opened;
            while (this.opened.contains("\\")) {
                this.opened = this.opened.substring(1);
            }
            while (this.opened.contains("/")) {
                this.opened = this.opened.substring(1);
            }
            if (!savename.toLowerCase().endsWith(".asm")) {
                savename = savename + ".asm";
            }
            File file = new File(savename);
            String exported = exportedText.replace("\r", "");
            exported = exported.replace("\n", "\r\n");
            try {
                FileWriter fw = new FileWriter(file);
                fw.write(exported);
                fw.close();
                final String g = this.jtab.getTitleAt(this.tabpos).replace("*", "");
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        for (int i = 0; i < 100; ++i) {
                            EditorPanel.this.modified = false;
                            Interface.modified.setText("");
                            try {
                                EditorPanel.this.jtab.setTitleAt(EditorPanel.this.tabpos, g);
                            }
                            catch (Exception e) {
                                break;
                            }
                            try {
                                Thread.sleep(10L);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
                thread.start();
                Set.set("file_" + this.tabpos, savename);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.saveFileAs();
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    static {
        errors = 0;
        BIN_HEADER = "JAVACPC BIN";
        BIN_EYECATCHER = "File exported by     JavaCPC    ";
    }
}

