/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.math;

public class IntMath {
    public static int gcd(int a, int b) {
        a = Math.abs(a);
        b = Math.abs(b);
        while (a > 0 && b > 0) {
            if ((a %= b) <= 0) continue;
            b %= a;
        }
        return a + b;
    }

    public static long gcd(long a, long b) {
        a = Math.abs(a);
        b = Math.abs(b);
        while (a > 0L && b > 0L) {
            if ((a %= b) <= 0L) continue;
            b %= a;
        }
        return a + b;
    }

    public static int scm(int a, int b) {
        if (a == 0 || b == 0) {
            return 0;
        }
        a = Math.abs(a);
        b = Math.abs(b);
        int u = a;
        int v = b;
        while (a != b) {
            if (a < b) {
                b -= a;
                v += u;
                continue;
            }
            a -= b;
            u += v;
        }
        return (u + v) / 2;
    }

    public static long scm(long a, long b) {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        a = Math.abs(a);
        if ((b = Math.abs(b)) == 1L) {
            return a;
        }
        long u = a;
        long v = b;
        while (a != b) {
            if (a < b) {
                b -= a;
                v += u;
                continue;
            }
            a -= b;
            u += v;
        }
        return (u + v) / 2L;
    }

    public static int reverseBits(int a) {
        return IntMath.reverseBits(a, 32);
    }

    public static int reverseBits(int a, int numBits) {
        int b = 0;
        for (int i = 0; i < numBits; ++i) {
            b <<= 1;
            b |= a & 1;
            a >>>= 1;
        }
        return b;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 8; ++i) {
            int a = 1 << i;
            int b = IntMath.reverseBits(a, 3);
            System.out.println(a + " - " + b);
        }
    }
}

