/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime;

import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import javax.imageio.stream.ImageOutputStream;
import org.monte.media.Buffer;
import org.monte.media.Codec;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.io.ImageOutputStreamAdapter;
import org.monte.media.math.Rational;
import org.monte.media.quicktime.DataAtomOutputStream;

public class AbstractQuickTimeStream {
    protected ImageOutputStream out;
    protected long streamOffset;
    protected WideDataAtom mdatAtom;
    protected long mdatOffset;
    protected CompositeAtom moovAtom;
    protected Date creationTime;
    protected Date modificationTime;
    protected long movieTimeScale = 600L;
    protected ArrayList<Track> tracks = new ArrayList();
    protected double[] movieMatrix = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
    protected States state = States.REALIZED;

    protected long getRelativeStreamPosition() throws IOException {
        return this.out.getStreamPosition() - this.streamOffset;
    }

    protected void seekRelative(long newPosition) throws IOException {
        this.out.seek(newPosition + this.streamOffset);
    }

    protected static int typeToInt(String str) {
        byte[] b;
        try {
            b = str.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            InternalError ie = new InternalError("ASCII not supported");
            ie.initCause(ex);
            throw ie;
        }
        return (b[3] & 0xFF) << 24 | (b[2] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[0] & 0xFF;
    }

    protected static String intToType(int id) {
        byte[] b = new byte[]{(byte)(id >>> 24 & 0xFF), (byte)(id >>> 16 & 0xFF), (byte)(id >>> 8 & 0xFF), (byte)(id & 0xFF)};
        try {
            return new String(b, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            InternalError ie = new InternalError("ASCII not supported");
            ie.initCause(ex);
            throw ie;
        }
    }

    public static class Edit {
        public int trackDuration;
        public int mediaTime;
        public int mediaRate;

        public Edit(int trackDuration, int mediaTime, double mediaRate) {
            if (trackDuration < 0) {
                throw new IllegalArgumentException("trackDuration must not be < 0:" + trackDuration);
            }
            if (mediaTime < -1) {
                throw new IllegalArgumentException("mediaTime must not be < -1:" + mediaTime);
            }
            if (mediaRate <= 0.0) {
                throw new IllegalArgumentException("mediaRate must not be <= 0:" + mediaRate);
            }
            this.trackDuration = trackDuration;
            this.mediaTime = mediaTime;
            this.mediaRate = (int)(mediaRate * 65536.0);
        }

        public Edit(int trackDuration, int mediaTime, int mediaRate) {
            if (trackDuration < 0) {
                throw new IllegalArgumentException("trackDuration must not be < 0:" + trackDuration);
            }
            if (mediaTime < -1) {
                throw new IllegalArgumentException("mediaTime must not be < -1:" + mediaTime);
            }
            if (mediaRate <= 0) {
                throw new IllegalArgumentException("mediaRate must not be <= 0:" + mediaRate);
            }
            this.trackDuration = trackDuration;
            this.mediaTime = mediaTime;
            this.mediaRate = mediaRate;
        }
    }

    protected class AudioTrack
    extends Track {
        protected int soundNumberOfChannels;
        protected int soundSampleSize;
        protected int soundCompressionId;
        protected long soundSamplesPerPacket;
        protected int soundBytesPerPacket;
        protected int soundBytesPerFrame;
        protected int soundBytesPerSample;
        protected double soundSampleRate;
        protected byte[] stsdExtensions;

        public AudioTrack() {
            super(FormatKeys.MediaType.AUDIO);
            this.stsdExtensions = new byte[0];
        }

        @Override
        protected void writeMediaInformationHeaderAtom(CompositeAtom minfAtom) throws IOException {
            DataAtom leaf = new DataAtom("smhd");
            minfAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeFixed8D8(0.0);
            d.writeUShort(0);
        }

        @Override
        protected void writeSampleDescriptionAtom(CompositeAtom stblAtom) throws IOException {
            DataAtom leaf = new DataAtom("stsd");
            stblAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeInt(1);
            d.writeUInt(52 + this.stsdExtensions.length);
            d.writeType(this.mediaCompressionType);
            d.write(new byte[6]);
            d.writeUShort(1);
            d.writeUShort(1);
            d.writeUShort(0);
            d.writeUInt(0L);
            d.writeUShort(this.soundNumberOfChannels);
            d.writeUShort(this.soundSampleSize);
            d.writeUShort(this.soundCompressionId);
            d.writeUShort(0);
            d.writeFixed16D16(this.soundSampleRate);
            d.writeUInt(this.soundSamplesPerPacket);
            d.writeUInt(this.soundBytesPerPacket);
            d.writeUInt(this.soundBytesPerFrame);
            d.writeUInt(this.soundBytesPerSample);
            d.write(this.stsdExtensions);
        }
    }

    protected class VideoTrack
    extends Track {
        protected float videoQuality;
        protected int videoDepth;
        protected IndexColorModel videoColorTable;

        public VideoTrack() {
            super(FormatKeys.MediaType.VIDEO);
            this.videoQuality = 0.97f;
            this.videoDepth = -1;
        }

        @Override
        protected void writeMediaInformationHeaderAtom(CompositeAtom minfAtom) throws IOException {
            DataAtom leaf = new DataAtom("vmhd");
            minfAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(1);
            d.writeShort(64);
            d.writeUShort(0);
            d.writeUShort(0);
            d.writeUShort(0);
        }

        @Override
        protected void writeSampleDescriptionAtom(CompositeAtom stblAtom) throws IOException {
            CompositeAtom leaf = new CompositeAtom("stsd");
            stblAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeInt(1);
            d.writeInt(86);
            d.writeType(this.mediaCompressionType);
            d.write(new byte[6]);
            d.writeShort(1);
            d.writeShort(0);
            d.writeShort(0);
            d.writeType("java");
            d.writeInt(0);
            d.writeInt(512);
            d.writeUShort((int)this.width);
            d.writeUShort((int)this.height);
            d.writeFixed16D16(72.0);
            d.writeFixed16D16(72.0);
            d.writeInt(0);
            d.writeShort(1);
            d.writePString(this.mediaCompressorName, 32);
            d.writeShort(this.videoDepth);
            d.writeShort(this.videoColorTable == null ? -1 : 0);
            if (this.videoColorTable != null) {
                this.writeColorTableAtom(leaf);
            }
        }

        protected void writeColorTableAtom(CompositeAtom stblAtom) throws IOException {
            DataAtom leaf = new DataAtom("ctab");
            stblAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.writeUInt(0L);
            d.writeUShort(32768);
            d.writeUShort(this.videoColorTable.getMapSize() - 1);
            int n = this.videoColorTable.getMapSize();
            for (int i = 0; i < n; ++i) {
                d.writeUShort(0);
                d.writeUShort(this.videoColorTable.getRed(i) << 8 | this.videoColorTable.getRed(i));
                d.writeUShort(this.videoColorTable.getGreen(i) << 8 | this.videoColorTable.getGreen(i));
                d.writeUShort(this.videoColorTable.getBlue(i) << 8 | this.videoColorTable.getBlue(i));
            }
        }
    }

    protected abstract class Track {
        protected final FormatKeys.MediaType mediaType;
        protected Format format;
        protected long mediaTimeScale = 600L;
        protected String mediaCompressionType;
        protected String mediaCompressorName;
        protected ArrayList<Chunk> chunks = new ArrayList();
        protected ArrayList<TimeToSampleGroup> timeToSamples = new ArrayList();
        protected ArrayList<SampleSizeGroup> sampleSizes = new ArrayList();
        protected ArrayList<Long> syncSamples = null;
        protected long sampleCount = 0L;
        protected long mediaDuration = 0L;
        protected Edit[] editList;
        protected int syncInterval;
        protected Codec codec;
        protected Buffer outputBuffer;
        protected Buffer inputBuffer;
        protected Rational inputTime;
        protected Rational writeTime;
        protected double[] matrix = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
        protected double width;
        protected double height;

        public Track(FormatKeys.MediaType mediaType) {
            this.mediaType = mediaType;
        }

        public void addSample(Sample sample, int sampleDescriptionId, boolean isSyncSample) {
            this.mediaDuration += sample.duration;
            ++this.sampleCount;
            if (isSyncSample) {
                if (this.syncSamples != null) {
                    this.syncSamples.add(this.sampleCount);
                }
            } else if (this.syncSamples == null) {
                this.syncSamples = new ArrayList();
                for (long i = 1L; i < this.sampleCount; ++i) {
                    this.syncSamples.add(i);
                }
            }
            if (this.timeToSamples.isEmpty() || !this.timeToSamples.get(this.timeToSamples.size() - 1).maybeAddSample(sample)) {
                this.timeToSamples.add(new TimeToSampleGroup(sample));
            }
            if (this.sampleSizes.isEmpty() || !this.sampleSizes.get(this.sampleSizes.size() - 1).maybeAddSample(sample)) {
                this.sampleSizes.add(new SampleSizeGroup(sample));
            }
            if (this.chunks.isEmpty() || !this.chunks.get(this.chunks.size() - 1).maybeAddSample(sample, sampleDescriptionId)) {
                this.chunks.add(new Chunk(sample, sampleDescriptionId));
            }
        }

        public void addChunk(Chunk chunk, boolean isSyncSample) {
            this.mediaDuration += chunk.firstSample.duration * chunk.sampleCount;
            this.sampleCount += chunk.sampleCount;
            if (isSyncSample) {
                if (this.syncSamples != null) {
                    for (long i = this.sampleCount - chunk.sampleCount; i < this.sampleCount; ++i) {
                        this.syncSamples.add(i);
                    }
                }
            } else if (this.syncSamples == null) {
                this.syncSamples = new ArrayList();
                for (long i = 1L; i < this.sampleCount; ++i) {
                    this.syncSamples.add(i);
                }
            }
            if (this.timeToSamples.isEmpty() || !this.timeToSamples.get(this.timeToSamples.size() - 1).maybeAddChunk(chunk)) {
                this.timeToSamples.add(new TimeToSampleGroup(chunk));
            }
            if (this.sampleSizes.isEmpty() || !this.sampleSizes.get(this.sampleSizes.size() - 1).maybeAddChunk(chunk)) {
                this.sampleSizes.add(new SampleSizeGroup(chunk));
            }
            if (this.chunks.isEmpty() || !this.chunks.get(this.chunks.size() - 1).maybeAddChunk(chunk)) {
                this.chunks.add(chunk);
            }
        }

        public boolean isEmpty() {
            return this.sampleCount == 0L;
        }

        public long getSampleCount() {
            return this.sampleCount;
        }

        public long getTrackDuration(long movieTimeScale) {
            if (this.editList == null || this.editList.length == 0) {
                return this.mediaDuration * movieTimeScale / this.mediaTimeScale;
            }
            long duration = 0L;
            for (int i = 0; i < this.editList.length; ++i) {
                duration += (long)this.editList[i].trackDuration;
            }
            return duration;
        }

        protected void writeTrackAtoms(int trackIndex, CompositeAtom moovAtom, Date modificationTime) throws IOException {
            CompositeAtom trakAtom = new CompositeAtom("trak");
            moovAtom.add(trakAtom);
            DataAtom leaf = new DataAtom("tkhd");
            trakAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(15);
            d.writeMacTimestamp(AbstractQuickTimeStream.this.creationTime);
            d.writeMacTimestamp(modificationTime);
            d.writeInt(trackIndex + 1);
            d.writeInt(0);
            d.writeUInt(this.getTrackDuration(AbstractQuickTimeStream.this.movieTimeScale));
            d.writeLong(0L);
            d.writeShort(0);
            d.writeShort(0);
            d.writeFixed8D8(this.mediaType == FormatKeys.MediaType.AUDIO ? 1.0 : 0.0);
            d.writeShort(0);
            d.writeFixed16D16(this.matrix[0]);
            d.writeFixed16D16(this.matrix[1]);
            d.writeFixed2D30(this.matrix[2]);
            d.writeFixed16D16(this.matrix[3]);
            d.writeFixed16D16(this.matrix[4]);
            d.writeFixed2D30(this.matrix[5]);
            d.writeFixed16D16(this.matrix[6]);
            d.writeFixed16D16(this.matrix[7]);
            d.writeFixed2D30(this.matrix[8]);
            d.writeFixed16D16(this.mediaType == FormatKeys.MediaType.VIDEO ? ((VideoTrack)this).width : 0.0);
            d.writeFixed16D16(this.mediaType == FormatKeys.MediaType.VIDEO ? ((VideoTrack)this).height : 0.0);
            CompositeAtom edtsAtom = new CompositeAtom("edts");
            trakAtom.add(edtsAtom);
            leaf = new DataAtom("elst");
            edtsAtom.add(leaf);
            d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            Edit[] elist = this.editList;
            if (elist == null || elist.length == 0) {
                d.writeUInt(1L);
                d.writeUInt(this.getTrackDuration(AbstractQuickTimeStream.this.movieTimeScale));
                d.writeUInt(0L);
                d.writeFixed16D16(1.0);
            } else {
                d.writeUInt(elist.length);
                for (int i = 0; i < elist.length; ++i) {
                    d.writeUInt(elist[i].trackDuration);
                    d.writeUInt(elist[i].mediaTime);
                    d.writeUInt(elist[i].mediaRate);
                }
            }
            CompositeAtom mdiaAtom = new CompositeAtom("mdia");
            trakAtom.add(mdiaAtom);
            leaf = new DataAtom("mdhd");
            mdiaAtom.add(leaf);
            d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeMacTimestamp(AbstractQuickTimeStream.this.creationTime);
            d.writeMacTimestamp(modificationTime);
            d.writeUInt(this.mediaTimeScale);
            d.writeUInt(this.mediaDuration);
            d.writeShort(0);
            d.writeShort(0);
            leaf = new DataAtom("hdlr");
            mdiaAtom.add(leaf);
            d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeType("mhlr");
            d.writeType(this.mediaType == FormatKeys.MediaType.VIDEO ? "vide" : "soun");
            if (this.mediaType == FormatKeys.MediaType.AUDIO) {
                d.writeType("appl");
            } else {
                d.writeUInt(0L);
            }
            d.writeUInt(this.mediaType == FormatKeys.MediaType.AUDIO ? 0x10000000L : 0L);
            d.writeUInt(this.mediaType == FormatKeys.MediaType.AUDIO ? 65941L : 0L);
            d.writePString(this.mediaType == FormatKeys.MediaType.AUDIO ? "Apple Sound Media Handler" : "");
            this.writeMediaInformationAtoms(mdiaAtom);
        }

        protected void writeMediaInformationAtoms(CompositeAtom mdiaAtom) throws IOException {
            CompositeAtom minfAtom = new CompositeAtom("minf");
            mdiaAtom.add(minfAtom);
            this.writeMediaInformationHeaderAtom(minfAtom);
            DataAtom leaf = new DataAtom("hdlr");
            minfAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeType("dhlr");
            d.writeType("alis");
            if (this.mediaType == FormatKeys.MediaType.AUDIO) {
                d.writeType("appl");
            } else {
                d.writeUInt(0L);
            }
            d.writeUInt(this.mediaType == FormatKeys.MediaType.AUDIO ? 0x10000001L : 0L);
            d.writeInt(this.mediaType == FormatKeys.MediaType.AUDIO ? 65967 : 0);
            d.writePString("Apple Alias Data Handler");
            CompositeAtom dinfAtom = new CompositeAtom("dinf");
            minfAtom.add(dinfAtom);
            leaf = new DataAtom("dref");
            dinfAtom.add(leaf);
            d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeInt(1);
            d.writeInt(12);
            d.writeType("alis");
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(1);
            this.writeSampleTableAtoms(minfAtom);
        }

        protected abstract void writeMediaInformationHeaderAtom(CompositeAtom var1) throws IOException;

        protected abstract void writeSampleDescriptionAtom(CompositeAtom var1) throws IOException;

        protected void writeSampleTableAtoms(CompositeAtom minfAtom) throws IOException {
            int n;
            CompositeAtom stblAtom = new CompositeAtom("stbl");
            minfAtom.add(stblAtom);
            this.writeSampleDescriptionAtom(stblAtom);
            DataAtom leaf = new DataAtom("stts");
            stblAtom.add(leaf);
            DataAtomOutputStream d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            d.writeUInt(this.timeToSamples.size());
            for (TimeToSampleGroup tts : this.timeToSamples) {
                d.writeUInt(tts.getSampleCount());
                d.writeUInt(tts.getSampleDuration());
            }
            leaf = new DataAtom("stsc");
            stblAtom.add(leaf);
            d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            int entryCount = 0;
            long previousSampleCount = -1L;
            long previousSampleDescriptionId = -1L;
            for (Chunk chunk : this.chunks) {
                if (chunk.sampleCount == previousSampleCount && (long)chunk.sampleDescriptionId == previousSampleDescriptionId) continue;
                previousSampleCount = chunk.sampleCount;
                previousSampleDescriptionId = chunk.sampleDescriptionId;
                ++entryCount;
            }
            d.writeInt(entryCount);
            int firstChunk = 1;
            previousSampleCount = -1L;
            previousSampleDescriptionId = -1L;
            for (Chunk c : this.chunks) {
                if (c.sampleCount != previousSampleCount || (long)c.sampleDescriptionId != previousSampleDescriptionId) {
                    previousSampleCount = c.sampleCount;
                    previousSampleDescriptionId = c.sampleDescriptionId;
                    d.writeUInt(firstChunk);
                    d.writeUInt(c.sampleCount);
                    d.writeInt(c.sampleDescriptionId);
                }
                ++firstChunk;
            }
            if (this.syncSamples != null) {
                leaf = new DataAtom("stss");
                stblAtom.add(leaf);
                d = leaf.getOutputStream();
                d.write(0);
                d.write(0);
                d.write(0);
                d.write(0);
                d.writeUInt(this.syncSamples.size());
                for (Long number : this.syncSamples) {
                    d.writeUInt(number);
                }
            }
            leaf = new DataAtom("stsz");
            stblAtom.add(leaf);
            d = leaf.getOutputStream();
            d.write(0);
            d.write(0);
            d.write(0);
            d.write(0);
            int n2 = n = this.mediaType == FormatKeys.MediaType.AUDIO && ((AudioTrack)this).soundCompressionId != -2 ? ((AudioTrack)this).soundSampleSize / 8 * ((AudioTrack)this).soundNumberOfChannels : 1;
            if (this.sampleSizes.size() == 1) {
                d.writeUInt(this.sampleSizes.get(0).getSampleLength() / (long)n);
                d.writeUInt(this.sampleSizes.get(0).getSampleCount());
            } else {
                d.writeUInt(0L);
                long count = 0L;
                for (SampleSizeGroup s : this.sampleSizes) {
                    count += s.sampleCount;
                }
                d.writeUInt(count);
                for (SampleSizeGroup s : this.sampleSizes) {
                    long sampleSize = s.getSampleLength() / (long)n;
                    int i = 0;
                    while ((long)i < s.sampleCount) {
                        d.writeUInt(sampleSize);
                        ++i;
                    }
                }
            }
            if (this.chunks.isEmpty() || this.chunks.get(this.chunks.size() - 1).getChunkOffset() <= 0xFFFFFFFFL) {
                leaf = new DataAtom("stco");
                stblAtom.add(leaf);
                d = leaf.getOutputStream();
                d.write(0);
                d.write(0);
                d.write(0);
                d.write(0);
                d.writeUInt(this.chunks.size());
                for (Chunk c : this.chunks) {
                    d.writeUInt(c.getChunkOffset() + AbstractQuickTimeStream.this.mdatOffset);
                }
            } else {
                leaf = new DataAtom("co64");
                stblAtom.add(leaf);
                d = leaf.getOutputStream();
                d.write(0);
                d.write(0);
                d.write(0);
                d.write(0);
                d.writeUInt(this.chunks.size());
                for (Chunk c : this.chunks) {
                    d.writeLong(c.getChunkOffset());
                }
            }
        }
    }

    protected static class Chunk
    extends Group {
        protected int sampleDescriptionId;

        public Chunk(Sample firstSample, int sampleDescriptionId) {
            super(firstSample);
            this.sampleDescriptionId = sampleDescriptionId;
        }

        public Chunk(Sample firstSample, Sample lastSample, int sampleCount, int sampleDescriptionId) {
            super(firstSample, lastSample, sampleCount);
            this.sampleDescriptionId = sampleDescriptionId;
        }

        public boolean maybeAddSample(Sample sample, int sampleDescriptionId) {
            if (sampleDescriptionId == this.sampleDescriptionId && this.lastSample.offset + this.lastSample.length == sample.offset) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.sampleDescriptionId == chunk.sampleDescriptionId && this.lastSample.offset + this.lastSample.length == chunk.firstSample.offset) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getChunkOffset() {
            return this.firstSample.offset;
        }
    }

    protected static class SampleSizeGroup
    extends Group {
        public SampleSizeGroup(Sample firstSample) {
            super(firstSample);
        }

        public SampleSizeGroup(Group group) {
            super(group);
        }

        @Override
        public boolean maybeAddSample(Sample sample) {
            if (this.firstSample.length == sample.length) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.firstSample.length == chunk.firstSample.length) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getSampleLength() {
            return this.firstSample.length;
        }
    }

    protected static class TimeToSampleGroup
    extends Group {
        public TimeToSampleGroup(Sample firstSample) {
            super(firstSample);
        }

        public TimeToSampleGroup(Group group) {
            super(group);
        }

        @Override
        public boolean maybeAddSample(Sample sample) {
            if (this.firstSample.duration == sample.duration) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.firstSample.duration == chunk.firstSample.duration) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getSampleDuration() {
            return this.firstSample.duration;
        }
    }

    protected static class Sample {
        long offset;
        long length;
        long duration;

        public Sample(long duration, long offset, long length) {
            this.duration = duration;
            this.offset = offset;
            this.length = length;
        }
    }

    protected static abstract class Group {
        protected Sample firstSample;
        protected Sample lastSample;
        protected long sampleCount;
        protected static final long maxSampleCount = Integer.MAX_VALUE;

        protected Group(Sample firstSample) {
            this.firstSample = this.lastSample = firstSample;
            this.sampleCount = 1L;
        }

        protected Group(Sample firstSample, Sample lastSample, long sampleCount) {
            this.firstSample = firstSample;
            this.lastSample = lastSample;
            this.sampleCount = sampleCount;
            if (sampleCount > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Capacity exceeded");
            }
        }

        protected Group(Group group) {
            this.firstSample = group.firstSample;
            this.lastSample = group.lastSample;
            this.sampleCount = group.sampleCount;
        }

        protected boolean maybeAddSample(Sample sample) {
            if (this.sampleCount < Integer.MAX_VALUE) {
                this.lastSample = sample;
                ++this.sampleCount;
                return true;
            }
            return false;
        }

        protected boolean maybeAddChunk(Chunk chunk) {
            if (this.sampleCount + chunk.sampleCount <= Integer.MAX_VALUE) {
                this.lastSample = chunk.lastSample;
                this.sampleCount += chunk.sampleCount;
                return true;
            }
            return false;
        }

        public long getSampleCount() {
            return this.sampleCount;
        }
    }

    protected class WideDataAtom
    extends Atom {
        protected DataAtomOutputStream data;
        protected boolean finished;

        public WideDataAtom(String type) throws IOException {
            super(type);
            AbstractQuickTimeStream.this.out.writeLong(0L);
            AbstractQuickTimeStream.this.out.writeLong(0L);
            this.data = new DataAtomOutputStream(new ImageOutputStreamAdapter(AbstractQuickTimeStream.this.out)){

                @Override
                public void flush() throws IOException {
                }
            };
        }

        public DataAtomOutputStream getOutputStream() {
            if (this.finished) {
                throw new IllegalStateException("Atom is finished");
            }
            return this.data;
        }

        public long getOffset() {
            return this.offset;
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                long pointer = AbstractQuickTimeStream.this.getRelativeStreamPosition();
                AbstractQuickTimeStream.this.seekRelative(this.offset);
                DataAtomOutputStream headerData = new DataAtomOutputStream(new ImageOutputStreamAdapter(AbstractQuickTimeStream.this.out));
                long finishedSize = this.size();
                if (finishedSize <= 0xFFFFFFFFL) {
                    headerData.writeUInt(8L);
                    headerData.writeType("wide");
                    headerData.writeUInt(finishedSize - 8L);
                    headerData.writeType(this.type);
                } else {
                    headerData.writeInt(1);
                    headerData.writeType(this.type);
                    headerData.writeLong(finishedSize - 8L);
                }
                AbstractQuickTimeStream.this.seekRelative(pointer);
                this.finished = true;
            }
        }

        @Override
        public long size() {
            return 16L + this.data.size();
        }
    }

    protected class DataAtom
    extends Atom {
        protected DataAtomOutputStream data;
        protected boolean finished;

        public DataAtom(String type) throws IOException {
            super(type);
            AbstractQuickTimeStream.this.out.writeLong(0L);
            this.data = new DataAtomOutputStream(new ImageOutputStreamAdapter(AbstractQuickTimeStream.this.out));
        }

        public DataAtomOutputStream getOutputStream() {
            if (this.finished) {
                throw new IllegalStateException("DataAtom is finished");
            }
            return this.data;
        }

        public long getOffset() {
            return this.offset;
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                long sizeBefore = this.size();
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("DataAtom \"" + this.type + "\" is too large: " + this.size());
                }
                long pointer = AbstractQuickTimeStream.this.getRelativeStreamPosition();
                AbstractQuickTimeStream.this.seekRelative(this.offset);
                DataAtomOutputStream headerData = new DataAtomOutputStream(new ImageOutputStreamAdapter(AbstractQuickTimeStream.this.out));
                headerData.writeUInt(this.size());
                headerData.writeType(this.type);
                AbstractQuickTimeStream.this.seekRelative(pointer);
                this.finished = true;
                long sizeAfter = this.size();
                if (sizeBefore != sizeAfter) {
                    System.err.println("size mismatch " + sizeBefore + ".." + sizeAfter);
                }
            }
        }

        @Override
        public long size() {
            return 8L + this.data.size();
        }
    }

    protected class CompositeAtom
    extends DataAtom {
        protected LinkedList<Atom> children;

        public CompositeAtom(String type) throws IOException {
            super(type);
            this.children = new LinkedList();
        }

        public void add(Atom child) throws IOException {
            if (this.children.size() > 0) {
                this.children.getLast().finish();
            }
            this.children.add(child);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("CompositeAtom \"" + this.type + "\" is too large: " + this.size());
                }
                long pointer = AbstractQuickTimeStream.this.getRelativeStreamPosition();
                AbstractQuickTimeStream.this.seekRelative(this.offset);
                DataAtomOutputStream headerData = new DataAtomOutputStream(new ImageOutputStreamAdapter(AbstractQuickTimeStream.this.out));
                headerData.writeInt((int)this.size());
                headerData.writeType(this.type);
                for (Atom child : this.children) {
                    child.finish();
                }
                AbstractQuickTimeStream.this.seekRelative(pointer);
                this.finished = true;
            }
        }

        @Override
        public long size() {
            long length = 8L + this.data.size();
            for (Atom child : this.children) {
                length += child.size();
            }
            return length;
        }
    }

    protected abstract class Atom {
        protected String type;
        protected long offset;

        public Atom(String type) throws IOException {
            this.type = type;
            this.offset = AbstractQuickTimeStream.this.getRelativeStreamPosition();
        }

        public abstract void finish() throws IOException;

        public abstract long size();
    }

    protected static enum States {
        REALIZED,
        STARTED,
        FINISHED,
        CLOSED;

    }
}

