/*
 * Decompiled with CFR 0.152.
 */
package pacman;

import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import jemu.core.samples.Samples;
import pacman.Fruit;
import pacman.Ghost;
import pacman.Main;
import pacman.PacMan;
import pacman.Sprite;

public class Game {
    static final int DIR_NONE = -1;
    static final int DIR_UP = 0;
    static final int DIR_DOWN = 1;
    static final int DIR_LEFT = 2;
    static final int DIR_RIGHT = 3;
    static final int PILL = 0;
    static final int POWER_PILL = 1;
    static final int NO_PILL = 2;
    static final int NO_POWER_PILL = 3;
    static final int EMPTY_PILL = 4;
    static final int POWER_PILL_TIME = 480;
    static final int PILL_SPACE_X = 32;
    static final int PILL_SPACE_Y = 24;
    static final int PILL_NEXTLINE_X = 12;
    static final int GAMEAREA_X = 269;
    static final int GAMEAREA_Y = 24;
    static final int GAMEAREA_WIDTH = 17;
    static final int GAMEAREA_HEIGHT = 23;
    static final int IMAGES_BACKGROUND = 0;
    static final int IMAGES_TITLE = 1;
    static final int IMAGES_GAMEOVER = 2;
    static final int IMAGES_LIVES = 3;
    static final int IMAGES_SCORE = 4;
    static final int IMAGES_HI = 5;
    static final int GHOST_GREEN = 0;
    static final int GHOST_RED = 1;
    static final int GHOST_TIMER_1 = 85;
    static final int GHOST_TIMER_2 = 55;
    static final int GHOST_TIMER_3 = 25;
    static final int GHOST_TIMER_4 = 15;
    static final int STATE_WAIT_TO_PLAY = 0;
    static final int STATE_PLAY = 1;
    static final int STATE_DIE = 2;
    static final int STATE_WIN = 3;
    static final int STATE_INTRO = 4;
    static final int STATE_GAMEOVER = 5;
    static final int STATE_PAUSE = 6;
    static final int SCORE_PILL = 60;
    static final int SCORE_POWER_PILL = 0;
    static final int SCORE_GHOST = 200;
    static final int SCORE_FRUIT = 2000;
    static final int NUM_PILLS = 150;
    Ghost[] ghost = new Ghost[4];
    PacMan pacman;
    Fruit fruit;
    protected Main parent;
    protected Image[] GhostImages = new Image[2];
    protected Image[] MiscImages = new Image[6];
    protected Sprite LivesSprite;
    protected Sprite ScoreSprite;
    protected Sprite HiSprite;
    protected Sprite BackgroundSprite;
    protected Sprite TitleSprite;
    protected Sprite GameOverSprite;
    protected Image[] PillImages = new Image[4];
    protected Sprite[] PillSprites = new Sprite[4];
    protected int[][] Pills = new int[17][23];
    protected int[][] MazeSolve = new int[17][23];
    protected int RandomSeed = 313210061;
    protected int state;
    protected int state_timer;

    Game(Main main) {
        this.parent = main;
        this.MiscImages[0] = main.LoadImage("images/pacman.gif", 768, 568);
        this.MiscImages[1] = main.LoadImage("images/title.gif", 280, 39);
        this.MiscImages[2] = main.LoadImage("images/gameover.gif", 336, 40);
        this.MiscImages[3] = main.LoadImage("images/lives.gif", 62, 70);
        this.MiscImages[4] = main.LoadImage("images/score.gif", 40, 8);
        this.MiscImages[5] = main.LoadImage("images/hi.gif", 15, 8);
        this.BackgroundSprite = new Sprite(main, this.MiscImages[0], 784, 568);
        this.TitleSprite = new Sprite(main, this.MiscImages[1], 280, 39);
        this.GameOverSprite = new Sprite(main, this.MiscImages[2], 336, 40);
        this.LivesSprite = new Sprite(main, this.MiscImages[3], 62, 14);
        this.ScoreSprite = new Sprite(main, this.MiscImages[4], 40, 8);
        this.HiSprite = new Sprite(main, this.MiscImages[5], 15, 8);
        this.GhostImages[0] = main.LoadImage("images/ghostgreen.gif", 16, 576);
        this.GhostImages[1] = main.LoadImage("images/ghostred.gif", 16, 576);
        this.PillImages[0] = main.LoadImage("images/pill.gif", 4, 4);
        this.PillImages[1] = main.LoadImage("images/powerpill.gif", 16, 16);
        this.PillImages[2] = main.LoadImage("images/nopill.gif", 4, 4);
        this.PillImages[3] = main.LoadImage("images/nopowerpill.gif", 16, 16);
        this.PillSprites[0] = new Sprite(main, this.PillImages[0], 4, 4);
        this.PillSprites[0].setHotspot(2, 2);
        this.PillSprites[1] = new Sprite(main, this.PillImages[1], 16, 16);
        this.PillSprites[1].setHotspot(8, 13);
        this.PillSprites[2] = new Sprite(main, this.PillImages[2], 4, 4);
        this.PillSprites[2].setHotspot(2, 2);
        this.PillSprites[3] = new Sprite(main, this.PillImages[3], 16, 16);
        this.PillSprites[3].setHotspot(8, 13);
        this.pacman = new PacMan(main, 7, 16);
        this.ghost[0] = new Ghost(main, this.GhostImages[0], 0, 0, 85);
        this.ghost[1] = new Ghost(main, this.GhostImages[1], 0, 0, 55);
        this.ghost[2] = new Ghost(main, this.GhostImages[1], 0, 0, 25);
        this.ghost[3] = new Ghost(main, this.GhostImages[0], 0, -1, 15);
        this.fruit = new Fruit(main);
        this.resetPills();
        this.buildScreen(main.offScrImage.getGraphics());
        this.setState(4, 0);
    }

    public void resetPills() {
        for (int i = 0; i < 23; ++i) {
            for (int i_0_ = 0; i_0_ < 17; ++i_0_) {
                this.Pills[i_0_][i] = -2;
            }
        }
        this.Pills[1][1] = 0;
        this.MazeSolve[1][1] = 1;
        this.Pills[2][1] = 0;
        this.MazeSolve[2][1] = 3;
        this.Pills[3][1] = 0;
        this.MazeSolve[3][1] = 3;
        this.Pills[4][1] = 0;
        this.MazeSolve[4][1] = 1;
        this.Pills[5][1] = 0;
        this.MazeSolve[5][1] = 3;
        this.Pills[6][1] = 0;
        this.MazeSolve[6][1] = 3;
        this.Pills[7][1] = 0;
        this.MazeSolve[7][1] = 1;
        this.Pills[9][1] = 0;
        this.MazeSolve[9][1] = 1;
        this.Pills[10][1] = 0;
        this.MazeSolve[10][1] = 2;
        this.Pills[11][1] = 0;
        this.MazeSolve[11][1] = 2;
        this.Pills[12][1] = 0;
        this.MazeSolve[12][1] = 1;
        this.Pills[13][1] = 0;
        this.MazeSolve[13][1] = 2;
        this.Pills[14][1] = 0;
        this.MazeSolve[14][1] = 2;
        this.Pills[15][1] = 0;
        this.MazeSolve[15][1] = 1;
        this.Pills[1][2] = 1;
        this.MazeSolve[1][2] = 1;
        this.Pills[4][2] = 0;
        this.MazeSolve[4][2] = 1;
        this.Pills[7][2] = 0;
        this.MazeSolve[7][2] = 1;
        this.Pills[9][2] = 0;
        this.MazeSolve[9][2] = 1;
        this.Pills[12][2] = 0;
        this.MazeSolve[12][2] = 1;
        this.Pills[15][2] = 1;
        this.MazeSolve[15][2] = 1;
        this.Pills[1][3] = 0;
        this.MazeSolve[1][3] = 1;
        this.Pills[4][3] = 0;
        this.MazeSolve[4][3] = 1;
        this.Pills[7][3] = 0;
        this.MazeSolve[7][3] = 1;
        this.Pills[9][3] = 0;
        this.MazeSolve[9][3] = 1;
        this.Pills[12][3] = 0;
        this.MazeSolve[12][3] = 1;
        this.Pills[15][3] = 0;
        this.MazeSolve[15][3] = 1;
        this.Pills[1][4] = 0;
        this.MazeSolve[1][4] = 1;
        this.Pills[4][4] = 0;
        this.MazeSolve[4][4] = 1;
        this.Pills[7][4] = 0;
        this.MazeSolve[7][4] = 1;
        this.Pills[9][4] = 0;
        this.MazeSolve[9][4] = 1;
        this.Pills[12][4] = 0;
        this.MazeSolve[12][4] = 1;
        this.Pills[15][4] = 0;
        this.MazeSolve[15][4] = 1;
        this.Pills[1][5] = 0;
        this.MazeSolve[1][5] = 3;
        this.Pills[2][5] = 0;
        this.MazeSolve[2][5] = 3;
        this.Pills[3][5] = 0;
        this.MazeSolve[3][5] = 3;
        this.Pills[4][5] = 0;
        this.MazeSolve[4][5] = 3;
        this.Pills[5][5] = 0;
        this.MazeSolve[5][5] = 3;
        this.Pills[6][5] = 0;
        this.MazeSolve[6][5] = 1;
        this.Pills[7][5] = 0;
        this.MazeSolve[7][5] = 2;
        this.Pills[8][5] = 0;
        this.MazeSolve[8][5] = 3;
        this.Pills[9][5] = 0;
        this.MazeSolve[9][5] = 3;
        this.Pills[10][5] = 0;
        this.MazeSolve[10][5] = 1;
        this.Pills[11][5] = 0;
        this.MazeSolve[11][5] = 2;
        this.Pills[12][5] = 0;
        this.MazeSolve[12][5] = 2;
        this.Pills[13][5] = 0;
        this.MazeSolve[13][5] = 2;
        this.Pills[14][5] = 0;
        this.MazeSolve[14][5] = 2;
        this.Pills[15][5] = 0;
        this.MazeSolve[15][5] = 2;
        this.Pills[1][6] = 0;
        this.MazeSolve[1][6] = 1;
        this.Pills[4][6] = 0;
        this.MazeSolve[4][6] = 0;
        this.Pills[6][6] = 0;
        this.MazeSolve[6][6] = 1;
        this.Pills[10][6] = 0;
        this.MazeSolve[10][6] = 1;
        this.Pills[12][6] = 0;
        this.MazeSolve[12][6] = 0;
        this.Pills[15][6] = 0;
        this.MazeSolve[15][6] = 1;
        this.Pills[1][7] = 0;
        this.MazeSolve[1][7] = 3;
        this.Pills[2][7] = 0;
        this.MazeSolve[2][7] = 3;
        this.Pills[3][7] = 0;
        this.MazeSolve[3][7] = 3;
        this.Pills[4][7] = 0;
        this.MazeSolve[4][7] = 1;
        this.Pills[6][7] = 0;
        this.MazeSolve[6][7] = 3;
        this.Pills[7][7] = 0;
        this.MazeSolve[7][7] = 1;
        this.Pills[9][7] = 0;
        this.MazeSolve[9][7] = 1;
        this.Pills[10][7] = 0;
        this.MazeSolve[10][7] = 2;
        this.Pills[12][7] = 0;
        this.MazeSolve[12][7] = 1;
        this.Pills[13][7] = 0;
        this.MazeSolve[13][7] = 2;
        this.Pills[14][7] = 0;
        this.MazeSolve[14][7] = 2;
        this.Pills[15][7] = 0;
        this.MazeSolve[15][7] = 2;
        this.Pills[4][8] = 0;
        this.MazeSolve[4][8] = 1;
        this.Pills[7][8] = 0;
        this.MazeSolve[7][8] = 1;
        this.Pills[9][8] = 0;
        this.MazeSolve[9][8] = 1;
        this.Pills[12][8] = 0;
        this.MazeSolve[12][8] = 1;
        this.Pills[4][9] = 0;
        this.MazeSolve[4][9] = 1;
        this.Pills[6][9] = 4;
        this.MazeSolve[6][9] = 3;
        this.Pills[7][9] = 4;
        this.MazeSolve[7][9] = 3;
        this.Pills[8][9] = 4;
        this.MazeSolve[8][9] = 1;
        this.Pills[9][9] = 4;
        this.MazeSolve[9][9] = 2;
        this.Pills[10][9] = 4;
        this.MazeSolve[10][9] = 2;
        this.Pills[12][9] = 0;
        this.MazeSolve[12][9] = 1;
        this.Pills[4][10] = 0;
        this.MazeSolve[4][10] = 1;
        this.Pills[6][10] = 4;
        this.MazeSolve[6][10] = 0;
        this.MazeSolve[8][10] = 1;
        this.Pills[10][10] = 4;
        this.MazeSolve[10][10] = 0;
        this.Pills[12][10] = 0;
        this.MazeSolve[12][10] = 1;
        this.Pills[1][11] = -1;
        this.MazeSolve[1][11] = 3;
        this.Pills[2][11] = -1;
        this.MazeSolve[2][11] = 3;
        this.Pills[3][11] = -1;
        this.MazeSolve[3][11] = 3;
        this.Pills[4][11] = 0;
        this.MazeSolve[4][11] = 3;
        this.Pills[5][11] = 0;
        this.MazeSolve[5][11] = 3;
        this.Pills[6][11] = 4;
        this.MazeSolve[6][11] = 0;
        this.MazeSolve[8][11] = 1;
        this.Pills[10][11] = 4;
        this.MazeSolve[10][11] = 0;
        this.Pills[11][11] = 0;
        this.MazeSolve[11][11] = 2;
        this.Pills[12][11] = 0;
        this.MazeSolve[12][11] = 2;
        this.Pills[13][11] = -1;
        this.MazeSolve[13][11] = 2;
        this.Pills[14][11] = -1;
        this.MazeSolve[14][11] = 2;
        this.Pills[15][11] = -1;
        this.MazeSolve[15][11] = 2;
        this.Pills[4][12] = 0;
        this.MazeSolve[4][12] = 0;
        this.Pills[6][12] = 4;
        this.MazeSolve[6][12] = 0;
        this.Pills[10][12] = 4;
        this.MazeSolve[10][12] = 0;
        this.Pills[12][12] = 0;
        this.MazeSolve[12][12] = 0;
        this.Pills[4][13] = 0;
        this.MazeSolve[4][13] = 0;
        this.Pills[6][13] = 4;
        this.MazeSolve[6][13] = 0;
        this.Pills[7][13] = 4;
        this.MazeSolve[7][13] = 2;
        this.Pills[8][13] = 4;
        this.MazeSolve[8][13] = 2;
        this.Pills[9][13] = 4;
        this.MazeSolve[9][13] = 3;
        this.Pills[10][13] = 4;
        this.MazeSolve[10][13] = 0;
        this.Pills[12][13] = 0;
        this.MazeSolve[12][13] = 0;
        this.Pills[4][14] = 0;
        this.MazeSolve[4][14] = 0;
        this.Pills[6][14] = 0;
        this.MazeSolve[6][14] = 0;
        this.Pills[10][14] = 0;
        this.MazeSolve[10][14] = 0;
        this.Pills[12][14] = 0;
        this.MazeSolve[12][14] = 0;
        this.Pills[1][15] = 0;
        this.MazeSolve[1][15] = 3;
        this.Pills[2][15] = 0;
        this.MazeSolve[2][15] = 3;
        this.Pills[3][15] = 0;
        this.MazeSolve[3][15] = 3;
        this.Pills[4][15] = 0;
        this.MazeSolve[4][15] = 0;
        this.Pills[5][15] = 0;
        this.MazeSolve[5][15] = 3;
        this.Pills[6][15] = 0;
        this.MazeSolve[6][15] = 0;
        this.Pills[7][15] = 0;
        this.MazeSolve[7][15] = 2;
        this.Pills[9][15] = 0;
        this.MazeSolve[9][15] = 3;
        this.Pills[10][15] = 0;
        this.MazeSolve[10][15] = 0;
        this.Pills[11][15] = 0;
        this.MazeSolve[11][15] = 2;
        this.Pills[12][15] = 0;
        this.MazeSolve[12][15] = 0;
        this.Pills[13][15] = 0;
        this.MazeSolve[13][15] = 2;
        this.Pills[14][15] = 0;
        this.MazeSolve[14][15] = 2;
        this.Pills[15][15] = 0;
        this.MazeSolve[15][15] = 2;
        this.Pills[1][16] = 0;
        this.MazeSolve[1][16] = 0;
        this.Pills[4][16] = 0;
        this.MazeSolve[4][16] = 0;
        this.Pills[7][16] = 0;
        this.MazeSolve[7][16] = 0;
        this.Pills[9][16] = 0;
        this.MazeSolve[9][16] = 0;
        this.Pills[12][16] = 0;
        this.MazeSolve[12][16] = 0;
        this.Pills[15][16] = 0;
        this.MazeSolve[15][16] = 0;
        this.Pills[1][17] = 1;
        this.MazeSolve[1][17] = 0;
        this.Pills[2][17] = 0;
        this.MazeSolve[2][17] = 2;
        this.Pills[4][17] = 0;
        this.MazeSolve[4][17] = 0;
        this.Pills[5][17] = 0;
        this.MazeSolve[5][17] = 2;
        this.Pills[6][17] = 0;
        this.MazeSolve[6][17] = 3;
        this.Pills[7][17] = 0;
        this.MazeSolve[7][17] = 0;
        this.Pills[8][17] = 4;
        this.MazeSolve[8][17] = 2;
        this.Pills[9][17] = 0;
        this.MazeSolve[9][17] = 0;
        this.Pills[10][17] = 0;
        this.MazeSolve[10][17] = 2;
        this.Pills[11][17] = 0;
        this.MazeSolve[11][17] = 3;
        this.Pills[12][17] = 0;
        this.MazeSolve[12][17] = 0;
        this.Pills[14][17] = 0;
        this.MazeSolve[14][17] = 3;
        this.Pills[15][17] = 1;
        this.MazeSolve[15][17] = 0;
        this.Pills[2][18] = 0;
        this.MazeSolve[2][18] = 1;
        this.Pills[4][18] = 0;
        this.MazeSolve[4][18] = 0;
        this.Pills[6][18] = 0;
        this.MazeSolve[6][18] = 0;
        this.Pills[10][18] = 0;
        this.MazeSolve[10][18] = 0;
        this.Pills[12][18] = 0;
        this.MazeSolve[12][18] = 0;
        this.Pills[14][18] = 0;
        this.MazeSolve[14][18] = 1;
        this.Pills[1][19] = 0;
        this.MazeSolve[1][19] = 3;
        this.Pills[2][19] = 0;
        this.MazeSolve[2][19] = 3;
        this.Pills[3][19] = 0;
        this.MazeSolve[3][19] = 3;
        this.Pills[4][19] = 0;
        this.MazeSolve[4][19] = 0;
        this.Pills[6][19] = 0;
        this.MazeSolve[6][19] = 0;
        this.Pills[7][19] = 0;
        this.MazeSolve[7][19] = 2;
        this.Pills[9][19] = 0;
        this.MazeSolve[9][19] = 3;
        this.Pills[10][19] = 0;
        this.MazeSolve[10][19] = 0;
        this.Pills[12][19] = 0;
        this.MazeSolve[12][19] = 0;
        this.Pills[13][19] = 0;
        this.MazeSolve[13][19] = 2;
        this.Pills[14][19] = 0;
        this.MazeSolve[14][19] = 2;
        this.Pills[15][19] = 0;
        this.MazeSolve[15][19] = 2;
        this.Pills[1][20] = 0;
        this.MazeSolve[1][20] = 0;
        this.Pills[7][20] = 0;
        this.MazeSolve[7][20] = 0;
        this.Pills[9][20] = 0;
        this.MazeSolve[9][20] = 0;
        this.Pills[15][20] = 0;
        this.MazeSolve[15][20] = 0;
        this.Pills[1][21] = 0;
        this.MazeSolve[1][21] = 0;
        this.Pills[2][21] = 0;
        this.MazeSolve[2][21] = 2;
        this.Pills[3][21] = 0;
        this.MazeSolve[3][21] = 3;
        this.Pills[4][21] = 0;
        this.MazeSolve[4][21] = 3;
        this.Pills[5][21] = 0;
        this.MazeSolve[5][21] = 3;
        this.Pills[6][21] = 0;
        this.MazeSolve[6][21] = 3;
        this.Pills[7][21] = 0;
        this.MazeSolve[7][21] = 0;
        this.Pills[8][21] = 0;
        this.MazeSolve[8][21] = 2;
        this.Pills[9][21] = 0;
        this.MazeSolve[9][21] = 0;
        this.Pills[10][21] = 0;
        this.MazeSolve[10][21] = 2;
        this.Pills[11][21] = 0;
        this.MazeSolve[11][21] = 2;
        this.Pills[12][21] = 0;
        this.MazeSolve[12][21] = 2;
        this.Pills[13][21] = 0;
        this.MazeSolve[13][21] = 2;
        this.Pills[14][21] = 0;
        this.MazeSolve[14][21] = 3;
        this.Pills[15][21] = 0;
        this.MazeSolve[15][21] = 0;
    }

    public void setState(int i, int i_1_) {
        this.state = i;
        this.state_timer = i_1_;
    }

    public void resetGame(boolean bool) {
        this.resetPills();
        this.pacman.setPosition(7, 16);
        this.pacman.reset(bool);
        this.ghost[0].setPosition(0, 0, 85);
        this.ghost[1].setPosition(0, 0, 55);
        this.ghost[2].setPosition(0, 0, 25);
        this.ghost[3].setPosition(0, -1, 15);
        this.fruit.reset();
        if (bool) {
            this.setState(4, 0);
        } else {
            this.setState(0, 0);
        }
        this.refresh();
    }

    public void resetLevel() {
        this.pacman.setPosition(7, 16);
        this.ghost[0].setPosition(0, 0, 85);
        this.ghost[1].setPosition(0, 0, 55);
        this.ghost[2].setPosition(0, 0, 25);
        this.ghost[3].setPosition(0, -1, 15);
        this.setState(0, 0);
    }

    public void drawPills(Graphics graphics) {
        for (int i = 0; i < 23; ++i) {
            block5: for (int i_2_ = 0; i_2_ < 17; ++i_2_) {
                switch (this.Pills[i_2_][i]) {
                    case 0: {
                        this.PillSprites[0].draw(graphics, 269 + i_2_ * 32 - i * 12, 24 + i * 24);
                        continue block5;
                    }
                    case 1: {
                        this.PillSprites[1].draw(graphics, 269 + i_2_ * 32 - i * 12, 24 + i * 24);
                    }
                }
            }
        }
    }

    public void buildScreen(Graphics graphics) {
        this.BackgroundSprite.draw(graphics, 0, 0);
        this.drawPills(graphics);
        this.ScoreSprite.draw(graphics, 324, 8);
        this.HiSprite.draw(graphics, 515, 8);
    }

    public void refresh() {
        this.buildScreen(this.parent.offScrImage.getGraphics());
        this.parent.dirty.invalidate();
    }

    public void drawScreen(Graphics graphics) {
        int i;
        for (i = 3; i >= 0; --i) {
            this.ghost[i].repair(graphics);
        }
        this.pacman.repair(graphics);
        this.fruit.repair(graphics);
        if (this.pacman.bPillEaten) {
            switch (this.Pills[this.pacman.PillEatenX][this.pacman.PillEatenY]) {
                case 0: {
                    this.pacman.addScore(60);
                    this.PillSprites[2].draw(graphics, 269 + this.pacman.PillEatenX * 32 - this.pacman.PillEatenY * 12, 24 + this.pacman.PillEatenY * 24);
                    ++this.pacman.nPillsEaten;
                    if (this.pacman.nPillsEaten != 150) break;
                    this.setState(3, 120);
                    break;
                }
                case 1: {
                    this.pacman.addScore(0);
                    this.PillSprites[3].draw(graphics, 269 + this.pacman.PillEatenX * 32 - this.pacman.PillEatenY * 12, 24 + this.pacman.PillEatenY * 24);
                    for (i = 0; i < 4; ++i) {
                        this.ghost[i].setPillTimer();
                    }
                    break;
                }
            }
            this.Pills[this.pacman.PillEatenX][this.pacman.PillEatenY] = 4;
            this.pacman.bPillEaten = false;
        }
        switch (this.state) {
            case 2: {
                --this.state_timer;
                if (this.state_timer == 0) {
                    --this.pacman.PacLives;
                    if (this.pacman.PacLives < 0) {
                        this.setState(5, 240);
                    } else {
                        this.resetLevel();
                    }
                    this.fruit.reset();
                    break;
                }
                if (this.state_timer >= 90 || (this.state_timer & 3) != 0) break;
                switch (this.pacman.LastPacDirection) {
                    case 0: {
                        this.pacman.LastPacDirection = 3;
                        break;
                    }
                    case 1: {
                        this.pacman.LastPacDirection = 2;
                        break;
                    }
                    case 2: {
                        this.pacman.LastPacDirection = 0;
                        break;
                    }
                    case 3: {
                        this.pacman.LastPacDirection = 1;
                    }
                }
                break;
            }
            case 3: {
                --this.state_timer;
                if (this.state_timer != 0) break;
                this.resetGame(false);
                break;
            }
            case 5: {
                --this.state_timer;
                if (this.state_timer != 0) break;
                this.refresh();
                this.resetGame(true);
                break;
            }
            case 6: {
                --this.state_timer;
                if (this.state_timer != 0) break;
                this.setState(1, 0);
            }
        }
        this.fruit.draw(graphics);
        this.pacman.draw(graphics);
        for (i = 0; i < 4; ++i) {
            this.ghost[i].draw(graphics);
        }
        this.parent.score.drawDigitsLeadingZeros(graphics, 376, 8, this.pacman.PacScore);
        this.parent.score.drawDigitsLeadingZeros(graphics, 542, 8, this.pacman.HiScore);
        this.LivesSprite.setAnimation(this.pacman.PacLives >= 0 ? this.pacman.PacLives : 0, 1, 0);
        this.LivesSprite.draw(graphics, 180, 5);
        if (this.state == 4) {
            this.TitleSprite.draw(graphics, 252, 92);
        }
        if (this.state == 5) {
            this.GameOverSprite.draw(graphics, 224, 264);
        }
        this.pacman.collide();
        this.fruit.collide();
    }

    public void handleInput(Event event, int i) {
        if (this.state == 0 || this.state == 1 || this.state == 4) {
            if (this.state == 0 || this.state == 4) {
                Samples.PAC_START.play();
                this.refresh();
                this.state = 1;
            }
            if (i == 1004) {
                this.pacman.NextPacDirection = 0;
            }
            if (i == 1006) {
                this.pacman.NextPacDirection = 2;
            }
            if (i == 1007) {
                this.pacman.NextPacDirection = 3;
            }
            if (i == 1005) {
                this.pacman.NextPacDirection = 1;
            }
            this.parent.random();
        }
    }

    public int random() {
        int i;
        int i_3_ = i = this.RandomSeed;
        if ((i_3_ ^= (i <<= 1)) < 0) {
            i |= 1;
        }
        this.RandomSeed = i *= 31055;
        return i;
    }

    public int random_range(int i) {
        int i_4_ = this.random();
        i_4_ = i_4_ >> 16 & 0xFFFF;
        i_4_ *= i;
        i_4_ = i_4_ >> 16 & 0xFFF;
        return i_4_;
    }
}

