/*
 * Decompiled with CFR 0.152.
 */
package pacman;

import java.awt.Graphics;
import java.awt.Image;
import jemu.core.samples.Samples;
import pacman.Main;
import pacman.Sprite;

public class Ghost {
    static final int START_X = 8;
    static final int START_Y = 11;
    protected Main parent;
    protected Sprite GhostSprite;
    protected int GhostX;
    protected int GhostY;
    protected int GhostDirection;
    protected int[] Directions = new int[4];
    protected int PillTimer;
    protected boolean bDead;
    protected int StartTimer;

    Ghost(Main main, Image image, int i, int i_0_, int i_1_) {
        this.parent = main;
        this.GhostSprite = new Sprite(main, image, 16, 24);
        this.GhostSprite.setAnimation(0, 3, 3);
        this.GhostSprite.setHotspot(8, 19);
        this.GhostSprite.setRepair();
        this.setPosition(i, i_0_, i_1_);
    }

    public void setPillTimer() {
        if (!this.bDead) {
            Samples.PAC_TURNGHOST.play();
            this.PillTimer += 480;
        }
    }

    public void setPosition(int i, int i_2_, int i_3_) {
        this.GhostX = 32 + 32 * (7 + i);
        this.GhostY = 24 + 24 * (10 + i_2_);
        this.GhostDirection = 0;
        this.PillTimer = 0;
        this.StartTimer = i_3_;
        this.bDead = false;
        this.GhostSprite.setFrame(0);
    }

    public boolean collide(int i, int i_4_, int i_5_, int i_6_) {
        if (this.bDead) {
            return false;
        }
        int i_7_ = this.GhostX - 8 + 4;
        int i_8_ = this.GhostY - 19 + 6;
        if (i + i_5_ < i_7_ || i_4_ + i_6_ < i_8_) {
            return false;
        }
        return i <= i_7_ + 8 && i_4_ <= i_8_ + 12;
    }

    public void kill() {
        this.bDead = true;
        this.PillTimer = 0;
    }

    public void repair(Graphics graphics) {
        this.GhostSprite.drawRepair(graphics);
    }

    public void draw(Graphics graphics) {
        boolean bool = false;
        int i = 0;
        this.GhostSprite.grabRepair(269 + this.GhostX - this.GhostY / 2, 24 + this.GhostY);
        if (this.bDead) {
            this.GhostSprite.setBaseFrame(24);
            this.GhostSprite.setFrame(this.GhostDirection);
            this.GhostSprite.draw(graphics, 269 + this.GhostX - this.GhostY / 2, 24 + this.GhostY);
        } else {
            int i_9_ = 0;
            if (this.PillTimer > 0) {
                if (this.PillTimer < 120) {
                    if (this.PillTimer == 100) {
                        Samples.PAC_RETURNGHOST.play();
                    }
                    if ((this.PillTimer & 8) == 0) {
                        i_9_ = 12;
                    }
                } else {
                    i_9_ = 12;
                }
                if (this.parent.game.state != 3 && this.parent.game.state != 6) {
                    --this.PillTimer;
                }
            }
            this.GhostSprite.setBaseFrame(i_9_ + this.GhostDirection * 3);
            this.GhostSprite.draw(graphics, 269 + this.GhostX - this.GhostY / 2, 24 + this.GhostY);
            if (this.parent.game.state != 3) {
                this.GhostSprite.update();
            }
        }
        if ((this.PillTimer <= 0 || (this.PillTimer & 1) != 0) && this.parent.game.state == 1) {
            if (this.StartTimer > 0) {
                --this.StartTimer;
            } else {
                switch (this.GhostDirection) {
                    case 0: {
                        this.GhostY -= 2;
                        break;
                    }
                    case 1: {
                        this.GhostY += 2;
                        break;
                    }
                    case 2: {
                        this.GhostX -= 2;
                        break;
                    }
                    case 3: {
                        this.GhostX += 2;
                    }
                }
                if (this.GhostX % 32 == 0 && this.GhostY % 24 == 0) {
                    if (this.bDead) {
                        if (this.GhostX == 256 && this.GhostY == 264) {
                            this.bDead = false;
                            this.GhostSprite.setFrame(0);
                            this.GhostDirection = 0;
                            return;
                        }
                        this.GhostDirection = this.parent.game.MazeSolve[this.GhostX / 32][this.GhostY / 24];
                    }
                    if (!this.bDead) {
                        if (this.parent.game.Pills[this.GhostX / 32][this.GhostY / 24 - 1] >= 0 && this.GhostDirection != 1) {
                            this.Directions[i++] = 0;
                        }
                        if (this.parent.game.Pills[this.GhostX / 32][this.GhostY / 24 + 1] >= 0 && this.GhostDirection != 0) {
                            this.Directions[i++] = 1;
                        }
                        if (this.parent.game.Pills[this.GhostX / 32 - 1][this.GhostY / 24] >= 0 && this.GhostDirection != 3) {
                            this.Directions[i++] = 2;
                        }
                        if (this.parent.game.Pills[this.GhostX / 32 + 1][this.GhostY / 24] >= 0 && this.GhostDirection != 2) {
                            this.Directions[i++] = 3;
                        }
                        if (i != 0) {
                            this.GhostDirection = this.Directions[this.parent.random_range(i)];
                        }
                    }
                }
            }
        }
    }
}

