/*
 * Decompiled with CFR 0.152.
 */
package pacman;

import java.awt.Graphics;
import java.awt.Image;
import jemu.core.samples.Samples;
import pacman.Main;
import pacman.Sprite;

public class PacMan {
    static final int LIVES = 4;
    protected Main parent;
    protected Image PacManImage;
    protected Sprite PacManSprite;
    protected int PacManX;
    protected int PacManY;
    protected int PacDirection;
    protected int LastPacDirection;
    protected int NextPacDirection;
    protected int PacScore;
    protected int HiScore;
    protected int nPillsEaten;
    protected boolean bPillEaten;
    protected int PillEatenX;
    protected int PillEatenY;
    protected int PacLives;

    PacMan(Main main, int i, int i_0_) {
        this.parent = main;
        this.PacManImage = main.LoadImage("images/pac.gif", 23, 805);
        this.PacManSprite = new Sprite(main, this.PacManImage, 23, 23);
        this.PacManSprite.setAnimation(0, 8, 3);
        this.PacManSprite.setHotspot(12, 19);
        this.PacManSprite.setRepair();
        this.setPosition(i, i_0_);
        this.reset(true);
    }

    public void setPosition(int i, int i_1_) {
        this.PacManX = 32 + 32 * i;
        this.PacManY = 24 + 24 * i_1_;
        this.PacDirection = -1;
        this.LastPacDirection = 3;
        this.NextPacDirection = -1;
        this.bPillEaten = false;
        this.PillEatenY = -1;
        this.PillEatenX = -1;
    }

    public void reset(boolean bool) {
        if (bool) {
            this.PacScore = 0;
            this.PacLives = 4;
        }
        this.nPillsEaten = 0;
    }

    public void addLive() {
        if (this.PacLives < 4) {
            Samples.PAC_ADDLIVE.play();
            ++this.PacLives;
        }
    }

    public void collide() {
        int i = -1;
        if (this.parent.game.state == 1) {
            for (int i_2_ = 0; i_2_ < 4 && i == -1; ++i_2_) {
                if (!this.parent.game.ghost[i_2_].collide(this.PacManX - 12 + 6, this.PacManY - 19 + 6, 11, 11)) continue;
                i = i_2_;
            }
            if (i != -1) {
                if (this.parent.game.ghost[i].PillTimer > 0) {
                    Samples.PAC_EATGHOST.play();
                    this.addScore(200);
                    this.parent.game.ghost[i].kill();
                    this.parent.game.setState(6, 60);
                } else {
                    Samples.PAC_DIE.play();
                    this.parent.game.setState(2, 120);
                }
            }
        }
    }

    public void addScore(int i) {
        this.PacScore += i;
        if (this.PacScore > 9999999) {
            this.PacScore = 9999999;
        }
        if (this.PacScore > this.HiScore) {
            this.HiScore = this.PacScore;
        }
    }

    public void repair(Graphics graphics) {
        this.PacManSprite.drawRepair(graphics);
    }

    public void draw(Graphics graphics) {
        this.PacManSprite.grabRepair(269 + this.PacManX - this.PacManY / 2, 24 + this.PacManY);
        if (this.parent.game.state == 2 && this.parent.game.state_timer < 30) {
            this.PacManSprite.setBaseFrame(32);
            if (this.parent.game.state_timer < 10) {
                this.PacManSprite.setFrame(2);
            } else if (this.parent.game.state_timer < 20) {
                this.PacManSprite.setFrame(1);
            } else {
                this.PacManSprite.setFrame(0);
            }
        } else {
            this.PacManSprite.setBaseFrame(this.LastPacDirection * 8);
        }
        if (this.parent.game.state != 5) {
            this.PacManSprite.draw(graphics, 269 + this.PacManX - this.PacManY / 2, 24 + this.PacManY);
        }
        if (this.parent.game.state != 2 && this.parent.game.state != 3) {
            this.PacManSprite.update();
        }
        if (this.parent.game.state == 1) {
            switch (this.PacDirection) {
                case 0: {
                    this.PacManY -= 2;
                    break;
                }
                case 1: {
                    this.PacManY += 2;
                    break;
                }
                case 2: {
                    this.PacManX -= 2;
                    break;
                }
                case 3: {
                    this.PacManX += 2;
                }
            }
            switch (this.PacDirection) {
                case 0: {
                    if (this.NextPacDirection != 1) break;
                    this.LastPacDirection = 1;
                    this.PacDirection = 1;
                    break;
                }
                case 1: {
                    if (this.NextPacDirection != 0) break;
                    this.LastPacDirection = 0;
                    this.PacDirection = 0;
                    break;
                }
                case 2: {
                    if (this.NextPacDirection != 3) break;
                    this.LastPacDirection = 3;
                    this.PacDirection = 3;
                    break;
                }
                case 3: {
                    if (this.NextPacDirection != 2) break;
                    this.LastPacDirection = 2;
                    this.PacDirection = 2;
                }
            }
            if (this.PacManX % 32 == 0 && this.PacManY % 24 == 0) {
                this.PillEatenX = this.PacManX / 32;
                this.PillEatenY = this.PacManY / 24;
                if (this.parent.game.Pills[this.PillEatenX][this.PillEatenY] == 0 || this.parent.game.Pills[this.PillEatenX][this.PillEatenY] == 1) {
                    Samples.PAC_EAT.play();
                    this.bPillEaten = true;
                }
                if (this.PillEatenY == 11) {
                    if (this.PillEatenX == 1) {
                        this.PacManX = 480;
                    }
                    if (this.PillEatenX == 15) {
                        this.PacManX = 32;
                    }
                }
                switch (this.PacDirection) {
                    case 0: {
                        if (this.parent.game.Pills[this.PacManX / 32][this.PacManY / 24 - 1] > -2) break;
                        this.PacDirection = -1;
                        break;
                    }
                    case 1: {
                        if (this.parent.game.Pills[this.PacManX / 32][this.PacManY / 24 + 1] > -2) break;
                        this.PacDirection = -1;
                        break;
                    }
                    case 2: {
                        if (this.parent.game.Pills[this.PacManX / 32 - 1][this.PacManY / 24] > -2) break;
                        this.PacDirection = -1;
                        break;
                    }
                    case 3: {
                        if (this.parent.game.Pills[this.PacManX / 32 + 1][this.PacManY / 24] > -2) break;
                        this.PacDirection = -1;
                    }
                }
                switch (this.NextPacDirection) {
                    case 0: {
                        if (this.parent.game.Pills[this.PacManX / 32][this.PacManY / 24 - 1] <= -2) break;
                        this.PacDirection = this.LastPacDirection = this.NextPacDirection;
                        break;
                    }
                    case 1: {
                        if (this.parent.game.Pills[this.PacManX / 32][this.PacManY / 24 + 1] <= -2) break;
                        this.PacDirection = this.LastPacDirection = this.NextPacDirection;
                        break;
                    }
                    case 2: {
                        if (this.parent.game.Pills[this.PacManX / 32 - 1][this.PacManY / 24] <= -2) break;
                        this.PacDirection = this.LastPacDirection = this.NextPacDirection;
                        break;
                    }
                    case 3: {
                        if (this.parent.game.Pills[this.PacManX / 32 + 1][this.PacManY / 24] <= -2) break;
                        this.PacDirection = this.LastPacDirection = this.NextPacDirection;
                    }
                }
            }
        }
    }
}

