/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.actions;

import java.text.MessageFormat;
import tiled.core.Map;
import tiled.core.MapLayer;
import tiled.mapeditor.MapEditor;
import tiled.mapeditor.Resources;
import tiled.mapeditor.actions.AbstractLayerAction;

public class CloneLayerAction
extends AbstractLayerAction {
    public CloneLayerAction(MapEditor editor) {
        super(editor, Resources.getString("action.layer.duplicate.name"), Resources.getString("action.layer.duplicate.tooltip"), Resources.getIcon("gimp-duplicate-16.png"));
    }

    @Override
    protected void doPerformAction() {
        MapLayer currentLayer = this.editor.getCurrentLayer();
        Map currentMap = this.editor.getCurrentMap();
        if (currentLayer != null) {
            try {
                MapLayer clone = (MapLayer)currentLayer.clone();
                String newName = Resources.getString("action.layer.duplicate.newlayer.name");
                clone.setName(MessageFormat.format(newName, clone.getName()));
                currentMap.addLayer(clone);
                this.editor.setCurrentLayer(currentMap.getTotalLayers() - 1);
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
    }
}

